/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.rowset;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Vector;
import javax.sql.RowSetInternal;
import javax.sql.RowSetWriter;
import sun.jdbc.rowset.CachedRowSet;
import sun.jdbc.rowset.RowSetReaderImpl;

public class RowSetWriterImpl
implements RowSetWriter,
Serializable {
    private Connection con;
    private String selectCmd;
    private String updateCmd;
    private String updateWhere;
    private String deleteCmd;
    private String deleteWhere;
    private String insertCmd;
    private int[] keyCols;
    private Object[] params;
    private RowSetReaderImpl reader;
    private ResultSetMetaData callerMd;
    private int callerColumnCount;

    private void buildKeyDesc(CachedRowSet cachedRowSet) throws SQLException {
        this.keyCols = cachedRowSet.getKeyColumns();
        if (this.keyCols == null || this.keyCols.length == 0) {
            this.keyCols = new int[this.callerColumnCount];
            int n = 0;
            while (n < this.keyCols.length) {
                this.keyCols[n++] = n;
            }
        }
        this.params = new Object[this.keyCols.length];
    }

    private String buildTableName(DatabaseMetaData databaseMetaData, String string, String string2) throws SQLException {
        String string3 = new String();
        if (databaseMetaData.isCatalogAtStart()) {
            if (string.length() > 0) {
                string3 = String.valueOf(string3) + string + databaseMetaData.getCatalogSeparator();
            }
            string3 = String.valueOf(string3) + string2;
        } else {
            string3 = String.valueOf(string3) + string2;
            if (string.length() > 0) {
                string3 = String.valueOf(string3) + databaseMetaData.getCatalogSeparator() + string;
            }
        }
        string3 = String.valueOf(string3) + " ";
        return string3;
    }

    private String buildWhereClause(String string, ResultSet resultSet) throws SQLException {
        string = "WHERE ";
        int n = 0;
        while (n < this.keyCols.length) {
            if (n > 0) {
                string = String.valueOf(string) + "AND ";
            }
            string = String.valueOf(string) + this.callerMd.getColumnName(this.keyCols[n]);
            this.params[n] = resultSet.getObject(this.keyCols[n]);
            string = resultSet.wasNull() ? String.valueOf(string) + " IS NULL " : String.valueOf(string) + " = ? ";
            ++n;
        }
        return string;
    }

    private boolean deleteOriginalRow(CachedRowSet cachedRowSet) throws SQLException {
        int n = 0;
        ResultSet resultSet = cachedRowSet.getOriginalRow();
        resultSet.next();
        this.deleteWhere = this.buildWhereClause(this.deleteWhere, resultSet);
        PreparedStatement preparedStatement = this.con.prepareStatement(String.valueOf(this.selectCmd) + this.deleteWhere);
        int n2 = 0;
        while (n2 < this.keyCols.length) {
            if (this.params[n2] != null) {
                preparedStatement.setObject(++n, this.params[n2]);
            }
            ++n2;
        }
        try {
            preparedStatement.setMaxRows(cachedRowSet.getMaxRows());
            preparedStatement.setMaxFieldSize(cachedRowSet.getMaxFieldSize());
            preparedStatement.setEscapeProcessing(cachedRowSet.getEscapeProcessing());
            preparedStatement.setQueryTimeout(cachedRowSet.getQueryTimeout());
        }
        catch (Exception exception) {}
        ResultSet resultSet2 = preparedStatement.executeQuery();
        if (resultSet2.next()) {
            if (resultSet2.next()) {
                return true;
            }
            resultSet2.close();
            preparedStatement.close();
            String string = String.valueOf(this.deleteCmd) + this.deleteWhere;
            preparedStatement = this.con.prepareStatement(string);
            n = 0;
            n2 = 0;
            while (n2 < this.keyCols.length) {
                if (this.params[n2] != null) {
                    preparedStatement.setObject(++n, this.params[n2]);
                }
                ++n2;
            }
            if (preparedStatement.executeUpdate() != 1) {
                return true;
            }
        } else {
            return true;
        }
        preparedStatement.close();
        return false;
    }

    public RowSetReaderImpl getReader() throws SQLException {
        return this.reader;
    }

    private void initSQLStatements(CachedRowSet cachedRowSet) throws SQLException {
        String string;
        this.callerMd = cachedRowSet.getMetaData();
        this.callerColumnCount = this.callerMd.getColumnCount();
        if (this.callerColumnCount < 1) {
            return;
        }
        String string2 = cachedRowSet.getTableName();
        if (string2 == null) {
            string2 = this.callerMd.getSchemaName(1);
            if (string2 != null && string2.length() > 0) {
                string2 = String.valueOf(string2) + ".";
            }
            string = this.callerMd.getTableName(1);
            if (string2 == null || string2.length() == 0) {
                throw new SQLException("writeData cannot determine the table name.");
            }
            string2 = String.valueOf(string2) + string;
        }
        string = this.callerMd.getCatalogName(1);
        DatabaseMetaData databaseMetaData = this.con.getMetaData();
        this.selectCmd = "SELECT ";
        int n = 1;
        while (n <= this.callerColumnCount) {
            this.selectCmd = String.valueOf(this.selectCmd) + this.callerMd.getColumnName(n);
            this.selectCmd = n < this.callerMd.getColumnCount() ? String.valueOf(this.selectCmd) + ", " : String.valueOf(this.selectCmd) + " ";
            ++n;
        }
        this.selectCmd = String.valueOf(this.selectCmd) + "FROM " + this.buildTableName(databaseMetaData, string, string2);
        this.updateCmd = "UPDATE " + this.buildTableName(databaseMetaData, string, string2);
        this.updateCmd = String.valueOf(this.updateCmd) + "SET ";
        this.insertCmd = "INSERT INTO " + this.buildTableName(databaseMetaData, string, string2);
        this.insertCmd = String.valueOf(this.insertCmd) + "(";
        n = 1;
        while (n <= this.callerColumnCount) {
            this.insertCmd = String.valueOf(this.insertCmd) + this.callerMd.getColumnName(n);
            this.insertCmd = n < this.callerMd.getColumnCount() ? String.valueOf(this.insertCmd) + ", " : String.valueOf(this.insertCmd) + ") VALUES (";
            ++n;
        }
        n = 1;
        while (n <= this.callerColumnCount) {
            this.insertCmd = String.valueOf(this.insertCmd) + "?";
            this.insertCmd = n < this.callerColumnCount ? String.valueOf(this.insertCmd) + ", " : String.valueOf(this.insertCmd) + ")";
            ++n;
        }
        this.deleteCmd = "DELETE FROM " + this.buildTableName(databaseMetaData, string, string2);
        this.buildKeyDesc(cachedRowSet);
    }

    private boolean insertNewRow(CachedRowSet cachedRowSet, PreparedStatement preparedStatement) throws SQLException {
        int n = 0;
        try {
            n = 1;
            while (n <= cachedRowSet.getMetaData().getColumnCount()) {
                Object object = cachedRowSet.getObject(n);
                if (object != null) {
                    if (cachedRowSet.getMetaData().getColumnType(n) == 5) {
                        preparedStatement.setShort(n, (Short)object);
                    } else {
                        preparedStatement.setObject(n, object);
                    }
                } else {
                    preparedStatement.setNull(n, cachedRowSet.getMetaData().getColumnType(n));
                }
                ++n;
            }
            n = preparedStatement.executeUpdate();
            if (n != 1) {
                System.err.println("excuteUpdate ret: " + n);
                return true;
            }
            return false;
        }
        catch (SQLException sQLException) {
            System.out.println(sQLException.getMessage());
            return true;
        }
    }

    public void setReader(RowSetReaderImpl rowSetReaderImpl) throws SQLException {
        this.reader = rowSetReaderImpl;
    }

    private boolean updateOriginalRow(CachedRowSet cachedRowSet) throws SQLException {
        int n = 0;
        int n2 = 0;
        ResultSet resultSet = cachedRowSet.getOriginalRow();
        resultSet.next();
        try {
            this.updateWhere = this.buildWhereClause(this.updateWhere, resultSet);
            PreparedStatement preparedStatement = this.con.prepareStatement(String.valueOf(this.selectCmd) + this.updateWhere);
            n = 0;
            while (n < this.keyCols.length) {
                if (this.params[n] != null) {
                    preparedStatement.setObject(++n2, this.params[n]);
                }
                ++n;
            }
            try {
                preparedStatement.setMaxRows(cachedRowSet.getMaxRows());
                preparedStatement.setMaxFieldSize(cachedRowSet.getMaxFieldSize());
                preparedStatement.setEscapeProcessing(cachedRowSet.getEscapeProcessing());
                preparedStatement.setQueryTimeout(cachedRowSet.getQueryTimeout());
            }
            catch (Exception exception) {}
            ResultSet resultSet2 = preparedStatement.executeQuery();
            if (resultSet2.next()) {
                if (resultSet2.next()) {
                    System.out.println("Cannot uniquely id. row");
                    return true;
                }
                resultSet2.close();
                preparedStatement.close();
                Vector<Integer> vector = new Vector<Integer>();
                String string = new String(this.updateCmd);
                boolean bl = true;
                n = 1;
                while (n <= this.callerColumnCount) {
                    Object object = resultSet.getObject(n);
                    Object object2 = cachedRowSet.getObject(n);
                    if (!(object == null && object2 == null || object != null && object2 != null && object.equals(object2))) {
                        if (!bl) {
                            string = String.valueOf(string) + ", ";
                        }
                        string = String.valueOf(string) + cachedRowSet.getMetaData().getColumnName(n);
                        vector.add(new Integer(n));
                        string = String.valueOf(string) + " = ? ";
                        bl = false;
                    }
                    ++n;
                }
                if (!bl && vector.size() == 0) {
                    return false;
                }
                string = String.valueOf(string) + this.updateWhere;
                preparedStatement = this.con.prepareStatement(string);
                n = 0;
                while (n < vector.size()) {
                    Object object = cachedRowSet.getObject((Integer)vector.get(n));
                    if (object != null) {
                        preparedStatement.setObject(n + 1, object);
                    } else {
                        preparedStatement.setNull(n + 1, cachedRowSet.getMetaData().getColumnType(n + 1));
                    }
                    ++n;
                }
                n2 = n;
                n = 0;
                while (n < this.keyCols.length) {
                    if (this.params[n] != null) {
                        preparedStatement.setObject(++n2, this.params[n]);
                    }
                    ++n;
                }
                n = preparedStatement.executeUpdate();
                if (n != 1) {
                    System.err.println("excuteUpdate ret: " + n);
                    return true;
                }
                return false;
            }
            return true;
        }
        catch (SQLException sQLException) {
            System.out.println(sQLException.getMessage());
            return true;
        }
    }

    public boolean writeData(RowSetInternal rowSetInternal) throws SQLException {
        boolean bl = false;
        boolean bl2 = false;
        PreparedStatement preparedStatement = null;
        CachedRowSet cachedRowSet = (CachedRowSet)rowSetInternal;
        this.con = ((RowSetReaderImpl)cachedRowSet.getReader()).connect(rowSetInternal);
        if (this.con == null) {
            throw new SQLException("Unable to get Connection");
        }
        if (this.con.getAutoCommit()) {
            this.con.setAutoCommit(false);
        }
        this.con.setTransactionIsolation(cachedRowSet.getTransactionIsolation());
        this.initSQLStatements(cachedRowSet);
        preparedStatement = this.con.prepareStatement(this.insertCmd);
        if (this.callerColumnCount < 1) {
            if (((RowSetReaderImpl)cachedRowSet.getReader()).getCloseConnection()) {
                this.con.close();
            }
            return true;
        }
        bl2 = cachedRowSet.getShowDeleted();
        cachedRowSet.setShowDeleted(true);
        cachedRowSet.beforeFirst();
        while (cachedRowSet.next()) {
            if (cachedRowSet.rowDeleted() && cachedRowSet.rowInserted()) continue;
            if (cachedRowSet.rowDeleted()) {
                bl = this.deleteOriginalRow(cachedRowSet);
                if (!bl) continue;
                break;
            }
            if (!cachedRowSet.rowInserted() ? cachedRowSet.rowUpdated() && (bl = this.updateOriginalRow(cachedRowSet)) : (bl = this.insertNewRow(cachedRowSet, preparedStatement))) break;
        }
        preparedStatement.close();
        cachedRowSet.setShowDeleted(bl2);
        if (bl) {
            this.con.rollback();
            if (((RowSetReaderImpl)cachedRowSet.getReader()).getCloseConnection()) {
                this.con.close();
            }
            return false;
        }
        this.con.commit();
        if (((RowSetReaderImpl)cachedRowSet.getReader()).getCloseConnection()) {
            this.con.close();
        }
        return true;
    }
}

