/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.rowset;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;

public class SQLInputImpl
implements SQLInput {
    private boolean lastValueWasNull;
    private int idx;
    private Object[] attrib;
    private Map map;

    SQLInputImpl(Object[] objectArray, Map map) {
        this.attrib = objectArray;
        this.idx = -1;
        this.map = map;
    }

    private Object getNextAttribute() throws SQLException {
        if (++this.idx >= this.attrib.length) {
            throw new SQLException("Invalid read position");
        }
        return this.attrib[this.idx];
    }

    public Array readArray() throws SQLException {
        Array array = (Array)this.getNextAttribute();
        if (array == null) {
            this.lastValueWasNull = true;
            return null;
        }
        this.lastValueWasNull = false;
        return array;
    }

    public InputStream readAsciiStream() throws SQLException {
        InputStream inputStream = (InputStream)this.getNextAttribute();
        if (inputStream == null) {
            this.lastValueWasNull = true;
            return null;
        }
        this.lastValueWasNull = false;
        return inputStream;
    }

    public BigDecimal readBigDecimal() throws SQLException {
        BigDecimal bigDecimal = (BigDecimal)this.getNextAttribute();
        if (bigDecimal == null) {
            this.lastValueWasNull = true;
            return null;
        }
        this.lastValueWasNull = false;
        return bigDecimal;
    }

    public InputStream readBinaryStream() throws SQLException {
        InputStream inputStream = (InputStream)this.getNextAttribute();
        if (inputStream == null) {
            this.lastValueWasNull = true;
            return null;
        }
        this.lastValueWasNull = false;
        return inputStream;
    }

    public Blob readBlob() throws SQLException {
        Blob blob = (Blob)this.getNextAttribute();
        if (blob == null) {
            this.lastValueWasNull = true;
            return null;
        }
        this.lastValueWasNull = false;
        return blob;
    }

    public boolean readBoolean() throws SQLException {
        Boolean bl = (Boolean)this.getNextAttribute();
        if (bl == null) {
            this.lastValueWasNull = true;
            return false;
        }
        this.lastValueWasNull = false;
        return bl;
    }

    public byte readByte() throws SQLException {
        Byte by = (Byte)this.getNextAttribute();
        if (by == null) {
            this.lastValueWasNull = true;
            return 0;
        }
        this.lastValueWasNull = false;
        return by;
    }

    public byte[] readBytes() throws SQLException {
        byte[] byArray = (byte[])this.getNextAttribute();
        if (byArray == null) {
            this.lastValueWasNull = true;
            return null;
        }
        this.lastValueWasNull = false;
        return byArray;
    }

    public Reader readCharacterStream() throws SQLException {
        Reader reader = (Reader)this.getNextAttribute();
        if (reader == null) {
            this.lastValueWasNull = true;
            return null;
        }
        this.lastValueWasNull = false;
        return reader;
    }

    public Clob readClob() throws SQLException {
        Clob clob = (Clob)this.getNextAttribute();
        if (clob == null) {
            this.lastValueWasNull = true;
            return null;
        }
        this.lastValueWasNull = false;
        return clob;
    }

    public Date readDate() throws SQLException {
        Date date = (Date)this.getNextAttribute();
        if (date == null) {
            this.lastValueWasNull = true;
            return null;
        }
        this.lastValueWasNull = false;
        return date;
    }

    public double readDouble() throws SQLException {
        Double d = (Double)this.getNextAttribute();
        if (d == null) {
            this.lastValueWasNull = true;
            return 0.0;
        }
        this.lastValueWasNull = false;
        return d;
    }

    public float readFloat() throws SQLException {
        Float f = (Float)this.getNextAttribute();
        if (f == null) {
            this.lastValueWasNull = true;
            return 0.0f;
        }
        this.lastValueWasNull = false;
        return f.floatValue();
    }

    public int readInt() throws SQLException {
        Integer n = (Integer)this.getNextAttribute();
        if (n == null) {
            this.lastValueWasNull = true;
            return 0;
        }
        this.lastValueWasNull = false;
        return n;
    }

    public long readLong() throws SQLException {
        Long l = (Long)this.getNextAttribute();
        if (l == null) {
            this.lastValueWasNull = true;
            return 0L;
        }
        this.lastValueWasNull = false;
        return l;
    }

    public Object readObject() throws SQLException {
        Struct struct;
        Class clazz;
        Object object = this.getNextAttribute();
        if (object == null) {
            this.lastValueWasNull = true;
            return null;
        }
        this.lastValueWasNull = false;
        if (object instanceof Struct && (clazz = (Class)this.map.get((struct = (Struct)object).getSQLTypeName())) != null) {
            SQLData sQLData = null;
            try {
                sQLData = (SQLData)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new SQLException("Unable to instantiate: " + instantiationException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SQLException("Unable to instantiate: " + illegalAccessException.getMessage());
            }
            Object[] objectArray = struct.getAttributes(this.map);
            SQLInputImpl sQLInputImpl = new SQLInputImpl(objectArray, this.map);
            sQLData.readSQL(sQLInputImpl, struct.getSQLTypeName());
            return sQLData;
        }
        return object;
    }

    public Ref readRef() throws SQLException {
        Ref ref = (Ref)this.getNextAttribute();
        if (ref == null) {
            this.lastValueWasNull = true;
            return null;
        }
        this.lastValueWasNull = false;
        return ref;
    }

    public short readShort() throws SQLException {
        Short s = (Short)this.getNextAttribute();
        if (s == null) {
            this.lastValueWasNull = true;
            return 0;
        }
        this.lastValueWasNull = false;
        return s;
    }

    public String readString() throws SQLException {
        String string = (String)this.getNextAttribute();
        if (string == null) {
            this.lastValueWasNull = true;
            return null;
        }
        this.lastValueWasNull = false;
        return string;
    }

    public Time readTime() throws SQLException {
        Time time = (Time)this.getNextAttribute();
        if (time == null) {
            this.lastValueWasNull = true;
            return null;
        }
        this.lastValueWasNull = false;
        return time;
    }

    public Timestamp readTimestamp() throws SQLException {
        Timestamp timestamp = (Timestamp)this.getNextAttribute();
        if (timestamp == null) {
            this.lastValueWasNull = true;
            return null;
        }
        this.lastValueWasNull = false;
        return timestamp;
    }

    public boolean wasNull() throws SQLException {
        return this.lastValueWasNull;
    }
}

