/*
 * Decompiled with CFR 0.152.
 */
package iDSS.math;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;

public class Fourier {
    private Vector x;
    private Vector y;
    private double period;
    private double halfP;
    private Vector a;
    private Vector b;
    private double c;
    private Double aDouble;
    private int MAX_NUMBER_OF_ITERATIONS = 0;

    public Fourier(Vector vector, Vector vector2, double d, int n) {
        this.x = vector;
        this.y = vector2;
        this.period = d;
        this.halfP = this.period / 2.0;
        if (n >= 0) {
            this.MAX_NUMBER_OF_ITERATIONS = n;
        }
        this.aDouble = (Double)this.x.elementAt(0);
        double d2 = this.aDouble;
        this.aDouble = (Double)this.x.elementAt(this.x.size() - 1);
        double d3 = this.aDouble;
        double d4 = d3 - d2;
        if (Math.abs(this.period - d4) > this.period / 1000.0) {
            System.out.println("period, dataLength = " + this.period + ", " + d4);
            System.out.println("Length of observed data not sufficient");
            System.exit(0);
        }
        this.a = new Vector();
        this.b = new Vector();
        this.c = 0.0;
        this.calculateC();
        this.calculateA();
        this.calculateB();
    }

    public Fourier(Vector vector, int n) {
        double d;
        Vector vector2 = (Vector)vector.elementAt(0);
        Vector vector3 = (Vector)vector.elementAt(1);
        if (n >= 0) {
            this.MAX_NUMBER_OF_ITERATIONS = n;
        }
        this.x = new Vector();
        this.y = vector3;
        Timestamp timestamp = (Timestamp)vector2.elementAt(0);
        double d2 = ((Date)timestamp).getTime();
        int n2 = 0;
        while (n2 < vector2.size()) {
            Timestamp timestamp2 = (Timestamp)vector2.elementAt(n2);
            double d3 = ((Date)timestamp2).getTime();
            this.x.add(new Double(d3));
            ++n2;
        }
        this.aDouble = (Double)this.x.elementAt(0);
        double d4 = this.aDouble;
        this.aDouble = (Double)this.x.elementAt(this.x.size() - 1);
        double d5 = this.aDouble;
        this.period = d = d5 - d4;
        this.halfP = this.period / 2.0;
        if (Math.abs(this.period - d) > this.period / 1000.0) {
            System.out.println("period, dataLength = " + this.period + ", " + d);
            System.out.println("Length of observed data not sufficient");
            System.exit(0);
        }
        this.a = new Vector();
        this.b = new Vector();
        this.c = 0.0;
        this.calculateC();
        this.calculateA();
        this.calculateB();
    }

    public Vector getFourierA() {
        return this.a;
    }

    public Vector getFourierB() {
        return this.b;
    }

    public double getFourierC() {
        return this.c;
    }

    public int getFourierIterations() {
        return this.MAX_NUMBER_OF_ITERATIONS;
    }

    public double getFourierPeriod() {
        return this.period;
    }

    public void calculateC() {
        System.out.println("Calculating Fourier coefficient c");
        this.aDouble = (Double)this.x.elementAt(0);
        double d = this.aDouble;
        this.aDouble = (Double)this.y.elementAt(0);
        double d2 = this.aDouble;
        int n = 1;
        while (n < this.x.size()) {
            this.aDouble = (Double)this.x.elementAt(n);
            double d3 = this.aDouble;
            this.aDouble = (Double)this.y.elementAt(n);
            double d4 = this.aDouble;
            this.c += (d3 - d) * (d2 + d4) / 2.0 / this.halfP / 2.0;
            d = d3;
            d2 = d4;
            ++n;
        }
        System.out.println("c = " + this.c);
    }

    public void calculateA() {
        System.out.println("Calculating Fourier coefficient a");
        int n = 0;
        boolean bl = true;
        while (bl) {
            this.aDouble = (Double)this.x.elementAt(0);
            double d = this.aDouble;
            this.aDouble = (Double)this.y.elementAt(0);
            double d2 = this.aDouble;
            d2 *= Math.cos((double)(++n) * Math.PI * d / this.halfP);
            double d3 = 0.0;
            int n2 = 1;
            while (n2 < this.x.size()) {
                this.aDouble = (Double)this.x.elementAt(n2);
                double d4 = this.aDouble;
                this.aDouble = (Double)this.y.elementAt(n2);
                double d5 = this.aDouble;
                d3 += Math.abs(d4 - d) * (d2 + (d5 *= Math.cos((double)n * Math.PI * d4 / this.halfP))) / 2.0;
                d = d4;
                d2 = d5;
                ++n2;
            }
            this.a.add(new Double(d3 /= this.halfP));
            if (n <= this.MAX_NUMBER_OF_ITERATIONS) continue;
            bl = false;
        }
    }

    public void calculateB() {
        System.out.println("Calculating Fourier coefficient b");
        int n = 0;
        boolean bl = true;
        while (bl) {
            this.aDouble = (Double)this.x.elementAt(0);
            double d = this.aDouble;
            this.aDouble = (Double)this.y.elementAt(0);
            double d2 = this.aDouble;
            d2 *= Math.sin((double)(++n) * Math.PI * d / this.halfP);
            double d3 = 0.0;
            int n2 = 1;
            while (n2 < this.x.size()) {
                this.aDouble = (Double)this.x.elementAt(n2);
                double d4 = this.aDouble;
                this.aDouble = (Double)this.y.elementAt(n2);
                double d5 = this.aDouble;
                d3 += Math.abs(d4 - d) * (d2 + (d5 *= Math.sin((double)n * Math.PI * d4 / this.halfP))) / 2.0;
                d = d4;
                d2 = d5;
                ++n2;
            }
            this.b.add(new Double(d3 /= this.halfP));
            if (n <= this.MAX_NUMBER_OF_ITERATIONS) continue;
            bl = false;
        }
    }

    public double getComputedY(double d) {
        double d2 = d;
        double d3 = 0.0;
        int n = 0;
        while (n < this.a.size()) {
            int n2 = n + 1;
            this.aDouble = (Double)this.a.elementAt(n);
            double d4 = this.aDouble;
            d3 += d4 * Math.cos((double)n2 * Math.PI * d2 / this.halfP);
            ++n;
        }
        double d5 = 0.0;
        int n3 = 0;
        while (n3 < this.b.size()) {
            int n4 = n3 + 1;
            this.aDouble = (Double)this.b.elementAt(n3);
            double d6 = this.aDouble;
            d5 += d6 * Math.sin((double)n4 * Math.PI * d2 / this.halfP);
            ++n3;
        }
        double d7 = this.c + d3 + d5;
        return d7;
    }

    public static double computeY(double d, Vector vector, Vector vector2, double d2, double d3) {
        Double d4;
        double d5 = d;
        double d6 = d3 / 2.0;
        double d7 = 0.0;
        int n = 0;
        while (n < vector.size()) {
            int n2 = n + 1;
            d4 = (Double)vector.elementAt(n);
            double d8 = d4;
            d7 += d8 * Math.cos((double)n2 * Math.PI * d5 / d6);
            ++n;
        }
        double d9 = 0.0;
        int n3 = 0;
        while (n3 < vector2.size()) {
            int n4 = n3 + 1;
            d4 = (Double)vector2.elementAt(n3);
            double d10 = d4;
            d9 += d10 * Math.sin((double)n4 * Math.PI * d5 / d6);
            ++n3;
        }
        double d11 = d2 + d7 + d9;
        return d11;
    }

    public void compareValues() {
        int n = 0;
        while (n < this.x.size()) {
            this.aDouble = (Double)this.x.elementAt(n);
            double d = this.aDouble;
            this.aDouble = (Double)this.y.elementAt(n);
            double d2 = this.aDouble;
            double d3 = this.getComputedY(d);
            System.out.println(d + ", " + d2 + ", " + d3);
            ++n;
        }
    }

    public static void main(String[] stringArray) {
        Vector<Timestamp> vector = new Vector<Timestamp>();
        Vector<Double> vector2 = new Vector<Double>();
        double d = 48.0;
        vector.add(Timestamp.valueOf("1999-01-01 00:00:00"));
        vector.add(Timestamp.valueOf("1999-01-01 01:00:00"));
        vector.add(Timestamp.valueOf("1999-01-01 02:00:00"));
        vector.add(Timestamp.valueOf("1999-01-01 03:00:00"));
        vector.add(Timestamp.valueOf("1999-01-01 04:00:00"));
        vector.add(Timestamp.valueOf("1999-01-01 05:00:00"));
        vector.add(Timestamp.valueOf("1999-01-01 06:00:00"));
        vector.add(Timestamp.valueOf("1999-01-01 07:00:00"));
        vector.add(Timestamp.valueOf("1999-01-01 08:00:00"));
        vector.add(Timestamp.valueOf("1999-01-01 09:00:00"));
        vector.add(Timestamp.valueOf("1999-01-01 10:00:00"));
        vector.add(Timestamp.valueOf("1999-01-01 11:00:00"));
        vector.add(Timestamp.valueOf("1999-01-01 12:00:00"));
        vector.add(Timestamp.valueOf("1999-01-01 13:00:00"));
        vector.add(Timestamp.valueOf("1999-01-01 14:00:00"));
        vector.add(Timestamp.valueOf("1999-01-01 15:00:00"));
        vector.add(Timestamp.valueOf("1999-01-01 16:00:00"));
        vector.add(Timestamp.valueOf("1999-01-01 17:00:00"));
        vector.add(Timestamp.valueOf("1999-01-01 18:00:00"));
        vector.add(Timestamp.valueOf("1999-01-01 19:00:00"));
        vector.add(Timestamp.valueOf("1999-01-01 20:00:00"));
        vector.add(Timestamp.valueOf("1999-01-01 21:00:00"));
        vector.add(Timestamp.valueOf("1999-01-01 22:00:00"));
        vector.add(Timestamp.valueOf("1999-01-01 23:00:00"));
        vector.add(Timestamp.valueOf("1999-01-01 24:00:00"));
        vector2.add(new Double(2.595));
        vector2.add(new Double(1.899));
        vector2.add(new Double(1.341));
        vector2.add(new Double(0.85));
        vector2.add(new Double(0.587));
        vector2.add(new Double(0.793));
        vector2.add(new Double(1.36));
        vector2.add(new Double(1.935));
        vector2.add(new Double(2.562));
        vector2.add(new Double(3.218));
        vector2.add(new Double(3.795));
        vector2.add(new Double(3.758));
        vector2.add(new Double(3.019));
        vector2.add(new Double(2.23));
        vector2.add(new Double(1.619));
        vector2.add(new Double(1.048));
        vector2.add(new Double(0.628));
        vector2.add(new Double(0.574));
        vector2.add(new Double(0.972));
        vector2.add(new Double(1.561));
        vector2.add(new Double(2.165));
        vector2.add(new Double(2.801));
        vector2.add(new Double(3.454));
        vector2.add(new Double(3.848));
        vector2.add(new Double(3.379));
        Vector<Vector<Comparable<Date>>> vector3 = new Vector<Vector<Comparable<Date>>>();
        vector3.add(vector);
        vector3.add(vector2);
        Fourier fourier = new Fourier(vector3, 100);
        fourier.compareValues();
        Timestamp timestamp = Timestamp.valueOf("1999-01-01 00:00:00");
        double d2 = ((Date)timestamp).getTime();
        double d3 = Fourier.computeY(d2, fourier.getFourierA(), fourier.getFourierB(), fourier.getFourierC(), fourier.getFourierPeriod());
        System.out.println("xx = " + timestamp.toString());
        System.out.println("yy = " + d3);
        System.out.println("Extrapolation starts....\n");
        int n = 0;
        while (n < vector.size()) {
            timestamp = (Timestamp)vector.elementAt(n);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(timestamp);
            calendar.add(5, 1);
            ((Date)timestamp).setTime(calendar.getTime().getTime());
            d2 = calendar.getTime().getTime();
            d3 = Fourier.computeY(d2, fourier.getFourierA(), fourier.getFourierB(), fourier.getFourierC(), fourier.getFourierPeriod());
            System.out.println(d2 + "," + timestamp.toString() + "," + d3);
            ++n;
        }
    }
}

