/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.rowset;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSet;
import javax.sql.RowSetInternal;
import javax.sql.RowSetReader;
import sun.jdbc.rowset.CachedRowSet;

public class RowSetReaderImpl
implements RowSetReader,
Serializable {
    private int writerCalls = 0;
    private boolean userCon = false;

    public Connection connect(RowSetInternal rowSetInternal) throws SQLException {
        if (rowSetInternal.getConnection() != null) {
            this.userCon = true;
            return rowSetInternal.getConnection();
        }
        if (((RowSet)((Object)rowSetInternal)).getDataSourceName() != null) {
            try {
                InitialContext initialContext = new InitialContext();
                DataSource dataSource = (DataSource)initialContext.lookup(((RowSet)((Object)rowSetInternal)).getDataSourceName());
                return dataSource.getConnection(((RowSet)((Object)rowSetInternal)).getUsername(), ((RowSet)((Object)rowSetInternal)).getPassword());
            }
            catch (NamingException namingException) {
                throw new SQLException("(JNDI) Unable to connect");
            }
        }
        if (((RowSet)((Object)rowSetInternal)).getUrl() != null) {
            return DriverManager.getConnection(((RowSet)((Object)rowSetInternal)).getUrl(), ((RowSet)((Object)rowSetInternal)).getUsername(), ((RowSet)((Object)rowSetInternal)).getPassword());
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void decodeParams(Object[] objectArray, PreparedStatement preparedStatement) throws SQLException {
        int n = 0;
        while (n < objectArray.length) {
            block21: {
                int n2;
                try {
                    n2 = Array.getLength(objectArray[n]);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    preparedStatement.setObject(n + 1, objectArray[n]);
                    break block21;
                }
                Object[] objectArray2 = (Object[])objectArray[n];
                if (n2 == 2) {
                    if (objectArray2[0] == null) {
                        preparedStatement.setNull(n + 1, (Integer)objectArray2[1]);
                    } else if (objectArray2[0] instanceof Date || objectArray2[0] instanceof Time || objectArray2[0] instanceof Timestamp) {
                        System.err.println("Detected a Date");
                        if (!(objectArray2[1] instanceof Calendar)) throw new SQLException("Unable to deduce param type");
                        System.err.println("Detected a Calendar");
                        preparedStatement.setDate(n + 1, (Date)objectArray2[0], (Calendar)objectArray2[1]);
                    } else if (objectArray2[0] instanceof Reader) {
                        preparedStatement.setCharacterStream(n + 1, (Reader)objectArray2[0], (Integer)objectArray2[1]);
                    } else if (objectArray2[1] instanceof Integer) {
                        preparedStatement.setObject(n + 1, objectArray2[0], (Integer)objectArray2[1]);
                    }
                } else if (n2 == 3) {
                    if (objectArray2[0] == null) {
                        preparedStatement.setNull(n + 1, (Integer)objectArray2[1], (String)objectArray2[2]);
                    } else {
                        if (objectArray2[0] instanceof InputStream) {
                            switch ((Integer)objectArray2[2]) {
                                case 0: {
                                    preparedStatement.setUnicodeStream(n + 1, (InputStream)objectArray2[0], (Integer)objectArray2[1]);
                                }
                                case 1: {
                                    preparedStatement.setBinaryStream(n + 1, (InputStream)objectArray2[0], (Integer)objectArray2[1]);
                                }
                                case 2: {
                                    preparedStatement.setAsciiStream(n + 1, (InputStream)objectArray2[0], (Integer)objectArray2[1]);
                                }
                            }
                            throw new SQLException("Unable to deduce parameter type");
                        }
                        if (!(objectArray2[1] instanceof Integer) || !(objectArray2[2] instanceof Integer)) throw new SQLException("Unable to deduce param type");
                        preparedStatement.setObject(n + 1, objectArray2[0], (Integer)objectArray2[1], (int)((Integer)objectArray2[2]));
                    }
                }
            }
            ++n;
        }
    }

    protected boolean getCloseConnection() {
        return !this.userCon;
    }

    public void readData(RowSetInternal rowSetInternal) throws SQLException {
        CachedRowSet cachedRowSet = (CachedRowSet)rowSetInternal;
        cachedRowSet.close();
        this.writerCalls = 0;
        this.userCon = false;
        Connection connection = this.connect(rowSetInternal);
        if (connection == null || cachedRowSet.getCommand() == null) {
            throw new SQLException();
        }
        try {
            connection.setTransactionIsolation(cachedRowSet.getTransactionIsolation());
        }
        catch (Exception exception) {}
        PreparedStatement preparedStatement = connection.prepareStatement(cachedRowSet.getCommand());
        this.decodeParams(rowSetInternal.getParams(), preparedStatement);
        try {
            preparedStatement.setMaxRows(cachedRowSet.getMaxRows());
            preparedStatement.setMaxFieldSize(cachedRowSet.getMaxFieldSize());
            preparedStatement.setEscapeProcessing(cachedRowSet.getEscapeProcessing());
            preparedStatement.setQueryTimeout(cachedRowSet.getQueryTimeout());
        }
        catch (Exception exception) {}
        ResultSet resultSet = preparedStatement.executeQuery();
        cachedRowSet.populate(resultSet);
        resultSet.close();
        preparedStatement.close();
        try {
            connection.commit();
        }
        catch (SQLException sQLException) {}
        if (this.getCloseConnection()) {
            connection.close();
        }
    }

    public boolean reset() throws SQLException {
        ++this.writerCalls;
        return this.writerCalls == 1;
    }
}

