/*
 * Decompiled with CFR 0.152.
 */
package iDSS.sm;

import iDSS.disp.DisplayFrame;
import iDSS.gridDisp.DrawingPanel2;
import iDSS.sm.SurvivalModel;
import iDSS.utils.StringHandler;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class EllipticSurvivalModel
implements SurvivalModel,
Serializable,
ActionListener {
    private double majorAxis;
    private double minorAxis;
    private double axisShiftX;
    private double axisShiftY;
    private double axisRotation;
    private double criticalFloodingDepth;
    private String modelName = "Ellipse Model";
    private double rateOfDescent = 0.001;
    private Vector textFieldsVector;
    private PropertyChangeSupport pcs;
    private DisplayFrame internalFrame;

    public EllipticSurvivalModel() {
        this.majorAxis = 0.0;
        this.minorAxis = 0.0;
        this.axisShiftX = 0.0;
        this.axisShiftY = 0.0;
        this.axisRotation = 0.0;
        this.criticalFloodingDepth = 0.0;
        this.pcs = new PropertyChangeSupport(this);
    }

    public EllipticSurvivalModel(double d, double d2, double d3, double d4, double d5, double d6) {
        this.majorAxis = d > 0.0 ? d : 0.0;
        this.minorAxis = d2 > 0.0 ? d2 : 0.0;
        this.axisShiftX = d3 > 0.0 ? d3 : 0.0;
        this.axisShiftY = d4 > 0.0 ? d4 : 0.0;
        if (d5 >= Math.PI * -2 && d5 <= Math.PI * 2) {
            this.axisRotation = d5;
        } else {
            int n = (int)Math.floor(d5 / (Math.PI * 2));
            this.axisRotation = d5 - (double)n * Math.PI;
        }
        this.criticalFloodingDepth = d6 >= 0.0 ? d6 : 0.0;
        this.pcs = new PropertyChangeSupport(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public String getName() {
        return this.modelName;
    }

    public void setMajorAxis(double d) {
        this.majorAxis = d;
    }

    public void setMinorAxis(double d) {
        this.minorAxis = d;
    }

    public void setXShift(double d) {
        this.axisShiftX = d;
    }

    public void setYShift(double d) {
        this.axisShiftY = d;
    }

    public void setAxisRotation(double d) {
        this.axisRotation = d;
    }

    public void setCriticalFloodingDepth(double d) {
        this.criticalFloodingDepth = d;
    }

    public double getMajorAxis() {
        return this.majorAxis;
    }

    public double getMinorAxis() {
        return this.minorAxis;
    }

    public double getXShift() {
        return this.axisShiftX;
    }

    public double getYShift() {
        return this.axisShiftY;
    }

    public double getAxisRotation() {
        return this.axisRotation;
    }

    public double getCriticalFloodingDepth(Timestamp timestamp) {
        return this.criticalFloodingDepth;
    }

    private double getDistanceToPeripheri(double d) {
        double d2 = Math.pow(Math.cos(d), 2.0) / Math.pow(this.majorAxis, 2.0);
        double d3 = Math.pow(Math.sin(d), 2.0) / Math.pow(this.minorAxis, 2.0);
        double d4 = Math.sqrt(1.0 / (d2 + d3));
        return d4;
    }

    private double getTheta(double d, double d2) {
        double d3 = d2 - this.axisShiftY;
        double d4 = d - this.axisShiftX;
        double d5 = Math.atan2(d3, d4) - this.axisRotation;
        return d5;
    }

    private double getR(double d, double d2, double d3) {
        double d4 = d - this.axisShiftX;
        double d5 = Math.cos(d3 + this.axisRotation);
        double d6 = d4 / d5;
        return d6;
    }

    public double getProbability(long l, double d, Timestamp timestamp) {
        double d2 = l;
        if (d2 == this.getXShift()) {
            d2 *= 1.01;
        }
        double d3 = this.getTheta(d2, d);
        double d4 = this.getR(d2, d, d3);
        double d5 = this.getDistanceToPeripheri(d3);
        double d6 = Math.exp((d5 - d4) * this.rateOfDescent);
        d6 = Math.min(1.0, d6);
        return d6;
    }

    public DisplayFrame showDetails(boolean bl) {
        this.internalFrame = new DisplayFrame(this.modelName, false, true, false, true, null);
        DrawingPanel2 drawingPanel2 = new DrawingPanel2(400, 100);
        EllipticSurvivalModel.drawModel(drawingPanel2);
        JLabel jLabel = new JLabel("Major axis (hours):");
        JLabel jLabel2 = new JLabel("Minor axis (depth units):");
        JLabel jLabel3 = new JLabel("X-axis shift (hours):");
        JLabel jLabel4 = new JLabel("Y-axis shift (depth units):");
        JLabel jLabel5 = new JLabel("Axis rotation (degrees):");
        JLabel jLabel6 = new JLabel("Cirtical flood depth (depth units):");
        JTextField jTextField = new JTextField(String.valueOf(this.majorAxis / 3600000.0), 10);
        JTextField jTextField2 = new JTextField(String.valueOf(this.minorAxis), 10);
        JTextField jTextField3 = new JTextField(String.valueOf(this.axisShiftX / 3600000.0), 10);
        JTextField jTextField4 = new JTextField(String.valueOf(this.axisShiftY), 10);
        JTextField jTextField5 = new JTextField(String.valueOf(Math.toDegrees(this.axisRotation)), 10);
        JTextField jTextField6 = new JTextField(String.valueOf(this.criticalFloodingDepth), 10);
        jTextField.setEditable(bl);
        jTextField2.setEditable(bl);
        jTextField3.setEditable(bl);
        jTextField4.setEditable(bl);
        jTextField5.setEditable(bl);
        jTextField6.setEditable(bl);
        this.textFieldsVector = new Vector();
        this.textFieldsVector.add(jTextField);
        this.textFieldsVector.add(jTextField2);
        this.textFieldsVector.add(jTextField3);
        this.textFieldsVector.add(jTextField4);
        this.textFieldsVector.add(jTextField5);
        this.textFieldsVector.add(jTextField6);
        JButton jButton = new JButton("Accept");
        jButton.setEnabled(bl);
        jButton.setActionCommand("accept");
        jButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(6, 2));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add(jLabel);
        jPanel.add(jTextField);
        jPanel.add(jLabel2);
        jPanel.add(jTextField2);
        jPanel.add(jLabel3);
        jPanel.add(jTextField3);
        jPanel.add(jLabel4);
        jPanel.add(jTextField4);
        jPanel.add(jLabel5);
        jPanel.add(jTextField5);
        jPanel.add(jLabel6);
        jPanel.add(jTextField6);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(jButton);
        this.internalFrame.getContentPane().setLayout(new BoxLayout(this.internalFrame.getContentPane(), 1));
        this.internalFrame.getContentPane().add(drawingPanel2);
        this.internalFrame.getContentPane().add(jPanel);
        this.internalFrame.getContentPane().add(jPanel2);
        this.internalFrame.pack();
        this.internalFrame.setVisible(true);
        return this.internalFrame;
    }

    public static void drawModel(DrawingPanel2 drawingPanel2) {
        BufferedImage bufferedImage = drawingPanel2.getCanvas();
        Graphics graphics = bufferedImage.getGraphics();
        int n = drawingPanel2.getCanvasX();
        int n2 = drawingPanel2.getCanvasY();
        graphics.setColor(Color.lightGray);
        graphics.fillRect(0, 0, n, n2);
        int n3 = 10;
        int n4 = 200;
        int n5 = 90;
        graphics.setColor(Color.black);
        int n6 = (n - n4) / 2;
        int n7 = (n2 - n5) / 2;
        int n8 = n6 + n4 / 2;
        int n9 = n7 + n5 / 2;
        graphics.drawOval(n6, n7, n4, n5);
        graphics.drawLine(n8, n9, n6, n9);
        graphics.drawLine(n8, n9, n8, n7);
        graphics.drawString("Major axis", n6 + 20, n9 + 15);
        graphics.drawString("Minor axis", n8 + 5, n9 - n5 / 4);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("accept")) {
            JTextField jTextField = (JTextField)this.textFieldsVector.elementAt(0);
            double d = Double.parseDouble(jTextField.getText());
            d = d * 60.0 * 60.0 * 1000.0;
            jTextField = (JTextField)this.textFieldsVector.elementAt(1);
            double d2 = Double.parseDouble(jTextField.getText());
            jTextField = (JTextField)this.textFieldsVector.elementAt(2);
            double d3 = Double.parseDouble(jTextField.getText());
            d3 = d3 * 60.0 * 60.0 * 1000.0;
            jTextField = (JTextField)this.textFieldsVector.elementAt(3);
            double d4 = Double.parseDouble(jTextField.getText());
            jTextField = (JTextField)this.textFieldsVector.elementAt(4);
            double d5 = Double.parseDouble(jTextField.getText());
            d5 = Math.toRadians(d5);
            jTextField = (JTextField)this.textFieldsVector.elementAt(5);
            double d6 = Double.parseDouble(jTextField.getText());
            this.setMajorAxis(d);
            this.setMinorAxis(d2);
            this.setXShift(d3);
            this.setYShift(d4);
            this.setAxisRotation(d5);
            this.setCriticalFloodingDepth(d6);
            this.pcs.firePropertyChange("setSurvivalModel", null, this.getCopy());
            this.pcs.firePropertyChange("removeFromModelView", null, this.internalFrame);
        }
    }

    public SurvivalModel getCopy() {
        Timestamp timestamp = null;
        EllipticSurvivalModel ellipticSurvivalModel = new EllipticSurvivalModel(this.getMajorAxis(), this.getMinorAxis(), this.getXShift(), this.getYShift(), this.getAxisRotation(), this.getCriticalFloodingDepth(timestamp));
        return ellipticSurvivalModel;
    }

    public Hashtable getParameters() {
        Hashtable<String, Double> hashtable = new Hashtable<String, Double>();
        hashtable.put("majorAxis", new Double(this.majorAxis));
        hashtable.put("minorAxis", new Double(this.minorAxis));
        hashtable.put("axisShiftX", new Double(this.axisShiftX));
        hashtable.put("axisShiftY", new Double(this.axisShiftY));
        hashtable.put("axisRotation", new Double(this.axisRotation));
        hashtable.put("criticalFloodingDepth", new Double(this.criticalFloodingDepth));
        return hashtable;
    }

    public void setParameters(Hashtable hashtable) {
        this.majorAxis = StringHandler.stringToDouble((String)hashtable.get("majorAxis"));
        this.minorAxis = StringHandler.stringToDouble((String)hashtable.get("minorAxis"));
        this.axisShiftX = StringHandler.stringToDouble((String)hashtable.get("axisShiftX"));
        this.axisShiftY = StringHandler.stringToDouble((String)hashtable.get("axisShiftY"));
        this.axisRotation = StringHandler.stringToDouble((String)hashtable.get("axisRotation"));
        this.criticalFloodingDepth = StringHandler.stringToDouble((String)hashtable.get("criticalFloodingDepth"));
    }
}

