/*
 * Decompiled with CFR 0.152.
 */
package iDSS.tidalData;

import iDSS.beans2.DataManagerJBean;
import iDSS.disp.DisplayFrame;
import iDSS.disp.TabularDisplay;
import iDSS.tables.GeneralTableModel;
import iDSS.tidalData.ClientDataSet;
import iDSS.tidalData.TimestampPanel;
import iDSS.xyGraph.GraphicalDisplay2;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DataManager
extends DisplayFrame
implements ItemListener,
ActionListener,
ChangeListener,
PropertyChangeListener {
    private JPanel dataTablePanel;
    private JTable dataTable;
    private JScrollPane dataTableScrollPane;
    private JPanel processOptionsPanel;
    private JComboBox processTypesCombo;
    private String[] processTypes = new String[]{"Table", "XYGraph", "Devise Tidal Model", "Statistics", "Moving Average", "Correlation", "Select Tidal Model", "Dispose"};
    private JButton processDoItButton;
    private JButton selectDataModelButton;
    private JPanel processTypesPanel;
    private JPanel processFurtherOptionsPanel;
    private JPanel processTablePanel;
    private JPanel processXYGraphPanel;
    private JPanel processDataModelPanel;
    private JPanel processStatisticsPanel;
    private JPanel processMovingAveragePanel;
    private JPanel processCorrelationPanel;
    private JPanel selectPanel;
    private JPanel noOptionsPanel;
    private TimestampPanel tableStartDatePanel;
    private TimestampPanel tableEndDatePanel;
    private TimestampPanel xyGraphStartDatePanel;
    private TimestampPanel xyGraphEndDatePanel;
    private TimestampPanel dataModelStartDatePanel;
    private TimestampPanel dataModelEndDatePanel;
    private TimestampPanel statisticsStartDatePanel;
    private TimestampPanel statisticsEndDatePanel;
    private TimestampPanel movingAverageStartDatePanel;
    private TimestampPanel movingAverageEndDatePanel;
    private TimestampPanel correlationStartDatePanel;
    private TimestampPanel correlationEndDatePanel;
    private TimestampPanel selectStartDatePanel;
    private TimestampPanel selectEndDatePanel;
    private JLabel processTypesLabel;
    private JLabel superimposeLabel;
    private JComboBox superimposeCombo;
    private Vector superimposeVector;
    private JLabel correlateLabel;
    private JComboBox correlateCombo;
    private JComboBox selectCombo;
    private JLabel dataModelIterationsLabel;
    private JSlider dataModelIterationsSlider;
    private int numberOfFourierIterations = 0;
    private JLabel movingAverageLengthLabel;
    private JLabel movingAverageUnitLabel;
    private JSlider movingAverageLengthSlider;
    private JComboBox movingAverageUnitCombo;
    private String[] movignAverageUnits = new String[]{"Days", "Hours"};
    private GridBagLayout gbLayout = new GridBagLayout();
    private GridBagConstraints gbConstraints = new GridBagConstraints();
    private boolean ALLOW_ROW_SELECTION = true;
    private Vector currentRow;
    private String tidalModelKey;
    private DataManagerJBean dataManagerJBean = new DataManagerJBean();

    public DataManager(ClientDataSet clientDataSet) {
        super("dataManager", false, false, false, true, null);
        this.dataManagerJBean.addPropertyChangeListener(this);
        this.dataManagerJBean.addToDataSet(clientDataSet);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.gbConstraints.fill = 1;
        this.gbConstraints.weightx = 0.0;
        this.gbConstraints.weighty = 0.0;
        this.gbConstraints.ipadx = 5;
        this.gbConstraints.ipady = 5;
        this.dataTablePanel = new JPanel();
        this.dataTablePanel.setBorder(BorderFactory.createTitledBorder("Data Fetched So Far"));
        Vector<String> vector = new Vector<String>();
        vector.add("SQL String");
        vector.add("Station");
        vector.add("Start Date");
        vector.add("End Date");
        Vector<Vector> vector2 = new Vector<Vector>();
        vector2.add(clientDataSet.getDataSetVector());
        GeneralTableModel generalTableModel = new GeneralTableModel(vector2, vector);
        this.dataTable = new JTable(generalTableModel);
        this.dataTable.setPreferredScrollableViewportSize(new Dimension(500, 70));
        this.dataTableScrollPane = new JScrollPane(this.dataTable, 20, 30);
        this.dataTablePanel.add((Component)this.dataTableScrollPane, "Center");
        this.processTypesPanel = new JPanel();
        this.processTypesPanel.setBorder(BorderFactory.createTitledBorder("Process Types"));
        this.processTypesPanel.setLayout(new BoxLayout(this.processTypesPanel, 1));
        this.processTypesCombo = new JComboBox<String>(this.processTypes);
        this.processDoItButton = new JButton("Do it!");
        this.processDoItButton.setActionCommand("doIt");
        this.processDoItButton.addActionListener(this);
        this.processTypesCombo.addItemListener(this);
        this.processTypesPanel.add(this.processTypesCombo);
        this.processTypesPanel.add(this.processDoItButton);
        this.tableStartDatePanel = new TimestampPanel("Start", 1900, 2050);
        this.tableEndDatePanel = new TimestampPanel("End", 1900, 2050);
        this.xyGraphStartDatePanel = new TimestampPanel("Start", 1900, 2050);
        this.xyGraphEndDatePanel = new TimestampPanel("End", 1900, 2050);
        this.dataModelStartDatePanel = new TimestampPanel("Start", 1900, 2050);
        this.dataModelEndDatePanel = new TimestampPanel("End", 1900, 2050);
        this.statisticsStartDatePanel = new TimestampPanel("Start", 1900, 2050);
        this.statisticsEndDatePanel = new TimestampPanel("End", 1900, 2050);
        this.movingAverageStartDatePanel = new TimestampPanel("Start", 1900, 2050);
        this.movingAverageEndDatePanel = new TimestampPanel("End", 1900, 2050);
        this.correlationStartDatePanel = new TimestampPanel("Start", 1900, 2050);
        this.correlationEndDatePanel = new TimestampPanel("End", 1900, 2050);
        this.selectStartDatePanel = new TimestampPanel("Start", 1900, 2050);
        this.selectEndDatePanel = new TimestampPanel("End", 1900, 2050);
        this.processTablePanel = new JPanel();
        this.processTablePanel.setBorder(BorderFactory.createTitledBorder("Table"));
        this.processTablePanel.setLayout(this.gbLayout);
        this.addComponent(this.processTablePanel, this.tableStartDatePanel, 0, 0, 3, 1);
        this.addComponent(this.processTablePanel, this.tableEndDatePanel, 1, 0, 3, 1);
        this.processXYGraphPanel = new JPanel();
        this.processXYGraphPanel.setBorder(BorderFactory.createTitledBorder("XY Graph"));
        this.processXYGraphPanel.setLayout(this.gbLayout);
        this.superimposeLabel = new JLabel("Superimpose on");
        this.superimposeVector = new Vector();
        this.superimposeVector.add("None");
        this.superimposeCombo = new JComboBox(this.superimposeVector);
        this.addComponent(this.processXYGraphPanel, this.superimposeLabel, 0, 0, 2, 1);
        this.addComponent(this.processXYGraphPanel, this.superimposeCombo, 0, 2, 2, 1);
        this.addComponent(this.processXYGraphPanel, this.xyGraphStartDatePanel, 1, 0, 4, 1);
        this.addComponent(this.processXYGraphPanel, this.xyGraphEndDatePanel, 2, 0, 4, 1);
        this.processDataModelPanel = new JPanel();
        this.processDataModelPanel.setBorder(BorderFactory.createTitledBorder("Devise Tidal Model"));
        this.processDataModelPanel.setLayout(this.gbLayout);
        this.dataModelIterationsLabel = new JLabel("Number of iterations");
        this.dataModelIterationsSlider = new JSlider(0, 0, 3000, this.numberOfFourierIterations);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        hashtable.put(new Integer(0), new JLabel("0"));
        hashtable.put(new Integer(500), new JLabel("500"));
        hashtable.put(new Integer(1000), new JLabel("1000"));
        hashtable.put(new Integer(1500), new JLabel("1500"));
        hashtable.put(new Integer(2000), new JLabel("2000"));
        hashtable.put(new Integer(2500), new JLabel("2500"));
        hashtable.put(new Integer(3000), new JLabel("3000"));
        this.dataModelIterationsSlider.setMajorTickSpacing(500);
        this.dataModelIterationsSlider.setMinorTickSpacing(100);
        this.dataModelIterationsSlider.setPaintTicks(true);
        this.dataModelIterationsSlider.setLabelTable(hashtable);
        this.dataModelIterationsSlider.setPaintLabels(true);
        this.dataModelIterationsSlider.setSnapToTicks(true);
        this.dataModelIterationsSlider.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        this.dataModelIterationsSlider.addChangeListener(this);
        this.addComponent(this.processDataModelPanel, this.dataModelIterationsLabel, 0, 0, 1, 1);
        this.addComponent(this.processDataModelPanel, this.dataModelIterationsSlider, 0, 1, 3, 1);
        this.addComponent(this.processDataModelPanel, this.dataModelStartDatePanel, 1, 0, 4, 1);
        this.addComponent(this.processDataModelPanel, this.dataModelEndDatePanel, 2, 0, 4, 1);
        this.processStatisticsPanel = new JPanel();
        this.processStatisticsPanel.setBorder(BorderFactory.createTitledBorder("Statistics"));
        this.processStatisticsPanel.setLayout(this.gbLayout);
        this.addComponent(this.processStatisticsPanel, this.statisticsStartDatePanel, 0, 0, 3, 1);
        this.addComponent(this.processStatisticsPanel, this.statisticsEndDatePanel, 1, 0, 3, 1);
        this.processMovingAveragePanel = new JPanel();
        this.processMovingAveragePanel.setBorder(BorderFactory.createTitledBorder("Moving Average"));
        this.processMovingAveragePanel.setLayout(this.gbLayout);
        this.movingAverageLengthLabel = new JLabel("Length");
        this.movingAverageUnitLabel = new JLabel("Unit");
        this.movingAverageLengthSlider = new JSlider(0, 1, 100, 50);
        this.movingAverageUnitCombo = new JComboBox<String>(this.movignAverageUnits);
        this.addComponent(this.processMovingAveragePanel, this.movingAverageLengthSlider, 0, 0, 3, 1);
        this.addComponent(this.processMovingAveragePanel, this.movingAverageUnitCombo, 0, 3, 1, 1);
        this.addComponent(this.processMovingAveragePanel, this.movingAverageStartDatePanel, 1, 0, 4, 1);
        this.addComponent(this.processMovingAveragePanel, this.movingAverageEndDatePanel, 2, 0, 4, 1);
        this.processCorrelationPanel = new JPanel();
        this.processCorrelationPanel.setBorder(BorderFactory.createTitledBorder("Correlation"));
        this.processCorrelationPanel.setLayout(this.gbLayout);
        this.correlateLabel = new JLabel("Correlate with:");
        this.correlateCombo = new JComboBox();
        this.addComponent(this.processCorrelationPanel, this.correlateLabel, 0, 0, 1, 1);
        this.addComponent(this.processCorrelationPanel, this.correlateCombo, 0, 1, 3, 1);
        this.addComponent(this.processCorrelationPanel, this.correlationStartDatePanel, 1, 0, 4, 1);
        this.addComponent(this.processCorrelationPanel, this.correlationEndDatePanel, 2, 0, 4, 1);
        this.selectPanel = new JPanel();
        this.selectPanel.setBorder(BorderFactory.createTitledBorder("Select Tidal Model"));
        this.selectCombo = new JComboBox();
        this.selectCombo.addItem("None");
        this.selectCombo.addItemListener(this);
        this.selectDataModelButton = new JButton("Select");
        this.selectDataModelButton.setActionCommand("selectDataModel");
        this.selectDataModelButton.addActionListener(this);
        this.selectDataModelButton.setEnabled(false);
        this.selectPanel.setLayout(new BoxLayout(this.selectPanel, 1));
        this.selectPanel.add(this.selectCombo);
        this.selectPanel.add(this.selectDataModelButton);
        this.noOptionsPanel = new JPanel();
        this.noOptionsPanel.setBorder(BorderFactory.createTitledBorder("No options"));
        this.noOptionsPanel.add((Component)new JLabel("No options available"), "Center");
        this.processFurtherOptionsPanel = new JPanel();
        this.processFurtherOptionsPanel.setLayout(new CardLayout());
        this.processFurtherOptionsPanel.add((Component)this.processTablePanel, "Table");
        this.processFurtherOptionsPanel.add((Component)this.processXYGraphPanel, "XYGraph");
        this.processFurtherOptionsPanel.add((Component)this.processDataModelPanel, "Devise Tidal Model");
        this.processFurtherOptionsPanel.add((Component)this.processStatisticsPanel, "Statistics");
        this.processFurtherOptionsPanel.add((Component)this.processMovingAveragePanel, "Moving Average");
        this.processFurtherOptionsPanel.add((Component)this.processCorrelationPanel, "Correlation");
        this.processFurtherOptionsPanel.add((Component)this.selectPanel, "Select Tidal Model");
        this.processFurtherOptionsPanel.add((Component)this.noOptionsPanel, "Dispose");
        this.processOptionsPanel = new JPanel();
        this.processOptionsPanel.setBorder(BorderFactory.createTitledBorder("Process Options"));
        this.processDoItButton.setEnabled(false);
        this.addComponent(this.processOptionsPanel, this.processTypesPanel, 0, 0, 1, 1);
        this.addComponent(this.processOptionsPanel, this.processFurtherOptionsPanel, 0, 1, 2, 1);
        this.getContentPane().add(this.dataTablePanel);
        this.getContentPane().add(this.processOptionsPanel);
        this.pack();
        this.setVisible(true);
        this.dataTable.setPreferredScrollableViewportSize(new Dimension(500, 50));
        if (this.ALLOW_ROW_SELECTION) {
            ListSelectionModel listSelectionModel = this.dataTable.getSelectionModel();
            listSelectionModel.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                    if (listSelectionModel.isSelectionEmpty()) {
                        System.out.println("No rows are selected.");
                        DataManager.this.processDoItButton.setEnabled(false);
                    } else {
                        int n = listSelectionModel.getMinSelectionIndex();
                        System.out.println("Row " + n + " is now selected.");
                        DataManager.this.processDoItButton.setEnabled(true);
                        String string = (String)DataManager.this.dataTable.getValueAt(n, 0);
                        String string2 = (String)DataManager.this.dataTable.getValueAt(n, 1);
                        Timestamp timestamp = (Timestamp)DataManager.this.dataTable.getValueAt(n, 2);
                        Timestamp timestamp2 = (Timestamp)DataManager.this.dataTable.getValueAt(n, 3);
                        DataManager.this.currentRow = new Vector();
                        DataManager.this.currentRow.add(string);
                        DataManager.this.currentRow.add(string2);
                        DataManager.this.currentRow.add(timestamp);
                        DataManager.this.currentRow.add(timestamp2);
                        DataManager.this.dataManagerJBean.setCurrentRow(DataManager.this.currentRow);
                        System.out.println(timestamp.toString());
                        System.out.println(timestamp2.toString());
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(timestamp);
                        int n2 = calendar.get(1);
                        calendar.setTime(timestamp2);
                        int n3 = calendar.get(1);
                        DataManager.this.tableStartDatePanel.resetYearCombo(n2, n3);
                        DataManager.this.tableEndDatePanel.resetYearCombo(n2, n3);
                        DataManager.this.tableStartDatePanel.setTime(timestamp);
                        DataManager.this.tableEndDatePanel.setTime(timestamp2);
                        DataManager.this.xyGraphStartDatePanel.resetYearCombo(n2, n3);
                        DataManager.this.xyGraphEndDatePanel.resetYearCombo(n2, n3);
                        DataManager.this.xyGraphStartDatePanel.setTime(timestamp);
                        DataManager.this.xyGraphEndDatePanel.setTime(timestamp2);
                        DataManager.this.dataModelStartDatePanel.resetYearCombo(n2, n3);
                        DataManager.this.dataModelEndDatePanel.resetYearCombo(n2, n3);
                        DataManager.this.dataModelStartDatePanel.setTime(timestamp);
                        DataManager.this.dataModelEndDatePanel.setTime(timestamp2);
                        DataManager.this.statisticsStartDatePanel.resetYearCombo(n2, n3);
                        DataManager.this.statisticsEndDatePanel.resetYearCombo(n2, n3);
                        DataManager.this.statisticsStartDatePanel.setTime(timestamp);
                        DataManager.this.statisticsEndDatePanel.setTime(timestamp2);
                        DataManager.this.movingAverageStartDatePanel.resetYearCombo(n2, n3);
                        DataManager.this.movingAverageEndDatePanel.resetYearCombo(n2, n3);
                        DataManager.this.movingAverageStartDatePanel.setTime(timestamp);
                        DataManager.this.movingAverageEndDatePanel.setTime(timestamp2);
                        DataManager.this.correlationStartDatePanel.resetYearCombo(n2, n3);
                        DataManager.this.correlationEndDatePanel.resetYearCombo(n2, n3);
                        DataManager.this.correlationStartDatePanel.setTime(timestamp);
                        DataManager.this.correlationEndDatePanel.setTime(timestamp2);
                        DataManager.this.selectStartDatePanel.resetYearCombo(n2, n3);
                        DataManager.this.selectEndDatePanel.resetYearCombo(n2, n3);
                        DataManager.this.selectStartDatePanel.setTime(timestamp);
                        DataManager.this.selectEndDatePanel.setTime(timestamp2);
                    }
                }
            });
        } else {
            this.dataTable.setRowSelectionAllowed(false);
        }
    }

    private void addComponent(Container container, Component component, int n, int n2, int n3, int n4) {
        this.gbConstraints.gridx = n2;
        this.gbConstraints.gridy = n;
        this.gbConstraints.gridwidth = n3;
        this.gbConstraints.gridheight = n4;
        this.gbLayout.setConstraints(component, this.gbConstraints);
        container.add(component);
    }

    public void addToDataSet(ClientDataSet clientDataSet) {
        boolean bl = this.dataManagerJBean.addToDataSet(clientDataSet);
        if (bl) {
            GeneralTableModel generalTableModel = (GeneralTableModel)this.dataTable.getModel();
            Vector vector = clientDataSet.getDataSetVector();
            generalTableModel.addRow(vector);
            this.dataTable.setModel(generalTableModel);
        }
    }

    private void removeFromDataSet() {
        String string = (String)this.currentRow.elementAt(0);
        this.dataManagerJBean.removeFromDataSet(string);
        GeneralTableModel generalTableModel = (GeneralTableModel)this.dataTable.getModel();
        generalTableModel.removeRow(this.currentRow);
        this.dataTable.setModel(generalTableModel);
        this.dataTable.clearSelection();
        this.processDoItButton.setEnabled(false);
        Vector vector = new Vector();
        vector.add(this.currentRow.elementAt(1));
        vector.add(this.currentRow.elementAt(2));
        vector.add(this.currentRow.elementAt(3));
        this.firePropertyChange("disposeData", new Boolean(false), vector);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.dataModelIterationsSlider && this.dataModelIterationsSlider.getValueIsAdjusting()) {
            this.numberOfFourierIterations = this.dataModelIterationsSlider.getValue();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.processTypesCombo) {
            CardLayout cardLayout = (CardLayout)this.processFurtherOptionsPanel.getLayout();
            cardLayout.show(this.processFurtherOptionsPanel, (String)itemEvent.getItem());
        } else if (itemEvent.getSource() == this.selectCombo) {
            this.selectDataModelButton.setEnabled(true);
            this.tidalModelKey = (String)this.selectCombo.getSelectedItem();
            System.out.println("Current tidal model : " + this.tidalModelKey);
            if (this.tidalModelKey.equals("None")) {
                this.selectDataModelButton.setEnabled(false);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("doIt")) {
            String string = (String)this.processTypesCombo.getSelectedItem();
            System.out.println("do some process with " + string);
            if (string.equals("Table")) {
                String string2 = (String)this.currentRow.elementAt(0);
                TabularDisplay tabularDisplay = this.dataManagerJBean.getTable(string2, this.tableStartDatePanel.getTimestamp(), this.tableEndDatePanel.getTimestamp());
                if (tabularDisplay != null) {
                    this.addToModelView(tabularDisplay);
                } else {
                    JOptionPane.showMessageDialog(null, "No data found within the given range");
                }
            } else if (string.equals("XYGraph")) {
                String string3 = (String)this.currentRow.elementAt(0);
                String string4 = (String)this.superimposeCombo.getSelectedItem();
                Timestamp timestamp = this.xyGraphStartDatePanel.getTimestamp();
                Timestamp timestamp2 = this.xyGraphEndDatePanel.getTimestamp();
                String string5 = this.xyGraphStartDatePanel.getYear() + "/" + this.xyGraphStartDatePanel.getMonth() + "/" + this.xyGraphStartDatePanel.getDay();
                String string6 = this.xyGraphEndDatePanel.getYear() + "/" + this.xyGraphEndDatePanel.getMonth() + "/" + this.xyGraphEndDatePanel.getDay();
                String string7 = (String)this.currentRow.elementAt(1);
                String string8 = string7 + "," + string5 + "-" + string6;
                GraphicalDisplay2 graphicalDisplay2 = this.dataManagerJBean.drawXYGraph(string3, string8, timestamp, timestamp2, string4);
                if (graphicalDisplay2 != null) {
                    graphicalDisplay2.addPropertyChangeListener(this);
                    this.addToModelView(graphicalDisplay2);
                    this.superimposeCombo.addItem(string8);
                }
            } else if (!string.equals("Statistics")) {
                if (string.equals("Devise Tidal Model")) {
                    System.out.println("Tidal model selected");
                    String string9 = (String)this.currentRow.elementAt(0);
                    Timestamp timestamp = this.dataModelStartDatePanel.getTimestamp();
                    Timestamp timestamp3 = this.dataModelEndDatePanel.getTimestamp();
                    Vector vector = this.dataManagerJBean.makeTidalModel(string9, timestamp, timestamp3, this.numberOfFourierIterations);
                    if (vector != null) {
                        String string10 = (String)vector.elementAt(0);
                        this.selectCombo.addItem(string10);
                        GeneralTableModel generalTableModel = (GeneralTableModel)this.dataTable.getModel();
                        generalTableModel.addRow(vector);
                        this.dataTable.setModel(generalTableModel);
                    }
                } else if (!string.equals("Moving Average") && !string.equals("Correlation") && string.equals("Dispose")) {
                    this.removeFromDataSet();
                }
            }
        } else if (actionEvent.getActionCommand().equals("selectDataModel") && !this.tidalModelKey.equals("None")) {
            this.dataManagerJBean.setTidalModel(this.tidalModelKey);
        }
    }

    public boolean containsSql(String string) {
        return this.dataManagerJBean.containsSql(string);
    }

    private void addToModelView(DisplayFrame displayFrame) {
        this.firePropertyChange("addToModelView", null, displayFrame);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("internalFrameClosing")) {
            String string = (String)propertyChangeEvent.getNewValue();
            this.superimposeCombo.removeItem(string);
        }
        if (propertyChangeEvent.getPropertyName().equals("setTidalModel")) {
            this.firePropertyChange("setTidalModel", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
    }
}

