/*
 * Decompiled with CFR 0.152.
 */
package iDSS;

import iDSS.beans2.LCGridManagerJBean;
import iDSS.disp.DisplayFrame;
import iDSS.disp.DocumentDisplay;
import iDSS.tables.GeneralTableModel;
import iDSS.utils.DebugWriter;
import iDSS.utils.IDSSAppConstants;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class LCGridManager
extends DisplayFrame
implements ActionListener,
PropertyChangeListener {
    private LCGridManagerJBean gridManagerJBean = new LCGridManagerJBean();
    private String currentFileName;
    private JTable gridsTable;
    private JScrollPane gridsTableScrollPane;
    private JButton drawButton;
    private JButton disposeButton;
    private JButton selectButton;
    private JButton pickButton;
    private JButton describeButton;
    private JButton pickServerButton;
    private JButton saveServerButton;
    private boolean ALLOW_ROW_SELECTION = true;
    private String title = "modelSetupLandcoverRemote";

    public LCGridManager() {
        super("modelSetupLandcoverRemote", false, false, false, true, null);
        this.gridManagerJBean.removePropertyChangeListener(this);
        this.gridManagerJBean.addPropertyChangeListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Grids Fetched So Far"));
        Vector<String> vector = new Vector<String>();
        vector.add("Grid Name");
        vector.add("File Name");
        Vector vector2 = new Vector();
        GeneralTableModel generalTableModel = new GeneralTableModel(vector2, vector);
        this.gridsTable = new JTable(generalTableModel);
        this.gridsTable.setPreferredScrollableViewportSize(new Dimension(300, 50));
        this.gridsTableScrollPane = new JScrollPane(this.gridsTable, 20, 30);
        jPanel.add((Component)this.gridsTableScrollPane, "Center");
        this.drawButton = new JButton("Draw");
        this.drawButton.addActionListener(this);
        this.drawButton.setActionCommand("draw");
        this.drawButton.setEnabled(false);
        this.selectButton = new JButton("Select");
        this.selectButton.addActionListener(this);
        this.selectButton.setActionCommand("select");
        this.selectButton.setEnabled(false);
        this.disposeButton = new JButton("Dispose");
        this.disposeButton.addActionListener(this);
        this.disposeButton.setActionCommand("dispose");
        this.disposeButton.setEnabled(false);
        this.pickButton = new JButton("From file");
        this.pickButton.addActionListener(this);
        this.pickButton.setActionCommand("pickFromFile");
        this.pickButton.setEnabled(true);
        this.describeButton = new JButton("Describe");
        this.describeButton.addActionListener(this);
        this.describeButton.setActionCommand("describe");
        this.describeButton.setEnabled(false);
        this.pickServerButton = new JButton("From server");
        this.pickServerButton.addActionListener(this);
        this.pickServerButton.setActionCommand("pickFromServer");
        this.pickServerButton.setEnabled(true);
        this.saveServerButton = new JButton("To server");
        this.saveServerButton.addActionListener(this);
        this.saveServerButton.setActionCommand("toServer");
        this.saveServerButton.setEnabled(false);
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        jPanel3.add(this.drawButton);
        jPanel3.add(this.selectButton);
        jPanel3.add(this.disposeButton);
        jPanel3.add(this.describeButton);
        jPanel4.add(this.pickButton);
        jPanel4.add(this.pickServerButton);
        jPanel4.add(this.saveServerButton);
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.add(jPanel3);
        jPanel2.add(jPanel4);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(jPanel);
        this.getContentPane().add(jPanel2);
        this.pack();
        this.setVisible(true);
        this.gridsTable.setPreferredScrollableViewportSize(new Dimension(300, 40));
        if (this.ALLOW_ROW_SELECTION) {
            ListSelectionModel listSelectionModel = this.gridsTable.getSelectionModel();
            listSelectionModel.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                    if (listSelectionModel.isSelectionEmpty()) {
                        System.out.println("No rows are selected.");
                        LCGridManager.this.drawButton.setEnabled(false);
                        LCGridManager.this.selectButton.setEnabled(false);
                        LCGridManager.this.disposeButton.setEnabled(false);
                        LCGridManager.this.describeButton.setEnabled(false);
                        LCGridManager.this.saveServerButton.setEnabled(false);
                        LCGridManager.this.gridManagerJBean.setCurrentFileName(null);
                    } else {
                        int n = listSelectionModel.getMinSelectionIndex();
                        System.out.println("Row " + n + " is now selected.");
                        LCGridManager.this.drawButton.setEnabled(true);
                        LCGridManager.this.selectButton.setEnabled(true);
                        LCGridManager.this.disposeButton.setEnabled(true);
                        LCGridManager.this.describeButton.setEnabled(true);
                        LCGridManager.this.saveServerButton.setEnabled(true);
                        LCGridManager.this.currentFileName = (String)LCGridManager.this.gridsTable.getValueAt(n, 1);
                        LCGridManager.this.gridManagerJBean.setCurrentFileName(LCGridManager.this.currentFileName);
                    }
                }
            });
        } else {
            this.gridsTable.setRowSelectionAllowed(false);
        }
    }

    public void addToGrids(Vector vector) {
        GeneralTableModel generalTableModel = (GeneralTableModel)this.gridsTable.getModel();
        generalTableModel.addRow(vector);
        this.gridsTable.setModel(generalTableModel);
        this.saveServerButton.setEnabled(false);
    }

    private void removeFromGrids(Vector vector) {
        this.drawButton.setEnabled(false);
        this.selectButton.setEnabled(false);
        this.disposeButton.setEnabled(false);
        GeneralTableModel generalTableModel = (GeneralTableModel)this.gridsTable.getModel();
        generalTableModel.removeRow(vector);
        this.gridsTable.setModel(generalTableModel);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("pickFromFile")) {
            if (IDSSAppConstants.debug) {
                DebugWriter.writeDebug("pickFromFile");
            }
            this.gridManagerJBean.pickGrid();
        } else if (actionEvent.getActionCommand().equals("draw")) {
            if (IDSSAppConstants.debug) {
                DebugWriter.writeDebug("draw");
            }
            this.gridManagerJBean.drawGrid();
        } else if (actionEvent.getActionCommand().equals("dispose")) {
            if (IDSSAppConstants.debug) {
                DebugWriter.writeDebug("dispose");
            }
            this.gridManagerJBean.removeFromGrids();
        } else if (actionEvent.getActionCommand().equals("select")) {
            if (IDSSAppConstants.debug) {
                DebugWriter.writeDebug("select");
            }
            this.gridManagerJBean.selectGrid();
        } else if (actionEvent.getActionCommand().equals("toServer")) {
            if (IDSSAppConstants.debug) {
                DebugWriter.writeDebug("toServer");
            }
            System.out.println("toServer");
            this.gridManagerJBean.saveToServer();
        } else if (actionEvent.getActionCommand().equals("pickFromServer")) {
            if (IDSSAppConstants.debug) {
                DebugWriter.writeDebug("pickFromServer");
            }
            System.out.println("pickFromServer");
            this.gridManagerJBean.pickFromServer();
        } else if (actionEvent.getActionCommand().equals("describe")) {
            if (IDSSAppConstants.debug) {
                DebugWriter.writeDebug("describe");
            }
            System.out.println("pickFromServer");
            this.gridManagerJBean.describe();
        }
    }

    private void describe(Vector vector) {
        DocumentDisplay documentDisplay = new DocumentDisplay("Describing :", vector, "text/HTML");
        this.firePropertyChange("addToModelView", null, documentDisplay);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("LCGridManagerRemoveFromGrids")) {
            this.removeFromGrids((Vector)propertyChangeEvent.getNewValue());
        }
        if (propertyChangeEvent.getPropertyName().equals("LCGridManagerAddToGrids")) {
            this.addToGrids((Vector)propertyChangeEvent.getNewValue());
        }
        if (propertyChangeEvent.getPropertyName().equals("LCGridManagerGridDisp")) {
            this.firePropertyChange("addToModelView", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
        if (propertyChangeEvent.getPropertyName().equals("LCGridManagerImgDisp")) {
            this.firePropertyChange("addToModelView", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
        if (propertyChangeEvent.getPropertyName().equals("addGridToModel")) {
            this.firePropertyChange("addGridToModel", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
        if (propertyChangeEvent.getPropertyName().equals("LCGridManagerGridDesc")) {
            this.describe((Vector)propertyChangeEvent.getNewValue());
        }
    }

    public String toString() {
        return "DisplayFrame: " + this.title;
    }
}

