/*
 * Decompiled with CFR 0.152.
 */
package iDSS.gridDisp;

import iDSS.disp.ImageDisplay;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Vector;
import javax.swing.JOptionPane;

public class SurfaceColor {
    private Vector zValues;
    private Vector rValues;
    private Vector gValues;
    private Vector bValues;
    private int x0 = 20;
    private int y0 = 20;
    private int hGap = 2;
    private int tickLength = 5;
    private int cellWidth = 20;
    private int cellHeight = 2;
    private int stringLength = 30;
    private int legendWidth;
    private int legendHeight;
    private String legendTitle;
    private int numberOfTics = 5;
    private int type;
    public static int GENERAL = 0;
    public static int TIMECOLORSCHEMEUPTOAYEAR = 1;
    public static int DEM = 2;
    public static int FLOOD = 3;

    public SurfaceColor(String string, Vector vector, Vector vector2, Vector vector3, Vector vector4) {
        this.legendTitle = string;
        this.type = GENERAL;
        this.zValues = vector;
        this.rValues = vector2;
        this.gValues = vector3;
        this.bValues = vector4;
        this.legendWidth = this.x0 + this.cellWidth + this.tickLength + this.hGap + this.stringLength + this.x0;
        this.legendHeight = this.y0 + 256 * this.cellHeight + this.y0;
    }

    public SurfaceColor(String string, int n) {
        if (n == TIMECOLORSCHEMEUPTOAYEAR) {
            this.legendTitle = string;
            this.type = TIMECOLORSCHEMEUPTOAYEAR;
            this.zValues = new Vector();
            this.rValues = new Vector();
            this.gValues = new Vector();
            this.bValues = new Vector();
            double d = 3.1536E10;
            this.zValues.add(new Double(0.0));
            this.zValues.add(new Double(d * 0.25));
            this.zValues.add(new Double(d * 0.5));
            this.zValues.add(new Double(d * 0.75));
            this.zValues.add(new Double(d));
            this.rValues.add(new Double(0.0));
            this.rValues.add(new Double(1.0));
            this.rValues.add(new Double(0.75));
            this.rValues.add(new Double(0.5));
            this.rValues.add(new Double(0.0));
            this.gValues.add(new Double(1.0));
            this.gValues.add(new Double(0.0));
            this.gValues.add(new Double(0.0));
            this.gValues.add(new Double(0.0));
            this.gValues.add(new Double(0.0));
            this.bValues.add(new Double(0.0));
            this.bValues.add(new Double(0.25));
            this.bValues.add(new Double(0.5));
            this.bValues.add(new Double(0.75));
            this.bValues.add(new Double(1.0));
            this.legendWidth = this.x0 + this.cellWidth + this.tickLength + this.hGap + this.stringLength + this.x0;
            this.legendHeight = this.y0 + 256 * this.cellHeight + this.y0;
        } else {
            this.zValues = new Vector();
            this.rValues = new Vector();
            this.gValues = new Vector();
            this.bValues = new Vector();
            JOptionPane.showMessageDialog(null, "Surface color constructor with invalid option.\nGrids won't be drawn properly", "Warning", 2);
        }
    }

    public SurfaceColor(String string, double d, double d2, int n) {
        this.legendTitle = string;
        this.type = n;
        this.zValues = new Vector();
        this.rValues = new Vector();
        this.gValues = new Vector();
        this.bValues = new Vector();
        this.zValues.add(new Double(d));
        this.zValues.add(new Double(d + (d2 - d) * 0.25));
        this.zValues.add(new Double(d + (d2 - d) * 0.5));
        this.zValues.add(new Double(d + (d2 - d) * 0.75));
        this.zValues.add(new Double(d2));
        if (this.type == DEM) {
            this.rValues.add(new Double(0.0));
            this.rValues.add(new Double(0.0));
            this.rValues.add(new Double(0.0));
            this.rValues.add(new Double(0.5));
            this.rValues.add(new Double(1.0));
            this.gValues.add(new Double(0.0));
            this.gValues.add(new Double(0.5));
            this.gValues.add(new Double(1.0));
            this.gValues.add(new Double(0.5));
            this.gValues.add(new Double(0.0));
            this.bValues.add(new Double(1.0));
            this.bValues.add(new Double(0.0));
            this.bValues.add(new Double(0.0));
            this.bValues.add(new Double(0.0));
            this.bValues.add(new Double(0.0));
        } else if (this.type == FLOOD) {
            this.rValues.add(new Double(0.0));
            this.rValues.add(new Double(0.5));
            this.rValues.add(new Double(1.0));
            this.rValues.add(new Double(0.5));
            this.rValues.add(new Double(0.0));
            this.gValues.add(new Double(1.0));
            this.gValues.add(new Double(0.0));
            this.gValues.add(new Double(0.0));
            this.gValues.add(new Double(0.0));
            this.gValues.add(new Double(0.0));
            this.bValues.add(new Double(0.0));
            this.bValues.add(new Double(0.25));
            this.bValues.add(new Double(0.5));
            this.bValues.add(new Double(0.75));
            this.bValues.add(new Double(1.0));
        }
        this.legendWidth = this.x0 + this.cellWidth + this.tickLength + this.hGap + this.stringLength + this.x0;
        this.legendHeight = this.y0 + 256 * this.cellHeight + this.y0;
    }

    public String getTitle() {
        return this.legendTitle;
    }

    public int getLegendWidth() {
        return this.legendWidth;
    }

    public int getLegendHeight() {
        return this.legendHeight;
    }

    public Color getColor(double d) {
        Color color = new Color(0, 0, 0);
        double d2 = Double.parseDouble(this.zValues.elementAt(0).toString());
        double d3 = Double.parseDouble(this.zValues.elementAt(this.zValues.size() - 1).toString());
        if (d >= d2 && d <= d3) {
            int n = 0;
            while (n < this.zValues.size() - 1) {
                double d4 = Double.parseDouble(this.zValues.elementAt(n).toString());
                double d5 = Double.parseDouble(this.zValues.elementAt(n + 1).toString());
                if (d >= d4 && d <= d5) {
                    double d6 = Double.parseDouble(this.rValues.elementAt(n).toString());
                    double d7 = Double.parseDouble(this.rValues.elementAt(n + 1).toString());
                    double d8 = Double.parseDouble(this.gValues.elementAt(n).toString());
                    double d9 = Double.parseDouble(this.gValues.elementAt(n + 1).toString());
                    double d10 = Double.parseDouble(this.bValues.elementAt(n).toString());
                    double d11 = Double.parseDouble(this.bValues.elementAt(n + 1).toString());
                    float f = new Double((d7 - d6) * (d - d4) / (d5 - d4) + d6).floatValue();
                    float f2 = new Double((d9 - d8) * (d - d4) / (d5 - d4) + d8).floatValue();
                    float f3 = new Double((d11 - d10) * (d - d4) / (d5 - d4) + d10).floatValue();
                    color = new Color(Math.abs(f), Math.abs(f2), Math.abs(f3));
                    break;
                }
                ++n;
            }
        } else if (d > d3) {
            double d12 = Double.parseDouble(this.rValues.elementAt(this.rValues.size() - 1).toString());
            double d13 = Double.parseDouble(this.gValues.elementAt(this.gValues.size() - 1).toString());
            double d14 = Double.parseDouble(this.bValues.elementAt(this.bValues.size() - 1).toString());
            float f = new Double(d12).floatValue();
            float f4 = new Double(d13).floatValue();
            float f5 = new Double(d14).floatValue();
            color = new Color(Math.abs(f), Math.abs(f4), Math.abs(f5));
        } else if (d < d2) {
            double d15 = Double.parseDouble(this.rValues.elementAt(0).toString());
            double d16 = Double.parseDouble(this.gValues.elementAt(0).toString());
            double d17 = Double.parseDouble(this.bValues.elementAt(0).toString());
            float f = new Double(d15).floatValue();
            float f6 = new Double(d16).floatValue();
            float f7 = new Double(d17).floatValue();
            color = new Color(Math.abs(f), Math.abs(f6), Math.abs(f7));
        }
        return color;
    }

    public void drawLegend(ImageDisplay imageDisplay) {
        BufferedImage bufferedImage = this.getImage(imageDisplay);
        imageDisplay.refreshCanvas(bufferedImage);
    }

    public BufferedImage getImage(ImageDisplay imageDisplay) {
        Serializable serializable;
        BufferedImage bufferedImage = imageDisplay.getCanvas();
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        double d = Double.parseDouble(this.zValues.elementAt(0).toString());
        double d2 = Double.parseDouble(this.zValues.elementAt(this.zValues.size() - 1).toString());
        double d3 = (d2 - d) / 256.0;
        int n = 0;
        while (n < 256) {
            serializable = this.getColor(d + (double)n * d3);
            graphics2D.setColor((Color)serializable);
            graphics2D.fillRect(this.x0, this.y0 + (255 - n) * this.cellHeight, this.cellWidth, this.cellHeight);
            ++n;
        }
        graphics2D.setColor(Color.black);
        serializable = new DecimalFormat("0.00");
        d3 = (d2 - d) / (double)(this.numberOfTics - 1);
        int n2 = 0;
        while (n2 < this.numberOfTics) {
            double d4 = d + (double)n2 * d3;
            int n3 = new Double((double)(256 * this.cellHeight) * (d2 - d4) / (d2 - d) + (double)this.y0).intValue();
            String string = ((NumberFormat)serializable).format(d4);
            if (this.type == TIMECOLORSCHEMEUPTOAYEAR) {
                serializable = new DecimalFormat("0");
                string = ((NumberFormat)serializable).format(d4 /= 8.64E7) + " days";
            }
            graphics2D.drawLine(this.x0 + this.cellWidth, n3, this.x0 + this.cellWidth + this.tickLength, n3);
            graphics2D.drawString(string, this.x0 + this.cellWidth + this.tickLength + this.hGap, n3);
            ++n2;
        }
        return bufferedImage;
    }
}

