/*
 * Decompiled with CFR 0.152.
 */
package iDSS.grids;

import helpers.ServerGrid;
import iDSS.gridDisp.GridDisplay;
import iDSS.gridDisp.SurfaceColor;
import iDSS.grids.GenericGrid;
import iDSS.utils.FileNameDialog;
import iDSS.utils.IDSSAppConstants;
import iDSS.utils.ObjectReadWrite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;

public class Grid
implements GenericGrid,
Serializable {
    private int type;
    private final int UNKNOWN = 0;
    private final int VALUE = 1;
    private final int CLASS = 2;
    private String name;
    private int units;
    private final int FT = 1;
    private final int IN = 2;
    private final int M = 3;
    private final int MM = 4;
    private double cellSize;
    private int nRows;
    private int nColumns;
    private double xLLCorner;
    private double yLLCorner;
    private double xURCorner;
    private double yURCorner;
    private int noDataValue = -9999;
    private String fileName = "";
    private File inFile;
    private File outFile;
    private Vector z;
    private double zMax = -9999999.0;
    private double zMin = 9999999.0;
    private Vector zRows;
    private Vector zColumns;
    private boolean isGridRead = false;
    private File tempZFile;
    private static int recursionLevel = 0;
    private static final int MAX_RECURSION_LEVEL = 3;

    public Grid(String string, int n, int n2, File file) {
        this.name = string;
        if (file != null) {
            this.inFile = file;
            this.fileName = this.inFile.toString();
        }
        this.type = n > 0 && n < 3 ? n : 0;
        this.units = n2 > 0 && n2 < 5 ? n2 : 0;
    }

    public double getNoDataValue() {
        double d = this.noDataValue;
        return d;
    }

    public Vector getZ() {
        return this.getDataVector();
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public int getUnits() {
        return this.units;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setType(int n) {
        this.type = n;
    }

    public void setUnits(int n) {
        this.units = n;
    }

    public double getCellSize() {
        return this.cellSize;
    }

    public void setCellSize(double d) {
        this.cellSize = d;
    }

    public int getNRows() {
        return this.nRows;
    }

    public void setNRows(int n) {
        this.nRows = n;
    }

    public int getNColumns() {
        return this.nColumns;
    }

    public void setNColumns(int n) {
        this.nColumns = n;
    }

    public double getxLLCorner() {
        return this.xLLCorner;
    }

    public void setxLLCorner(double d) {
        this.xLLCorner = d;
    }

    public double getyLLCorner() {
        return this.yLLCorner;
    }

    public void setyLLCorner(double d) {
        this.yLLCorner = d;
    }

    public double getZMin() {
        return this.zMin;
    }

    public double getZMax() {
        return this.zMax;
    }

    public Vector getGridVector() {
        Vector<String> vector = new Vector<String>();
        vector.add(this.name);
        vector.add(this.fileName);
        return vector;
    }

    public Vector getDataVector() {
        Vector vector = this.z == null ? this.readFromTempFile() : this.z;
        return vector;
    }

    public void setDataVector(Vector vector) {
        this.z = vector;
        this.writeToTempFile();
        this.z = null;
    }

    public File getInFile() {
        return this.inFile;
    }

    public File getOutFile() {
        return this.outFile;
    }

    public void setOutFile(File file) {
        this.outFile = file;
    }

    public void setGrid(double d, double d2, double d3, Vector vector) {
        this.xLLCorner = d;
        this.yLLCorner = d2;
        this.cellSize = d3;
        this.xURCorner = (double)(this.nColumns - 1) * this.cellSize;
        this.yURCorner = (double)(this.nRows - 1) * this.cellSize;
        this.z = vector;
        this.writeToTempFile();
        this.z = null;
    }

    public void setGrid(double d, double d2, double d3, Vector vector, int n, int n2) {
        this.xLLCorner = d;
        this.yLLCorner = d2;
        this.cellSize = d3;
        this.xURCorner = (double)(this.nColumns - 1) * this.cellSize;
        this.yURCorner = (double)(this.nRows - 1) * this.cellSize;
        this.z = vector;
        this.nRows = n;
        this.nColumns = n2;
        this.writeToTempFile();
        this.z = null;
    }

    public void setGrid(double d, double d2, double d3, Vector vector, int n, int n2, boolean bl) {
        this.xLLCorner = d;
        this.yLLCorner = d2;
        this.cellSize = d3;
        this.xURCorner = (double)(this.nColumns - 1) * this.cellSize;
        this.yURCorner = (double)(this.nRows - 1) * this.cellSize;
        this.z = vector;
        this.nRows = n;
        this.nColumns = n2;
        if (bl) {
            this.writeToTempFile();
            this.z = null;
        }
    }

    private double getSecondToken(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        String string2 = stringTokenizer.nextToken();
        System.out.println(string2);
        string2 = stringTokenizer.nextToken();
        System.out.println(string2);
        double d = Double.parseDouble(string2);
        return d;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setRead(boolean bl) {
        this.isGridRead = bl;
    }

    public void gridIsRead(boolean bl) {
        this.isGridRead = bl;
    }

    public boolean isRead() {
        return this.isGridRead;
    }

    public void read() {
        this.isGridRead = true;
        try {
            String string;
            FileReader fileReader = new FileReader(this.inFile);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            int n = 0;
            while (n <= 5) {
                string = bufferedReader.readLine();
                System.out.println(string);
                if (string != null) {
                    switch (n) {
                        case 0: {
                            this.nColumns = (int)this.getSecondToken(string);
                            break;
                        }
                        case 1: {
                            this.nRows = (int)this.getSecondToken(string);
                            break;
                        }
                        case 2: {
                            this.xLLCorner = this.getSecondToken(string);
                            break;
                        }
                        case 3: {
                            this.yLLCorner = this.getSecondToken(string);
                            break;
                        }
                        case 4: {
                            this.cellSize = this.getSecondToken(string);
                            break;
                        }
                        case 5: {
                            this.noDataValue = (int)this.getSecondToken(string);
                            break;
                        }
                    }
                }
                ++n;
            }
            this.xURCorner = (double)(this.nColumns - 1) * this.cellSize;
            this.yURCorner = (double)(this.nRows - 1) * this.cellSize;
            this.z = new Vector();
            int n2 = 0;
            while (n2 < this.nRows) {
                string = bufferedReader.readLine();
                Vector<String> vector = new Vector<String>();
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                int n3 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    vector.add(string2);
                    if (Math.abs(Double.parseDouble(string2) - (double)this.noDataValue) > 0.1) {
                        if (Double.parseDouble(string2) < this.zMin) {
                            this.zMin = Double.parseDouble(string2);
                        }
                        if (Double.parseDouble(string2) > this.zMax) {
                            this.zMax = Double.parseDouble(string2);
                        }
                    }
                    ++n3;
                }
                if (this.nColumns != vector.size()) {
                    System.out.println("nColumns != data length at row " + n2 + " (row starts from 0)");
                    System.exit(0);
                }
                this.z.add(vector);
                ++n2;
            }
            if (Math.abs(this.zMin - this.zMax) < 2.0) {
                this.zMax += 2.0;
            }
            bufferedReader.close();
            fileReader.close();
        }
        catch (IOException iOException) {
            System.out.println("IOException has occured in Grid.read()" + iOException);
        }
        this.writeToTempFile();
        this.z = null;
    }

    public void read(URL uRL) {
        this.isGridRead = true;
        try {
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            int n = httpURLConnection.getResponseCode();
            if (n != 200) {
                String string;
                InputStream inputStream = httpURLConnection.getInputStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                int n2 = 0;
                while (n2 <= 5) {
                    string = bufferedReader.readLine();
                    System.out.println(string);
                    if (string != null) {
                        switch (n2) {
                            case 0: {
                                this.nColumns = (int)this.getSecondToken(string);
                                break;
                            }
                            case 1: {
                                this.nRows = (int)this.getSecondToken(string);
                                break;
                            }
                            case 2: {
                                this.xLLCorner = this.getSecondToken(string);
                                break;
                            }
                            case 3: {
                                this.yLLCorner = this.getSecondToken(string);
                                break;
                            }
                            case 4: {
                                this.cellSize = this.getSecondToken(string);
                                break;
                            }
                            case 5: {
                                this.noDataValue = (int)this.getSecondToken(string);
                                break;
                            }
                        }
                    }
                    ++n2;
                }
                this.xURCorner = (double)(this.nColumns - 1) * this.cellSize;
                this.yURCorner = (double)(this.nRows - 1) * this.cellSize;
                this.z = new Vector();
                int n3 = 0;
                while (n3 < this.nRows) {
                    string = bufferedReader.readLine();
                    Vector<String> vector = new Vector<String>();
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    int n4 = 0;
                    while (stringTokenizer.hasMoreTokens()) {
                        String string2 = stringTokenizer.nextToken();
                        vector.add(string2);
                        if (Math.abs(Double.parseDouble(string2) - (double)this.noDataValue) > 0.1) {
                            if (Double.parseDouble(string2) < this.zMin) {
                                this.zMin = Double.parseDouble(string2);
                            }
                            if (Double.parseDouble(string2) > this.zMax) {
                                this.zMax = Double.parseDouble(string2);
                            }
                        }
                        ++n4;
                    }
                    if (this.nColumns != vector.size()) {
                        System.out.println("Grid.read(URL), nColumns != data length at row " + n3 + " (row starts from 0)");
                    }
                    this.z.add(vector);
                    ++n3;
                }
                if (Math.abs(this.zMin - this.zMax) < 2.0) {
                    this.zMax += 2.0;
                }
                bufferedReader.close();
                inputStream.close();
                httpURLConnection.disconnect();
            }
        }
        catch (IOException iOException) {
            System.out.println("Grid.read(URL), IOException has occured in Grid.read()" + iOException);
        }
        this.writeToTempFile();
        this.z = null;
    }

    public double getValue(double d, double d2) {
        double d3 = this.xLLCorner + this.cellSize / 2.0;
        double d4 = this.yLLCorner + this.cellSize / 2.0;
        double d5 = d3 + (double)(this.nColumns - 1) * this.cellSize;
        double d6 = d4 + (double)(this.nRows - 1) * this.cellSize;
        double d7 = this.noDataValue;
        if (d >= d3 && d <= d5 && d2 >= d4 && d2 <= d6) {
            double d8 = (d - d3) * ((double)this.nColumns - 1.0) / (d5 - d3);
            double d9 = (double)(this.nRows - 1) - (d2 - d4) * ((double)this.nRows - 1.0) / (d6 - d4);
            double d10 = Math.floor(d8);
            double d11 = Math.ceil(d8);
            double d12 = Math.floor(d9);
            double d13 = Math.ceil(d9);
            int n = new Double(d10).intValue();
            int n2 = new Double(d11).intValue();
            int n3 = new Double(d12).intValue();
            int n4 = new Double(d13).intValue();
            double d14 = this.getValue(n, n3);
            double d15 = this.getValue(n, n4);
            double d16 = this.getValue(n2, n3);
            double d17 = this.getValue(n2, n4);
            double d18 = d3 + d10 * this.cellSize;
            double d19 = d3 + d11 * this.cellSize;
            double d20 = d6 - d12 * this.cellSize;
            double d21 = d6 - d13 * this.cellSize;
            double d22 = Math.sqrt(Math.pow(d - d18, 2.0) + Math.pow(d2 - d20, 2.0));
            double d23 = Math.sqrt(Math.pow(d - d18, 2.0) + Math.pow(d2 - d21, 2.0));
            double d24 = Math.sqrt(Math.pow(d - d19, 2.0) + Math.pow(d2 - d20, 2.0));
            double d25 = Math.sqrt(Math.pow(d - d19, 2.0) + Math.pow(d2 - d21, 2.0));
            double d26 = 1.0 / d22 + 1.0 / d24 + 1.0 / d23 + 1.0 / d25;
            d7 = (d14 / d22 + d15 / d23 + d16 / d24 + d17 / d25) / d26;
        }
        return d7;
    }

    public synchronized double getValue(int n, int n2) {
        double d = this.noDataValue;
        if (this.z != null) {
            if (n >= 0 && n < this.nColumns && n2 >= 0 && n2 < this.nRows) {
                Vector vector = (Vector)this.z.elementAt(n2);
                String string = (String)vector.elementAt(n);
                Double d2 = new Double(string);
                d = d2;
            }
        } else if (this.tempZFile != null) {
            d = this.getValueFromTempFile(n, n2);
        }
        return d;
    }

    public synchronized int getIntValue(int n, int n2) {
        int n3 = this.noDataValue;
        if (this.z != null) {
            if (n >= 0 && n < this.nColumns && n2 >= 0 && n2 < this.nRows) {
                Vector vector = (Vector)this.z.elementAt(n2);
                String string = (String)vector.elementAt(n);
                Integer n4 = new Integer(string);
                n3 = n4;
            }
        } else if (this.tempZFile != null) {
            double d = this.getValueFromTempFile(n, n2);
            String string = String.valueOf(Math.floor(d));
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            if (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                n3 = Integer.parseInt(string2);
            } else {
                n3 = 0;
            }
        }
        return n3;
    }

    public Vector getClasses() {
        if (!this.isGridRead) {
            this.read();
        }
        Vector vector = this.z == null ? this.readFromTempFile() : this.z;
        Vector<String> vector2 = new Vector<String>();
        if (this.type == 2) {
            int n = 0;
            while (n < vector.size()) {
                Vector vector3 = (Vector)vector.elementAt(n);
                int n2 = 0;
                while (n2 < vector3.size()) {
                    String string = (String)vector3.elementAt(n2);
                    if (!vector2.contains(string)) {
                        vector2.add(string);
                        System.out.println(string);
                    }
                    ++n2;
                }
                ++n;
            }
        }
        return vector2;
    }

    public Grid createFloodGrid(double d, String string, Vector vector, File file) {
        Vector vector2;
        Grid grid = new Grid(string, 1, this.units, file);
        grid.setCellSize(this.cellSize);
        grid.setNRows(this.nRows);
        grid.setNColumns(this.nColumns);
        grid.setxLLCorner(this.xLLCorner);
        grid.setyLLCorner(this.yLLCorner);
        Vector<Vector> vector3 = new Vector<Vector>();
        double d2 = -1.0;
        String string2 = String.valueOf(d2);
        int n = 0;
        while (n < this.nRows) {
            vector2 = new Vector();
            int n2 = 0;
            while (n2 < this.nColumns) {
                vector2.add(string2);
                ++n2;
            }
            vector3.add(vector2);
            ++n;
        }
        grid.setDataVector(vector3);
        vector2 = this.getFloodStartVector(vector);
        System.out.println("Grid.createFloodGrid(), " + grid.getName());
        while (vector2.size() > 0) {
            Vector vector4 = this.startFlooding(d, grid, d2, vector2);
            grid = (Grid)vector4.elementAt(0);
            vector2 = (Vector)vector4.elementAt(1);
        }
        double d3 = 0.0;
        grid.filterOut(d2, d3);
        grid.gridIsRead(true);
        return grid;
    }

    private Vector getFloodStartVector(Vector vector) {
        Vector vector2 = new Vector();
        double d = this.xLLCorner + this.cellSize / 2.0;
        double d2 = this.yLLCorner + this.cellSize / 2.0;
        double d3 = d + (double)(this.nColumns - 1) * this.cellSize;
        double d4 = d2 + (double)(this.nRows - 1) * this.cellSize;
        int n = 0;
        while (n < vector.size()) {
            double d5;
            double d6;
            Vector vector3 = (Vector)vector.elementAt(n);
            double d7 = (Double)vector3.elementAt(0);
            double d8 = (Double)vector3.elementAt(1);
            if (d7 >= d && d7 <= d3 && d8 >= d2 && d8 <= d4) {
                d6 = (d7 - d) * ((double)this.nColumns - 1.0) / (d3 - d);
                d5 = (double)(this.nRows - 1) - (d8 - d2) * ((double)this.nRows - 1.0) / (d4 - d2);
            } else {
                Vector<Double> vector4 = new Vector<Double>();
                Vector<Double> vector5 = new Vector<Double>();
                vector4.add(new Double(d));
                vector4.add(new Double(d3));
                vector4.add(new Double(d3));
                vector4.add(new Double(d));
                vector5.add(new Double(d2));
                vector5.add(new Double(d2));
                vector5.add(new Double(d4));
                vector5.add(new Double(d4));
                double d9 = 9.9999999E7;
                double d10 = d;
                double d11 = d2;
                int n2 = 0;
                while (n2 < 4) {
                    double d12 = (Double)vector4.elementAt(n2);
                    double d13 = (Double)vector5.elementAt(n2);
                    double d14 = Math.sqrt(Math.pow(d7 - d12, 2.0) + Math.pow(d8 - d13, 2.0));
                    if (d14 < d9) {
                        d9 = d14;
                        d10 = d12;
                        d11 = d13;
                    }
                    ++n2;
                }
                d6 = (d10 - d) * ((double)this.nColumns - 1.0) / (d3 - d);
                d5 = (double)(this.nRows - 1) - (d11 - d2) * ((double)this.nRows - 1.0) / (d4 - d2);
            }
            d6 = Math.floor(d6);
            d5 = Math.floor(d5);
            int n3 = new Double(d6).intValue();
            int n4 = new Double(d5).intValue();
            Vector<Integer> vector6 = new Vector<Integer>();
            vector6.add(new Integer(n4));
            vector6.add(new Integer(n3));
            vector6.add(new Integer(-99));
            vector6.add(new Integer(-99));
            vector2.add(vector6);
            ++n;
        }
        return vector2;
    }

    private Vector startFlooding(double d, Grid grid, double d2, Vector vector) {
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        ++recursionLevel;
        int n = 0;
        while (n < vector.size()) {
            double d3;
            Vector vector4 = (Vector)vector.elementAt(n);
            int n2 = (Integer)vector4.elementAt(0);
            int n3 = (Integer)vector4.elementAt(1);
            int n4 = (Integer)vector4.elementAt(2);
            int n5 = (Integer)vector4.elementAt(3);
            if (this.isWithinRange(n2, n3) && Math.abs((d3 = grid.getValue(n3, n2)) - d2) < 0.01) {
                double d4 = this.getValue(n3, n2);
                if (Math.abs(d4 - (double)this.noDataValue) < 0.01) {
                    grid.setDataAt(n3, n2, this.noDataValue);
                } else if (d4 >= d) {
                    grid.setDataAt(n3, n2, 0.0);
                } else {
                    double d5 = d - d4;
                    grid.setDataAt(n3, n2, d5);
                    int n6 = n2 - 1;
                    while (n6 <= n2 + 1) {
                        int n7 = n3 - 1;
                        while (n7 <= n3 + 1) {
                            if (!(n6 == n4 - 1 && n7 == n5 - 1 || n6 == n4 - 1 && n7 == n5 - 0 || n6 == n4 - 1 && n7 == n5 + 1 || n6 == n4 - 0 && n7 == n5 - 1 || n6 == n4 - 0 && n7 == n5 - 0 || n6 == n4 - 0 && n7 == n5 + 1 || n6 == n4 + 1 && n7 == n5 - 1 || n6 == n4 + 1 && n7 == n5 - 0 || n6 == n4 + 1 && n7 == n5 + 1 || !this.isWithinRange(n6, n7))) {
                                Vector<Integer> vector5 = new Vector<Integer>();
                                vector5.add(new Integer(n6));
                                vector5.add(new Integer(n7));
                                vector5.add(new Integer(n2));
                                vector5.add(new Integer(n3));
                                vector3.add(vector5);
                            }
                            ++n7;
                        }
                        ++n6;
                    }
                }
            }
            ++n;
        }
        while (vector3.size() > 0) {
            if (recursionLevel >= 3) {
                recursionLevel = 0;
                break;
            }
            vector2 = this.startFlooding(d, grid, d2, vector3);
            grid = (Grid)vector2.elementAt(0);
            vector3 = (Vector)vector2.elementAt(1);
        }
        vector2.add(grid);
        vector2.add(vector3);
        return vector2;
    }

    private boolean isWithinRange(int n, int n2) {
        return n >= 0 && n <= this.nRows - 1 && n2 >= 0 && n2 <= this.nColumns - 1;
    }

    public synchronized void setDataAt(int n, int n2, double d) {
        if (this.z != null) {
            Vector vector = (Vector)this.z.elementAt(n2);
            vector.remove(n);
            vector.insertElementAt(String.valueOf(d), n);
            this.z.remove(n2);
            this.z.insertElementAt(vector, n2);
        } else {
            this.setValueToTempFile(n, n2, d);
        }
    }

    private void filterOut(double d, double d2) {
        if (this.z == null) {
            this.z = this.readFromTempFile();
        }
        int n = 0;
        while (n < this.nRows) {
            Vector vector = (Vector)this.z.elementAt(n);
            int n2 = 0;
            while (n2 < this.nColumns) {
                String string = (String)vector.elementAt(n2);
                double d3 = Double.parseDouble(string);
                if (Math.abs(d3 - d) < 0.1) {
                    this.setDataAt(n2, n, d2);
                }
                ++n2;
            }
            ++n;
        }
        this.writeToTempFile();
        this.z = null;
    }

    public void writeGridObject() {
        if (this.outFile == null) {
            this.inFile = this.outFile = FileNameDialog.getOutputFileName("Save", null, null);
        }
        if (this.outFile != null) {
            if (this.z == null) {
                this.z = this.readFromTempFile();
            }
            ObjectReadWrite.write(this.outFile, (Object)this);
            this.z = null;
        }
    }

    public static Grid readGridObject(File file) {
        Grid grid = new Grid("no title", 0, 0, file);
        if (file.exists()) {
            grid = (Grid)ObjectReadWrite.read(file);
        } else {
            System.out.println("Grid.readGridObject, input file " + file.toString() + " doesn't exist");
        }
        grid.gridIsRead(true);
        grid.setZMinMax();
        grid.writeToTempFile();
        return grid;
    }

    public void describe() {
        System.out.println("Describing grid");
        System.out.println("\nName        = " + this.name + "\nnRows       = " + this.nRows + "\nnColumns    = " + this.nColumns + "\nxLLCorner   = " + this.xLLCorner + "\nyLLCorner   = " + this.yLLCorner + "\ncellSize    = " + this.cellSize + "\nnoDataValue = " + this.noDataValue);
        Vector vector = this.z == null ? this.readFromTempFile() : this.z;
        int n = 0;
        while (n < this.nRows) {
            Vector vector2 = (Vector)vector.elementAt(n);
            int n2 = 0;
            while (n2 < this.nColumns) {
                String string = (String)vector2.elementAt(n2);
                double d = Double.parseDouble(string);
                System.out.print(" " + d);
                ++n2;
            }
            System.out.println("");
            ++n;
        }
        vector = null;
    }

    public Vector showdescription() {
        Vector<String> vector = new Vector<String>();
        vector.add("Name        = " + this.name);
        vector.add("\nnRows       = " + this.nRows);
        vector.add("\nnColumns    = " + this.nColumns);
        vector.add("\nxLLCorner   = " + this.xLLCorner);
        vector.add("\nyLLCorner   = " + this.yLLCorner);
        vector.add("\ncellSize    = " + this.cellSize);
        vector.add("\nnoDataValue = " + this.noDataValue);
        Vector vector2 = this.z == null ? this.readFromTempFile() : this.z;
        int n = 0;
        while (n < this.nRows) {
            Vector vector3 = (Vector)vector2.elementAt(n);
            String string = "";
            int n2 = 0;
            while (n2 < this.nColumns) {
                String string2 = (String)vector3.elementAt(n2);
                string = string.concat(" " + string2);
                ++n2;
            }
            vector.add("\n" + string);
            ++n;
        }
        vector2 = null;
        return vector;
    }

    public void setZMinMax() {
        Vector vector = this.z == null ? this.readFromTempFile() : this.z;
        int n = 0;
        while (n < this.nRows - 1) {
            Vector vector2 = (Vector)vector.elementAt(n);
            int n2 = 0;
            while (n2 < this.nColumns - 1) {
                String string = (String)vector2.elementAt(n2);
                double d = Double.parseDouble(string);
                if (Math.abs(d - (double)this.noDataValue) > 0.1) {
                    this.zMin = Math.min(this.zMin, d);
                    this.zMax = Math.max(this.zMax, d);
                }
                ++n2;
            }
            ++n;
        }
        this.zMin = Math.floor(this.zMin);
        this.zMax = Math.ceil(this.zMax);
    }

    public void draw(GridDisplay gridDisplay, SurfaceColor surfaceColor) {
        if (IDSSAppConstants.debug) {
            System.out.println("Grid.draw()");
        }
        BufferedImage bufferedImage = this.getImage(surfaceColor);
        gridDisplay.refreshCanvas(bufferedImage);
    }

    public BufferedImage getImage(SurfaceColor surfaceColor) {
        if (IDSSAppConstants.debug) {
            System.out.println("Grid.getImage()");
        }
        if (!this.isRead()) {
            this.read();
        }
        BufferedImage bufferedImage = new BufferedImage(this.getNColumns(), this.getNRows(), 1);
        Graphics graphics = bufferedImage.getGraphics();
        double d = this.getNoDataValue();
        Vector vector = this.z == null ? this.readFromTempFile() : this.z;
        int n = 0;
        while (n < vector.size()) {
            Vector vector2 = (Vector)vector.elementAt(n);
            int n2 = 0;
            while (n2 < vector2.size()) {
                double d2 = Double.parseDouble(vector2.elementAt(n2).toString());
                if (Math.abs(d2 - d) > 0.1) {
                    Color color = surfaceColor.getColor(d2);
                    graphics.setColor(color);
                    graphics.fillRect(n2, n, 1, 1);
                }
                ++n2;
            }
            ++n;
        }
        vector = null;
        return bufferedImage;
    }

    public ServerGrid getServerGrid() {
        Vector vector = this.z == null ? this.readFromTempFile() : this.z;
        ServerGrid serverGrid = new ServerGrid(this.name, this.type, this.units, this.fileName, this.cellSize, this.nRows, this.nColumns, this.xLLCorner, this.yLLCorner, this.noDataValue, vector);
        return serverGrid;
    }

    public void readServerGrid(ServerGrid serverGrid) {
        this.name = serverGrid.getName();
        this.type = serverGrid.getType();
        this.units = serverGrid.getUnits();
        this.fileName = serverGrid.getFileName();
        this.cellSize = serverGrid.getCellSize();
        this.nRows = serverGrid.getNRows();
        this.nColumns = serverGrid.getNColumns();
        this.xLLCorner = serverGrid.getXLLCorner();
        this.yLLCorner = serverGrid.getYLLCorner();
        this.noDataValue = serverGrid.getNoDataValue();
        this.z = serverGrid.getZ();
        this.setZMinMax();
        this.gridIsRead(true);
        this.xURCorner = (double)(this.nColumns - 1) * this.cellSize;
        this.yURCorner = (double)(this.nRows - 1) * this.cellSize;
        this.inFile = new File(this.fileName);
        this.outFile = new File(this.fileName);
        this.writeToTempFile();
        this.z = null;
    }

    public void writeToTempFile() {
        System.out.println("Grid.writeToTempFile(), IDSSAppConstants.tempDir : c:\\iDSSTemp");
        File file = new File("c:\\iDSSTemp");
        if (!file.exists()) {
            file.mkdirs();
        }
        this.tempZFile = new File(file, FileNameDialog.getTempFileName());
        if (this.tempZFile.exists()) {
            this.tempZFile.delete();
        }
        this.tempZFile.deleteOnExit();
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.tempZFile, "rw");
            if (randomAccessFile == null) {
                System.out.println("demRAF is null");
                System.exit(0);
            }
            if (this.z == null) {
                System.out.println("z is null");
                System.exit(0);
            }
            int n = 0;
            while (n < this.getNRows()) {
                Vector vector = (Vector)this.z.elementAt(n);
                int n2 = 0;
                while (n2 < vector.size()) {
                    String string = (String)vector.elementAt(n2);
                    float f = -9999.0f;
                    if (!string.equals("NaN")) {
                        f = Float.parseFloat(string);
                    }
                    randomAccessFile.writeFloat(f);
                    ++n2;
                }
                ++n;
            }
            this.z = null;
            randomAccessFile.close();
        }
        catch (Exception exception) {
            System.out.println("Grid.writeToTempFile(), e: " + exception.toString());
            System.exit(0);
        }
    }

    private Vector readFromTempFile() {
        Vector vector = null;
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.tempZFile, "r");
            vector = new Vector();
            int n = 0;
            while (n < this.getNRows()) {
                Vector<String> vector2 = new Vector<String>();
                int n2 = 0;
                while (n2 < this.getNColumns()) {
                    float f = randomAccessFile.readFloat();
                    String string = String.valueOf(f);
                    vector2.add(string);
                    ++n2;
                }
                vector.add(vector2);
                ++n;
            }
            randomAccessFile.close();
        }
        catch (Exception exception) {
            System.out.println("Grid.readFromTempFile(), e: " + exception.toString());
            System.exit(0);
        }
        return vector;
    }

    private double getValueFromTempFile(int n, int n2) {
        double d = this.noDataValue;
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.tempZFile, "r");
            long l = (n2 * this.getNColumns() + n) * 4;
            randomAccessFile.seek(l);
            float f = randomAccessFile.readFloat();
            d = f;
            randomAccessFile.close();
        }
        catch (Exception exception) {
            System.out.println("Grid.getValueFromTempFile(), e: " + exception.toString());
            System.exit(0);
        }
        return d;
    }

    private void setValueToTempFile(int n, int n2, double d) {
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.tempZFile, "rw");
            long l = (n2 * this.getNColumns() + n) * 4;
            randomAccessFile.seek(l);
            float f = new Double(d).floatValue();
            randomAccessFile.writeFloat(f);
            randomAccessFile.close();
        }
        catch (Exception exception) {
            System.out.println("Grid.setValueToTempFile(), e: " + exception.toString());
            System.exit(0);
        }
    }
}

