/*
 * Decompiled with CFR 0.152.
 */
package iDSS.grids;

import iDSS.grids.GenericGrid;
import iDSS.grids.Grid;
import iDSS.grids.GridCell;
import iDSS.grids.LCGrid2;
import iDSS.sm.SurvivalModel;
import iDSS.utils.FileNameDialog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Vector;
import javax.swing.JOptionPane;

public class Grid2
implements GenericGrid,
Serializable {
    private String name;
    private int units;
    private final int UNKNOWN = 0;
    private final int FT = 1;
    private final int IN = 2;
    private final int M = 3;
    private final int MM = 4;
    private double cellSize;
    private int nRows;
    private int nColumns;
    private double xLLCorner;
    private double yLLCorner;
    private double xURCorner;
    private double yURCorner;
    private double xLLC;
    private double yLLC;
    private double xURC;
    private double yURC;
    private String fileName = "";
    private File file;
    private boolean gridReadDone = false;
    private Vector z;

    public Grid2(String string, int n, File file, int n2, int n3, double d, double d2, double d3) {
        System.out.println("Creating grid2 " + string);
        System.out.println("nRows/nColumns : " + this.nRows + "/" + this.nColumns);
        this.name = string;
        if (file != null) {
            this.file = file;
            this.fileName = file.toString();
        }
        this.units = n > 0 && n < 5 ? n : 0;
        this.nRows = n2;
        this.nColumns = n3;
        this.cellSize = d;
        this.xLLCorner = d2;
        this.yLLCorner = d3;
        this.xURCorner = (double)(this.nColumns - 1) * this.cellSize;
        this.yURCorner = (double)(this.nRows - 1) * this.cellSize;
        this.xLLC = this.xLLCorner + this.cellSize / 2.0;
        this.yLLC = this.yLLCorner + this.cellSize / 2.0;
        this.xURC = this.xLLC + (double)(this.nColumns - 1) * this.cellSize;
        this.yURC = this.yLLC + (double)(this.nRows - 1) * this.cellSize;
        this.z = new Vector();
        int n4 = 0;
        while (n4 < this.nRows) {
            Vector<GridCell> vector = new Vector<GridCell>();
            int n5 = 0;
            while (n5 < this.nColumns) {
                vector.add(new GridCell());
                ++n5;
            }
            this.z.add(vector);
            ++n4;
        }
        System.out.println("nRows/nColumns : " + this.nRows + "/" + this.nColumns);
    }

    public String getName() {
        return this.name;
    }

    public long getTotalFloodingTime(double d, double d2) {
        long l = -9999L;
        Vector vector = this.getRowsColsAndDists(d, d2);
        if (vector != null) {
            Vector vector2 = (Vector)vector.elementAt(0);
            Vector vector3 = (Vector)vector.elementAt(1);
            int n = Integer.parseInt(vector2.elementAt(0).toString());
            int n2 = Integer.parseInt(vector2.elementAt(1).toString());
            int n3 = Integer.parseInt(vector2.elementAt(2).toString());
            int n4 = Integer.parseInt(vector2.elementAt(3).toString());
            double d3 = Double.parseDouble(vector3.elementAt(0).toString());
            double d4 = Double.parseDouble(vector3.elementAt(1).toString());
            double d5 = Double.parseDouble(vector3.elementAt(2).toString());
            double d6 = Double.parseDouble(vector3.elementAt(3).toString());
            double d7 = 1.0 / d3 + 1.0 / d5 + 1.0 / d4 + 1.0 / d6;
            GridCell gridCell = this.getGridCell(n3, n);
            GridCell gridCell2 = this.getGridCell(n3, n2);
            GridCell gridCell3 = this.getGridCell(n4, n);
            GridCell gridCell4 = this.getGridCell(n4, n2);
            long l2 = gridCell.getTotalFloodingTime();
            long l3 = gridCell2.getTotalFloodingTime();
            long l4 = gridCell3.getTotalFloodingTime();
            long l5 = gridCell4.getTotalFloodingTime();
            l = new Double(((double)l2 / d3 + (double)l3 / d4 + (double)l4 / d5 + (double)l5 / d6) / d7).longValue();
        }
        return l;
    }

    public GridCell getGridCell(int n, int n2) {
        GridCell gridCell = null;
        if (n >= 0 && n < this.nColumns && n2 >= 0 && n2 < this.nRows) {
            Vector vector = (Vector)this.z.elementAt(n2);
            gridCell = (GridCell)vector.elementAt(n);
        }
        return gridCell;
    }

    private Vector getRowsColsAndDists(double d, double d2) {
        Vector vector = null;
        if (d >= this.xLLC && d <= this.xURC && d2 >= this.yLLC && d2 <= this.yURC) {
            vector = new Vector();
            double d3 = (d - this.xLLC) * ((double)this.nColumns - 1.0) / (this.xURC - this.xLLC);
            double d4 = (double)(this.nRows - 1) - (d2 - this.yLLC) * ((double)this.nRows - 1.0) / (this.yURC - this.yLLC);
            int n = new Double(Math.floor(d4)).intValue();
            int n2 = new Double(Math.ceil(d4)).intValue();
            int n3 = new Double(Math.floor(d3)).intValue();
            int n4 = new Double(Math.ceil(d3)).intValue();
            double d5 = this.xLLC + (double)n3 * this.cellSize;
            double d6 = this.xLLC + (double)n4 * this.cellSize;
            double d7 = this.yURC - (double)n * this.cellSize;
            double d8 = this.yURC - (double)n2 * this.cellSize;
            double d9 = Math.sqrt(Math.pow(d - d5, 2.0) + Math.pow(d2 - d7, 2.0));
            double d10 = Math.sqrt(Math.pow(d - d5, 2.0) + Math.pow(d2 - d8, 2.0));
            double d11 = Math.sqrt(Math.pow(d - d6, 2.0) + Math.pow(d2 - d7, 2.0));
            double d12 = Math.sqrt(Math.pow(d - d6, 2.0) + Math.pow(d2 - d8, 2.0));
            Vector<Integer> vector2 = new Vector<Integer>();
            vector2.add(new Integer(n));
            vector2.add(new Integer(n2));
            vector2.add(new Integer(n3));
            vector2.add(new Integer(n4));
            Vector<Double> vector3 = new Vector<Double>();
            vector3.add(new Double(d9));
            vector3.add(new Double(d10));
            vector3.add(new Double(d11));
            vector3.add(new Double(d12));
            vector.add(vector2);
            vector.add(vector3);
        }
        return vector;
    }

    private void setCellAt(int n, int n2, GridCell gridCell) {
        Vector vector = (Vector)this.z.elementAt(n2);
        vector.remove(n);
        vector.insertElementAt(gridCell, n);
        this.z.remove(n2);
        this.z.insertElementAt(vector, n2);
    }

    public void writeGrid2Object() {
        try {
            if (this.file.exists()) {
                int n = JOptionPane.showConfirmDialog(null, "File already exists, overwrite?", "Confirm file overwrite", 1, 3);
                switch (n) {
                    case 0: {
                        this.file.delete();
                        break;
                    }
                    case 1: {
                        this.file = FileNameDialog.getOutputFileName("Pick output file", null, null);
                        break;
                    }
                    case 2: {
                        this.file = null;
                        break;
                    }
                }
            }
            if (this.file.createNewFile()) {
                FileOutputStream fileOutputStream = new FileOutputStream(this.file);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(this);
                objectOutputStream.flush();
                fileOutputStream.close();
            } else {
                System.out.println("Failed to create file " + this.file.toString());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.print("In Grid2.writeGridObject()");
            System.out.println("File not found : " + fileNotFoundException);
        }
        catch (IOException iOException) {
            System.out.print("In Grid2.writeGridObject()");
            System.out.println("IOException : " + iOException);
        }
    }

    public static Grid2 readGrid2Object(File file) {
        Grid2 grid2 = new Grid2("no title", 0, null, 0, 0, 0.0, 0.0, 0.0);
        try {
            if (file.exists()) {
                FileInputStream fileInputStream = new FileInputStream(file);
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                grid2 = (Grid2)objectInputStream.readObject();
                fileInputStream.close();
                grid2.describe();
            } else {
                System.out.println("Input file " + file.toString() + " doesn't exist");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.print("In Grid2.readGridObject()");
            System.out.println("File not found : " + fileNotFoundException);
        }
        catch (IOException iOException) {
            System.out.print("In Grid2.readGridObject()");
            System.out.println("IOException : " + iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.print("In Grid2.readGridObject()");
            System.out.println("ClassNotFoundException : " + classNotFoundException);
        }
        catch (ClassCastException classCastException) {
            System.out.println("ClassCastException : " + classCastException);
            return null;
        }
        grid2.gridIsRead(true);
        return grid2;
    }

    public boolean isGridRead() {
        return this.gridReadDone;
    }

    private void gridIsRead(boolean bl) {
        this.gridReadDone = bl;
    }

    public void describe() {
        System.out.println("Describing grid");
        System.out.println("\nName        = " + this.name + "\nnRows       = " + this.nRows + "\nnColumns    = " + this.nColumns + "\nxLLCorner   = " + this.xLLCorner + "\nyLLCorner   = " + this.yLLCorner + "\ncellSize    = " + this.cellSize);
    }

    public void buildUp(Grid grid, LCGrid2 lCGrid2, long l, Timestamp timestamp) {
        int n = 0;
        while (n < this.nRows) {
            Vector vector = (Vector)this.z.elementAt(n);
            int n2 = 0;
            while (n2 < this.nColumns) {
                GridCell gridCell = (GridCell)vector.elementAt(n2);
                double d = grid.getValue(n2, n);
                SurvivalModel survivalModel = lCGrid2.getSurvivalModel(n2, n);
                gridCell.buildUP(d, l, timestamp, survivalModel);
                ++n2;
            }
            ++n;
        }
    }

    public void roundUp(LCGrid2 lCGrid2, long l, double d, Timestamp timestamp) {
        int n = 0;
        while (n < this.nRows) {
            Vector vector = (Vector)this.z.elementAt(n);
            int n2 = 0;
            while (n2 < this.nColumns) {
                GridCell gridCell = (GridCell)vector.elementAt(n2);
                SurvivalModel survivalModel = lCGrid2.getSurvivalModel(n2, n);
                gridCell.roundUp(survivalModel, l, d, timestamp);
                ++n2;
            }
            ++n;
        }
    }

    public Grid getGrid(String string) {
        Grid grid = new Grid(this.name + ":" + string, 1, this.units, null);
        Vector vector = new Vector();
        int n = 0;
        while (n < this.z.size()) {
            Vector vector2 = (Vector)this.z.elementAt(n);
            Vector<String> vector3 = new Vector<String>();
            int n2 = 0;
            while (n2 < vector2.size()) {
                GridCell gridCell = (GridCell)vector2.elementAt(n2);
                String string2 = gridCell.getValue(string);
                vector3.add(string2);
                ++n2;
            }
            vector.add(vector3);
            ++n;
        }
        grid.setGrid(this.xLLCorner, this.yLLCorner, this.cellSize, vector, this.nRows, this.nColumns, false);
        grid.gridIsRead(true);
        grid.setZMinMax();
        return grid;
    }

    public Vector getGridVector() {
        Vector<String> vector = new Vector<String>();
        vector.add(this.name);
        vector.add(this.fileName);
        return vector;
    }

    public String getFileName() {
        return this.fileName;
    }
}

