/*
 * Decompiled with CFR 0.152.
 */
package iDSS.tidalData;

import iDSS.disp.TabularDisplay;
import iDSS.tables.GeneralTableModel;
import iDSS.utils.ImageRW;
import iDSS.xyGraph.Graph;
import iDSS.xyGraph.GraphicalDisplay2;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;

public class ClientDataSet
implements Serializable {
    private String sqlString;
    private Timestamp startOfData;
    private Timestamp endOfData;
    private Vector columnNames;
    private Vector rowsOfData;
    private String stationName;
    private String dateColumnName = "date";
    private String dataColumnName = "observation";
    private double valueMin;
    private double valueMax;

    public ClientDataSet() {
        this.sqlString = "noSQL";
        this.startOfData = new Timestamp(System.currentTimeMillis());
        this.endOfData = new Timestamp(System.currentTimeMillis());
        this.columnNames = new Vector();
        this.rowsOfData = new Vector();
        this.stationName = "noStation";
        this.getMinMax();
    }

    public ClientDataSet(String string, Timestamp timestamp, Timestamp timestamp2, Vector vector, Vector vector2) {
        this.sqlString = string;
        this.startOfData = timestamp;
        this.endOfData = timestamp2;
        this.columnNames = vector;
        this.rowsOfData = vector2;
        this.stationName = "Unknown";
        this.getMinMax();
    }

    public ClientDataSet(String string, String string2, Timestamp timestamp, Timestamp timestamp2, Vector vector, Vector vector2) {
        this.sqlString = string;
        this.startOfData = timestamp;
        this.endOfData = timestamp2;
        this.columnNames = vector;
        this.rowsOfData = vector2;
        this.stationName = string2;
        this.getMinMax();
    }

    private void getMinMax() {
        System.out.println(this.stationName + ", " + this.startOfData.toString() + " to " + this.endOfData.toString());
        this.valueMin = 99999.9;
        this.valueMax = -99999.9;
        int n = 0;
        while (n < this.rowsOfData.size()) {
            Vector vector = (Vector)this.rowsOfData.elementAt(n);
            String string = vector.elementAt(1).toString();
            double d = Double.parseDouble(string);
            if (d < this.valueMin) {
                this.valueMin = d;
            }
            if (d > this.valueMax) {
                this.valueMax = d;
            }
            ++n;
        }
    }

    public Timestamp getTimeMin() {
        return this.startOfData;
    }

    public Timestamp getTimeMax() {
        return this.endOfData;
    }

    public double getValueMin() {
        return this.valueMin;
    }

    public double getValueMax() {
        return this.valueMax;
    }

    public Vector getColumnNamesVector() {
        return this.columnNames;
    }

    public Vector getRowsOfDataVector() {
        return this.rowsOfData;
    }

    public Vector getRowsOfDataVector(Timestamp timestamp, Timestamp timestamp2) {
        Vector vector = new Vector();
        int n = 0;
        while (n < this.rowsOfData.size()) {
            Vector vector2 = (Vector)this.rowsOfData.elementAt(n);
            Timestamp timestamp3 = (Timestamp)vector2.elementAt(0);
            if (timestamp3.after(timestamp) && timestamp3.before(timestamp2)) {
                Double d = (Double)vector2.elementAt(1);
                Vector<Comparable<Date>> vector3 = new Vector<Comparable<Date>>();
                vector3.add(timestamp3);
                vector3.add(d);
                vector.add(vector3);
            }
            ++n;
        }
        return vector;
    }

    public Vector getColumnsOfDataVector(Timestamp timestamp, Timestamp timestamp2) {
        Vector vector;
        Vector<Timestamp> vector2 = new Vector<Timestamp>();
        Vector<Double> vector3 = new Vector<Double>();
        int n = 0;
        while (n < this.rowsOfData.size()) {
            vector = (Vector)this.rowsOfData.elementAt(n);
            Timestamp timestamp3 = (Timestamp)vector.elementAt(0);
            if (timestamp3.after(timestamp) && timestamp3.before(timestamp2)) {
                Double d = (Double)vector.elementAt(1);
                vector2.add(timestamp3);
                vector3.add(d);
            }
            ++n;
        }
        vector = new Vector();
        vector.add(vector2);
        vector.add(vector3);
        return vector;
    }

    public Vector getColumnsOfDataVector() {
        Vector vector;
        Vector<Timestamp> vector2 = new Vector<Timestamp>();
        Vector<Double> vector3 = new Vector<Double>();
        int n = 0;
        while (n < this.rowsOfData.size()) {
            vector = (Vector)this.rowsOfData.elementAt(n);
            Timestamp timestamp = (Timestamp)vector.elementAt(0);
            Double d = (Double)vector.elementAt(1);
            vector2.add(timestamp);
            vector3.add(d);
            ++n;
        }
        vector = new Vector();
        vector.add(vector2);
        vector.add(vector3);
        return vector;
    }

    public String getSqlString() {
        return this.sqlString;
    }

    public String getStationName() {
        return this.stationName;
    }

    public void setStationName(String string) {
        this.stationName = string;
    }

    public Timestamp getStartOfData() {
        return this.startOfData;
    }

    public Timestamp getEndOfData() {
        return this.endOfData;
    }

    public double getDataAt(Timestamp timestamp) {
        boolean bl = false;
        int n = 0;
        double d = -9999.0;
        long l = ((Date)timestamp).getTime() / 1000L;
        while (!bl) {
            Vector vector = (Vector)this.rowsOfData.elementAt(n);
            Timestamp timestamp2 = (Timestamp)vector.elementAt(0);
            long l2 = ((Date)timestamp2).getTime() / 1000L;
            if (l == l2) {
                bl = true;
                Double d2 = (Double)vector.elementAt(1);
                d = d2;
                continue;
            }
            if (n >= this.rowsOfData.size() - 1) break;
            ++n;
        }
        return d;
    }

    public Vector getDataSetVector() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.sqlString);
        vector.add(this.stationName);
        vector.add(this.startOfData);
        vector.add(this.endOfData);
        return vector;
    }

    public TabularDisplay makeTable(Timestamp timestamp, Timestamp timestamp2) {
        Object object;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.columnNames.size()) {
            object = (String)this.columnNames.elementAt(n3);
            if (((String)object).equals(this.dateColumnName)) {
                n = n3;
                System.out.println("dateColumn is " + n3);
            } else if (((String)object).equals(this.dataColumnName)) {
                n2 = n3;
                System.out.println("dataColumn is " + n3);
            }
            ++n3;
        }
        object = new Vector();
        int n4 = 0;
        while (n4 < this.getRowsOfDataVector().size()) {
            Vector vector = (Vector)this.getRowsOfDataVector().elementAt(n4);
            Timestamp timestamp3 = (Timestamp)vector.elementAt(n);
            if (timestamp3.after(timestamp) && timestamp3.before(timestamp2)) {
                ((Vector)object).add(vector);
            }
            ++n4;
        }
        TabularDisplay tabularDisplay = null;
        if (((Vector)object).size() > 0) {
            GeneralTableModel generalTableModel = new GeneralTableModel((Vector)object, this.getColumnNamesVector());
            tabularDisplay = new TabularDisplay(this.getStationName(), generalTableModel);
        }
        return tabularDisplay;
    }

    public Graph drawXYGraph(String string, Timestamp timestamp, Timestamp timestamp2, Graph graph) {
        Graph graph2 = null;
        GraphicalDisplay2 graphicalDisplay2 = null;
        if (graph == null) {
            graphicalDisplay2 = new GraphicalDisplay2(string, 600, 300);
            graph2 = new Graph(graphicalDisplay2, this, timestamp, timestamp2, Color.black);
            graphicalDisplay2.removePropertyChangeListener(graph2);
            graphicalDisplay2.addPropertyChangeListener(graph2);
        } else {
            graph.addToGraph(this, timestamp, timestamp2, Color.blue);
        }
        return graph2;
    }

    public Vector getXYGraphImg(String string, Timestamp timestamp, Timestamp timestamp2, Graph graph) {
        Graph graph2 = null;
        GraphicalDisplay2 graphicalDisplay2 = null;
        if (graph == null) {
            graphicalDisplay2 = new GraphicalDisplay2(string, 800, 400);
            graph2 = new Graph(graphicalDisplay2, this, timestamp, timestamp2, Color.black);
        } else {
            graph.addToGraph(this, timestamp, timestamp2, Color.blue);
        }
        BufferedImage bufferedImage = null;
        Vector vector = new Vector();
        if (graphicalDisplay2 != null) {
            bufferedImage = graphicalDisplay2.getCanvas();
            vector = ImageRW.writeImgFile(bufferedImage);
            vector.add(string);
        }
        return vector;
    }
}

