/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.rowset;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSet;
import sun.jdbc.rowset.BaseRowSet;

public class JdbcRowSet
extends BaseRowSet
implements RowSet {
    private Connection conn = null;
    private PreparedStatement ps = null;
    private ResultSet rs = null;

    public JdbcRowSet() throws SQLException {
        this.initParams();
        this.setShowDeleted(false);
        this.setQueryTimeout(0);
        this.setMaxRows(0);
        this.setMaxFieldSize(0);
        this.setType(1004);
        this.setConcurrency(1007);
        this.setReadOnly(true);
        this.setTransactionIsolation(2);
        this.setEscapeProcessing(true);
        this.setTypeMap((Map)null);
    }

    public boolean absolute(int n) throws SQLException {
        this.checkState();
        boolean bl = this.rs.absolute(n);
        this.notifyCursorMoved();
        return bl;
    }

    public void afterLast() throws SQLException {
        this.checkState();
        this.rs.afterLast();
        this.notifyCursorMoved();
    }

    public void beforeFirst() throws SQLException {
        this.checkState();
        this.rs.beforeFirst();
        this.notifyCursorMoved();
    }

    public void cancelRowUpdates() throws SQLException {
        this.checkState();
        this.rs.cancelRowUpdates();
        this.notifyRowChanged();
    }

    void checkState() throws SQLException {
        if (this.conn == null || this.ps == null || this.rs == null) {
            throw new SQLException("Invalid State");
        }
    }

    public void clearWarnings() throws SQLException {
        this.checkState();
        this.rs.clearWarnings();
    }

    public void close() throws SQLException {
        if (this.rs != null) {
            this.rs.close();
        }
        if (this.ps != null) {
            this.ps.close();
        }
        if (this.conn != null) {
            this.conn.close();
        }
    }

    private Connection connect() throws SQLException {
        if (this.getDataSourceName() != null) {
            try {
                InitialContext initialContext = new InitialContext();
                DataSource dataSource = (DataSource)initialContext.lookup(this.getDataSourceName());
                return dataSource.getConnection(this.getUsername(), this.getPassword());
            }
            catch (NamingException namingException) {
                throw new SQLException("(JNDI) Unable to connect");
            }
        }
        if (this.getUrl() != null) {
            return DriverManager.getConnection(this.getUrl(), this.getUsername(), this.getPassword());
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void decodeParams(Object[] objectArray, PreparedStatement preparedStatement) throws SQLException {
        Object[] objectArray2 = null;
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray2[n] instanceof Object[]) {
                objectArray2 = (Object[])objectArray[n];
                if (objectArray2.length == 2) {
                    if (objectArray2[0] == null) {
                        preparedStatement.setNull(n + 1, (Integer)objectArray2[1]);
                    } else if (objectArray2[0] instanceof Date || objectArray2[0] instanceof Time || objectArray2[0] instanceof Timestamp) {
                        System.err.println("Detected a Date");
                        if (!(objectArray2[1] instanceof Calendar)) throw new SQLException("Unable to deduce param type");
                        System.err.println("Detected a Calendar");
                        preparedStatement.setDate(n + 1, (Date)objectArray2[0], (Calendar)objectArray2[1]);
                    } else if (objectArray2[0] instanceof Reader) {
                        preparedStatement.setCharacterStream(n + 1, (Reader)objectArray2[0], (Integer)objectArray2[1]);
                    } else if (objectArray2[1] instanceof Integer) {
                        preparedStatement.setObject(n + 1, objectArray2[0], (Integer)objectArray2[1]);
                    }
                } else if (objectArray2.length == 3) {
                    if (objectArray2[0] == null) {
                        preparedStatement.setNull(n + 1, (Integer)objectArray2[1], (String)objectArray2[2]);
                    } else {
                        if (objectArray2[0] instanceof InputStream) {
                            switch ((Integer)objectArray2[2]) {
                                case 0: {
                                    preparedStatement.setUnicodeStream(n + 1, (InputStream)objectArray2[0], (Integer)objectArray2[1]);
                                }
                                case 1: {
                                    preparedStatement.setBinaryStream(n + 1, (InputStream)objectArray2[0], (Integer)objectArray2[1]);
                                }
                                case 2: {
                                    preparedStatement.setAsciiStream(n + 1, (InputStream)objectArray2[0], (Integer)objectArray2[1]);
                                }
                            }
                            throw new SQLException("Unable to deduce parameter type");
                        }
                        if (!(objectArray2[1] instanceof Integer) || !(objectArray2[2] instanceof Integer)) throw new SQLException("Unable to deduce param type");
                        preparedStatement.setObject(n + 1, objectArray2[0], (Integer)objectArray2[1], (int)((Integer)objectArray2[2]));
                    }
                } else {
                    preparedStatement.setObject(n + 1, objectArray[n]);
                }
            }
            ++n;
        }
    }

    public void deleteRow() throws SQLException {
        this.checkState();
        this.rs.deleteRow();
        this.notifyRowChanged();
    }

    public void execute() throws SQLException {
        this.conn = this.connect();
        try {
            this.conn.setTransactionIsolation(this.getTransactionIsolation());
        }
        catch (SQLException sQLException) {
            System.err.println("JdbcRowSet (setTransactionIsolation): " + sQLException.getMessage());
        }
        try {
            this.conn.setTypeMap(this.getTypeMap());
        }
        catch (Throwable throwable) {
            System.err.println("JdbcRowSet (setTypeMap): " + throwable.getMessage());
        }
        try {
            this.ps = this.conn.prepareStatement(this.getCommand());
        }
        catch (SQLException sQLException) {
            System.err.println("JdbcRowSet (execute): " + sQLException.getMessage());
            if (this.ps != null) {
                this.ps.close();
            }
            if (this.conn != null) {
                this.conn.close();
            }
            throw new SQLException(sQLException.getMessage());
        }
        this.setProperties(this.ps);
        this.decodeParams(this.getParams(), this.ps);
        this.rs = this.ps.executeQuery();
        this.notifyRowSetChanged();
    }

    public int findColumn(String string) throws SQLException {
        this.checkState();
        return this.rs.findColumn(string);
    }

    public boolean first() throws SQLException {
        this.checkState();
        boolean bl = this.rs.first();
        this.notifyCursorMoved();
        return bl;
    }

    public Array getArray(int n) throws SQLException {
        this.checkState();
        return this.rs.getArray(n);
    }

    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        this.checkState();
        return this.rs.getAsciiStream(n);
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.checkState();
        return this.rs.getBigDecimal(n);
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        this.checkState();
        return this.rs.getBigDecimal(n, n2);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        this.checkState();
        return this.rs.getBinaryStream(n);
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public Blob getBlob(int n) throws SQLException {
        this.checkState();
        return this.rs.getBlob(n);
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    public boolean getBoolean(int n) throws SQLException {
        this.checkState();
        return this.rs.getBoolean(n);
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(int n) throws SQLException {
        this.checkState();
        return this.rs.getByte(n);
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public byte[] getBytes(int n) throws SQLException {
        this.checkState();
        return this.rs.getBytes(n);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Reader getCharacterStream(int n) throws SQLException {
        this.checkState();
        return this.rs.getCharacterStream(n);
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    public Clob getClob(int n) throws SQLException {
        this.checkState();
        return this.rs.getClob(n);
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    public int getConcurrency() throws SQLException {
        this.checkState();
        return this.rs.getConcurrency();
    }

    public String getCursorName() throws SQLException {
        this.checkState();
        return this.rs.getCursorName();
    }

    public Date getDate(int n) throws SQLException {
        this.checkState();
        return this.rs.getDate(n);
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        this.checkState();
        return this.rs.getDate(n, calendar);
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    public double getDouble(int n) throws SQLException {
        this.checkState();
        return this.rs.getDouble(n);
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public int getFetchDirection() throws SQLException {
        this.checkState();
        return this.rs.getFetchDirection();
    }

    public float getFloat(int n) throws SQLException {
        this.checkState();
        return this.rs.getFloat(n);
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public int getInt(int n) throws SQLException {
        this.checkState();
        return this.rs.getInt(n);
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(int n) throws SQLException {
        this.checkState();
        return this.rs.getLong(n);
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkState();
        return this.rs.getMetaData();
    }

    public Object getObject(int n) throws SQLException {
        this.checkState();
        return this.rs.getObject(n);
    }

    public Object getObject(int n, Map map) throws SQLException {
        this.checkState();
        return this.rs.getObject(n, map);
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.findColumn(string), map);
    }

    public Ref getRef(int n) throws SQLException {
        this.checkState();
        return this.rs.getRef(n);
    }

    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    public int getRow() throws SQLException {
        this.checkState();
        return this.rs.getRow();
    }

    public short getShort(int n) throws SQLException {
        this.checkState();
        return this.rs.getShort(n);
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public Statement getStatement() throws SQLException {
        throw new SQLException("Unsupported Operation");
    }

    public String getString(int n) throws SQLException {
        this.checkState();
        return this.rs.getString(n);
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public Time getTime(int n) throws SQLException {
        this.checkState();
        return this.rs.getTime(n);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        this.checkState();
        return this.rs.getTime(n, calendar);
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        this.checkState();
        return this.rs.getTimestamp(n);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        this.checkState();
        return this.rs.getTimestamp(n, calendar);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    public int getType() throws SQLException {
        this.checkState();
        return this.rs.getType();
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        this.checkState();
        return this.rs.getUnicodeStream(n);
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkState();
        return this.rs.getWarnings();
    }

    public void insertRow() throws SQLException {
        this.checkState();
        this.rs.insertRow();
        this.notifyRowChanged();
    }

    public boolean isAfterLast() throws SQLException {
        this.checkState();
        return this.rs.isAfterLast();
    }

    public boolean isBeforeFirst() throws SQLException {
        this.checkState();
        return this.rs.isBeforeFirst();
    }

    public boolean isFirst() throws SQLException {
        this.checkState();
        return this.rs.isFirst();
    }

    public boolean isLast() throws SQLException {
        this.checkState();
        return this.rs.isLast();
    }

    public boolean last() throws SQLException {
        this.checkState();
        boolean bl = this.rs.last();
        this.notifyCursorMoved();
        return bl;
    }

    public void moveToCurrentRow() throws SQLException {
        this.checkState();
        this.rs.moveToCurrentRow();
    }

    public void moveToInsertRow() throws SQLException {
        this.checkState();
        this.rs.moveToInsertRow();
    }

    public boolean next() throws SQLException {
        this.checkState();
        boolean bl = this.rs.next();
        this.notifyCursorMoved();
        return bl;
    }

    public boolean previous() throws SQLException {
        this.checkState();
        boolean bl = this.rs.previous();
        this.notifyCursorMoved();
        return bl;
    }

    public void refreshRow() throws SQLException {
        this.checkState();
        this.rs.refreshRow();
    }

    public boolean relative(int n) throws SQLException {
        this.checkState();
        boolean bl = this.rs.relative(n);
        this.notifyCursorMoved();
        return bl;
    }

    public boolean rowDeleted() throws SQLException {
        this.checkState();
        return this.rs.rowDeleted();
    }

    public boolean rowInserted() throws SQLException {
        this.checkState();
        return this.rs.rowInserted();
    }

    public boolean rowUpdated() throws SQLException {
        this.checkState();
        return this.rs.rowUpdated();
    }

    public void setFetchDirection(int n) throws SQLException {
        this.checkState();
        this.rs.setFetchDirection(n);
    }

    public void setFetchSize(int n) throws SQLException {
        this.checkState();
        this.rs.setFetchSize(n);
    }

    private void setProperties(PreparedStatement preparedStatement) throws SQLException {
        try {
            preparedStatement.setEscapeProcessing(this.getEscapeProcessing());
        }
        catch (SQLException sQLException) {
            System.err.println("JdbcRowSet (setEscapeProcessing): " + sQLException.getMessage());
        }
        try {
            preparedStatement.setMaxFieldSize(this.getMaxFieldSize());
        }
        catch (SQLException sQLException) {
            System.err.println("JdbcRowSet (setMaxFieldSize): " + sQLException.getMessage());
        }
        try {
            preparedStatement.setMaxRows(this.getMaxRows());
        }
        catch (SQLException sQLException) {
            System.err.println("JdbcRowSet (setMaxRows): " + sQLException.getMessage());
        }
        try {
            preparedStatement.setQueryTimeout(this.getQueryTimeout());
        }
        catch (SQLException sQLException) {
            System.err.println("JdbcRowSet (setQueryTimeout): " + sQLException.getMessage());
        }
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkState();
        this.rs.updateAsciiStream(n, inputStream, n2);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.checkState();
        this.rs.updateBigDecimal(n, bigDecimal);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkState();
        this.rs.updateBinaryStream(n, inputStream, n2);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.checkState();
        this.rs.updateBoolean(n, bl);
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    public void updateByte(int n, byte by) throws SQLException {
        this.checkState();
        this.rs.updateByte(n, by);
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.checkState();
        this.rs.updateBytes(n, byArray);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.checkState();
        this.rs.updateCharacterStream(n, reader, n2);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    public void updateDate(int n, Date date) throws SQLException {
        this.checkState();
        this.rs.updateDate(n, date);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    public void updateDouble(int n, double d) throws SQLException {
        this.checkState();
        this.rs.updateDouble(n, d);
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    public void updateFloat(int n, float f) throws SQLException {
        this.checkState();
        this.rs.updateFloat(n, f);
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    public void updateInt(int n, int n2) throws SQLException {
        this.checkState();
        this.rs.updateInt(n, n2);
    }

    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    public void updateLong(int n, long l) throws SQLException {
        this.checkState();
        this.rs.updateLong(n, l);
    }

    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    public void updateNull(int n) throws SQLException {
        this.checkState();
        this.rs.updateNull(n);
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    public void updateObject(int n, Object object) throws SQLException {
        this.checkState();
        this.rs.updateObject(n, object);
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        this.checkState();
        this.rs.updateObject(n, object, n2);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, n);
    }

    public void updateRow() throws SQLException {
        this.checkState();
        this.rs.updateRow();
        this.notifyRowChanged();
    }

    public void updateShort(int n, short s) throws SQLException {
        this.checkState();
        this.rs.updateShort(n, s);
    }

    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    public void updateString(int n, String string) throws SQLException {
        this.checkState();
        this.rs.updateString(n, string);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    public void updateTime(int n, Time time) throws SQLException {
        this.checkState();
        this.rs.updateTime(n, time);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.checkState();
        this.rs.updateTimestamp(n, timestamp);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    public boolean wasNull() throws SQLException {
        this.checkState();
        return this.rs.wasNull();
    }
}

