/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.CosNaming;

import com.sun.corba.ee.internal.CosNaming.NamingContextDataStore;
import com.sun.corba.ee.internal.CosNaming.NamingUtils;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.BindingType;
import org.omg.CosNaming.BindingTypeHolder;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotEmpty;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.CosNaming.NamingContextPackage.NotFoundReason;
import org.omg.CosNaming._NamingContextImplBase;

public abstract class NamingContextImpl
extends _NamingContextImplBase {
    protected transient ORB orb;
    public static boolean debug = false;

    public NamingContextImpl(ORB oRB) throws Exception {
        this.orb = oRB;
    }

    public void bind(NameComponent[] nameComponentArray, Object object) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        if (object == null) {
            throw new INTERNAL(204, CompletionStatus.COMPLETED_NO);
        }
        if (debug) {
            NamingContextImpl.dprint("bind " + NamingContextImpl.nameToString(nameComponentArray) + " to " + object);
        }
        NamingContextDataStore namingContextDataStore = (NamingContextDataStore)((java.lang.Object)this);
        NamingContextImpl.doBind(namingContextDataStore, nameComponentArray, object, false, BindingType.nobject);
    }

    public void bind_context(NameComponent[] nameComponentArray, NamingContext namingContext) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        if (debug) {
            NamingContextImpl.dprint("bind_context " + NamingContextImpl.nameToString(nameComponentArray) + " to " + namingContext);
        }
        NamingContextDataStore namingContextDataStore = (NamingContextDataStore)((java.lang.Object)this);
        NamingContextImpl.doBind(namingContextDataStore, nameComponentArray, namingContext, false, BindingType.ncontext);
    }

    public NamingContext bind_new_context(NameComponent[] nameComponentArray) throws NotFound, AlreadyBound, CannotProceed, InvalidName {
        NamingContext namingContext = null;
        NamingContext namingContext2 = null;
        try {
            if (debug) {
                NamingContextImpl.dprint("bind_new_context " + NamingContextImpl.nameToString(nameComponentArray));
            }
            namingContext = this.new_context();
            this.bind_context(nameComponentArray, namingContext);
            namingContext2 = namingContext;
            namingContext = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var5_5 = null;
            try {
                if (namingContext != null) {
                    namingContext.destroy();
                }
            }
            catch (NotEmpty notEmpty) {}
            throw throwable;
        }
        java.lang.Object var5_4 = null;
        try {
            if (namingContext != null) {
                namingContext.destroy();
            }
        }
        catch (NotEmpty notEmpty) {}
        return namingContext2;
    }

    public void destroy() throws NotEmpty {
        NamingContextDataStore namingContextDataStore;
        if (debug) {
            NamingContextImpl.dprint("destroy ");
        }
        NamingContextDataStore namingContextDataStore2 = namingContextDataStore = (NamingContextDataStore)((java.lang.Object)this);
        synchronized (namingContextDataStore2) {
            if (!namingContextDataStore.IsEmpty()) {
                throw new NotEmpty();
            }
            namingContextDataStore.Destroy();
        }
    }

    public static void doBind(NamingContextDataStore namingContextDataStore, NameComponent[] nameComponentArray, Object object, boolean bl2, BindingType bindingType) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        if (nameComponentArray.length < 1) {
            throw new InvalidName();
        }
        if (nameComponentArray.length == 1) {
            if (nameComponentArray[0].id.length() == 0) {
                throw new InvalidName();
            }
            NamingContextDataStore namingContextDataStore2 = namingContextDataStore;
            synchronized (namingContextDataStore2) {
                BindingTypeHolder bindingTypeHolder = new BindingTypeHolder();
                if (bl2) {
                    namingContextDataStore.Unbind(nameComponentArray[0]);
                } else if (namingContextDataStore.Resolve(nameComponentArray[0], bindingTypeHolder) != null) {
                    throw new AlreadyBound();
                }
                namingContextDataStore.Bind(nameComponentArray[0], object, bindingType);
            }
        } else {
            NamingContext namingContext = NamingContextImpl.resolveFirstAsContext(namingContextDataStore, nameComponentArray);
            NameComponent[] nameComponentArray2 = new NameComponent[nameComponentArray.length - 1];
            System.arraycopy(nameComponentArray, 1, nameComponentArray2, 0, nameComponentArray.length - 1);
            switch (bindingType.value()) {
                case 0: {
                    if (bl2) {
                        namingContext.rebind(nameComponentArray2, object);
                        break;
                    }
                    namingContext.bind(nameComponentArray2, object);
                    break;
                }
                case 1: {
                    NamingContext namingContext2 = (NamingContext)object;
                    if (bl2) {
                        namingContext.rebind_context(nameComponentArray2, namingContext2);
                        break;
                    }
                    namingContext.bind_context(nameComponentArray2, namingContext2);
                    break;
                }
                default: {
                    throw new INTERNAL(102, CompletionStatus.COMPLETED_NO);
                }
            }
        }
    }

    public static Object doResolve(NamingContextDataStore namingContextDataStore, NameComponent[] nameComponentArray) throws NotFound, CannotProceed, InvalidName {
        Object object = null;
        BindingTypeHolder bindingTypeHolder = new BindingTypeHolder();
        if (nameComponentArray.length < 1) {
            throw new InvalidName();
        }
        if (nameComponentArray.length == 1) {
            NamingContextDataStore namingContextDataStore2 = namingContextDataStore;
            synchronized (namingContextDataStore2) {
                object = namingContextDataStore.Resolve(nameComponentArray[0], bindingTypeHolder);
            }
            if (object == null) {
                throw new NotFound(NotFoundReason.missing_node, nameComponentArray);
            }
            return object;
        }
        if (nameComponentArray[1].id.length() == 0) {
            throw new InvalidName();
        }
        NamingContext namingContext = NamingContextImpl.resolveFirstAsContext(namingContextDataStore, nameComponentArray);
        NameComponent[] nameComponentArray2 = new NameComponent[nameComponentArray.length - 1];
        System.arraycopy(nameComponentArray, 1, nameComponentArray2, 0, nameComponentArray.length - 1);
        return namingContext.resolve(nameComponentArray2);
    }

    public static void doUnbind(NamingContextDataStore namingContextDataStore, NameComponent[] nameComponentArray) throws NotFound, CannotProceed, InvalidName {
        if (nameComponentArray.length < 1) {
            throw new InvalidName();
        }
        if (nameComponentArray.length == 1) {
            if (nameComponentArray[0].id.length() == 0) {
                throw new InvalidName();
            }
            Object object = null;
            NamingContextDataStore namingContextDataStore2 = namingContextDataStore;
            synchronized (namingContextDataStore2) {
                object = namingContextDataStore.Unbind(nameComponentArray[0]);
            }
            if (object == null) {
                throw new NotFound(NotFoundReason.missing_node, nameComponentArray);
            }
            return;
        }
        NamingContext namingContext = NamingContextImpl.resolveFirstAsContext(namingContextDataStore, nameComponentArray);
        NameComponent[] nameComponentArray2 = new NameComponent[nameComponentArray.length - 1];
        System.arraycopy(nameComponentArray, 1, nameComponentArray2, 0, nameComponentArray.length - 1);
        namingContext.unbind(nameComponentArray2);
    }

    private static void dprint(String string) {
        NamingUtils.dprint("NamingContextImpl(" + Thread.currentThread().getName() + " at " + System.currentTimeMillis() + " ems): " + string);
    }

    public void list(int n2, BindingListHolder bindingListHolder, BindingIteratorHolder bindingIteratorHolder) {
        NamingContextDataStore namingContextDataStore;
        if (debug) {
            NamingContextImpl.dprint("list(" + n2 + ")");
        }
        NamingContextDataStore namingContextDataStore2 = namingContextDataStore = (NamingContextDataStore)((java.lang.Object)this);
        synchronized (namingContextDataStore2) {
            namingContextDataStore.List(n2, bindingListHolder, bindingIteratorHolder);
        }
        if (debug && bindingListHolder.value != null) {
            NamingContextImpl.dprint("list(" + n2 + ") -> bindings[" + bindingListHolder.value.length + "] + iterator: " + bindingIteratorHolder.value);
        }
    }

    public static String nameToString(NameComponent[] nameComponentArray) {
        StringBuffer stringBuffer = new StringBuffer("{");
        if (nameComponentArray != null || nameComponentArray.length > 0) {
            int n2 = 0;
            while (n2 < nameComponentArray.length) {
                if (n2 > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append("[").append(nameComponentArray[n2].id).append(",").append(nameComponentArray[n2].kind).append("]");
                ++n2;
            }
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public synchronized NamingContext new_context() {
        NamingContextDataStore namingContextDataStore;
        if (debug) {
            NamingContextImpl.dprint("new_context()");
        }
        NamingContextDataStore namingContextDataStore2 = namingContextDataStore = (NamingContextDataStore)((java.lang.Object)this);
        synchronized (namingContextDataStore2) {
            NamingContext namingContext = namingContextDataStore.NewContext();
            java.lang.Object var4_4 = null;
            return namingContext;
        }
    }

    public void rebind(NameComponent[] nameComponentArray, Object object) throws NotFound, CannotProceed, InvalidName {
        if (object == null) {
            throw new INTERNAL(204, CompletionStatus.COMPLETED_NO);
        }
        try {
            if (debug) {
                NamingContextImpl.dprint("rebind " + NamingContextImpl.nameToString(nameComponentArray) + " to " + object);
            }
            NamingContextDataStore namingContextDataStore = (NamingContextDataStore)((java.lang.Object)this);
            NamingContextImpl.doBind(namingContextDataStore, nameComponentArray, object, true, BindingType.nobject);
        }
        catch (AlreadyBound alreadyBound) {
            throw new INTERNAL(100, CompletionStatus.COMPLETED_NO);
        }
    }

    public void rebind_context(NameComponent[] nameComponentArray, NamingContext namingContext) throws NotFound, CannotProceed, InvalidName {
        try {
            if (debug) {
                NamingContextImpl.dprint("rebind_context " + NamingContextImpl.nameToString(nameComponentArray) + " to " + namingContext);
            }
            NamingContextDataStore namingContextDataStore = (NamingContextDataStore)((java.lang.Object)this);
            NamingContextImpl.doBind(namingContextDataStore, nameComponentArray, namingContext, true, BindingType.ncontext);
        }
        catch (AlreadyBound alreadyBound) {
            throw new INTERNAL(101, CompletionStatus.COMPLETED_NO);
        }
    }

    public Object resolve(NameComponent[] nameComponentArray) throws NotFound, CannotProceed, InvalidName {
        if (debug) {
            NamingContextImpl.dprint("resolve " + NamingContextImpl.nameToString(nameComponentArray));
        }
        NamingContextDataStore namingContextDataStore = (NamingContextDataStore)((java.lang.Object)this);
        return NamingContextImpl.doResolve(namingContextDataStore, nameComponentArray);
    }

    protected static NamingContext resolveFirstAsContext(NamingContextDataStore namingContextDataStore, NameComponent[] nameComponentArray) throws NotFound {
        Object object = null;
        BindingTypeHolder bindingTypeHolder = new BindingTypeHolder();
        NamingContext namingContext = null;
        NamingContextDataStore namingContextDataStore2 = namingContextDataStore;
        synchronized (namingContextDataStore2) {
            object = namingContextDataStore.Resolve(nameComponentArray[0], bindingTypeHolder);
            if (object == null) {
                throw new NotFound(NotFoundReason.missing_node, nameComponentArray);
            }
        }
        if (bindingTypeHolder.value != BindingType.ncontext) {
            throw new NotFound(NotFoundReason.not_context, nameComponentArray);
        }
        try {
            namingContext = NamingContextHelper.narrow(object);
        }
        catch (BAD_PARAM bAD_PARAM) {
            throw new NotFound(NotFoundReason.not_context, nameComponentArray);
        }
        return namingContext;
    }

    public void unbind(NameComponent[] nameComponentArray) throws NotFound, CannotProceed, InvalidName {
        if (debug) {
            NamingContextImpl.dprint("unbind " + NamingContextImpl.nameToString(nameComponentArray));
        }
        NamingContextDataStore namingContextDataStore = (NamingContextDataStore)((java.lang.Object)this);
        NamingContextImpl.doUnbind(namingContextDataStore, nameComponentArray);
    }
}

