/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.core;

import com.sun.corba.ee.internal.core.CodeSetComponentInfo;
import com.sun.corba.ee.internal.core.EndPoint;
import com.sun.corba.ee.internal.core.MarshalInputStream;
import com.sun.corba.ee.internal.core.MarshalOutputStream;
import com.sun.corba.ee.internal.core.ORB;
import com.sun.corba.ee.internal.core.Profile;
import com.sun.corba.ee.internal.util.HexOutputStream;
import com.sun.corba.ee.internal.util.JDKBridge;
import java.io.IOException;
import java.io.StringWriter;
import javax.rmi.CORBA.Util;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.InputStream;

public class IOR {
    public static final IOR NULL = new IOR();
    protected String typeId;
    protected int[] profileTags;
    protected byte[][] profileData;
    protected ORB factory;
    protected String host;
    protected int port;
    protected byte[] key;
    protected Object servant;
    private EndPoint ep;
    protected Profile iop;
    protected String codebase;
    protected boolean cachedCodebase = false;
    private static Profile.TaggedComponent localCodeBaseTC = null;
    public static final int InternetIOPTag = 0;

    private IOR() {
        this.factory = null;
        this.typeId = "";
        this.profileTags = new int[0];
    }

    public IOR(IOR iOR) {
        this(iOR.factory, iOR.typeId, iOR.host, iOR.port, iOR.key, iOR.servant);
    }

    public IOR(ORB oRB) {
        this.factory = oRB;
    }

    public IOR(ORB oRB, String string, String string2, int n2, byte[] byArray) throws SystemException {
        this(oRB, string, string2, n2, byArray, null);
    }

    public IOR(ORB oRB, String string, String string2, int n2, byte[] byArray, Object object) throws SystemException {
        this(oRB);
        this.typeId = string;
        this.host = string2;
        this.port = n2;
        this.key = byArray;
        this.servant = object;
        Profile.TaggedComponent taggedComponent = this.createCodeSetComponent();
        Profile.TaggedComponent taggedComponent2 = this.createCodebaseComponent(object);
        this.setProfile(string2, n2, byArray, taggedComponent, taggedComponent2);
    }

    protected Profile.TaggedComponent createCodeSetComponent() {
        MarshalOutputStream marshalOutputStream = this.factory.newOutputStream();
        CodeSetComponentInfo codeSetComponentInfo = this.factory.getCodeSetComponentInfo();
        marshalOutputStream.putEndian();
        codeSetComponentInfo.write(marshalOutputStream);
        byte[] byArray = marshalOutputStream.toByteArray();
        Profile.TaggedComponent taggedComponent = new Profile.TaggedComponent(1, byArray);
        return taggedComponent;
    }

    protected Profile.TaggedComponent createCodebaseComponent(Object object) {
        if (object != null) {
            this.codebase = Util.getCodebase(object.getClass());
            this.cachedCodebase = true;
            return this.createCodebaseComponent(this.codebase);
        }
        return null;
    }

    protected Profile.TaggedComponent createCodebaseComponent(String string) {
        Profile.TaggedComponent taggedComponent = null;
        try {
            MarshalOutputStream marshalOutputStream = this.factory.newOutputStream();
            marshalOutputStream.putEndian();
            marshalOutputStream.write_string(string);
            byte[] byArray = marshalOutputStream.toByteArray();
            if (byArray != null && byArray.length > 0) {
                taggedComponent = new Profile.TaggedComponent(25, byArray);
            }
        }
        catch (Exception exception) {}
        return taggedComponent;
    }

    public String getCodebase() {
        if (!this.cachedCodebase && this.profileTags.length > 0) {
            Profile.TaggedComponent[] taggedComponentArray = this.getProfile().getTaggedComponents();
            int n2 = 0;
            while (n2 < taggedComponentArray.length) {
                if (taggedComponentArray[n2].tag == 25) {
                    try {
                        MarshalInputStream marshalInputStream = taggedComponentArray[n2].getComponentData(this.factory);
                        this.codebase = marshalInputStream.read_string();
                    }
                    catch (Exception exception) {}
                }
                ++n2;
            }
            this.cachedCodebase = true;
        }
        return this.codebase;
    }

    public synchronized EndPoint getEndpoint() {
        if (this.ep == null) {
            this.ep = this.factory.newEndPoint(this);
        }
        return this.ep;
    }

    public synchronized Profile getProfile() {
        if (this.iop != null) {
            return this.iop;
        }
        int n2 = 0;
        while (n2 < this.profileTags.length) {
            if (this.profileTags[n2] == 0) {
                this.iop = new Profile(this.factory, this.profileData[n2]);
                return this.iop;
            }
            ++n2;
        }
        throw new INV_OBJREF(1398079489, CompletionStatus.COMPLETED_NO);
    }

    public String getTypeId() {
        return this.typeId;
    }

    public boolean isEquivalent(IOR iOR) {
        return this.getProfile().isEquivalent(iOR.getProfile());
    }

    public boolean isLocal() {
        if (this.factory == null) {
            return false;
        }
        Profile profile = this.getProfile();
        String string = profile.getHost();
        byte[] byArray = profile.getObjectKey();
        return this.factory.isLocalHost(string) && this.factory.isLocalServerId(byArray);
    }

    public boolean is_nil() {
        return this.profileTags.length == 0;
    }

    public void putProfile(Profile profile) {
        int n2 = 0;
        if (this.profileTags != null) {
            n2 = this.profileTags.length;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (this.profileTags[n3] == 0) {
                this.profileData[n3] = profile.getEncapsulation();
                this.iop = profile;
                return;
            }
            ++n3;
        }
        int[] nArray = new int[n2 + 1];
        byte[][] byArray = new byte[n2 + 1][];
        n3 = 0;
        while (n3 < n2) {
            nArray[n3] = this.profileTags[n3];
            byArray[n3] = this.profileData[n3];
            ++n3;
        }
        nArray[n3] = 0;
        byArray[n3] = profile.getEncapsulation();
        this.profileTags = nArray;
        this.profileData = byArray;
        this.iop = profile;
    }

    public void read(InputStream inputStream) {
        String string;
        this.typeId = inputStream.read_string();
        int n2 = inputStream.read_long();
        this.profileTags = new int[n2];
        this.profileData = new byte[n2][];
        int n3 = 0;
        while (n3 < n2) {
            this.profileTags[n3] = inputStream.read_long();
            this.profileData[n3] = new byte[inputStream.read_long()];
            inputStream.read_octet_array(this.profileData[n3], 0, this.profileData[n3].length);
            ++n3;
        }
        this.cachedCodebase = false;
        if (!this.is_nil() && (string = JDKBridge.getLocalCodebase()) != null && this.getCodebase() == null) {
            if (localCodeBaseTC == null) {
                localCodeBaseTC = this.createCodebaseComponent(string);
            }
            Profile.TaggedComponent taggedComponent = null;
            Profile profile = this.getProfile();
            Profile.TaggedComponent[] taggedComponentArray = profile.getTaggedComponents();
            int n4 = 0;
            while (n4 < taggedComponentArray.length) {
                if (taggedComponentArray[n4].tag == 1) {
                    taggedComponent = taggedComponentArray[n4];
                }
                ++n4;
            }
            this.setProfile(profile.getHost(), profile.getPort(), profile.getObjectKey(), taggedComponent, localCodeBaseTC);
            this.codebase = string;
            this.cachedCodebase = true;
        }
    }

    protected void setProfile(String string, int n2, byte[] byArray, Profile.TaggedComponent taggedComponent, Profile.TaggedComponent taggedComponent2) {
        Profile.TaggedComponent[] taggedComponentArray = taggedComponent2 == null ? new Profile.TaggedComponent[]{taggedComponent} : new Profile.TaggedComponent[]{taggedComponent, taggedComponent2};
        Profile profile = new Profile(this.factory, string, n2, byArray, taggedComponentArray);
        this.putProfile(profile);
    }

    public String stringify() {
        return this.stringify(this.factory);
    }

    public String stringify(ORB oRB) {
        MarshalOutputStream marshalOutputStream = oRB.newOutputStream();
        marshalOutputStream.putEndian();
        this.write(marshalOutputStream);
        StringWriter stringWriter = new StringWriter();
        try {
            marshalOutputStream.writeTo(new HexOutputStream(stringWriter));
        }
        catch (IOException iOException) {
            throw new INTERNAL(1398079498, CompletionStatus.COMPLETED_NO);
        }
        return "IOR:" + stringWriter;
    }

    public void write(MarshalOutputStream marshalOutputStream) {
        marshalOutputStream.write_string(this.typeId);
        marshalOutputStream.write_long(this.profileTags.length);
        int n2 = 0;
        while (n2 < this.profileTags.length) {
            marshalOutputStream.write_long(this.profileTags[n2]);
            marshalOutputStream.write_long(this.profileData[n2].length);
            marshalOutputStream.write_octet_array(this.profileData[n2], 0, this.profileData[n2].length);
            ++n2;
        }
    }
}

