/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.core;

import com.sun.corba.ee.internal.corba.ORB;
import com.sun.corba.ee.internal.core.DuplicateServiceContext;
import com.sun.corba.ee.internal.core.NoSuchServiceContext;
import com.sun.corba.ee.internal.core.ServiceContext;
import com.sun.corba.ee.internal.core.ServiceContextData;
import com.sun.corba.ee.internal.core.ServiceContextEnumeration;
import com.sun.corba.ee.internal.core.ServiceContextRegistry;
import com.sun.corba.ee.internal.core.UnknownServiceContext;
import com.sun.corba.ee.internal.iiop.CDRInputStream;
import com.sun.corba.ee.internal.iiop.CDROutputStream;
import com.sun.corba.ee.internal.util.Utility;
import java.util.Enumeration;
import java.util.Vector;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public class ServiceContexts {
    private static final int JAVAIDL_ALIGN_SERVICE_ID = -1106033203;
    private ORB orb;
    private Vector scList;
    private int numValid;
    private boolean addAlignmentOnWrite;

    public ServiceContexts(ORB oRB) {
        this.orb = oRB;
        this.numValid = 0;
        this.scList = new Vector();
        this.addAlignmentOnWrite = false;
    }

    public ServiceContexts(InputStream inputStream) {
        CDRInputStream cDRInputStream = (CDRInputStream)inputStream;
        this.orb = (ORB)cDRInputStream.getORB();
        if (this.orb.serviceContextDebugFlag) {
            this.dprint("Constructing ServiceContexts from input stream");
        }
        ServiceContextRegistry serviceContextRegistry = this.orb.getServiceContextRegistry();
        this.numValid = inputStream.read_long();
        if (this.orb.serviceContextDebugFlag) {
            this.dprint("Number of service contexts = " + this.numValid);
        }
        this.scList = new Vector(this.numValid);
        this.addAlignmentOnWrite = false;
        int n2 = 0;
        while (n2 < this.numValid) {
            int n3 = inputStream.read_long();
            if (this.orb.serviceContextDebugFlag) {
                this.dprint("Read service context id " + n3);
            }
            ServiceContextData serviceContextData = serviceContextRegistry.findServiceContextData(n3);
            ServiceContext serviceContext = null;
            if (serviceContextData == null) {
                if (this.orb.serviceContextDebugFlag) {
                    this.dprint("Could not find ServiceContextData: using UnknownServiceContext");
                }
                serviceContext = new UnknownServiceContext(n3, inputStream);
            } else {
                if (this.orb.serviceContextDebugFlag) {
                    this.dprint("Found " + serviceContextData);
                }
                try {
                    serviceContext = serviceContextData.makeServiceContext(inputStream);
                }
                catch (NoSuchServiceContext noSuchServiceContext) {
                    throw new INTERNAL();
                }
            }
            this.scList.addElement(serviceContext);
            ++n2;
        }
    }

    public void addAlignmentPadding() {
        this.addAlignmentOnWrite = true;
    }

    public void delete(int n2) throws NoSuchServiceContext {
        int n3 = this.findServiceContextIndex(n2);
        if (n3 < 0) {
            throw new NoSuchServiceContext();
        }
        this.scList.setElementAt(null, n3);
        --this.numValid;
    }

    private void dprint(String string) {
        Utility.dprint(this, string);
    }

    private int findFirstNullIndex() {
        int n2 = 0;
        while (n2 < this.scList.size()) {
            if (this.scList.elementAt(n2) == null) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private int findServiceContextIndex(int n2) {
        int n3 = 0;
        while (n3 < this.scList.size()) {
            ServiceContext serviceContext;
            Object e10 = this.scList.elementAt(n3);
            if (e10 != null && (serviceContext = (ServiceContext)e10).getId() == n2) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public ServiceContext get(int n2) throws NoSuchServiceContext {
        int n3 = this.findServiceContextIndex(n2);
        if (n3 < 0) {
            throw new NoSuchServiceContext();
        }
        return (ServiceContext)this.scList.elementAt(n3);
    }

    private static boolean isDebugging(InputStream inputStream) {
        CDRInputStream cDRInputStream = (CDRInputStream)inputStream;
        ORB oRB = (ORB)cDRInputStream.getORB();
        if (oRB == null) {
            return false;
        }
        return oRB.serviceContextDebugFlag;
    }

    private static boolean isDebugging(OutputStream outputStream) {
        CDROutputStream cDROutputStream = (CDROutputStream)outputStream;
        ORB oRB = (ORB)cDROutputStream.getORB();
        if (oRB == null) {
            return false;
        }
        return oRB.serviceContextDebugFlag;
    }

    public Enumeration list() {
        return new ServiceContextEnumeration(this.scList);
    }

    public void put(ServiceContext serviceContext) throws DuplicateServiceContext {
        int n2 = this.findServiceContextIndex(serviceContext.getId());
        if (n2 >= 0) {
            throw new DuplicateServiceContext();
        }
        n2 = this.findFirstNullIndex();
        if (n2 < 0) {
            this.scList.addElement(serviceContext);
        } else {
            this.scList.setElementAt(serviceContext, n2);
        }
        ++this.numValid;
    }

    public void write(OutputStream outputStream) {
        if (ServiceContexts.isDebugging(outputStream)) {
            this.dprint("Writing service contexts to output stream");
            Utility.printStackTrace();
        }
        int n2 = this.numValid;
        if (this.addAlignmentOnWrite) {
            if (ServiceContexts.isDebugging(outputStream)) {
                this.dprint("Adding alignment padding");
            }
            ++n2;
        }
        if (ServiceContexts.isDebugging(outputStream)) {
            this.dprint("Service context has " + n2 + " components");
        }
        outputStream.write_long(n2);
        Enumeration enumeration = this.scList.elements();
        while (enumeration.hasMoreElements()) {
            ServiceContext serviceContext = (ServiceContext)enumeration.nextElement();
            if (ServiceContexts.isDebugging(outputStream)) {
                this.dprint("Writing service context " + serviceContext);
            }
            serviceContext.write(outputStream);
        }
        if (this.addAlignmentOnWrite) {
            if (ServiceContexts.isDebugging(outputStream)) {
                this.dprint("Writing alignment padding");
            }
            outputStream.write_long(-1106033203);
            outputStream.write_long(4);
            outputStream.write_octet((byte)0);
            outputStream.write_octet((byte)0);
            outputStream.write_octet((byte)0);
            outputStream.write_octet((byte)0);
        }
        if (ServiceContexts.isDebugging(outputStream)) {
            this.dprint("Service context writing complete");
        }
    }

    public static void writeNullServiceContext(OutputStream outputStream) {
        if (ServiceContexts.isDebugging(outputStream)) {
            Utility.dprint("ServiceContexts", "Writing null service context");
        }
        outputStream.write_long(0);
    }
}

