/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.iiop;

import com.sun.corba.ee.internal.corba.ORB;
import com.sun.corba.ee.internal.core.IOR;
import com.sun.corba.ee.internal.core.ServiceContexts;
import com.sun.corba.ee.internal.iiop.CDRInputStream;
import com.sun.corba.ee.internal.iiop.IIOPInputStream;
import com.sun.corba.ee.internal.iiop.Message;
import com.sun.corba.ee.internal.util.Utility;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.SystemException;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public class ReplyMessage
extends Message {
    protected ServiceContexts ctx;
    protected int status;
    protected String exceptionId;
    protected String exClassName;
    protected int minorCode;
    protected CompletionStatus completionStatus;
    protected IOR ior;
    protected ORB orb;
    public static final int NO_EXCEPTION = 0;
    public static final int USER_EXCEPTION = 1;
    public static final int SYSTEM_EXCEPTION = 2;
    public static final int LOCATION_FORWARD = 3;

    public ReplyMessage(ServiceContexts serviceContexts, int n2, int n3, IOR iOR, boolean bl2) {
        super(bl2);
        this.setType(1);
        this.ctx = serviceContexts;
        this.requestId = n2;
        this.status = n3;
        this.ior = iOR;
    }

    public ReplyMessage(boolean bl2) {
        super(bl2);
    }

    private void dprint(String string) {
        Utility.dprint(this, string);
    }

    public String getExceptionId() {
        return this.exceptionId;
    }

    public IOR getIOR() {
        return this.ior;
    }

    public int getMinorCode() {
        return this.minorCode;
    }

    public int getReplyStatus() {
        return this.status;
    }

    public ServiceContexts getServiceContexts() {
        return this.ctx;
    }

    public SystemException getSystemException() {
        Exception exception;
        if (this.debug) {
            this.dprint("getSystemException called");
            this.dprint("exClassName = " + this.exClassName);
            exception = new Exception("traceback");
            exception.fillInStackTrace();
            exception.printStackTrace();
        }
        try {
            exception = (SystemException)Class.forName(this.exClassName).newInstance();
        }
        catch (Exception exception2) {
            if (this.debug) {
                this.dprint("Bad system exception");
            }
            throw new INTERNAL("BAD SystemException: " + this.exClassName, 0, CompletionStatus.COMPLETED_MAYBE);
        }
        ((SystemException)exception).minor = this.minorCode;
        ((SystemException)exception).completed = this.completionStatus;
        if (this.debug) {
            this.dprint("returning system exception " + exception);
        }
        return exception;
    }

    public void read(org.omg.CORBA.portable.InputStream inputStream) throws SystemException {
        block21: {
            block20: {
                if (this.debug) {
                    this.dprint("read from input stream called");
                }
                this.ctx = new ServiceContexts((InputStream)inputStream);
                this.requestId = inputStream.read_long();
                if (this.debug) {
                    this.dprint("requestId = " + this.requestId);
                }
                this.status = inputStream.read_long();
                if (this.debug) {
                    this.dprint("status = " + this.status);
                }
                if (this.status != 2) break block20;
                if (this.debug) {
                    this.dprint("messsage is system exception");
                }
                String string = inputStream.read_string();
                if (this.debug) {
                    this.dprint("reposId is " + string);
                }
                this.exClassName = Utility.classNameOf(string);
                if (this.debug) {
                    this.dprint("exClassName is " + this.exClassName);
                }
                this.minorCode = inputStream.read_long();
                if (this.debug) {
                    this.dprint("minorCode is " + this.minorCode);
                }
                int n2 = inputStream.read_long();
                if (this.debug) {
                    this.dprint("status is " + n2);
                }
                switch (n2) {
                    case 0: {
                        this.completionStatus = CompletionStatus.COMPLETED_YES;
                        break block21;
                    }
                    case 1: {
                        this.completionStatus = CompletionStatus.COMPLETED_NO;
                        break block21;
                    }
                    case 2: {
                        this.completionStatus = CompletionStatus.COMPLETED_MAYBE;
                        break block21;
                    }
                    default: {
                        if (this.debug) {
                            this.dprint("Bad completion status error");
                        }
                        throw new INTERNAL("BAD completion status: " + n2, 0, CompletionStatus.COMPLETED_MAYBE);
                    }
                }
            }
            if (this.status == 1) {
                if (this.debug) {
                    this.dprint("message is user exception");
                }
                IIOPInputStream iIOPInputStream = (IIOPInputStream)inputStream;
                this.exceptionId = iIOPInputStream.peek_string();
                if (this.debug) {
                    this.dprint("exceptionId is " + this.exceptionId);
                }
            } else if (this.status == 3) {
                if (this.debug) {
                    this.dprint("message is location forward");
                }
                CDRInputStream cDRInputStream = (CDRInputStream)inputStream;
                this.ior = new IOR(cDRInputStream.orb);
                this.ior.read(inputStream);
            }
        }
    }

    public void write(org.omg.CORBA.portable.OutputStream outputStream) throws SystemException {
        super.write(outputStream);
        if (this.ctx != null) {
            this.ctx.write((OutputStream)outputStream);
        } else {
            ServiceContexts.writeNullServiceContext((OutputStream)outputStream);
        }
        outputStream.write_long(this.requestId);
        outputStream.write_long(this.status);
    }
}

