/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.sqlgen;

import com.sun.ejb.sqlgen.CMPFields;
import com.sun.ejb.sqlgen.DBInfo;
import com.sun.ejb.sqlgen.DBMetaData;
import com.sun.ejb.sqlgen.SQLTypeMapper;
import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.resource.ResourcePrincipal;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.Field;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Iterator;

public final class SQLGenerator {
    private static final boolean debug = false;
    private EjbEntityDescriptor desc;
    private String tableName;
    private Field[] pkeyFields;
    private Field[] contMgFields;
    private Field[] contMgNoPkeyFields;
    private Field[] ejbPkeyFields;
    private String[] pkeyFieldNames;
    private String[] contMgFieldNames;
    private String[] contMgNoPkeyFieldNames;
    private String whereClause;
    private String createTableQuery;
    private String deleteTableQuery;
    private String ejbLoadQuery;
    private String ejbStoreQuery;
    private String ejbCreateQuery;
    private String ejbRemoveQuery;
    private String ejbFindByPrimaryKeyQuery;
    private String nonPrimaryKeyFinderQuery;
    private Hashtable findQueryTable = new Hashtable();
    private SQLTypeMapper typeMapper;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$ejb$sqlgen$SQLGenerator != null ? class$com$sun$ejb$sqlgen$SQLGenerator : (class$com$sun$ejb$sqlgen$SQLGenerator = SQLGenerator.class$("com.sun.ejb.sqlgen.SQLGenerator")));
    private ClassLoader loader;
    private boolean isMSSqlServer = false;
    static /* synthetic */ Class class$com$sun$ejb$sqlgen$SQLGenerator;

    private SQLGenerator(EjbEntityDescriptor desc, ClassLoader loader, SQLTypeMapper typeMapper, DBMetaData metadata) throws RemoteException {
        int columnNameMax;
        int tableNameMax;
        this.desc = desc;
        this.typeMapper = typeMapper;
        this.loader = loader;
        try {
            CMPFields fieldInfo = new CMPFields(desc, loader);
            this.pkeyFields = fieldInfo.pkeyFields;
            this.contMgFields = fieldInfo.contMgFields;
            this.contMgNoPkeyFields = fieldInfo.contMgNoPkeyFields;
            this.ejbPkeyFields = fieldInfo.ejbPkeyFields;
            tableNameMax = metadata.maxTableNameLength - 2;
            columnNameMax = metadata.maxColumnNameLength - 2;
            if (metadata.dbName.toLowerCase().indexOf("microsoft") != -1) {
                this.isMSSqlServer = true;
            }
        }
        catch (Exception ex2) {
            throw new RemoteException("Error obtaining CMP/primary key fields", ex2);
        }
        String ejbFullName = desc.getEjbClassName();
        String ejbName = ejbFullName.substring(ejbFullName.lastIndexOf(".") + 1);
        if (ejbName.length() > columnNameMax) {
            ejbName = ejbName.substring(0, tableNameMax);
        }
        this.tableName = "\"" + ejbName + "Table\" ";
        this.contMgFieldNames = new String[this.contMgFields.length];
        int i2 = 0;
        while (i2 < this.contMgFields.length) {
            String name = this.contMgFields[i2].getName();
            if (name.length() > columnNameMax) {
                Log.err.println(localStrings.getLocalString("ejb.sqlgen.fieldnamewillbetruncatedtomaxchars", "Warning: field name {0} will be truncated to {1} characters to get column name.", new Object[]{name, new Integer(columnNameMax)}));
                name = name.substring(0, columnNameMax);
            }
            this.contMgFieldNames[i2] = name = "\"" + name + "\"";
            ++i2;
        }
        this.contMgNoPkeyFieldNames = new String[this.contMgNoPkeyFields.length];
        int i3 = 0;
        while (i3 < this.contMgNoPkeyFields.length) {
            String name = this.contMgNoPkeyFields[i3].getName();
            if (name.length() > columnNameMax) {
                name = name.substring(0, columnNameMax);
            }
            this.contMgNoPkeyFieldNames[i3] = name = "\"" + name + "\"";
            ++i3;
        }
        this.pkeyFieldNames = new String[this.pkeyFields.length];
        int i4 = 0;
        while (i4 < this.pkeyFields.length) {
            String name = this.pkeyFields[i4].getName();
            if (name.length() > columnNameMax) {
                name = name.substring(0, columnNameMax);
            }
            this.pkeyFieldNames[i4] = name = "\"" + name + "\"";
            ++i4;
        }
        try {
            this.generateWhereClause();
            this.generateCreateTableQuery();
            this.generateDeleteTableQuery();
            this.generateEjbLoadQuery();
            this.generateEjbStoreQuery();
            this.generateEjbCreateQuery();
            this.generateEjbRemoveQuery();
            this.generateEjbFindByPrimaryKeyQuery();
            this.generateNonPrimaryKeyFinderQuery();
        }
        catch (Exception ex3) {
            throw new RemoteException("Unable to generate SQL ", ex3);
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private void generateCreateTableQuery() {
        String query = "CREATE TABLE " + this.tableName + " (";
        int i2 = 0;
        while (i2 < this.contMgFields.length) {
            int jdbcType;
            if (i2 > 0) {
                query = String.valueOf(query) + " , ";
            }
            Class<?> javaObjClass = this.contMgFields[i2].getType();
            String type = this.typeMapper.getSQLTypeFor(javaObjClass);
            query = String.valueOf(query) + this.contMgFieldNames[i2] + " " + type;
            if (javaObjClass.isPrimitive()) {
                query = String.valueOf(query) + " NOT NULL";
            } else if (this.isMSSqlServer && !this.isPkeyField(this.contMgFields[i2].getName()) && (jdbcType = this.typeMapper.getJDBCTypeFor(javaObjClass)) != -7) {
                query = String.valueOf(query) + " NULL";
            }
            ++i2;
        }
        String constraintName = "\"pk_" + this.tableName.substring(1, this.tableName.length());
        query = String.valueOf(query) + ", CONSTRAINT " + constraintName + " PRIMARY KEY (";
        int i3 = 0;
        while (i3 < this.pkeyFields.length) {
            if (i3 > 0) {
                query = String.valueOf(query) + " , ";
            }
            query = String.valueOf(query) + this.pkeyFieldNames[i3];
            ++i3;
        }
        this.createTableQuery = query = String.valueOf(query) + ") )";
    }

    private void generateDeleteTableQuery() {
        this.deleteTableQuery = "DROP TABLE " + this.tableName;
    }

    private void generateEjbCreateQuery() {
        String query = "INSERT INTO " + this.tableName + " ( ";
        int i2 = 0;
        while (i2 < this.contMgFields.length) {
            if (i2 > 0) {
                query = String.valueOf(query) + " , ";
            }
            query = String.valueOf(query) + this.contMgFieldNames[i2];
            ++i2;
        }
        query = String.valueOf(query) + " ) VALUES ( ";
        int i3 = 0;
        while (i3 < this.contMgFields.length) {
            if (i3 > 0) {
                query = String.valueOf(query) + " , ";
            }
            query = String.valueOf(query) + " ? ";
            ++i3;
        }
        this.ejbCreateQuery = query = String.valueOf(query) + " )";
    }

    private void generateEjbFindByPrimaryKeyQuery() {
        this.ejbFindByPrimaryKeyQuery = "SELECT ";
        int i2 = 0;
        while (i2 < this.pkeyFields.length) {
            if (i2 > 0) {
                this.ejbFindByPrimaryKeyQuery = String.valueOf(this.ejbFindByPrimaryKeyQuery) + " , ";
            }
            this.ejbFindByPrimaryKeyQuery = String.valueOf(this.ejbFindByPrimaryKeyQuery) + this.pkeyFieldNames[i2];
            ++i2;
        }
        this.ejbFindByPrimaryKeyQuery = String.valueOf(this.ejbFindByPrimaryKeyQuery) + " FROM " + this.tableName + this.whereClause;
    }

    private void generateEjbLoadQuery() {
        this.ejbLoadQuery = "SELECT ";
        int i2 = 0;
        while (i2 < this.contMgNoPkeyFields.length) {
            if (i2 > 0) {
                this.ejbLoadQuery = String.valueOf(this.ejbLoadQuery) + " , ";
            }
            this.ejbLoadQuery = String.valueOf(this.ejbLoadQuery) + this.contMgNoPkeyFieldNames[i2];
            ++i2;
        }
        if (this.contMgNoPkeyFields.length == 0) {
            this.ejbLoadQuery = String.valueOf(this.ejbLoadQuery) + " * ";
        }
        this.ejbLoadQuery = String.valueOf(this.ejbLoadQuery) + " FROM " + this.tableName + this.whereClause;
    }

    private void generateEjbRemoveQuery() {
        this.ejbRemoveQuery = "DELETE FROM " + this.tableName + this.whereClause;
    }

    private void generateEjbStoreQuery() {
        if (this.contMgNoPkeyFields.length == 0) {
            this.ejbStoreQuery = " ";
            return;
        }
        this.ejbStoreQuery = "UPDATE " + this.tableName + " SET ";
        int i2 = 0;
        while (i2 < this.contMgNoPkeyFields.length) {
            if (i2 > 0) {
                this.ejbStoreQuery = String.valueOf(this.ejbStoreQuery) + " , ";
            }
            this.ejbStoreQuery = String.valueOf(this.ejbStoreQuery) + this.contMgNoPkeyFieldNames[i2] + " = ? ";
            ++i2;
        }
        this.ejbStoreQuery = String.valueOf(this.ejbStoreQuery) + this.whereClause;
    }

    private void generateNonPrimaryKeyFinderQuery() {
        this.nonPrimaryKeyFinderQuery = "SELECT ";
        int i2 = 0;
        while (i2 < this.pkeyFields.length) {
            if (i2 > 0) {
                this.nonPrimaryKeyFinderQuery = String.valueOf(this.nonPrimaryKeyFinderQuery) + " , ";
            }
            this.nonPrimaryKeyFinderQuery = String.valueOf(this.nonPrimaryKeyFinderQuery) + this.pkeyFieldNames[i2];
            ++i2;
        }
        this.nonPrimaryKeyFinderQuery = String.valueOf(this.nonPrimaryKeyFinderQuery) + " FROM " + this.tableName;
    }

    public static String generateSQL(EjbEntityDescriptor entd, ResourceReferenceDescriptor rrd, boolean overWrite, DBInfo dbInfo) throws Exception {
        ResourcePrincipal rp = rrd.getResourcePrincipal();
        DBMetaData metadata = dbInfo.getDBMetaData(rrd.getJndiName(), rp.getName(), rp.getPassword());
        SQLTypeMapper sqlt = new SQLTypeMapper();
        String msg = sqlt.initializeMapping(metadata);
        ClassLoader cl2 = ((EjbBundleArchivist)entd.getEjbBundleDescriptor().getArchivist()).getClassLoader();
        SQLGenerator sqlgen = new SQLGenerator(entd, cl2, sqlt, metadata);
        sqlgen.storeIntoDescriptor(overWrite);
        return msg;
    }

    private void generateWhereClause() {
        String clause = " WHERE ";
        int i2 = 0;
        while (i2 < this.pkeyFields.length) {
            if (i2 > 0) {
                clause = String.valueOf(clause) + " AND ";
            }
            clause = String.valueOf(clause) + this.pkeyFieldNames[i2] + " = ? ";
            ++i2;
        }
        this.whereClause = clause;
    }

    private boolean isPkeyField(String fieldname) {
        int i2 = 0;
        while (i2 < this.pkeyFields.length) {
            if (this.pkeyFields[i2].getName().equals(fieldname)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    private void printQueries() {
        System.err.println("findByPrimaryKey query: " + this.ejbFindByPrimaryKeyQuery);
        System.err.println("ejbLoad query: " + this.ejbLoadQuery);
        System.err.println("ejbStore query: " + this.ejbStoreQuery);
        System.err.println("ejbRemove query: " + this.ejbRemoveQuery);
        System.err.println("ejbCreate query: " + this.ejbCreateQuery);
        System.err.println("Table Create query: " + this.createTableQuery);
        System.err.println("Table Remove query: " + this.deleteTableQuery);
    }

    private void storeIntoDescriptor(boolean overWrite) {
        this.desc.setTableCreateSqlStatement(this.createTableQuery);
        this.desc.setTableRemoveSqlStatement(this.deleteTableQuery);
        Iterator i2 = this.desc.getAllSqlStatementedMethods().iterator();
        while (i2.hasNext()) {
            MethodDescriptor md = (MethodDescriptor)i2.next();
            String methodName = md.getName();
            String prevSql = this.desc.getSqlStatementFor(md);
            boolean noPrevSql = false;
            if (prevSql == null || prevSql.equals("")) {
                noPrevSql = true;
            }
            if (methodName.equals("ejbCreate")) {
                if (!overWrite && !noPrevSql) continue;
                this.desc.setSqlStatementFor(md, this.ejbCreateQuery);
                continue;
            }
            if (methodName.equals("ejbRemove")) {
                if (!overWrite && !noPrevSql) continue;
                this.desc.setSqlStatementFor(md, this.ejbRemoveQuery);
                continue;
            }
            if (methodName.equals("ejbStore")) {
                if (!overWrite && !noPrevSql) continue;
                this.desc.setSqlStatementFor(md, this.ejbStoreQuery);
                continue;
            }
            if (methodName.equals("ejbLoad")) {
                if (!overWrite && !noPrevSql) continue;
                this.desc.setSqlStatementFor(md, this.ejbLoadQuery);
                continue;
            }
            if (methodName.equals("findByPrimaryKey")) {
                if (!overWrite && !noPrevSql) continue;
                this.desc.setSqlStatementFor(md, this.ejbFindByPrimaryKeyQuery);
                continue;
            }
            if (!methodName.startsWith("find") || !overWrite && !noPrevSql) continue;
            this.desc.setSqlStatementFor(md, this.nonPrimaryKeyFinderQuery);
        }
    }
}

