/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.FileContentsDescriptor;
import com.sun.enterprise.deployment.Project;
import com.sun.enterprise.deployment.xml.XMLUtils;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.xml.tree.XmlDocument;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public abstract class Archivist {
    public static String MANIFEST_VERSION_VALUE = "1.0";
    public static final boolean debug = false;
    private static String TMPFILENAME = "scratch";
    private static String EJB_TMP_FILENAME = "ejb_temp";
    private static String WEB_TMP_FILENAME = "web_temp";
    private static String APP_CLIENT_TMP_FILENAME = "app-client-temp";
    private static String LIB_TMP_FILENAME = "lib-temp";
    private String externalDescriptorArchiveUri = null;
    private String archiveUri = "";
    protected Set manifestClasspath;
    private Vector entryNames = null;
    private Hashtable filesToBeAdded = new Hashtable();
    private Set filesToBeRemoved = new HashSet();
    private boolean archiveFileExists = true;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$deployment$Archivist != null ? class$com$sun$enterprise$deployment$Archivist : (class$com$sun$enterprise$deployment$Archivist = Archivist.class$("com.sun.enterprise.deployment.Archivist")));
    static /* synthetic */ Class class$com$sun$enterprise$deployment$Archivist;

    protected Archivist(String archiveUri) {
        this.setHasArchive(true, archiveUri);
    }

    protected Archivist(String archiveUri, boolean archiveExists) {
        this.setHasArchive(archiveExists, archiveUri);
    }

    public void addFiles(Hashtable addFiles) throws IOException {
        this.updateFiles(addFiles);
        Project project = Project.getProject(this);
        if (project != null) {
            project.addFiles(this, addFiles);
        }
    }

    public Hashtable addFiles(Hashtable fileToEntryNameMap, File jarFile) throws IOException {
        File scratchFile = Archivist.createTempFile(Archivist.getDirectory(jarFile));
        FileOutputStream fos = new FileOutputStream(scratchFile);
        ZipOutputStream zos = new ZipOutputStream(fos);
        Hashtable<String, File> actual = new Hashtable<String, File>();
        Vector names = this.getEntryNamesFrom(jarFile);
        JarFile jar = new JarFile(jarFile);
        Archivist.addJarToOutput(zos, jar, new Vector());
        Enumeration e10 = fileToEntryNameMap.keys();
        while (e10.hasMoreElements()) {
            String trialEntryName = (String)e10.nextElement();
            File nextFile = (File)fileToEntryNameMap.get(trialEntryName);
            String entryName = Descriptor.createUniqueNameAmongst(trialEntryName, names);
            actual.put(entryName, nextFile);
            FileInputStream fis = new FileInputStream(nextFile);
            zos.putNextEntry(new JarEntry(entryName));
            Archivist.copy(fis, zos);
            zos.closeEntry();
            fis.close();
        }
        zos.close();
        jar.close();
        jarFile.delete();
        if (!scratchFile.renameTo(jarFile)) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionerrornamingjartofile", "Error renaming JAR [0} to {1}", new Object[]{scratchFile, jarFile}));
        }
        return actual;
    }

    public static void addJarToOutput(ZipOutputStream zos, JarFile jarFileToAdd, Vector entryNamesToSkip) throws IOException {
        Enumeration<JarEntry> e10 = jarFileToAdd.entries();
        while (e10.hasMoreElements()) {
            ZipEntry nextEntry = e10.nextElement();
            if (entryNamesToSkip.contains(nextEntry.getName())) continue;
            InputStream is = jarFileToAdd.getInputStream(nextEntry);
            try {
                Archivist.writeEntry(zos, is, new ZipEntry(nextEntry));
            }
            catch (IOException ex2) {
                ex2.printStackTrace();
            }
        }
        jarFileToAdd.close();
    }

    public void addManfiestClasspath(String uri) {
        this.getManifestClasspaths().add(uri);
    }

    static void checkExists(File f2) throws IOException {
        if (!f2.exists()) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionfiledoesnotexist", "{0} does not exist", new Object[]{f2}));
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static void copy(InputStream is, OutputStream os) throws IOException {
        byte[] buf = new byte[1024];
        int len = 0;
        while (len != -1) {
            try {
                len = is.read(buf, 0, buf.length);
            }
            catch (EOFException eOFException) {
                break;
            }
            if (len == -1) continue;
            os.write(buf, 0, len);
        }
        is.close();
    }

    public Hashtable createEntryNameMap(FileContentsDescriptor fcd) throws IOException {
        Hashtable<String, File> entriesToFileNames = new Hashtable<String, File>();
        Enumeration e10 = fcd.getFiles();
        while (e10.hasMoreElements()) {
            File nextRelativeFile = (File)e10.nextElement();
            File actualFile = fcd.getFullFileFor(nextRelativeFile);
            String archiveName = nextRelativeFile.toString().replace(File.separatorChar, '/');
            entriesToFileNames.put(archiveName, actualFile);
        }
        return entriesToFileNames;
    }

    public Manifest createManifest() {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, MANIFEST_VERSION_VALUE);
        if (!this.getManifestClasspaths().isEmpty()) {
            String classpathString = "";
            Iterator itr = this.getManifestClasspaths().iterator();
            while (itr.hasNext()) {
                String next = (String)itr.next();
                classpathString = String.valueOf(classpathString) + next;
                if (!itr.hasNext()) continue;
                classpathString = String.valueOf(classpathString) + " ";
            }
            manifest.getMainAttributes().put(Attributes.Name.CLASS_PATH, classpathString);
        }
        return manifest;
    }

    static File createTempFile(File directory) {
        File f2 = null;
        try {
            f2 = File.createTempFile(TMPFILENAME, "jar", directory);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        f2.deleteOnExit();
        return f2;
    }

    static void dump(Manifest m2) {
        try {
            m2.write(System.out);
        }
        catch (Throwable t2) {
            t2.printStackTrace();
        }
    }

    public static void extractJarFile(File jarFile, File directory) throws IOException {
        JarFile jar = new JarFile(jarFile);
        Enumeration<JarEntry> e10 = jar.entries();
        while (e10.hasMoreElements()) {
            ZipEntry entry = e10.nextElement();
            String filename = entry.getName().replace('/', File.separatorChar);
            File file = new File(directory.getAbsolutePath(), filename);
            file.deleteOnExit();
            if (entry.isDirectory()) continue;
            InputStream is = jar.getInputStream(new ZipEntry(entry));
            boolean mkdirs = true;
            if (!file.getParentFile().exists()) {
                mkdirs = file.getParentFile().mkdirs();
            }
            if (!mkdirs) {
                throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionunpackingarchivefailed", "Unpacking archive failed: could not make parent file for {0}", new Object[]{file}));
            }
            FileOutputStream fos = new FileOutputStream(file);
            Archivist.copy(is, fos);
            fos.close();
            is.close();
        }
        jar.close();
    }

    static File getApplicationClientTemp(File directory) {
        File f2 = null;
        try {
            f2 = File.createTempFile(APP_CLIENT_TMP_FILENAME, ".jar", directory);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        f2.deleteOnExit();
        return f2;
    }

    protected abstract File getArchiveFile() throws IOException;

    public String getArchiveUri() {
        return this.archiveUri;
    }

    public Vector getClassEntryNames() throws IOException {
        Vector allEntryNames = this.getEntryNames();
        Vector<String> allClassEntryNames = new Vector<String>();
        int entryIndex = 0;
        while (entryIndex < allEntryNames.size()) {
            String nextEntryName = (String)allEntryNames.elementAt(entryIndex);
            if (nextEntryName.endsWith(".class")) {
                allClassEntryNames.add(nextEntryName);
            }
            ++entryIndex;
        }
        return allClassEntryNames;
    }

    public Vector getClassNames() throws IOException {
        Vector classEntryNames = this.getClassEntryNames();
        Vector<String> allClassNames = new Vector<String>();
        int entryIndex = 0;
        while (entryIndex < classEntryNames.size()) {
            String nextEntryName = (String)classEntryNames.elementAt(entryIndex);
            String className = FileUtil.classNameFromEntryName(nextEntryName);
            allClassNames.add(className);
            ++entryIndex;
        }
        return allClassNames;
    }

    public abstract Descriptor getDescriptor();

    static File getDirectory(File f2) {
        String filename = f2.getAbsolutePath();
        return new File(new File(filename).getParent());
    }

    static File getEjbTemp(File directory) {
        File f2 = null;
        try {
            f2 = File.createTempFile(EJB_TMP_FILENAME, ".jar", directory);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return f2;
    }

    public Vector getEntryNames() throws IOException {
        this.refreshEntryNames();
        Vector allEntryNames = (Vector)this.entryNames.clone();
        Enumeration e10 = this.filesToBeAdded.keys();
        while (e10.hasMoreElements()) {
            allEntryNames.add((String)e10.nextElement());
        }
        return allEntryNames;
    }

    protected Vector getEntryNamesFrom(File archive) throws IOException {
        ZipFile zipFile = new ZipFile(archive);
        Vector<String> names = new Vector<String>();
        Enumeration<? extends ZipEntry> e10 = zipFile.entries();
        while (e10.hasMoreElements()) {
            ZipEntry ze = e10.nextElement();
            names.addElement(ze.getName());
        }
        zipFile.close();
        return names;
    }

    public String getExternalDescriptorArchiveUri() {
        return this.externalDescriptorArchiveUri;
    }

    protected Hashtable getFilesToBeAdded() throws IOException {
        return this.filesToBeAdded;
    }

    protected Set getFilesToBeRemoved() throws IOException {
        return this.filesToBeRemoved;
    }

    static File getLibraryTemp(File directory) {
        File f2 = null;
        try {
            f2 = File.createTempFile(LIB_TMP_FILENAME, ".jar", directory);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        f2.deleteOnExit();
        return f2;
    }

    public Set getManifestClasspaths() {
        if (this.manifestClasspath == null) {
            this.manifestClasspath = new HashSet();
        }
        return this.manifestClasspath;
    }

    protected String getUniqueEntryNameFor(File archive, String trialName) throws IOException {
        return Descriptor.createUniqueNameAmongst(trialName, this.getEntryNamesFrom(archive));
    }

    public String getUniqueEntryNameFor(String trialName) throws IOException {
        return Descriptor.createUniqueNameAmongst(trialName, this.getEntryNames());
    }

    static File getWebTemp(File directory) {
        File f2 = null;
        try {
            f2 = File.createTempFile(WEB_TMP_FILENAME, ".war", directory);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        f2.deleteOnExit();
        return f2;
    }

    protected boolean hasArchive() {
        return this.archiveFileExists;
    }

    public boolean hasExternalDescriptor() {
        return this.externalDescriptorArchiveUri != null;
    }

    public boolean isDeletable(String entryName) {
        return true;
    }

    private void refreshEntryNames() throws IOException {
        if (this.hasArchive()) {
            if (this.entryNames == null) {
                this.entryNames = this.getEntryNamesFrom(this.getArchiveFile());
                this.entryNames.removeAll(this.filesToBeRemoved);
            }
        } else {
            this.entryNames = new Vector();
        }
    }

    public void removeEntries(Set entryNames, File jarFile) throws IOException {
        Vector toRemove = new Vector(entryNames);
        File scratchFile = Archivist.createTempFile(Archivist.getDirectory(jarFile));
        FileOutputStream fos = new FileOutputStream(scratchFile);
        ZipOutputStream zos = new ZipOutputStream(fos);
        JarFile jar = new JarFile(jarFile);
        Archivist.addJarToOutput(zos, jar, toRemove);
        zos.close();
        jar.close();
        if (!scratchFile.renameTo(jarFile)) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionerrornamingjartofile", "Error renaming JAR [0} to {1}", new Object[]{scratchFile, jarFile}));
        }
    }

    public void removeEntries(Vector entries) throws IOException {
        this.refreshEntryNames();
        Vector<String> entriesToRemove = new Vector<String>();
        int removeIndex = 0;
        while (removeIndex < entries.size()) {
            String toRemove = (String)entries.elementAt(removeIndex);
            toRemove = toRemove.replace(File.separatorChar, '/');
            entriesToRemove.add(toRemove);
            boolean removed = this.entryNames.removeElement(toRemove);
            if (removed) {
                this.filesToBeRemoved.add(toRemove);
            } else {
                Object v2 = this.filesToBeAdded.remove(toRemove);
            }
            ++removeIndex;
        }
        Project project = Project.getProject(this);
        if (project != null) {
            project.removeEntries(this, entriesToRemove);
        }
    }

    public void removeEntry(String entryToRemove) throws IOException {
        Vector<String> entriesToRemove = new Vector<String>();
        entriesToRemove.add(entryToRemove);
        this.removeEntries(entriesToRemove);
    }

    public void removeManifestClasspath(String uri) {
        this.getManifestClasspaths().remove(uri);
    }

    public void setArchiveUri(String archiveUri) {
        this.archiveUri = archiveUri;
        this.entryNames = null;
    }

    public void setExternalDescriptorArchiveUri(String externalDescriptorArchiveUri) {
        this.externalDescriptorArchiveUri = externalDescriptorArchiveUri;
    }

    protected void setHasArchive(boolean archiveExists, String archiveUri) {
        this.archiveFileExists = archiveExists;
        this.setArchiveUri(archiveUri);
    }

    public void setManifestClasspaths(Manifest manifest) {
        Attributes mainAttributes = manifest.getMainAttributes();
        Iterator<Object> itr = mainAttributes.keySet().iterator();
        while (itr.hasNext()) {
            Attributes.Name next = (Attributes.Name)itr.next();
            if (!next.equals(Attributes.Name.CLASS_PATH)) continue;
            String classpathString = (String)mainAttributes.get(next);
            StringTokenizer st = new StringTokenizer(classpathString, " ");
            while (st.hasMoreTokens()) {
                String mc = st.nextToken();
                this.getManifestClasspaths().add(mc);
            }
        }
    }

    public void updateFiles(Hashtable newFiles) throws IOException {
        this.refreshEntryNames();
        Enumeration e10 = newFiles.keys();
        while (e10.hasMoreElements()) {
            String nextToAdd = (String)e10.nextElement();
            if (!this.entryNames.contains(nextToAdd)) continue;
            this.entryNames.remove(nextToAdd);
            this.filesToBeRemoved.add(nextToAdd);
        }
        this.filesToBeAdded.putAll(newFiles);
    }

    protected static void writeDocumentToJar(XmlDocument document, String entryName, ZipOutputStream zos) throws IOException {
        StringWriter sw = new StringWriter();
        XMLUtils.writeDocument(document, sw);
        byte[] deploymentInfo = sw.toString().getBytes();
        ZipEntry ze = new ZipEntry(entryName);
        ze.setTime(System.currentTimeMillis());
        zos.putNextEntry(ze);
        zos.write(deploymentInfo, 0, deploymentInfo.length);
        zos.closeEntry();
    }

    protected void writeEntriesToOutput(ZipOutputStream zos, Vector entryNamesToSkip) throws IOException {
        this.writeEntriesToOutput(zos, entryNamesToSkip, new Vector());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void writeEntriesToOutput(ZipOutputStream zos, Vector entryNamesToSkip, Vector toMakeClassLoadable) throws IOException {
        if (this.hasArchive()) {
            this.refreshEntryNames();
            JarFile archive = new JarFile(this.getArchiveFile());
            int entryIndex = 0;
            while (true) {
                if (entryIndex >= this.entryNames.size()) {
                    archive.close();
                    break;
                }
                String nextEntryName = (String)this.entryNames.elementAt(entryIndex);
                if (!entryNamesToSkip.contains(nextEntryName)) {
                    Archivist.writeEntry(zos, archive, nextEntryName);
                }
                ++entryIndex;
            }
        }
        Set toBeAddedSet = this.filesToBeAdded.entrySet();
        Iterator iter = toBeAddedSet.iterator();
        while (true) {
            if (!iter.hasNext()) break;
            Map.Entry entry = iter.next();
            File file = (File)entry.getValue();
            String entryName = (String)entry.getKey();
            Archivist.writeEntry(zos, file, entryName);
        }
        Vector<String> classLoadableToSkip = new Vector<String>();
        classLoadableToSkip.addElement("META-INF/MANIFEST.MF");
        int entryIndex = 0;
        while (true) {
            block12: {
                Object var11_12;
                if (entryIndex >= toMakeClassLoadable.size()) {
                    this.filesToBeAdded = new Hashtable();
                    this.filesToBeRemoved = new HashSet();
                    this.entryNames = null;
                    return;
                }
                File file = (File)toMakeClassLoadable.elementAt(entryIndex);
                JarFile jarFile = null;
                try {
                    try {
                        jarFile = new JarFile(file);
                        Archivist.addJarToOutput(zos, jarFile, classLoadableToSkip);
                    }
                    catch (Exception e10) {
                        e10.printStackTrace();
                    }
                    var11_12 = null;
                    if (jarFile == null) break block12;
                }
                catch (Throwable throwable) {
                    var11_12 = null;
                    if (jarFile != null) {
                        jarFile.close();
                    }
                    throw throwable;
                }
                jarFile.close();
            }
            ++entryIndex;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void writeEntry(ZipOutputStream zos, File file, String entryName) throws IOException {
        FileInputStream inputStream = null;
        try {
            try {
                inputStream = new FileInputStream(file);
                ZipEntry zipEntry = new ZipEntry(entryName);
                Archivist.writeEntry(zos, inputStream, zipEntry);
            }
            catch (ZipException e10) {
            }
            Object var5_6 = null;
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (inputStream == null) throw throwable;
            ((InputStream)inputStream).close();
            throw throwable;
        }
        ((InputStream)inputStream).close();
    }

    private static void writeEntry(ZipOutputStream zos, InputStream is, ZipEntry zipEntry) throws IOException {
        try {
            zos.putNextEntry(zipEntry);
            Archivist.copy(is, zos);
            zos.closeEntry();
        }
        catch (ZipException zipException) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void writeEntry(ZipOutputStream zos, JarFile archive, String entryName) throws IOException {
        InputStream inputStream = null;
        try {
            try {
                ZipEntry existingZipEntry = archive.getEntry(entryName);
                inputStream = archive.getInputStream(existingZipEntry);
                ZipEntry newZipEntry = new ZipEntry(existingZipEntry);
                Archivist.writeEntry(zos, inputStream, newZipEntry);
            }
            catch (ZipException e10) {
            }
            Object var5_7 = null;
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            if (inputStream == null) throw throwable;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
    }

    public static void writeManifest(Manifest manifest, ZipOutputStream zos) throws IOException {
        ZipEntry manifestEntry = new ZipEntry("META-INF/MANIFEST.MF");
        manifestEntry.setTime(System.currentTimeMillis());
        zos.putNextEntry(manifestEntry);
        manifest.write(zos);
        zos.closeEntry();
    }
}

