/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming;

import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationException;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.NamingManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.ORBManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.util.Hashtable;
import java.util.Iterator;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.omg.CORBA.Object;

public class NamingManagerImpl
implements NamingManager {
    public static final String SERIALOBJECT_FACTORY = "com.sun.enterprise.naming.factory.SerialObjectFactory";
    public static final String IIOPOBJECT_FACTORY = "com.sun.enterprise.naming.factory.IIOPObjectFactory";
    public static final String MAIL_COMPONENT_FACTORY = "com.sun.enterprise.naming.factory.MailSessionObjectFactory";
    public static final String JAVA_COMP_STRING = "java:comp/env/";
    private static final String CONTEXT_SEPARATOR = "/";
    private static final String ID_SEPARATOR = "_";
    private static final String ROOT_ENV_CONTEXT_NAME = "environments";
    private static final String EJB_ENV_CONTEXT_NAME = "environments/ejbs";
    private static final String WEB_ENV_CONTEXT_NAME = "environments/web";
    private static final String APPCLIENT_ENV_CONTEXT_NAME = "environments/appclients";
    private static final boolean debug = false;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$naming$NamingManagerImpl != null ? class$com$sun$enterprise$naming$NamingManagerImpl : (class$com$sun$enterprise$naming$NamingManagerImpl = NamingManagerImpl.class$("com.sun.enterprise.naming.NamingManagerImpl")));
    private InitialContext initialContext;
    private InitialContext cosContext;
    private Context ejbEnvContext;
    private Context webEnvContext;
    private Context appClientEnvContext;
    private InvocationManager im = null;
    private Switch theSwitch = null;
    static /* synthetic */ Class class$com$sun$enterprise$naming$NamingManagerImpl;

    public NamingManagerImpl() throws NamingException {
        this(new InitialContext());
    }

    public NamingManagerImpl(InitialContext ic) throws NamingException {
        this.initialContext = ic;
        this.theSwitch = Switch.getSwitch();
        this.im = this.theSwitch.getInvocationManager();
        Hashtable<String, java.lang.Object> myEnv = new Hashtable<String, java.lang.Object>();
        myEnv.put("java.naming.factory.initial", "com.sun.jndi.cosnaming.CNCtxFactory");
        myEnv.put("java.naming.corba.orb", ORBManager.getORB());
        this.cosContext = new InitialContext(myEnv);
        try {
            java.lang.Object rootContext = this.initialContext.lookup(ROOT_ENV_CONTEXT_NAME);
            this.appClientEnvContext = (Context)this.initialContext.lookup(APPCLIENT_ENV_CONTEXT_NAME);
            this.webEnvContext = (Context)this.initialContext.lookup(WEB_ENV_CONTEXT_NAME);
            this.ejbEnvContext = (Context)this.initialContext.lookup(EJB_ENV_CONTEXT_NAME);
        }
        catch (NameNotFoundException nameNotFoundException) {
            this.appClientEnvContext = this.initialContext.createSubcontext(APPCLIENT_ENV_CONTEXT_NAME);
            this.webEnvContext = this.initialContext.createSubcontext(WEB_ENV_CONTEXT_NAME);
            this.ejbEnvContext = this.initialContext.createSubcontext(EJB_ENV_CONTEXT_NAME);
        }
    }

    public void bindObjects(JndiNameEnvironment env) throws NamingException {
        Iterator itr = env.getEnvironmentProperties().iterator();
        while (itr.hasNext()) {
            EnvironmentProperty next = (EnvironmentProperty)itr.next();
            String logicalJndiName = this.descriptorToLogicalJndiName(next);
            String physicalJndiName = this.descriptorToPhysicalJndiName(env, next);
            java.lang.Object valueObject = next.getValueObject();
            System.out.println(localStrings.getLocalString("naming.bind", "Binding name:{0}", new java.lang.Object[]{logicalJndiName}));
            this.initialContext.rebind(physicalJndiName, valueObject);
        }
        Iterator itr2 = env.getEjbReferenceDescriptors().iterator();
        while (itr2.hasNext()) {
            EjbReferenceDescriptor next = (EjbReferenceDescriptor)itr2.next();
            String logicalJndiName = this.descriptorToLogicalJndiName(next);
            String physicalJndiName = this.descriptorToPhysicalJndiName(env, next);
            System.out.println(localStrings.getLocalString("naming.bind", "Binding name:{0}", new java.lang.Object[]{logicalJndiName}));
            String otherBeanJndi = next.getValue();
            if (otherBeanJndi == null || otherBeanJndi.equals("")) {
                throw new InvalidNameException("Real JNDI name cannot be empty for " + next.getName());
            }
            Reference obj = new Reference("reference", new StringRefAddr("url", otherBeanJndi), IIOPOBJECT_FACTORY, null);
            this.initialContext.rebind(physicalJndiName, (java.lang.Object)obj);
        }
        Iterator itr3 = env.getResourceReferenceDescriptors().iterator();
        while (itr3.hasNext()) {
            ResourceReferenceDescriptor next = (ResourceReferenceDescriptor)itr3.next();
            String logicalResRef = next.getName();
            String logicalJndiName = this.descriptorToLogicalJndiName(next);
            String physicalJndiName = this.descriptorToPhysicalJndiName(env, next);
            System.out.println(localStrings.getLocalString("naming.bind", "Binding name:{0}", new java.lang.Object[]{logicalJndiName}));
            String resJndi = next.getValue();
            if (resJndi == null || resJndi.equals("")) {
                throw new InvalidNameException("Real JNDI name cannot be empty for " + logicalResRef);
            }
            java.lang.Object obj = null;
            if (next.isMailResource()) {
                obj = next.getMailConfiguration();
                String mailSessionInfoName = String.valueOf(this.getEnvMailObjContextName(env)) + CONTEXT_SEPARATOR + logicalResRef;
                this.initialContext.rebind(mailSessionInfoName, obj);
                obj = new Reference(obj.getClass().toString(), new StringRefAddr("url", mailSessionInfoName), MAIL_COMPONENT_FACTORY, null);
            } else {
                if (next.isURLResource()) {
                    String url = next.getJndiName();
                    try {
                        obj = new URL(url);
                    }
                    catch (MalformedURLException malformedURLException) {
                        throw new InvalidNameException(localStrings.getLocalString("naming.malformedURL", "Malformed URL:'{0}'", new java.lang.Object[]{url}));
                    }
                }
                try {
                    obj = this.initialContext.lookup(resJndi);
                }
                catch (NamingException namingException) {
                    throw new InvalidNameException("JNDI name '" + resJndi + "' for resource reference '" + logicalResRef + "' is not valid");
                }
                obj = new Reference(obj.getClass().toString(), new StringRefAddr("url", resJndi), SERIALOBJECT_FACTORY, null);
            }
            this.initialContext.rebind(physicalJndiName, obj);
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private void createSubContexts(Name name, Context rootCtx) throws NamingException {
        int numSubContexts = name.size() - 1;
        Context currentCtx = rootCtx;
        int subCtxIndex = 0;
        while (subCtxIndex < numSubContexts) {
            block5: {
                String subCtxName = name.get(subCtxIndex);
                try {
                    java.lang.Object obj = currentCtx.lookup(subCtxName);
                    if (obj == null) {
                        Context newCtx;
                        currentCtx = newCtx = currentCtx.createSubcontext(subCtxName);
                        break block5;
                    }
                    if (obj instanceof Context) {
                        currentCtx = (Context)obj;
                        break block5;
                    }
                    throw new NameAlreadyBoundException(subCtxName);
                }
                catch (NameNotFoundException nameNotFoundException) {
                    Context newCtx;
                    currentCtx = newCtx = currentCtx.createSubcontext(subCtxName);
                }
            }
            ++subCtxIndex;
        }
    }

    private String descriptorToLogicalJndiName(Descriptor descriptor) {
        return JAVA_COMP_STRING + descriptor.getName();
    }

    private String descriptorToPhysicalJndiName(JndiNameEnvironment env, Descriptor descriptor) {
        return String.valueOf(this.getComponentIdInternal(env)) + CONTEXT_SEPARATOR + "env" + CONTEXT_SEPARATOR + descriptor.getName();
    }

    public String getComponentId() throws NamingException {
        String id = null;
        try {
            ComponentInvocation ci2 = this.im.getCurrentInvocation();
            java.lang.Object containerContext = ci2.getContainerContext();
            if (containerContext == null) {
                throw new NamingException("No container context");
            }
            JndiNameEnvironment desc = (JndiNameEnvironment)this.theSwitch.getDescriptorFor(containerContext);
            id = this.getComponentIdInternal(desc);
        }
        catch (InvocationException e10) {
            throw new NamingException("invocation exception " + e10);
        }
        return id;
    }

    private String getComponentIdInternal(JndiNameEnvironment env) {
        String id = this.getMangledIdName(env);
        String physicalJndiName = "none";
        if (env instanceof EjbDescriptor) {
            physicalJndiName = "environments/ejbs/" + id;
        } else if (env instanceof WebBundleDescriptor) {
            physicalJndiName = "environments/web/" + id;
        } else if (env instanceof ApplicationClientDescriptor) {
            physicalJndiName = "environments/appclients/" + id;
        }
        return physicalJndiName;
    }

    private Context getEnvContext(JndiNameEnvironment env) throws NamingException {
        Context context;
        if (env instanceof EjbDescriptor) {
            context = this.ejbEnvContext;
        } else if (env instanceof WebBundleDescriptor) {
            context = this.webEnvContext;
        } else if (env instanceof ApplicationClientDescriptor) {
            context = this.appClientEnvContext;
        } else {
            throw new NamingException("No env context available for " + env);
        }
        return context;
    }

    private String getEnvMailObjContextName(JndiNameEnvironment env) {
        return String.valueOf(this.getComponentIdInternal(env)) + CONTEXT_SEPARATOR + "mailsessions";
    }

    public Context getInitialContext() {
        return this.initialContext;
    }

    private String getMangledIdName(JndiNameEnvironment env) {
        String id = null;
        if (env instanceof EjbDescriptor) {
            EjbDescriptor ejbEnv = (EjbDescriptor)env;
            String flattedJndiName = ejbEnv.getJndiName().replace('/', '.');
            id = String.valueOf(ejbEnv.getApplication().getName()) + ID_SEPARATOR + ejbEnv.getEjbClassName() + ID_SEPARATOR + flattedJndiName;
        } else if (env instanceof WebBundleDescriptor) {
            WebBundleDescriptor webEnv = (WebBundleDescriptor)env;
            id = String.valueOf(webEnv.getApplication().getName()) + ID_SEPARATOR + webEnv.getContextRoot();
        } else if (env instanceof ApplicationClientDescriptor) {
            ApplicationClientDescriptor appEnv = (ApplicationClientDescriptor)env;
            id = "client_" + appEnv.getName() + ID_SEPARATOR + appEnv.getMainClassName();
        }
        return id;
    }

    private boolean isCOSNamingObj(java.lang.Object obj) {
        return obj instanceof Remote || obj instanceof Object;
    }

    public void publishObject(String name, java.lang.Object obj, boolean rebind) throws NamingException {
        CompositeName nameobj = new CompositeName(name);
        this.publishObject(nameobj, obj, rebind);
    }

    public void publishObject(Name name, java.lang.Object obj, boolean rebind) throws NamingException {
        java.lang.Object serialObj = obj;
        if (this.isCOSNamingObj(obj)) {
            this.createSubContexts(name, this.cosContext);
            if (rebind) {
                this.cosContext.rebind(name, obj);
            } else {
                this.cosContext.bind(name, obj);
            }
            serialObj = new Reference("reference", new StringRefAddr("url", name.toString()), IIOPOBJECT_FACTORY, null);
        }
        if (rebind) {
            this.initialContext.rebind(name, serialObj);
        } else {
            this.initialContext.bind(name, serialObj);
        }
    }

    public void unbindObjects(JndiNameEnvironment env) throws NamingException {
        Iterator itr = env.getEnvironmentProperties().iterator();
        while (itr.hasNext()) {
            EnvironmentProperty next = (EnvironmentProperty)itr.next();
            String logicalJndiName = this.descriptorToLogicalJndiName(next);
            String physicalJndiName = this.descriptorToPhysicalJndiName(env, next);
            System.out.println(localStrings.getLocalString("naming.unbind", "Unbinding:{0}", new java.lang.Object[]{logicalJndiName}));
            this.initialContext.unbind(physicalJndiName);
        }
        Iterator itr2 = env.getEjbReferenceDescriptors().iterator();
        while (itr2.hasNext()) {
            EjbReferenceDescriptor next = (EjbReferenceDescriptor)itr2.next();
            String logicalJndiName = this.descriptorToLogicalJndiName(next);
            String physicalJndiName = this.descriptorToPhysicalJndiName(env, next);
            System.out.println(localStrings.getLocalString("naming.unbind", "Unbinding:{0}", new java.lang.Object[]{logicalJndiName}));
            this.initialContext.unbind(physicalJndiName);
        }
        Iterator itr3 = env.getResourceReferenceDescriptors().iterator();
        while (itr3.hasNext()) {
            ResourceReferenceDescriptor next = (ResourceReferenceDescriptor)itr3.next();
            String logicalJndiName = this.descriptorToLogicalJndiName(next);
            String physicalJndiName = this.descriptorToPhysicalJndiName(env, next);
            System.out.println(localStrings.getLocalString("naming.unbind", "Unbinding:{0}", new java.lang.Object[]{logicalJndiName}));
            this.initialContext.unbind(physicalJndiName);
            if (!next.isMailResource()) continue;
            String mailSessionInfoName = String.valueOf(this.getEnvMailObjContextName(env)) + CONTEXT_SEPARATOR + next.getName();
            this.initialContext.unbind(mailSessionInfoName);
        }
        Context envContext = this.getEnvContext(env);
        envContext.destroySubcontext(this.getMangledIdName(env));
    }

    public void unpublishObject(String name) throws NamingException {
        java.lang.Object obj = this.initialContext.lookup(name);
        if (this.isCOSNamingObj(obj)) {
            this.cosContext.unbind(name);
        }
        this.initialContext.unbind(name);
    }

    public void unpublishObject(Name name) throws NamingException {
        this.unpublishObject(name.toString());
    }
}

