/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming;

import com.sun.enterprise.naming.SerialContextProvider;
import com.sun.enterprise.naming.SerialNameParser;
import com.sun.enterprise.util.ORBManager;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.CommunicationException;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.spi.NamingManager;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.ORB;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;

public class SerialContext
implements Context {
    private static Hashtable providerCache = new Hashtable();
    private static NameParser myParser = new SerialNameParser();
    private Hashtable myEnv;
    private SerialContextProvider provider;
    private String componentId;
    static /* synthetic */ Class class$com$sun$enterprise$naming$SerialContextProvider;

    public SerialContext(String compId, Hashtable env) throws NamingException {
        this(env);
        this.componentId = compId;
    }

    public SerialContext(Hashtable environment) throws NamingException {
        this.myEnv = environment != null ? (Hashtable)environment.clone() : null;
        this.provider = SerialContext.getProvider(this.myEnv);
        this.componentId = "";
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        if (this.myEnv == null) {
            this.myEnv = new Hashtable(5, 0.75f);
        }
        return this.myEnv.put(propName, propVal);
    }

    public void bind(String name, Object obj) throws NamingException {
        name = this.getRelativeName(name);
        try {
            this.provider.bind(name, obj);
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException();
        }
    }

    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void close() throws NamingException {
        this.myEnv = null;
    }

    public String composeName(String name, String prefix) throws NamingException {
        Name result = this.composeName(new CompositeName(name), new CompositeName(prefix));
        return result.toString();
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    public Context createSubcontext(String name) throws NamingException {
        Context c10 = null;
        name = this.getRelativeName(name);
        try {
            c10 = this.provider.createSubcontext(name);
            if (c10 instanceof Context) {
                c10 = new SerialContext(name, this.myEnv);
            }
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException();
        }
        return c10;
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    public void destroySubcontext(String name) throws NamingException {
        name = this.getRelativeName(name);
        try {
            this.provider.destroySubcontext(name);
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException();
        }
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.myEnv == null) {
            this.myEnv = new Hashtable(3, 0.75f);
        }
        return this.myEnv;
    }

    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException("getNameInNamespace() not implemented");
    }

    public NameParser getNameParser(String name) throws NamingException {
        return myParser;
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    private static SerialContextProvider getProvider(Hashtable environment) throws NamingException {
        SerialContextProvider theProvider = null;
        ORB orb = (ORB)environment.get("java.naming.corba.orb");
        if (orb == null) {
            orb = ORBManager.getORB();
        }
        if ((theProvider = (SerialContextProvider)providerCache.get(orb)) == null) {
            try {
                NamingContext nctx = NamingContextHelper.narrow(orb.resolve_initial_references("NameService"));
                NameComponent[] path = new NameComponent[]{new NameComponent("SerialContextProvider", "")};
                theProvider = (SerialContextProvider)PortableRemoteObject.narrow(nctx.resolve(path), class$com$sun$enterprise$naming$SerialContextProvider != null ? class$com$sun$enterprise$naming$SerialContextProvider : (class$com$sun$enterprise$naming$SerialContextProvider = SerialContext.class$("com.sun.enterprise.naming.SerialContextProvider")));
            }
            catch (Exception exception) {
                throw new CommunicationException("Can't find SerialContextProvider");
            }
            providerCache.put(orb, theProvider);
        }
        return theProvider;
    }

    private String getRelativeName(String name) {
        if (!this.componentId.equals("")) {
            name = String.valueOf(this.componentId) + "/" + name;
        }
        return name;
    }

    public NamingEnumeration list(String name) throws NamingException {
        if (name.equals("")) {
            try {
                Hashtable bindings = this.provider.list(this.componentId);
                return new RepNames(bindings);
            }
            catch (RemoteException remoteException) {
                throw new CommunicationException();
            }
        }
        Object target = this.lookup(name = this.getRelativeName(name));
        if (target instanceof Context) {
            return ((Context)target).list("");
        }
        throw new NotContextException(String.valueOf(name) + " cannot be listed");
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        if (name.equals("")) {
            try {
                Hashtable bindings = this.provider.list(this.componentId);
                return new RepBindings(bindings);
            }
            catch (RemoteException remoteException) {
                throw new CommunicationException();
            }
        }
        Object target = this.lookup(name = this.getRelativeName(name));
        if (target instanceof Context) {
            return ((Context)target).listBindings("");
        }
        throw new NotContextException(String.valueOf(name) + " cannot be listed");
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public Object lookup(String name) throws NamingException {
        if (name.equals("")) {
            return new SerialContext(this.componentId, this.myEnv);
        }
        name = this.getRelativeName(name);
        try {
            Object obj = this.provider.lookup(name);
            if (obj instanceof Context) {
                return new SerialContext(name, this.myEnv);
            }
            Object retObj = NamingManager.getObjectInstance(obj, null, null, this.myEnv);
            return retObj;
        }
        catch (NameNotFoundException nnfe) {
            throw nnfe;
        }
        catch (Exception exception) {
            throw new CommunicationException();
        }
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public Object lookupLink(String name) throws NamingException {
        name = this.getRelativeName(name);
        return this.lookup(name);
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    public void rebind(String name, Object obj) throws NamingException {
        name = this.getRelativeName(name);
        try {
            this.provider.rebind(name, obj);
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException();
        }
    }

    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        if (this.myEnv == null) {
            return null;
        }
        return this.myEnv.remove(propName);
    }

    public void rename(String oldname, String newname) throws NamingException {
        oldname = this.getRelativeName(oldname);
        newname = this.getRelativeName(newname);
        try {
            this.provider.rename(oldname, newname);
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException();
        }
    }

    public void rename(Name oldname, Name newname) throws NamingException {
        this.rename(oldname.toString(), newname.toString());
    }

    public void unbind(String name) throws NamingException {
        name = this.getRelativeName(name);
        try {
            this.provider.unbind(name);
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException();
        }
    }

    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    class RepNames
    implements NamingEnumeration {
        Hashtable bindings;
        Enumeration names;

        RepNames(Hashtable bindings) {
            this.bindings = bindings;
            this.names = bindings.keys();
        }

        public void close() throws NamingException {
            throw new OperationNotSupportedException("close() not implemented");
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public boolean hasMoreElements() {
            return this.names.hasMoreElements();
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public Object nextElement() {
            if (this.names.hasMoreElements()) {
                String name = (String)this.names.nextElement();
                String className = this.bindings.get(name).getClass().getName();
                return new NameClassPair(name, className);
            }
            return null;
        }
    }

    class RepBindings
    implements NamingEnumeration {
        Enumeration names;
        Hashtable bindings;

        RepBindings(Hashtable bindings) {
            this.bindings = bindings;
            this.names = bindings.keys();
        }

        public void close() throws NamingException {
            throw new OperationNotSupportedException("close() not implemented");
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public boolean hasMoreElements() {
            return this.names.hasMoreElements();
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                String name = (String)this.names.nextElement();
                return new Binding(name, this.bindings.get(name));
            }
            return null;
        }
    }
}

