/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.acl;

import com.sun.enterprise.security.acl.AccessControlEntry;
import com.sun.enterprise.security.acl.AccessControlList;
import com.sun.enterprise.security.acl.Role;
import java.util.Enumeration;
import java.util.Vector;

public class AccessControlListImpl
implements AccessControlList {
    private static boolean defaultPolicy = false;
    private Vector positiveEntries = new Vector(10);
    private Vector negativeEntries = new Vector(10);

    public void addEntry(AccessControlEntry anEntry) {
        if (anEntry.isNegative()) {
            this.negativeEntries.addElement(anEntry);
        } else {
            this.positiveEntries.addElement(anEntry);
        }
    }

    public boolean checkAccess(Role role) {
        Enumeration positive = this.getEntries(role, this.positiveEntries);
        Enumeration negative = this.getEntries(role, this.negativeEntries);
        if (negative.hasMoreElements()) {
            return false;
        }
        if (positive.hasMoreElements()) {
            return true;
        }
        return AccessControlListImpl.getDefaultPolicy();
    }

    public static boolean getDefaultPolicy() {
        return defaultPolicy;
    }

    public Enumeration getEntries() {
        Vector<AccessControlEntry> theseEntries = new Vector<AccessControlEntry>(10);
        Enumeration e10 = this.positiveEntries.elements();
        while (e10.hasMoreElements()) {
            AccessControlEntry ace = (AccessControlEntry)e10.nextElement();
            theseEntries.addElement(ace);
        }
        Enumeration e11 = this.negativeEntries.elements();
        while (e11.hasMoreElements()) {
            AccessControlEntry ace = (AccessControlEntry)e11.nextElement();
            theseEntries.addElement(ace);
        }
        return theseEntries.elements();
    }

    private Enumeration getEntries(Role role, Vector allEntries) {
        Vector<AccessControlEntry> theseEntries = new Vector<AccessControlEntry>(10);
        Enumeration e10 = allEntries.elements();
        while (e10.hasMoreElements()) {
            AccessControlEntry ace = (AccessControlEntry)e10.nextElement();
            if (!ace.getRole().equals(role)) continue;
            theseEntries.addElement(ace);
        }
        return theseEntries.elements();
    }

    public void removeEntry(AccessControlEntry anEntry) {
        if (anEntry.isNegative()) {
            this.negativeEntries.removeElement(anEntry);
        } else {
            this.positiveEntries.removeElement(anEntry);
        }
    }

    public static synchronized void setDefaultPolicy(boolean allowAccess) {
        defaultPolicy = allowAccess;
    }

    public String toString() {
        String s2 = "ACL{ ";
        Enumeration e10 = this.getEntries();
        while (e10.hasMoreElements()) {
            s2 = String.valueOf(s2) + e10.nextElement().toString() + " , ";
        }
        s2 = String.valueOf(s2) + "}";
        return s2;
    }
}

