/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.main;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.tools.deployment.backend.JarInstaller;
import com.sun.enterprise.tools.deployment.main.DeployTool;
import com.sun.enterprise.tools.deployment.main.Log;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Utility;
import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;

public class Main {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$main$Main != null ? class$com$sun$enterprise$tools$deployment$main$Main : (class$com$sun$enterprise$tools$deployment$main$Main = Main.class$("com.sun.enterprise.tools.deployment.main.Main")));
    private static String VERSION = localStrings.getLocalString("enterprise.tools.deployment.main.version", "1.2.1");
    private static String NAME = localStrings.getLocalString("enterprise.tools.deployment.main.name", "Deployment tool version {0}.", new Object[]{VERSION});
    private static String DEFAULT_STARTUP_MESSAGE = localStrings.getLocalString("enterprise.tools.deployment.main.defaultstartupmessage", "{0} Type deploytool -help for command line options. Starting...", new Object[]{NAME});
    public static String DEPLOY_APPLICATION = "-deploy";
    private static String EJB_WIZARD = "-ejbWizard";
    private static String PACKAGE_EJBS = "-packageEjbs";
    private static String LIST_APPLICATIONS = "-listApps";
    private static String NO_OVER_WRITE = "-noOverWrite";
    public static String UNINSTALL = "-uninstall";
    public static String GENERATE_SQL = "-generateSQL";
    public static String DONT_OVER_WRITE_SQL = "-noOverWrite";
    public static String UI = "-ui";
    public static String HELP = "-help";
    private static String LOG_NAME = localStrings.getLocalString("enterprise.tools.deployment.main.logname", "Deploytool");
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$main$Main;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static void help() {
        System.out.println(localStrings.getLocalString("enterprise.tools.deployment.main.deploymenttoolversion", "The deployment tool version is {0}", new Object[]{VERSION}));
        System.out.println(localStrings.getLocalString("enterprise.tools.deployment.main.options", "Options:"));
        System.out.println(localStrings.getLocalString("enterprise.tools.deployment.main.runstoolwithUI", "  {0} \t\t\tRuns the tool with a UI (default mode)", new Object[]{UI}));
        System.out.println(localStrings.getLocalString("enterprise.tools.deployment.main.displayhelpmessage", "  {0} \t\t\tDisplay this help message", new Object[]{HELP}));
        System.out.println(localStrings.getLocalString("enterprise.tools.deployment.main.lastparameteroptional", "  {0} \t\t\t[-noOverWrite] myAppljar myServerName myAppClientCode.jar (The last parameter is optional)", new Object[]{DEPLOY_APPLICATION}));
        System.out.println(localStrings.getLocalString("enterprise.tools.deployment.main.uninstallapplicationfromserver", "  {0} \t\t\t<application name> <server name>", new Object[]{UNINSTALL}));
        System.out.println(localStrings.getLocalString("enterprise.tools.deployment.main.listApps", "  {0} \t\t\t<server name>", new Object[]{LIST_APPLICATIONS}));
        System.exit(1);
    }

    public static void listApplications(String serverName) {
        try {
            DeployTool deployTool = new DeployTool(false);
            JarInstaller backend = deployTool.getServerManager().getServerForName(serverName);
            Vector deployedApps = backend.getApplicationNames();
            if (deployedApps.size() > 0) {
                System.out.println(String.valueOf(localStrings.getLocalString("enterprise.tools.deployment.main.followingapps", "The following apps are deployed on ")) + serverName + ":");
                int appIndex = 0;
                while (appIndex < deployedApps.size()) {
                    System.out.println("\t" + (String)deployedApps.elementAt(appIndex));
                    ++appIndex;
                }
            } else {
                System.out.println(String.valueOf(localStrings.getLocalString("enterprise.tools.deployment.main.nodeployedapps", "There are no deployed applications on ")) + serverName);
            }
        }
        catch (Exception e10) {
            Log.print(LOG_NAME, e10.getMessage());
        }
    }

    public static void main(String[] args) {
        Utility.checkJVMVersion();
        ApplicationArchivist.setMakeClassLoadable(false);
        if (args.length == 0) {
            System.out.println(DEFAULT_STARTUP_MESSAGE);
            new DeployTool(true);
            return;
        }
        if (args[0].equals(UI)) {
            new DeployTool(true);
            return;
        }
        if (args[0].equals(LIST_APPLICATIONS)) {
            if (args.length >= 2) {
                String server = args[1];
                Main.listApplications(server);
                return;
            }
            Main.help();
            return;
        }
        if (args[0].equals(HELP)) {
            Main.help();
            return;
        }
        if (args[0].equals(EJB_WIZARD)) {
            return;
        }
        DeployTool deployTool = new DeployTool(false);
        if (args[0].equals(DEPLOY_APPLICATION)) {
            int argIndex = 1;
            boolean allowRedeploy = true;
            if (args.length <= argIndex) {
                Main.help();
                return;
            }
            if (args[argIndex].equals(NO_OVER_WRITE)) {
                allowRedeploy = false;
                ++argIndex;
            }
            if (args.length < argIndex + 2) {
                Main.help();
                return;
            }
            String applicationJar = args[argIndex];
            String serverName = args[++argIndex];
            File clientCodeFile = null;
            if (args.length > ++argIndex) {
                clientCodeFile = new File(args[argIndex]);
            }
            Application toDeploy = null;
            try {
                toDeploy = ApplicationArchivist.open(new File(applicationJar));
            }
            catch (Exception ioe) {
                Log.print(LOG_NAME, localStrings.getLocalString("enterprise.tools.deployment.main.warning", "{0}", new Object[]{ioe.getMessage()}));
                System.exit(1);
            }
            try {
                boolean isInstalled = deployTool.getServerManager().isInstalled(toDeploy.getName(), serverName);
                if (isInstalled) {
                    if (!allowRedeploy) {
                        Log.print(LOG_NAME, localStrings.getLocalString("enterprise.tools.deployment.main.logmessagetodeploy", "To deploy the application {0} must be uninstalled before it can be re-deployed", new Object[]{toDeploy.getName()}));
                        System.exit(1);
                    } else {
                        System.out.println("Note : application " + toDeploy.getName() + " is already installed.  Redeploying...");
                    }
                }
                deployTool.deploy(toDeploy, serverName, null, clientCodeFile);
            }
            catch (Exception t2) {
                Log.print(LOG_NAME, localStrings.getLocalString("enterprise.tools.deployment.main.warning", "{0}", new Object[]{t2.getMessage()}));
                System.exit(1);
            }
            System.exit(0);
        }
        if (args[0].equals(PACKAGE_EJBS)) {
            if (args.length < 5) {
                Main.help();
                return;
            }
            String codebase = args[1];
            String classes = args[2];
            String descriptorFile = args[3];
            String jarFile = args[4];
            Vector<String> classNames = new Vector<String>();
            StringTokenizer st = new StringTokenizer(classes, ":");
            while (st.hasMoreTokens()) {
                classNames.addElement(st.nextToken());
            }
            String optionalEjbBundleFilename = "";
            String optionalRuntimeFiename = "";
            if (args.length > 5) {
                if (args[5] != null) {
                    optionalEjbBundleFilename = args[5];
                }
                if (args[6] != null) {
                    optionalRuntimeFiename = args[6];
                }
            }
            try {
                deployTool.getComponentPackager().packageEjbs(codebase, classNames, descriptorFile, jarFile, optionalEjbBundleFilename, optionalRuntimeFiename);
            }
            catch (Exception e10) {
                deployTool.getComponentPackager().handlePackagingException(e10);
                System.exit(1);
            }
            System.exit(0);
        }
        if (args[0].equals(UNINSTALL)) {
            if (args.length < 3) {
                Main.help();
                return;
            }
            String applicationName = args[1];
            String serverName = args[2];
            try {
                if (deployTool.getServerManager().isInstalled(applicationName, serverName)) {
                    deployTool.getServerManager().uninstall(applicationName, serverName);
                    Log.print(LOG_NAME, localStrings.getLocalString("enterprise.tools.deployment.main.applicationuninstalledfromserver", "The application {0} was uninstalled from {1}", new Object[]{applicationName, serverName}));
                } else {
                    Log.print(LOG_NAME, localStrings.getLocalString("enterprise.tools.deployment.main.applicationnotdeployed", "The application {0} is not deployed on {1}", new Object[]{applicationName, serverName}));
                }
                return;
            }
            catch (Exception e11) {
                Log.print(LOG_NAME, e11.getMessage());
                System.exit(1);
            }
        }
        if (args[0].equals(GENERATE_SQL)) {
            String applicationFilename = args[1];
            String serverName = args[2];
            boolean overWrite = true;
            if (args.length > 3 && args[3].equals(DONT_OVER_WRITE_SQL)) {
                overWrite = false;
            }
            try {
                deployTool.doGenerateSQL(applicationFilename, serverName, overWrite);
            }
            catch (Throwable t3) {
                t3.printStackTrace();
                System.exit(1);
            }
            return;
        }
        Main.help();
    }
}

