/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JSplitPane;

class DeploytoolWindowResizer
extends ComponentAdapter {
    private JSplitPane jsp;
    private Rectangle oldBounds;

    DeploytoolWindowResizer(JSplitPane jsp) {
        this.jsp = jsp;
        this.oldBounds = jsp.getBounds();
    }

    public void componentResized(ComponentEvent e10) {
        int mainSplitLocation = this.jsp.getDividerLocation();
        int oldHeight = this.oldBounds.height;
        if (oldHeight > 0) {
            float oldProportionPercent = 100 * mainSplitLocation / oldHeight;
            int newHeight = this.jsp.getBounds().height;
            int newLocation = Math.round(oldProportionPercent * (float)newHeight / 100.0f);
            this.jsp.setDividerLocation(newLocation);
        }
        this.resizeVerticalDivider(this.getUpper());
        this.resizeVerticalDivider(this.getLower());
        this.oldBounds = this.jsp.getBounds();
    }

    private JSplitPane getLower() {
        return (JSplitPane)this.jsp.getBottomComponent();
    }

    private JSplitPane getUpper() {
        return (JSplitPane)this.jsp.getTopComponent();
    }

    public void resizeVerticalDivider(JSplitPane sp) {
        int splitLocation = sp.getDividerLocation();
        int oldWidth = this.oldBounds.width;
        if (oldWidth > 0) {
            float oldProportionPercent = 100 * splitLocation / oldWidth;
            int newWidth = this.jsp.getBounds().width;
            int newLocation = Math.round(oldProportionPercent * (float)newWidth / 100.0f);
            sp.setDividerLocation(newLocation);
        }
    }
}

