/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.xml.ApplicationClientNode;
import com.sun.enterprise.deployment.xml.ApplicationNode;
import com.sun.enterprise.deployment.xml.EjbBundleNode;
import com.sun.enterprise.deployment.xml.WebBundleNode;
import com.sun.enterprise.deployment.xml.XMLUtils;
import com.sun.enterprise.tools.deployment.ui.DeployToolActions;
import com.sun.enterprise.tools.deployment.ui.Inspector;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import com.sun.xml.tree.XmlDocument;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class DescriptorViewer
extends JDialog
implements Inspector,
NotificationListener {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$DescriptorViewer != null ? class$com$sun$enterprise$tools$deployment$ui$DescriptorViewer : (class$com$sun$enterprise$tools$deployment$ui$DescriptorViewer = DescriptorViewer.class$("com.sun.enterprise.tools.deployment.ui.DescriptorViewer")));
    private static String helpSetMapID = "DescriptorViewer";
    private Descriptor descriptor;
    private JButton closePB;
    private JButton helpPB;
    private JButton saveAsPB;
    private JFileChooser jfc = UIUtils.getFileChooser();
    private JTextArea descriptorText;
    private StringWriter sw = null;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$DescriptorViewer;

    public DescriptorViewer(Frame frame) {
        super(frame, false);
        ((Component)this).setSize(new Dimension(500, 400));
        this.setTitle(localStrings.getLocalString("descriptorviewer.title", "Deployment Descriptor Viewer"));
        JPanel contentPane = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        contentPane.setLayout(gb);
        GridBagConstraints c10 = new GridBagConstraints();
        c10.fill = 1;
        c10.gridx = 0;
        c10.gridy = 0;
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.gridheight = 3;
        c10.gridwidth = 3;
        c10.insets = new Insets(5, 5, 5, 5);
        this.descriptorText = new JTextArea();
        this.descriptorText.setEnabled(false);
        JScrollPane descriptorTextPane = new JScrollPane(this.descriptorText);
        gb.setConstraints(descriptorTextPane, c10);
        contentPane.add(descriptorTextPane);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 3, 5, 5));
        this.saveAsPB = new JButton(localStrings.getLocalString("descriptorviewer.saveas", "Save As..."));
        buttonPanel.add(this.saveAsPB);
        this.saveAsPB.setMnemonic('S');
        this.saveAsPB.setActionCommand("Save As");
        this.saveAsPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                DescriptorViewer.this.saveAsAction();
            }
        });
        this.closePB = new JButton(localStrings.getLocalString("descriptorviewer.close", "Close"));
        buttonPanel.add(this.closePB);
        this.closePB.setMnemonic('C');
        this.closePB.setActionCommand("Close");
        this.closePB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                ((Component)DescriptorViewer.this).setVisible(false);
            }
        });
        this.helpPB = new JButton(localStrings.getLocalString("descriptorviewer.help", "Help"));
        DeployToolActions.enableHelpOnButton(this.helpPB, helpSetMapID);
        buttonPanel.add(this.helpPB);
        this.helpPB.setMnemonic('H');
        this.helpPB.setActionCommand("Help");
        this.helpPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
            }
        });
        c10.gridx = 2;
        c10.gridy = 3;
        c10.weightx = 0.0;
        c10.weighty = 0.0;
        c10.gridheight = 1;
        c10.gridwidth = 1;
        c10.anchor = 13;
        c10.fill = 0;
        gb.setConstraints(buttonPanel, c10);
        contentPane.add(buttonPanel);
        this.setContentPane(contentPane);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void notification(NotificationEvent ne) {
        this.refresh();
    }

    private void refresh() {
        block9: {
            XmlDocument document = null;
            if (this.descriptor instanceof Application) {
                document = ApplicationNode.getDocument((Application)this.descriptor);
            } else if (this.descriptor instanceof ApplicationClientDescriptor) {
                document = ApplicationClientNode.getDocument((ApplicationClientDescriptor)this.descriptor);
            } else if (this.descriptor instanceof EjbBundleDescriptor) {
                document = EjbBundleNode.getDocument((EjbBundleDescriptor)this.descriptor);
            } else if (this.descriptor instanceof WebBundleDescriptor) {
                document = WebBundleNode.getDocument((WebBundleDescriptor)this.descriptor);
            }
            if (document == null) break block9;
            try {
                this.sw = new StringWriter();
                XMLUtils.writeDocument(document, this.sw);
                this.descriptorText.setText(this.sw.toString());
            }
            catch (Throwable throwable) {
                System.out.println(localStrings.getLocalString("newejbwizard.error_forming_xml", "Warning: error forming XML"));
            }
        }
    }

    private void saveAsAction() {
        block6: {
            this.jfc.rescanCurrentDirectory();
            int returnValue = this.jfc.showDialog(this, localStrings.getLocalString("descriptorviewer.save_descriptor", "Save Deployment Descriptor"));
            if (returnValue != 0) break block6;
            File newFile = this.jfc.getSelectedFile();
            if (newFile.exists()) {
                int overwrite = JOptionPane.showConfirmDialog(this, String.valueOf(String.valueOf(newFile)) + localStrings.getLocalString("deploytoolwindow.already_exists", " already exists. Do you wish to overwrite ?"), localStrings.getLocalString("deploytoolwindow.confirm", "Confirm"), 0, 3);
                if (overwrite == 0) {
                    newFile.delete();
                } else {
                    return;
                }
            }
            if (this.sw != null) {
                try {
                    FileOutputStream fos = new FileOutputStream(newFile);
                    byte[] deploymentDescriptor = this.sw.toString().getBytes();
                    fos.write(deploymentDescriptor, 0, deploymentDescriptor.length);
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void setObject(Object o2) {
        ((Descriptor)o2).addNotificationListener(this);
        this.descriptor = (Descriptor)o2;
        this.refresh();
    }
}

