/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.FieldDescriptor;
import com.sun.enterprise.tools.deployment.main.ServerManager;
import com.sun.enterprise.tools.deployment.ui.Inspector;
import com.sun.enterprise.tools.deployment.ui.descriptor.DeploymentSettingsDialog;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Field;
import java.util.Set;
import java.util.Vector;
import javax.help.CSH;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class EjbEntityInspector
extends JPanel
implements Inspector {
    private EjbEntityDescriptor descriptor;
    private final JTextField primKeyClassText;
    private final JComboBox fieldNameCombo;
    private final JCheckBox reentrantCB;
    private final DefaultListModel cmpFieldListModel;
    private final JList cmpFieldList;
    private final JButton deploymentSettingsPB;
    private final DeploymentSettingsDialog deploymentSettingsDialog;
    private final JRadioButton containerMgtRB;
    private final JRadioButton beanMgtRB;
    private ServerManager serverManager;
    private boolean isAdjusting = false;
    private String inspectorMode;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$EjbEntityInspector != null ? class$com$sun$enterprise$tools$deployment$ui$descriptor$EjbEntityInspector : (class$com$sun$enterprise$tools$deployment$ui$descriptor$EjbEntityInspector = EjbEntityInspector.class$("com.sun.enterprise.tools.deployment.ui.descriptor.EjbEntityInspector")));
    private static String helpSetMapID = "EIEntity";
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$EjbEntityInspector;
    static /* synthetic */ Class class$javax$swing$JFrame;

    public EjbEntityInspector(ServerManager serverManager, String mode) {
        this.inspectorMode = mode;
        CSH.setHelpIDString((Component)this, (String)helpSetMapID);
        this.serverManager = serverManager;
        this.setToolTipText(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.entitybeaninfo", "EntityBean information"));
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        GridBagConstraints c10 = new GridBagConstraints();
        c10.fill = 1;
        c10.weightx = 0.5;
        JPanel persistenceMgtPanel = new JPanel();
        persistenceMgtPanel.setBorder(new TitledBorder(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.persistencemanagement", "Persistence management")));
        GridBagLayout gb1 = new GridBagLayout();
        persistenceMgtPanel.setLayout(gb1);
        this.beanMgtRB = new JRadioButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.bmp", "Bean managed persistence"));
        this.beanMgtRB.setMnemonic('b');
        this.beanMgtRB.setSelected(false);
        this.containerMgtRB = new JRadioButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.cmp", "Container managed persistence"));
        this.containerMgtRB.setMnemonic('c');
        this.containerMgtRB.setSelected(true);
        ButtonGroup persistenceRBGroup = new ButtonGroup();
        persistenceRBGroup.add(this.beanMgtRB);
        persistenceRBGroup.add(this.containerMgtRB);
        ActionListener persistenceRBListener = new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                if (EjbEntityInspector.this.descriptor != null) {
                    if (EjbEntityInspector.this.beanMgtRB.isSelected()) {
                        EjbEntityInspector.this.descriptor.setPersistenceType(EjbEntityDescriptor.BEAN_PERSISTENCE);
                    } else {
                        EjbEntityInspector.this.descriptor.setPersistenceType(EjbEntityDescriptor.CONTAINER_PERSISTENCE);
                    }
                    EjbEntityInspector.this.refreshCMPFields();
                }
            }
        };
        this.beanMgtRB.addActionListener(persistenceRBListener);
        this.containerMgtRB.addActionListener(persistenceRBListener);
        c10.gridx = 0;
        c10.gridy = 0;
        c10.insets = new Insets(0, 5, 0, 5);
        gb1.setConstraints(this.beanMgtRB, c10);
        persistenceMgtPanel.add(this.beanMgtRB);
        c10.gridx = 0;
        c10.gridy = 1;
        c10.insets = new Insets(0, 5, 0, 5);
        gb1.setConstraints(this.containerMgtRB, c10);
        persistenceMgtPanel.add(this.containerMgtRB);
        JPanel cmpFieldsPanel = new JPanel();
        cmpFieldsPanel.setBorder(new TitledBorder(""));
        GridBagLayout gb2 = new GridBagLayout();
        cmpFieldsPanel.setLayout(gb2);
        this.cmpFieldListModel = new DefaultListModel();
        this.cmpFieldList = new JList(this.cmpFieldListModel);
        this.cmpFieldList.setToolTipText(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.containermanagedfields", "Container managed fields"));
        this.cmpFieldList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e10) {
                int row = EjbEntityInspector.this.cmpFieldList.getMinSelectionIndex();
                if (row != -1) {
                    MyJCheckBox cb2 = (MyJCheckBox)EjbEntityInspector.this.cmpFieldListModel.elementAt(row);
                    Set persFields = EjbEntityInspector.this.descriptor.getPersistentFields();
                    if (cb2.isSelected()) {
                        cb2.setSelected(false);
                        persFields.remove(new FieldDescriptor(cb2.field));
                    } else {
                        cb2.setSelected(true);
                        persFields.add(new FieldDescriptor(cb2.field));
                    }
                    EjbEntityInspector.this.descriptor.changed();
                }
            }
        });
        this.cmpFieldList.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return (JCheckBox)value;
            }
        });
        this.cmpFieldList.setVisibleRowCount(10);
        this.cmpFieldList.setSelectionMode(0);
        JScrollPane cmpFieldListScrollPane = new JScrollPane(this.cmpFieldList);
        cmpFieldListScrollPane.setPreferredSize(new Dimension(250, 50));
        c10.gridx = 0;
        c10.gridy = 0;
        c10.weighty = 0.3;
        c10.gridwidth = 2;
        c10.gridheight = 5;
        c10.insets = new Insets(0, 0, 0, 0);
        gb2.setConstraints(cmpFieldListScrollPane, c10);
        cmpFieldsPanel.add(cmpFieldListScrollPane);
        JFrame frame = (JFrame)SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame != null ? class$javax$swing$JFrame : (class$javax$swing$JFrame = EjbEntityInspector.class$("javax.swing.JFrame")), this);
        this.deploymentSettingsDialog = new DeploymentSettingsDialog((Frame)frame, true, this.serverManager);
        this.deploymentSettingsDialog.pack();
        this.deploymentSettingsPB = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.entitydeploymentsettings", "Deployment Settings..."));
        this.deploymentSettingsPB.setMnemonic('D');
        this.deploymentSettingsPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                EjbEntityInspector.this.deploymentSettingsDialog.setLocationRelativeTo(EjbEntityInspector.this.deploymentSettingsDialog.getOwner());
                EjbEntityInspector.this.deploymentSettingsDialog.setDescriptor(EjbEntityInspector.this.descriptor);
                ((Component)EjbEntityInspector.this.deploymentSettingsDialog).setVisible(true);
            }
        });
        this.deploymentSettingsPB.setEnabled(this.serverManager != null);
        c10.gridx = 2;
        c10.gridy = 4;
        c10.weightx = 0.0;
        c10.weighty = 0.0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.fill = 0;
        c10.anchor = 16;
        c10.insets = new Insets(0, 10, 0, 5);
        gb2.setConstraints(this.deploymentSettingsPB, c10);
        cmpFieldsPanel.add(this.deploymentSettingsPB);
        c10.fill = 1;
        c10.anchor = 10;
        c10.weightx = 0.5;
        c10.gridx = 0;
        c10.gridy = 2;
        c10.weighty = 0.3;
        c10.insets = new Insets(5, 10, 5, 5);
        gb1.setConstraints(cmpFieldsPanel, c10);
        persistenceMgtPanel.add(cmpFieldsPanel);
        c10.insets = new Insets(0, 0, 0, 0);
        c10.weighty = 0.5;
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 2;
        c10.insets = new Insets(5, 5, 0, 5);
        gridbag.setConstraints(persistenceMgtPanel, c10);
        this.add(persistenceMgtPanel);
        c10.gridwidth = 1;
        JLabel primKeyClassLabel = new JLabel(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.primarykeyclass", "Primary key class:"));
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 1;
        c10.insets = new Insets(5, 5, 0, 5);
        gridbag.setConstraints(primKeyClassLabel, c10);
        this.add(primKeyClassLabel);
        this.primKeyClassText = new JTextField();
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 2;
        c10.insets = new Insets(0, 5, 0, 5);
        gridbag.setConstraints(this.primKeyClassText, c10);
        this.add(this.primKeyClassText);
        JLabel fieldNameLabel = new JLabel(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.primarykeyfieldname", "Primary key field name:"));
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 3;
        c10.insets = new Insets(5, 5, 0, 5);
        gridbag.setConstraints(fieldNameLabel, c10);
        this.add(fieldNameLabel);
        this.fieldNameCombo = new JComboBox();
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 4;
        c10.insets = new Insets(0, 5, 5, 5);
        gridbag.setConstraints(this.fieldNameCombo, c10);
        this.add(this.fieldNameCombo);
        this.fieldNameCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                EjbEntityInspector.this.savePrimKey();
            }
        });
        this.reentrantCB = new JCheckBox(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.reentrant", "Reentrant"));
        this.reentrantCB.setMnemonic('r');
        this.reentrantCB.setSelected(false);
        c10.weightx = 0.0;
        c10.weighty = 0.0;
        c10.gridx = 1;
        c10.gridy = 4;
        c10.insets = new Insets(0, 20, 0, 0);
        c10.fill = 0;
        gridbag.setConstraints(this.reentrantCB, c10);
        this.add(this.reentrantCB);
        c10.fill = 1;
        ActionListener textListener = new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                if (e10.getSource() == EjbEntityInspector.this.primKeyClassText) {
                    EjbEntityInspector.this.descriptor.setPrimaryKeyClassName(EjbEntityInspector.this.primKeyClassText.getText());
                }
            }
        };
        FocusAdapter focusListener = new FocusAdapter(){

            public void focusLost(FocusEvent e10) {
                if (e10.getSource() == EjbEntityInspector.this.primKeyClassText) {
                    EjbEntityInspector.this.descriptor.setPrimaryKeyClassName(EjbEntityInspector.this.primKeyClassText.getText());
                }
            }
        };
        this.primKeyClassText.addActionListener(textListener);
        this.primKeyClassText.addFocusListener(focusListener);
        this.reentrantCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                EjbEntityInspector.this.descriptor.setReentrant(EjbEntityInspector.this.reentrantCB.isSelected());
            }
        });
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        EjbEntityInspector myPanel = new EjbEntityInspector(null, "DeployerMode");
        frame.getContentPane().add((Component)myPanel, "Center");
        ((Component)frame).setSize(myPanel.getPreferredSize());
        ((Component)frame).setVisible(true);
    }

    private void refresh() {
        if (this.descriptor == null) {
            return;
        }
        if (this.inspectorMode.equals("DeveloperMode")) {
            this.deploymentSettingsPB.setVisible(false);
        } else {
            this.deploymentSettingsPB.setVisible(true);
        }
        this.primKeyClassText.setText(this.descriptor.getPrimaryKeyClassName());
        this.reentrantCB.setSelected(this.descriptor.isReentrant());
        this.refreshCMPFields();
    }

    private void refreshCMPFields() {
        if (this.descriptor == null) {
            return;
        }
        this.isAdjusting = true;
        DefaultComboBoxModel<String> dcbm = new DefaultComboBoxModel<String>();
        dcbm.addElement("");
        if (this.descriptor.getPersistenceType().equals(EjbEntityDescriptor.BEAN_PERSISTENCE)) {
            this.beanMgtRB.setSelected(true);
            this.containerMgtRB.setSelected(false);
            this.cmpFieldListModel.clear();
            this.cmpFieldList.setEnabled(false);
            this.deploymentSettingsPB.setEnabled(false);
            this.deploymentSettingsPB.setEnabled(false);
            this.fieldNameCombo.setEnabled(false);
        } else {
            this.beanMgtRB.setSelected(false);
            this.containerMgtRB.setSelected(true);
            this.deploymentSettingsPB.setEnabled(true);
            this.deploymentSettingsPB.setEnabled(this.serverManager != null);
            this.fieldNameCombo.setEnabled(true);
            this.cmpFieldList.setEnabled(true);
            this.cmpFieldListModel.clear();
            Vector allFields = this.descriptor.getFields();
            int i2 = 0;
            while (i2 < allFields.size()) {
                Field field = (Field)allFields.elementAt(i2);
                MyJCheckBox cb2 = new MyJCheckBox();
                cb2.field = field;
                cb2.setOpaque(true);
                cb2.setText(field.getName());
                cb2.setSelected(this.descriptor.isPersistent(field));
                cb2.setBackground(this.cmpFieldList.getBackground());
                cb2.setForeground(this.cmpFieldList.getForeground());
                this.cmpFieldListModel.addElement(cb2);
                dcbm.addElement(field.getName());
                ++i2;
            }
        }
        this.fieldNameCombo.setModel(dcbm);
        if (this.descriptor.getPrimaryKeyField() == null) {
            this.fieldNameCombo.setSelectedItem("");
        } else {
            this.fieldNameCombo.setSelectedItem(this.descriptor.getPrimaryKeyField().getName());
        }
        this.isAdjusting = false;
    }

    private void saveIntoDescriptor() {
        if (this.descriptor == null) {
            return;
        }
        this.descriptor.setReentrant(this.reentrantCB.isSelected());
    }

    void savePrimKey() {
        if (!this.isAdjusting) {
            String fieldName = (String)this.fieldNameCombo.getSelectedItem();
            if (this.descriptor.getPersistenceType().equals(EjbEntityDescriptor.CONTAINER_PERSISTENCE)) {
                if (!"".equals(fieldName)) {
                    this.descriptor.setPrimaryKeyField(new FieldDescriptor(fieldName, ""));
                } else {
                    this.descriptor.setPrimaryKeyField(null);
                }
            }
        }
    }

    public void setObject(Object o2) {
        if (o2 instanceof EjbEntityDescriptor) {
            this.descriptor = (EjbEntityDescriptor)o2;
            this.refresh();
        } else {
            this.descriptor = null;
        }
    }

    private class MyJCheckBox
    extends JCheckBox {
        Field field;

        MyJCheckBox() {
        }
    }
}

