/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.beanclass;

import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.Method;

public class EjbClassFinalizeMethod
implements EjbCheck {
    boolean debug = Verifier.getDebug();

    public Result check(EjbDescriptor descriptor) {
        LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        if (descriptor instanceof EjbSessionDescriptor || descriptor instanceof EjbEntityDescriptor) {
            try {
                JarClassLoader jcl = JarClassLoader.getInstance();
                Class<?> c10 = jcl.loadClass(descriptor.getEjbClassName());
                boolean foundOne = false;
                Method[] methods = c10.getDeclaredMethods();
                int i2 = 0;
                while (i2 < methods.length) {
                    if (methods[i2].getName().equals("finalize")) {
                        foundOne = true;
                        break;
                    }
                    ++i2;
                }
                if (foundOne) {
                    result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed", "Error: The bean class [ {0} ] must not define the \n finalize() method.", new Object[]{descriptor.getEjbClassName()}));
                } else {
                    result.passed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "Valid: This bean class [ {0} ] correctly does not \n define the finalize() method.", new Object[]{descriptor.getEjbClassName()}));
                }
            }
            catch (ClassNotFoundException e10) {
                Verifier.debug(e10);
                result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failedException", "Error: [ {0} ] class not found.", new Object[]{descriptor.getEjbClassName()}));
            }
            catch (Throwable t2) {
                Verifier.debug(t2);
                result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failedThrowable", "Error: [ {0} ] class encountered [ {1} ]. Cannot access methods of class [ {2} ] within [ {3} ].", new Object[]{descriptor.getEjbClassName(), t2.toString(), t2.getMessage(), Verifier.getJarFile(((EjbBundleArchivist)descriptor.getEjbBundleDescriptor().getArchivist()).getEjbJarFile().getName()).getName()}));
            }
            return result;
        }
        result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "{0} expected {1} bean or {2} bean, but called with {3}.", new Object[]{this.getClass(), "Session", "Entity", descriptor.getName()}));
        return result;
    }
}

