/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.findermethod;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.RmiIIOPUtils;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.Method;
import java.util.Arrays;

public class HomeInterfaceFindMethodExceptionMatch
implements EjbCheck {
    boolean debug = Verifier.getDebug();

    public Result check(EjbDescriptor descriptor) {
        LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        if (descriptor instanceof EjbEntityDescriptor) {
            String persistence = ((EjbEntityDescriptor)descriptor).getPersistenceType();
            if (EjbEntityDescriptor.BEAN_PERSISTENCE.equals(persistence)) {
                boolean oneFailed = false;
                int ejbFinderMethodLoopCounter = 0;
                try {
                    JarClassLoader jcl = JarClassLoader.getInstance();
                    Class<?> c10 = jcl.loadClass(descriptor.getHomeClassName());
                    Method[] methods = c10.getDeclaredMethods();
                    boolean ejbFinderFound = false;
                    boolean signaturesMatch = false;
                    boolean exceptionsMatch = false;
                    int i2 = 0;
                    while (i2 < methods.length) {
                        if (methods[i2].getName().startsWith("find")) {
                            ejbFinderFound = false;
                            signaturesMatch = false;
                            exceptionsMatch = false;
                            Class<?> EJBClass = jcl.loadClass(descriptor.getEjbClassName());
                            do {
                                Method[] ejbFinderMethods = EJBClass.getDeclaredMethods();
                                int z2 = 0;
                                while (z2 < ejbFinderMethods.length) {
                                    if (ejbFinderMethods[z2].getName().startsWith("ejbFind") && methods[i2].getName().toUpperCase().equals(ejbFinderMethods[z2].getName().toUpperCase().substring(3))) {
                                        Object[] ejbFinderMethodParameterTypes;
                                        ejbFinderFound = true;
                                        Object[] methodParameterTypes = methods[i2].getParameterTypes();
                                        if (Arrays.equals(methodParameterTypes, ejbFinderMethodParameterTypes = ejbFinderMethods[z2].getParameterTypes())) {
                                            signaturesMatch = true;
                                            Class[] methodExceptionTypes = methods[i2].getExceptionTypes();
                                            Class[] ejbFinderMethodExceptionTypes = ejbFinderMethods[z2].getExceptionTypes();
                                            if (RmiIIOPUtils.isEjbFindMethodExceptionsSubsetOfFindMethodExceptions(ejbFinderMethodExceptionTypes, methodExceptionTypes)) {
                                                exceptionsMatch = true;
                                                ejbFinderMethodLoopCounter = z2;
                                                break;
                                            }
                                        }
                                    }
                                    ++z2;
                                }
                                if (ejbFinderFound && signaturesMatch && exceptionsMatch) {
                                    result.addGoodDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug1", "For Home Interface [ {0} ] Method [ {1} ]", new Object[]{c10.getName(), methods[i2].getName()}));
                                    result.addGoodDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "The corresponding [ {0} ] method with matching exceptions was found.", new Object[]{ejbFinderMethods[ejbFinderMethodLoopCounter].getName()}));
                                    result.addGoodDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug2", "=============================="));
                                    continue;
                                }
                                if (ejbFinderFound && signaturesMatch && !exceptionsMatch) {
                                    if (!this.debug) continue;
                                    System.out.println(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug1", "For Home Interface [ {0} ] Method [ {1} ]", new Object[]{c10.getName(), methods[i2].getName()}));
                                    System.out.println(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug3", "A corresponding [ {0} ] method was found, but the exceptions did not match.", new Object[]{"ejb" + methods[i2].getName().toUpperCase().substring(0, 1) + methods[i2].getName().substring(1)}));
                                    System.out.println(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug2", "=============================="));
                                    continue;
                                }
                                if (!ejbFinderFound || signaturesMatch || !this.debug) continue;
                                System.out.println(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug1", "For Home Interface [ {0} ] Method [ {1} ]", new Object[]{c10.getName(), methods[i2].getName()}));
                                System.out.println(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug4", "A corresponding [ {0} ] method was found, but the parameters did not match.", new Object[]{"ejb" + methods[i2].getName().toUpperCase().substring(0, 1) + methods[i2].getName().substring(1)}));
                                System.out.println(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug2", "=============================="));
                            } while ((EJBClass = EJBClass.getSuperclass()) != null && (!ejbFinderFound || !signaturesMatch || !exceptionsMatch));
                            if (!(ejbFinderFound && signaturesMatch && exceptionsMatch)) {
                                oneFailed = true;
                                result.addErrorDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug1", "For Home Interface [ {0} ] Method [ {1} ]", new Object[]{c10.getName(), methods[i2].getName()}));
                                result.addErrorDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed", "Error: No corresponding [ {0} ] method with matching signatures was found.", new Object[]{"ejb" + methods[i2].getName().toUpperCase().substring(0, 1) + methods[i2].getName().substring(1)}));
                                result.addErrorDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug2", "=============================="));
                            }
                        }
                        ++i2;
                    }
                }
                catch (ClassNotFoundException e10) {
                    Verifier.debug(e10);
                    result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failedException", "Error: Home interface [ {0} ] or EJB class [ {1} ] does not exist or is not loadable within bean [ {2} ]", new Object[]{descriptor.getHomeClassName(), descriptor.getEjbClassName(), descriptor.getName()}));
                }
                if (oneFailed) {
                    result.setStatus(1);
                } else {
                    result.setStatus(0);
                }
                return result;
            }
            result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable2", "Expected [ {0} ] managed persistence, but [ {1} ] bean has [ {2} ] managed persistence.", new Object[]{EjbEntityDescriptor.BEAN_PERSISTENCE, descriptor.getName(), persistence}));
            return result;
        }
        result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Entity", "Session"}));
        return result;
    }
}

