/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.ErrorPageDescriptorImpl;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Enumeration;

public class ExceptionType
implements WebCheck {
    boolean debug = Verifier.getDebug();
    LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();

    public Result check(WebBundleDescriptor descriptor) {
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + this.smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(this.smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        if (descriptor.getErrorPageDescriptors().hasMoreElements()) {
            boolean oneFailed = false;
            int oneExceptionType = 0;
            int oneNA = 0;
            boolean foundIt = false;
            Enumeration e10 = descriptor.getErrorPageDescriptors();
            while (e10.hasMoreElements()) {
                foundIt = false;
                ++oneExceptionType;
                ErrorPageDescriptorImpl errorpage = (ErrorPageDescriptorImpl)e10.nextElement();
                if (errorpage.getErrorCode() == 0) {
                    String exceptionType = errorpage.getExceptionType();
                    if (exceptionType != null && exceptionType.length() > 0) {
                        boolean isValidExceptionType = false;
                        try {
                            Class<?> c10 = Class.forName(exceptionType);
                            if (c10.newInstance() instanceof Exception) {
                                isValidExceptionType = true;
                            }
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            isValidExceptionType = false;
                        }
                        catch (InstantiationException instantiationException) {
                            isValidExceptionType = false;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            isValidExceptionType = false;
                        }
                        if (foundIt = isValidExceptionType) {
                            result.addGoodDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "Exception type [ {0} ] contains a fully qualified class name of a Java exception type within web application [ {1} ]", new Object[]{exceptionType, descriptor.getName()}));
                            continue;
                        }
                        if (!oneFailed) {
                            oneFailed = true;
                        }
                        result.addErrorDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed", "Error: Exception type [ {0} ] does not contain a fully qualified class name of a Java exception type within web application [ {1} ]", new Object[]{exceptionType, descriptor.getName()}));
                        continue;
                    }
                    if (!oneFailed) {
                        oneFailed = true;
                    }
                    Integer errorCode = new Integer(errorpage.getErrorCode());
                    result.addErrorDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed", "Error: Exception type [ {0} ] does not contain a fully qualified class name of a Java exception type within web application [ {1} ]", new Object[]{errorCode.toString(), descriptor.getName()}));
                    ++oneNA;
                    continue;
                }
                Integer errorCode = new Integer(errorpage.getErrorCode());
                result.addNaDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable1", "Exception type is null, using error-code [ {0} ] instead within web application [ {1} ]", new Object[]{errorCode.toString(), descriptor.getName()}));
                ++oneNA;
            }
            if (oneFailed) {
                result.setStatus(1);
            } else if (oneNA == oneExceptionType) {
                result.setStatus(3);
            } else {
                result.setStatus(0);
            }
        } else {
            result.notApplicable(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "There are no exception-type elements within the web archive [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

