/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web.elements;

import com.sun.enterprise.deployment.MimeMappingDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Enumeration;

public class ExtensionElement
implements WebCheck {
    boolean debug = Verifier.getDebug();
    LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();

    public Result check(WebBundleDescriptor descriptor) {
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + this.smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(this.smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        if (descriptor.getMimeMappings().hasMoreElements()) {
            boolean oneFailed = false;
            boolean foundIt = false;
            Enumeration e10 = descriptor.getMimeMappings();
            while (e10.hasMoreElements()) {
                foundIt = false;
                MimeMappingDescriptor mimemapping = (MimeMappingDescriptor)e10.nextElement();
                String extension = mimemapping.getExtension();
                foundIt = extension.startsWith(".");
                if (foundIt) {
                    result.addGoodDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "Servlet extension [ {0} ] defined for this web application [ {1} ]", new Object[]{extension, descriptor.getName()}));
                    continue;
                }
                if (!oneFailed) {
                    oneFailed = true;
                }
                result.addErrorDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed", "Error: Servlet extension [ {0} ] not defined for this web application [ {1} ]", new Object[]{extension, descriptor.getName()}));
            }
            if (oneFailed) {
                result.setStatus(1);
            } else {
                result.setStatus(0);
            }
        } else {
            result.notApplicable(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "There are no mime-mappings within the web archive [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

