/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.internal.net.DNS;

import com.sun.jndi.internal.net.DNS.Packet;

class ResourceRecord {
    private static final int TYPE_OFFSET = 0;
    private static final int CLASS_OFFSET = 2;
    private static final int TTL_OFFSET = 4;
    private static final int DLEN_OFFSET = 8;
    private static final int DATA_OFFSET = 10;
    private static final int TYPE_A = 1;
    private static final int TYPE_NS = 2;
    private static final int TYPE_CNAME = 5;
    private static final int TYPE_PTR = 12;
    private static final int TYPE_TXT = 16;
    String domain_name;
    int type;
    int data_class;
    int ttl;
    Object answer;
    private static boolean debug = false;

    ResourceRecord(Packet packet, int n2) {
        this.domain_name = this.parseName(packet, n2);
        this.type = packet.getShort(0);
        this.data_class = packet.getShort(2);
        this.ttl = packet.getInt(4);
        int n3 = packet.getShort(8);
        packet.shiftHeader(10);
        switch (this.type) {
            case 1: {
                byte[] byArray = new byte[]{(byte)packet.getByte(0), (byte)packet.getByte(1), (byte)packet.getByte(2), (byte)packet.getByte(3)};
                packet.shiftHeader(n3);
                this.answer = byArray;
                break;
            }
            case 5: 
            case 12: {
                this.answer = this.parseName(packet, n2);
                break;
            }
            case 16: {
                this.answer = this.parseString(packet, n2, n3);
                ResourceRecord.dprint("name <" + this.domain_name + "> has TXT record <" + this.answer + ">");
                break;
            }
            default: {
                this.answer = null;
            }
        }
    }

    private static void dprint(String string) {
        if (debug) {
            ResourceRecord.err(string);
        }
    }

    private static void err(String string) {
        System.err.println("DNS RR: " + string);
    }

    private String parseName(Packet packet, int n2) {
        StringBuffer stringBuffer = new StringBuffer(32);
        int n3 = 0;
        boolean bl2 = true;
        block0: while (true) {
            int n4;
            if (((n4 = packet.getByte(n3++)) & 0xC0) == 192) {
                n4 = packet.getShort(n3 - 1) & 0x3FFF;
                ++n3;
                ResourceRecord.dprint("compression offset:" + n4);
                int n5 = packet.getHeaderOffset();
                packet.setHeaderOffset(n2 + n4);
                ResourceRecord.dprint("shifted to: " + packet.getHeaderOffset());
                String string = String.valueOf(new String(stringBuffer)) + this.parseName(packet, n2);
                packet.setHeaderOffset(n5 + n3);
                ResourceRecord.dprint("compressed parseName done: <" + string + ">, hdr off:" + packet.getHeaderOffset());
                return string;
            }
            if (n4 == 0) {
                ResourceRecord.dprint("parseName done: <" + stringBuffer + ">, shifting:" + n3);
                packet.shiftHeader(n3);
                return new String(stringBuffer);
            }
            if (!bl2) {
                stringBuffer.append('.');
            }
            bl2 = false;
            while (true) {
                if (n4 <= 0) continue block0;
                stringBuffer.append((char)packet.getByte(n3++));
                --n4;
            }
            break;
        }
    }

    private byte[] parseString(Packet packet, int n2, int n3) {
        byte[] byArray = new byte[n3];
        int n4 = 0;
        int n5 = 0;
        while (n4 < n3) {
            int n6 = packet.getByte(n4++);
            while (n6 > 0) {
                byArray[n5++] = (byte)packet.getByte(n4++);
                --n6;
            }
        }
        packet.shiftHeader(n4);
        ResourceRecord.dprint("parseString:  string <" + byArray + ">" + byArray.length);
        return byArray;
    }
}

