/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.BigInt;
import com.sun.net.ssl.internal.ssl.BitArray;
import com.sun.net.ssl.internal.ssl.ByteArrayLexOrder;
import com.sun.net.ssl.internal.ssl.ByteArrayTagOrder;
import com.sun.net.ssl.internal.ssl.DerEncoder;
import com.sun.net.ssl.internal.ssl.DerValue;
import com.sun.net.ssl.internal.ssl.ObjectIdentifier;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.TimeZone;

public class DerOutputStream
extends ByteArrayOutputStream
implements DerEncoder {
    private static ByteArrayLexOrder a = new ByteArrayLexOrder();
    private static ByteArrayTagOrder b = new ByteArrayTagOrder();

    public DerOutputStream() {
    }

    public DerOutputStream(int n2) {
        super(n2);
    }

    public void derEncode(OutputStream outputStream) throws IOException {
        outputStream.write(this.toByteArray());
    }

    private void a(BigInt bigInt) throws IOException {
        byte[] byArray = bigInt.toByteArray();
        if ((byArray[0] & 0x80) != 0) {
            this.putLength(byArray.length + 1);
            this.write(0);
        } else {
            this.putLength(byArray.length);
        }
        this.write(byArray, 0, byArray.length);
    }

    public void putBitString(byte[] byArray) throws IOException {
        this.write(3);
        this.putLength(byArray.length + 1);
        this.write(0);
        this.write(byArray);
    }

    public void putBoolean(boolean bl2) throws IOException {
        this.write(1);
        this.putLength(1);
        if (bl2) {
            this.write(255);
        } else {
            this.write(0);
        }
    }

    public void putDerValue(DerValue derValue) throws IOException {
        derValue.encode(this);
    }

    public void putEnumerated(BigInt bigInt) throws IOException {
        this.write(10);
        this.a(bigInt);
    }

    public void putGeneralizedTime(Date date) throws IOException {
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        String string = "yyyyMMddHHmmss'Z'";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        simpleDateFormat.setTimeZone(timeZone);
        byte[] byArray = simpleDateFormat.format(date).getBytes();
        this.write(24);
        this.putLength(byArray.length);
        this.write(byArray);
    }

    public void putIA5String(String string) throws IOException {
        this.write(22);
        this.putLength(string.length());
        int n2 = 0;
        while (n2 < string.length()) {
            this.write((byte)string.charAt(n2));
            ++n2;
        }
    }

    public void putInteger(BigInt bigInt) throws IOException {
        this.write(2);
        this.a(bigInt);
    }

    public void putLength(int n2) throws IOException {
        if (n2 < 128) {
            this.write((byte)n2);
        } else if (n2 < 256) {
            this.write(-127);
            this.write((byte)n2);
        } else if (n2 < 65536) {
            this.write(-126);
            this.write((byte)(n2 >> 8));
            this.write((byte)n2);
        } else if (n2 < 0x1000000) {
            this.write(-125);
            this.write((byte)(n2 >> 16));
            this.write((byte)(n2 >> 8));
            this.write((byte)n2);
        } else {
            this.write(-124);
            this.write((byte)(n2 >> 24));
            this.write((byte)(n2 >> 16));
            this.write((byte)(n2 >> 8));
            this.write((byte)n2);
        }
    }

    public void putNull() throws IOException {
        this.write(5);
        this.putLength(0);
    }

    public void putOID(ObjectIdentifier objectIdentifier) throws IOException {
        objectIdentifier.a(this);
    }

    public void putOctetString(byte[] byArray) throws IOException {
        this.write((byte)4, byArray);
    }

    public void putOrderedSet(byte by2, DerEncoder[] derEncoderArray) throws IOException {
        this.a(by2, derEncoderArray, b);
    }

    private void a(byte by2, DerEncoder[] derEncoderArray, Comparator comparator) throws IOException {
        DerOutputStream[] derOutputStreamArray = new DerOutputStream[derEncoderArray.length];
        int n2 = 0;
        while (n2 < derEncoderArray.length) {
            derOutputStreamArray[n2] = new DerOutputStream();
            derEncoderArray[n2].derEncode(derOutputStreamArray[n2]);
            ++n2;
        }
        byte[][] byArray = new byte[derOutputStreamArray.length][];
        int n3 = 0;
        while (n3 < derOutputStreamArray.length) {
            byArray[n3] = derOutputStreamArray[n3].toByteArray();
            ++n3;
        }
        Arrays.sort(byArray, comparator);
        DerOutputStream derOutputStream = new DerOutputStream();
        int n4 = 0;
        while (n4 < derOutputStreamArray.length) {
            derOutputStream.write(byArray[n4]);
            ++n4;
        }
        this.write(by2, derOutputStream);
    }

    public void putOrderedSetOf(byte by2, DerEncoder[] derEncoderArray) throws IOException {
        this.a(by2, derEncoderArray, a);
    }

    public void putPrintableString(String string) throws IOException {
        this.write(19);
        this.putLength(string.length());
        int n2 = 0;
        while (n2 < string.length()) {
            this.write((byte)string.charAt(n2));
            ++n2;
        }
    }

    public void putSequence(DerValue[] derValueArray) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        int n2 = 0;
        while (n2 < derValueArray.length) {
            derValueArray[n2].encode(derOutputStream);
            ++n2;
        }
        this.write((byte)48, derOutputStream);
    }

    public void putSet(DerValue[] derValueArray) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        int n2 = 0;
        while (n2 < derValueArray.length) {
            derValueArray[n2].encode(derOutputStream);
            ++n2;
        }
        this.write((byte)49, derOutputStream);
    }

    public void putTag(byte by2, boolean bl2, byte by3) {
        byte by4 = (byte)(by2 | by3);
        if (bl2) {
            by4 = (byte)(by4 | 0x20);
        }
        this.write(by4);
    }

    public void putUTCTime(Date date) throws IOException {
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        String string = "yyMMddHHmmss'Z'";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        simpleDateFormat.setTimeZone(timeZone);
        byte[] byArray = simpleDateFormat.format(date).getBytes();
        this.write(23);
        this.putLength(byArray.length);
        this.write(byArray);
    }

    public void putUnalignedBitString(BitArray bitArray) throws IOException {
        byte[] byArray = bitArray.toByteArray();
        this.write(3);
        this.putLength(byArray.length + 1);
        this.write(byArray.length * 8 - bitArray.length());
        this.write(byArray);
    }

    public void write(byte by2, DerOutputStream derOutputStream) throws IOException {
        this.write(by2);
        this.putLength(derOutputStream.count);
        this.write(derOutputStream.buf, 0, derOutputStream.count);
    }

    public void write(byte by2, byte[] byArray) throws IOException {
        this.write(by2);
        this.putLength(byArray.length);
        this.write(byArray, 0, byArray.length);
    }

    public void writeImplicit(byte by2, DerOutputStream derOutputStream) throws IOException {
        this.write(by2);
        this.write(derOutputStream.buf, 1, derOutputStream.count - 1);
    }
}

