/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.security;

import com.sun.web.security.HttpAuthenticator;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUtils;

class FormAuthentication
extends HttpAuthenticator {
    static final String SECURITY_CHECK = "/j_security_check";
    static final String USERNAME_VAR = "j_username";
    static final String PASSWORD_VAR = "j_password";
    private static final boolean debug = false;
    private static final String ORIGINATING_URL = "OriginatingURL";
    private static final String LOGIN_URL = "LoginURL";
    public static final String AUTH_REALM = "AuthenticationRealm";
    private String loginPage = "login.jsp";
    private String errorPage = "loginError.html";
    private String originalURL;
    private String currentURL;
    private String loginURL;
    private String requestMethod;
    private boolean authenticate = false;

    public FormAuthentication(HttpServletRequest req, HttpServletResponse res) {
        super(req, res);
        String requestURI = HttpUtils.getRequestURL(req).toString();
        if (requestURI.endsWith(SECURITY_CHECK)) {
            this.authenticate = true;
        }
        int index = requestURI.lastIndexOf("/");
    }

    public boolean authenticate() throws IOException {
        boolean bl2;
        if (!this.shouldAuthenticate()) {
            return true;
        }
        HttpServletRequest req = this.getRequest();
        String user = req.getParameter(USERNAME_VAR);
        String passwd = req.getParameter(PASSWORD_VAR);
        try {
            boolean ret;
            if (user != null && passwd != null && (ret = this.authenticate(user, passwd))) {
                HttpServletResponse res = this.getResponse();
                String qstring = req.getQueryString();
                qstring = qstring == null ? "" : "?" + qstring;
                res.sendRedirect(res.encodeURL(String.valueOf(this.originalURL) + qstring));
                boolean bl3 = true;
                Object var6_9 = null;
                this.reset();
                return bl3;
            }
            bl2 = false;
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            this.reset();
            throw throwable;
        }
        Object var6_10 = null;
        this.reset();
        return bl2;
    }

    public String getErrorPage() {
        return this.errorPage;
    }

    public String getLoginPage() {
        return this.loginPage;
    }

    public void init() throws IOException {
        HttpServletRequest req = this.getRequest();
        HttpServletResponse res = this.getResponse();
        HttpSession session = req.getSession(true);
        this.currentURL = HttpUtils.getRequestURL(req).toString();
        this.loginURL = res.encodeURL(this.loginPage);
        this.requestMethod = req.getMethod();
        if (this.currentURL.endsWith(SECURITY_CHECK) && this.requestMethod.equals("POST")) {
            this.authenticate = true;
        }
        if (session.getAttribute(ORIGINATING_URL) == null) {
            session.setAttribute(AUTH_REALM, this);
            this.originalURL = this.currentURL;
            session.setAttribute(ORIGINATING_URL, this.originalURL);
            String qstring = req.getQueryString();
            qstring = qstring == null ? "" : "?" + qstring;
            res.sendRedirect(res.encodeURL(String.valueOf(this.loginURL) + qstring));
            throw new IOException("");
        }
        this.originalURL = (String)session.getAttribute(ORIGINATING_URL);
        if (!this.currentURL.endsWith(this.loginURL) && !this.authenticate) {
            String qstring;
            if (!this.currentURL.equals(this.originalURL)) {
                this.originalURL = this.currentURL;
                session.setAttribute(ORIGINATING_URL, this.originalURL);
            }
            qstring = (qstring = req.getQueryString()) == null ? "" : "?" + qstring;
            res.sendRedirect(res.encodeURL(String.valueOf(this.loginURL) + qstring));
            throw new IOException("");
        }
    }

    public void reset() {
        HttpSession session = this.getRequest().getSession(true);
        if (session.getAttribute(AUTH_REALM) != null) {
            session.removeAttribute(AUTH_REALM);
        }
        if (session.getAttribute(ORIGINATING_URL) != null) {
            session.removeAttribute(ORIGINATING_URL);
        }
    }

    public void sendError() throws IOException {
        String qstring = this.getRequest().getQueryString();
        qstring = qstring == null ? "" : "?" + qstring;
        HttpServletResponse res = this.getResponse();
        res.sendRedirect(res.encodeURL(String.valueOf(this.errorPage) + qstring));
    }

    public void setErrorPage(String errorPage) {
        this.errorPage = errorPage;
    }

    public void setLoginPage(String loginPage) {
        this.loginPage = loginPage;
    }

    protected boolean shouldAuthenticate() {
        return this.authenticate;
    }
}

