/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.tree;

import com.sun.xml.tree.AttributeNode;
import com.sun.xml.tree.AttributeSet;
import com.sun.xml.tree.DomEx;
import com.sun.xml.tree.ElementEx;
import com.sun.xml.tree.ParentNode;
import com.sun.xml.tree.TextNode;
import com.sun.xml.tree.XmlDocument;
import com.sun.xml.tree.XmlWriteContext;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ElementNode
extends ParentNode
implements ElementEx {
    private String tag;
    private AttributeSet attributes;
    private String idAttributeName;
    private Object userObject;
    private static final char[] tagStart = new char[]{'<', '/'};
    private static final char[] tagEnd = new char[]{' ', '/', '>'};

    void checkChildType(int n2) throws DOMException {
        switch (n2) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                return;
            }
        }
        throw new DomEx(3);
    }

    public Node cloneNode(boolean bl2) {
        try {
            ElementNode elementNode = (ElementNode)this.getOwnerDocument().createElement(this.tag);
            if (this.attributes != null) {
                elementNode.setAttributes(new AttributeSet(this.attributes, true));
            }
            if (bl2) {
                Node node;
                int n2 = 0;
                while ((node = this.item(n2)) != null) {
                    elementNode.appendChild(node.cloneNode(true));
                    ++n2;
                }
            }
            return elementNode;
        }
        catch (DOMException dOMException) {
            throw new RuntimeException(this.getMessage("EN-001"));
        }
    }

    public String getAttribute(String string) {
        return this.attributes == null ? "" : this.attributes.getValue(string);
    }

    public String getAttribute(String string, String string2) {
        if (this.attributes == null) {
            return "";
        }
        Attr attr = this.getAttributeNode(string, string2);
        if (attr == null) {
            return "";
        }
        return attr.getValue();
    }

    public Attr getAttributeNode(String string) {
        if (this.attributes != null) {
            return (Attr)this.attributes.getNamedItem(string);
        }
        return null;
    }

    public Attr getAttributeNode(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        if (this.attributes != null) {
            int n2 = 0;
            while (true) {
                String string3;
                AttributeNode attributeNode;
                if ((attributeNode = (AttributeNode)this.attributes.item(n2)) == null) {
                    return null;
                }
                if (string2.equals(attributeNode.getName()) && (string3 = attributeNode.getNamespace()) != null && string3.equals(string)) {
                    return attributeNode;
                }
                ++n2;
            }
        }
        return null;
    }

    public NamedNodeMap getAttributes() {
        if (this.attributes == null) {
            this.attributes = new AttributeSet(this);
        }
        return this.attributes;
    }

    public String getIdAttributeName() {
        return this.idAttributeName;
    }

    public String getLocalName() {
        int n2 = this.tag.indexOf(58);
        if (n2 < 0) {
            return this.tag;
        }
        return this.tag.substring(n2 + 1);
    }

    public String getNamespace() {
        String string = this.getPrefix();
        if (string == null) {
            return this.getInheritedAttribute("xmlns");
        }
        if ("xml".equals(string) || "xmlns".equals(string)) {
            return null;
        }
        String string2 = this.getInheritedAttribute("xmlns:" + string);
        if (string2 == null) {
            throw new IllegalStateException(this.getMessage("EN-000", new Object[]{string}));
        }
        return string2;
    }

    public String getNodeName() {
        return this.tag;
    }

    public short getNodeType() {
        return 1;
    }

    public String getPrefix() {
        int n2 = this.tag.indexOf(58);
        return n2 < 0 ? null : this.tag.substring(0, n2);
    }

    public String getTagName() {
        return this.tag;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void normalize() {
        Node node;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.readonly) {
            throw new DomEx(7);
        }
        int n2 = 0;
        while ((node = this.item(n2)) != null) {
            switch (node.getNodeType()) {
                case 1: {
                    ((Element)node).normalize();
                    break;
                }
                case 3: {
                    Node node2 = this.item(n2 + 1);
                    if (node2 == null || node2.getNodeType() != 3) {
                        if (!bl3) {
                            bl2 = "preserve".equals(this.getInheritedAttribute("xml:space"));
                            bl3 = true;
                        }
                        if (bl2) break;
                        char[] cArray = ((TextNode)node).data;
                        if (cArray == null || cArray.length == 0) {
                            this.removeChild(node);
                            --n2;
                            break;
                        }
                        int n3 = this.removeWhiteSpaces(cArray);
                        if (n3 == cArray.length) break;
                        char[] cArray2 = new char[n3];
                        System.arraycopy(cArray, 0, cArray2, 0, n3);
                        ((TextNode)node).data = cArray2;
                        break;
                    }
                    ((TextNode)node).joinNextText();
                    --n2;
                    break;
                }
            }
            ++n2;
        }
    }

    public void removeAttribute(String string) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (this.attributes == null) {
            throw new DomEx(8);
        }
        this.attributes.removeNamedItem(string);
    }

    public Attr removeAttributeNode(Attr attr) throws DOMException {
        if (this.isReadonly()) {
            throw new DomEx(7);
        }
        Attr attr2 = this.getAttributeNode(attr.getNodeName());
        if (attr2 == null) {
            throw new DomEx(8);
        }
        this.removeAttribute(attr2.getNodeName());
        return attr2;
    }

    public int removeWhiteSpaces(char[] cArray) {
        int n2 = 0;
        int n3 = 0;
        block0: while (n3 < cArray.length) {
            int n4;
            boolean bl2 = false;
            if ((n4 = cArray[n3++]) == 32 || n4 == 9 || n4 == 10 || n4 == 13) {
                n4 = 32;
                bl2 = true;
            }
            cArray[n2++] = n4;
            if (!bl2) continue;
            while (n3 < cArray.length) {
                n4 = cArray[n3];
                if (n4 != 32 && n4 != 9 && n4 != 10 && n4 != 13) continue block0;
                ++n3;
            }
        }
        return n2;
    }

    public void setAttribute(String string, String string2) throws DOMException {
        AttributeNode attributeNode;
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (this.attributes == null) {
            this.attributes = new AttributeSet(this);
        }
        if ((attributeNode = (AttributeNode)this.attributes.getNamedItem(string)) != null) {
            attributeNode.setNodeValue(string2);
        } else {
            attributeNode = new AttributeNode(string, string2, true, null);
            attributeNode.setOwnerDocument((XmlDocument)this.getOwnerDocument());
            this.attributes.setNamedItem(attributeNode);
        }
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (!(attr instanceof AttributeNode)) {
            throw new DomEx(4);
        }
        if (this.attributes == null) {
            this.attributes = new AttributeSet(this);
        }
        return (Attr)this.attributes.setNamedItem(attr);
    }

    void setAttributes(AttributeSet attributeSet) {
        AttributeSet attributeSet2 = this.attributes;
        if (attributeSet2 != null && attributeSet2.isReadonly()) {
            throw new DomEx(7);
        }
        if (attributeSet != null) {
            attributeSet.setNameScope(this);
        }
        this.attributes = attributeSet;
        if (attributeSet2 != null) {
            attributeSet2.setNameScope(null);
        }
    }

    public void setIdAttributeName(String string) {
        if (this.readonly) {
            throw new DomEx(7);
        }
        this.idAttributeName = string;
    }

    public void setPrefix(String string) {
        int n2 = this.tag.indexOf(58);
        if (string == null) {
            if (n2 < 0) {
                return;
            }
            this.tag = this.tag.substring(n2 + 1);
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(':');
        if (n2 < 0) {
            stringBuffer.append(this.tag);
        } else {
            stringBuffer.append(this.tag.substring(n2 + 1));
        }
        this.tag = stringBuffer.toString();
    }

    public void setReadonly(boolean bl2) {
        if (this.attributes != null) {
            this.attributes.setReadonly();
        }
        super.setReadonly(bl2);
    }

    protected void setTag(String string) {
        this.tag = string;
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }

    public String toString() {
        try {
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            XmlWriteContext xmlWriteContext = new XmlWriteContext(charArrayWriter);
            this.writeXml(xmlWriteContext);
            return charArrayWriter.toString();
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    public void trimToSize() {
        super.trimToSize();
        if (this.attributes != null) {
            this.attributes.trimToSize();
        }
    }

    public void write(Writer writer) throws IOException {
        this.writeXml(new XmlWriteContext(writer));
    }

    public void writeXml(XmlWriteContext xmlWriteContext) throws IOException {
        Writer writer = xmlWriteContext.getWriter();
        if (this.tag == null) {
            throw new IllegalStateException(this.getMessage("EN-002"));
        }
        writer.write(tagStart, 0, 1);
        writer.write(this.tag);
        if (this.attributes != null) {
            this.attributes.writeXml(xmlWriteContext);
        }
        if (!this.hasChildNodes()) {
            writer.write(tagEnd, 0, 3);
        } else {
            writer.write(tagEnd, 2, 1);
            this.writeChildrenXml(xmlWriteContext);
            writer.write(tagStart, 0, 2);
            writer.write(this.tag);
            writer.write(tagEnd, 2, 1);
        }
    }
}

