/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.tree;

import com.sun.xml.tree.XmlDocument;
import java.io.IOException;
import java.io.Writer;

public class XmlWriteContext {
    private Writer writer;
    private int indentLevel;
    private boolean prettyOutput;

    public XmlWriteContext(Writer writer) {
        this.writer = writer;
    }

    public XmlWriteContext(Writer writer, int n2) {
        this.writer = writer;
        this.prettyOutput = true;
        this.indentLevel = n2;
    }

    public int getIndentLevel() {
        return this.indentLevel;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public boolean isEntityDeclared(String string) {
        return "amp".equals(string) || "lt".equals(string) || "gt".equals(string) || "quot".equals(string) || "apos".equals(string);
    }

    public boolean isPrettyOutput() {
        return this.prettyOutput;
    }

    public void printIndent() throws IOException {
        int n2 = this.indentLevel;
        if (!this.prettyOutput) {
            return;
        }
        this.writer.write(XmlDocument.eol);
        while (n2 >= 8) {
            this.writer.write(9);
            n2 -= 8;
        }
        while (n2-- > 0) {
            this.writer.write(32);
        }
    }

    public void setIndentLevel(int n2) {
        this.indentLevel = n2;
    }
}

