/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.GeneratorBase;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.ServiceMethodPhase;
import org.apache.jasper.compiler.ServletWriter;

public class IncludeGenerator
extends GeneratorBase
implements ServiceMethodPhase {
    String page;
    boolean isExpression = false;
    Hashtable params;

    public IncludeGenerator(Hashtable attrs, Hashtable param) throws JasperException {
        if (attrs.size() != 2) {
            throw new JasperException(Constants.getString("jsp.error.include.tag"));
        }
        this.page = (String)attrs.get("page");
        if (this.page == null) {
            throw new JasperException(Constants.getString("jsp.error.include.tag"));
        }
        String flush = (String)attrs.get("flush");
        if (flush == null) {
            throw new JasperException(Constants.getString("jsp.error.include.noflush"));
        }
        if (!flush.equals("true")) {
            throw new JasperException(Constants.getString("jsp.error.include.badflush"));
        }
        this.params = param;
        this.isExpression = JspUtil.isExpression(this.page);
    }

    public void generate(ServletWriter writer, Class phase) {
        boolean initial = true;
        String sep = "?";
        writer.println("{");
        writer.pushIndent();
        writer.println("String _jspx_qStr = \"\";");
        writer.println("out.flush();");
        if (this.params.size() > 0) {
            Enumeration en2 = this.params.keys();
            while (en2.hasMoreElements()) {
                String key = (String)en2.nextElement();
                String[] value = (String[])this.params.get(key);
                if (initial) {
                    sep = "?";
                    initial = false;
                } else {
                    sep = "&";
                }
                if (value.length == 1 && JspUtil.isExpression(value[0])) {
                    writer.println("_jspx_qStr = _jspx_qStr + \"" + sep + key + "=\" + " + JspUtil.getExpr(value[0]) + ";");
                    continue;
                }
                if (value.length == 1) {
                    writer.println("_jspx_qStr = _jspx_qStr + \"" + sep + key + "=\" + \"" + value[0] + "\";");
                    continue;
                }
                writer.println("String [] _tmpS = new String[" + value.length + "];");
                int i2 = 0;
                while (i2 < value.length) {
                    if (!JspUtil.isExpression(value[i2])) {
                        writer.println("_jspx_qStr = _jspx_qStr + \"" + sep + key + "=\" + \"" + value[i2] + "\";");
                    } else {
                        writer.println("_jspx_qStr = _jspx_qStr + \"" + sep + key + "=\" +" + JspUtil.getExpr(value[i2]) + ";");
                    }
                    if (sep.equals("?")) {
                        sep = "&";
                    }
                    ++i2;
                }
            }
        }
        if (!this.isExpression) {
            writer.println("pageContext.include(" + writer.quoteString(this.page) + " + _jspx_qStr);");
        } else {
            writer.println("pageContext.include(" + JspUtil.getExpr(this.page) + " + _jspx_qStr);");
        }
        writer.popIndent();
        writer.println("}");
    }
}

