/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.SingleThreadModel;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.HttpServletRequestFacade;
import org.apache.tomcat.core.HttpServletResponseFacade;
import org.apache.tomcat.core.InterceptorException;
import org.apache.tomcat.core.InvocationHandler;
import org.apache.tomcat.core.ServiceInterceptor;

class ServiceInvocationHandler
extends InvocationHandler {
    private HttpServletRequestFacade request;
    private HttpServletResponseFacade response;

    ServiceInvocationHandler(Context context, Servlet servlet, HttpServletRequestFacade request, HttpServletResponseFacade response) {
        super(context, servlet);
        this.request = request;
        this.response = response;
    }

    void method() throws ServletException, IOException {
        if (this.servlet instanceof SingleThreadModel) {
            Servlet servlet = this.servlet;
            synchronized (servlet) {
                this.servlet.service(this.request, this.response);
            }
        } else {
            this.servlet.service(this.request, this.response);
        }
    }

    void postInvoke(Object interceptor) throws InterceptorException {
        ((ServiceInterceptor)interceptor).postInvoke(this.context, this.servlet, this.request, this.response);
    }

    void preInvoke(Object interceptor) throws InterceptorException {
        ((ServiceInterceptor)interceptor).preInvoke(this.context, this.servlet, this.request, this.response);
    }
}

