/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.protocol;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class WARConnection
extends URLConnection {
    private URL warURL = null;
    private String path = null;
    private byte[] buffer = null;
    private long size = 0L;
    private long time = 0L;

    public WARConnection(URL url) throws MalformedURLException {
        super(url);
        this.parseSpecs(url);
    }

    public void connect() throws IOException {
        ZipInputStream zis = new ZipInputStream(this.warURL.openStream());
        ZipEntry ze = null;
        while ((ze = zis.getNextEntry()) != null) {
            if (!this.path.equals(ze.getName())) continue;
            this.size = ze.getSize();
            this.time = ze.getTime();
            int bufferSize = 128;
            byte[] buffer = new byte[bufferSize];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int length = 0;
            int totalLength = 0;
            while ((length = zis.read(buffer)) >= 0) {
                baos.write(buffer, 0, length);
                totalLength += length;
            }
            this.buffer = baos.toByteArray();
            if (this.size >= 0L) break;
            this.size = totalLength;
            break;
        }
        zis.close();
    }

    public int getContentLength() {
        Long l2 = new Long(this.size);
        return l2.intValue();
    }

    public String getContentType() {
        return URLConnection.getFileNameMap().getContentTypeFor(this.path);
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (this.buffer != null) {
            return new ByteArrayInputStream(this.buffer);
        }
        String msg = "error";
        throw new IOException(msg);
    }

    public long getLastModified() {
        return this.time;
    }

    private void parseSpecs(URL url) throws MalformedURLException {
        int separator;
        String spec = url.getFile();
        if (spec.startsWith("/")) {
            spec = spec.substring(1);
        }
        if ((separator = spec.indexOf(33)) == -1) {
            String msg = "bad url: " + url;
            throw new MalformedURLException(msg);
        }
        this.warURL = new URL(spec.substring(0, separator++));
        if (++separator != spec.length()) {
            this.path = spec.substring(separator, spec.length());
        }
    }
}

