/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.security.file;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.tomcat.security.file.FileRealmDatabase;
import org.apache.tomcat.security.file.FileRealmGroup;

final class FileRealmUser
implements Principal {
    private FileRealmDatabase database = null;
    private Hashtable groups = new Hashtable();
    private String name = null;
    private byte[] password = new byte[0];
    private Hashtable roles = new Hashtable();

    FileRealmUser(FileRealmDatabase database, String name, String password) {
        this.database = database;
        this.name = name;
        this.setPassword(password);
        database.addUser(this);
    }

    FileRealmUser(FileRealmDatabase database, String name, byte[] password) {
        this.database = database;
        this.name = name;
        this.setPassword(password);
        database.addUser(this);
    }

    public void addGroup(FileRealmGroup group) {
        group.addUser(this);
        this.groups.put(group.getName(), group);
    }

    public void addRole(String role) {
        this.database.addRole(role);
        this.roles.put(role, role);
    }

    public boolean authenticate(String password) {
        return MessageDigest.isEqual(this.password, this.encrypt(password));
    }

    public void destroy() {
        this.database.remove(this);
    }

    private byte[] encrypt(String password) {
        if (password == null) {
            return new byte[0];
        }
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return new byte[0];
        }
        int i2 = 0;
        while (i2 < password.length()) {
            char ch2 = password.charAt(i2);
            digest.update((byte)(ch2 & 0x7F));
            ++i2;
        }
        return digest.digest();
    }

    public Enumeration getGroups() {
        return this.groups.elements();
    }

    public String getName() {
        return this.name;
    }

    public byte[] getPassword() {
        return this.password;
    }

    public Enumeration getRoles() {
        return this.roles.keys();
    }

    public boolean hasGroup(FileRealmGroup group) {
        return this.groups.get(group.getName()) != null;
    }

    public boolean hasRole(String role) {
        return this.roles.get(role) != null;
    }

    public void remove(String role) {
        this.roles.remove(role);
    }

    public void remove(FileRealmGroup group) {
        this.groups.remove(group.getName());
        group.remove(this);
    }

    public void setPassword(String password) {
        this.password = this.encrypt(password);
    }

    public void setPassword(byte[] password) {
        this.password = new byte[password.length];
        int i2 = 0;
        while (i2 < this.password.length) {
            this.password[i2] = password[i2];
            ++i2;
        }
    }
}

