/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.server;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import org.apache.tomcat.core.BufferedServletInputStream;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.server.Endpoint;
import org.apache.tomcat.server.EndpointManager;
import org.apache.tomcat.server.HttpRequestAdapter;
import org.apache.tomcat.server.HttpResponseAdapter;
import org.apache.tomcat.server.HttpServer;
import org.apache.tomcat.util.StringManager;

class ConnectionHandler
extends Thread {
    protected StringManager sm = StringManager.getManager("org.apache.tomcat.server");
    protected EndpointManager manager;
    protected Request request = new Request();
    protected HttpRequestAdapter reqA = new HttpRequestAdapter();
    protected HttpResponseAdapter resA = new HttpResponseAdapter();
    protected Response response = new Response();
    protected Endpoint endpoint;
    protected Socket socket;

    ConnectionHandler() {
    }

    ConnectionHandler(EndpointManager manager) {
        this.manager = manager;
    }

    void recycle() {
        this.request.recycle();
        this.reqA.recycle();
        this.response.recycle();
        this.endpoint = null;
        this.socket = null;
    }

    public void run() {
        if (this.endpoint == null || this.socket == null) {
            String msg = this.sm.getString("conhandler.run.ise");
            throw new IllegalStateException(msg);
        }
        try {
            try {
                boolean count = true;
                this.request.setRequestAdapter(this.reqA);
                this.response.setResponseAdapter(this.resA);
                this.reqA.setSocket(this.socket);
                this.resA.setOutputStream(this.socket.getOutputStream());
                while (this.reqA.hasMoreRequests()) {
                    this.request.setResponse(this.response);
                    this.response.setRequest(this.request);
                    this.reqA.readNextRequest(this.response);
                    if (this.request.getProtocol() == null) {
                        this.response.setOmitHeaders(true);
                    }
                    if (this.response.getStatus() >= 400) {
                        this.response.finish();
                        this.request.recycle();
                        this.response.recycle();
                        break;
                    }
                    String hostHeader = this.request.getHeader("host");
                    if (hostHeader != null) {
                        int i2 = hostHeader.indexOf(58);
                        if (i2 > -1) {
                            hostHeader = hostHeader.substring(0, i2);
                        }
                        this.request.setServerName(hostHeader);
                    } else {
                        InetAddress localAddress = this.socket.getLocalAddress();
                        this.request.setServerName(localAddress.getHostName());
                    }
                    int contentLength = this.request.getIntHeader("content-length");
                    if (contentLength != -1) {
                        BufferedServletInputStream sis = (BufferedServletInputStream)this.request.getInputStream();
                        sis.setLimit(contentLength);
                    }
                    HttpServer server = this.manager.resolveServer(this.endpoint, hostHeader);
                    String path = this.request.getRequestURI();
                    int index = path.indexOf("?");
                    this.response.setServerHeader(server.getServerHeader());
                    if (index > 0) {
                        path = path.substring(0, index);
                    }
                    Context ctx = server.getContextByPath(path);
                    String ctxPath = ctx.getPath();
                    String pathInfo = path.substring(ctxPath.length(), path.length());
                    ctx.handleRequest(this.request, this.response);
                    this.response.finish();
                    this.request.recycle();
                    this.response.recycle();
                    this.reqA.recycle();
                    this.resA.recycle();
                }
                try {
                    InputStream is = this.socket.getInputStream();
                    int available = is.available();
                    if (available > 1) {
                        is.skip(available);
                    }
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (SocketException socketException) {}
            }
            catch (SocketException socketException) {
                System.out.println("Connection aborted by client");
            }
            catch (Exception e10) {
                System.out.println("HANDLER THREAD PROBLEM: " + e10);
                e10.printStackTrace();
            }
            Object var2_14 = null;
        }
        catch (Throwable throwable) {
            Object var2_15 = null;
            try {
                this.socket.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            this.socket.close();
        }
        catch (IOException iOException) {}
        this.manager.returnHandler(this);
    }

    void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    void setEndpointManager(EndpointManager manager) {
        this.manager = manager;
    }

    void setSocket(Socket socket) {
        this.socket = socket;
    }
}

