/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.server;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import org.apache.tomcat.core.BufferedServletInputStream;
import org.apache.tomcat.core.RequestAdapterImpl;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.util.StringManager;

public class HttpRequestAdapter
extends RequestAdapterImpl {
    private StringManager sm = StringManager.getManager("org.apache.tomcat.server");
    private Socket socket;
    private boolean moreRequests = false;
    InputStream sin;

    public int doRead() throws IOException {
        return this.sin.read();
    }

    public int doRead(byte[] b10, int off, int len) throws IOException {
        return this.sin.read(b10, off, len);
    }

    public String getRemoteAddr() {
        return this.socket.getInetAddress().getHostAddress();
    }

    public String getRemoteHost() {
        return this.socket.getInetAddress().getHostName();
    }

    public int getServerPort() {
        return this.socket.getLocalPort();
    }

    public Socket getSocket() {
        return this.socket;
    }

    public boolean hasMoreRequests() {
        return this.moreRequests;
    }

    public void processRequestLine(Response response, String line) {
        String s2;
        String buffer = line.trim();
        int firstDelim = buffer.indexOf(32);
        int lastDelim = buffer.lastIndexOf(32);
        if (firstDelim == -1 && lastDelim == -1 && buffer.trim().length() > 0) {
            firstDelim = buffer.trim().length();
            lastDelim = buffer.trim().length();
        }
        if (firstDelim != lastDelim && (s2 = buffer.substring(firstDelim, lastDelim)).trim().length() == 0) {
            firstDelim = lastDelim;
        }
        String requestString = null;
        if (firstDelim != lastDelim) {
            this.method = buffer.substring(0, firstDelim).trim();
            this.protocol = buffer.substring(lastDelim + 1).trim();
            requestString = buffer.substring(firstDelim + 1, lastDelim).trim();
        } else if (firstDelim != -1 && lastDelim != -1) {
            this.method = buffer.substring(0, firstDelim).trim();
            this.protocol = null;
            if (lastDelim < buffer.length()) {
                requestString = buffer.substring(lastDelim + 1).trim();
            }
        }
        if (this.protocol != null && !this.protocol.toLowerCase().startsWith("http/")) {
            requestString = String.valueOf(requestString) + " " + this.protocol;
            this.protocol = null;
        }
        int requestErrorCode = 0;
        try {
            int len = line.length();
            if (len < 2) {
                requestErrorCode = 400;
            } else if (line.charAt(len - 1) != '\n') {
                requestErrorCode = 414;
                this.protocol = "HTTP/1.0";
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        if (requestErrorCode == 0 && (requestString == null || requestString.indexOf(32) > -1 || requestString.indexOf(47) != 0)) {
            requestErrorCode = 400;
        }
        if (requestErrorCode != 0) {
            try {
                response.sendError(requestErrorCode);
            }
            catch (IOException iOException) {}
            return;
        }
        int indexQ = requestString.indexOf("?");
        int rLen = requestString.length();
        if (indexQ > -1 && indexQ < rLen) {
            this.queryString = requestString.substring(indexQ + 1, requestString.length());
            this.requestURI = requestString.substring(0, indexQ);
        } else {
            this.requestURI = requestString;
        }
    }

    public void readNextRequest(Response response) throws IOException {
        String line = "";
        byte[] buf = new byte[1024];
        int count = this.in.readLine(buf, 0, buf.length);
        if (count >= 0) {
            line = new String(buf, 0, count);
        }
        this.processRequestLine(response, line);
        if (response.getStatus() >= 400) {
            return;
        }
        if (this.protocol != null) {
            this.headers.read(this.in);
        }
        this.moreRequests = false;
    }

    public void setSocket(Socket socket) throws IOException {
        this.sin = socket.getInputStream();
        this.in = new BufferedServletInputStream(this);
        this.socket = socket;
        this.moreRequests = true;
    }
}

