/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.service.http;

import java.net.InetAddress;
import java.net.ServerSocket;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.ServerConnector;
import org.apache.tomcat.net.ServerSocketFactory;
import org.apache.tomcat.service.TcpEndpoint;
import org.apache.tomcat.service.http.HttpConnectionHandler;

public class HttpAdapter
implements ServerConnector {
    String handlerClassName;
    TcpEndpoint ep = new TcpEndpoint();
    HttpConnectionHandler con = new HttpConnectionHandler();
    ContextManager cm;
    private InetAddress address;
    int vport = 8080;
    private ServerSocketFactory socketFactory;
    private ServerSocket serverSocket;
    boolean running = true;

    public HttpAdapter() {
        this.ep.setConnectionHandler(this.con);
    }

    public Object getAttribute(String prop) {
        if ("vhost_name".equals(prop)) {
            return null;
        }
        if ("vhost_port".equals(prop)) {
            return new Integer(this.vport);
        }
        if ("vhost_address".equals(prop)) {
            return this.address;
        }
        if ("server".equals(prop)) {
            return null;
        }
        if ("socketFactory".equals(prop)) {
            return this.socketFactory;
        }
        return null;
    }

    public void setAttribute(String prop, Object value) {
        "vhost_name".equals(prop);
        if ("vhost_port".equals(prop)) {
            this.vport = (Integer)value;
        }
        if ("vhost_address".equals(prop)) {
            this.address = (InetAddress)value;
        }
        "server".equals(prop);
        if ("socketFactory".equals(prop)) {
            this.socketFactory = (ServerSocketFactory)value;
        }
    }

    public void setContextManager(ContextManager ctx) {
        this.cm = ctx;
        this.con.setContextManager(ctx);
    }

    public void setProperty(String prop, String value) {
        if ("vhost_port".equals(prop)) {
            this.vport = this.string2Int(value);
        }
    }

    public void start() throws Exception {
        if (this.con == null) {
            throw new Exception("Invalid ConnectionHandler");
        }
        this.ep.setPort(this.vport);
        if (this.socketFactory != null) {
            this.ep.setServerSocketFactory(this.socketFactory);
        }
        this.ep.startEndpoint();
    }

    public void stop() throws Exception {
        this.ep.stopEndpoint();
    }

    private int string2Int(String val) {
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }
}

