/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.shell.deployment;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.tomcat.util.URLUtil;

public class ContextConfig {
    private String path = "";
    private URL documentBase = null;
    private int defaultSessionTimeOut = 30;
    private boolean isWARExpanded = true;
    private boolean isWARValidated = false;
    private boolean isInvokerEnabled = true;
    private boolean isWorkDirPersistent = false;

    ContextConfig() {
    }

    public int getDefaultSessionTimeOut() {
        return this.defaultSessionTimeOut;
    }

    public URL getDocumentBase() {
        return this.documentBase;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isInvokerEnabled() {
        return this.isInvokerEnabled;
    }

    public boolean isWARExpanded() {
        return this.isWARExpanded;
    }

    public boolean isWARValidated() {
        return this.isWARValidated;
    }

    public boolean isWorkDirPersistent() {
        return this.isWorkDirPersistent;
    }

    void setDefaultSessionTimeOut(int defaultSessionTimeOut) {
        this.defaultSessionTimeOut = defaultSessionTimeOut;
    }

    void setDefaultSessionTimeOut(String defaultSessionTimeOut) {
        try {
            this.setDefaultSessionTimeOut(Integer.parseInt(defaultSessionTimeOut));
        }
        catch (NumberFormatException numberFormatException) {}
    }

    void setDocumentBase(String documentBase) {
        URL db2 = null;
        try {
            db2 = URLUtil.resolve(documentBase);
        }
        catch (MalformedURLException malformedURLException) {}
        this.setDocumentBase(db2);
    }

    void setDocumentBase(URL documentBase) {
        URL db2 = null;
        try {
            db2 = URLUtil.resolve(documentBase.toString());
        }
        catch (MalformedURLException malformedURLException) {}
        this.documentBase = db2;
    }

    void setIsInvokerEnabled(String isInvokerEnabled) {
        this.setIsInvokerEnabled(Boolean.valueOf(isInvokerEnabled));
    }

    void setIsInvokerEnabled(boolean isInvokerEnabled) {
        this.isInvokerEnabled = isInvokerEnabled;
    }

    void setIsWARExpanded(String isWARExpanded) {
        this.setIsWARExpanded(Boolean.valueOf(isWARExpanded));
    }

    void setIsWARExpanded(boolean isWARExpanded) {
        this.isWARExpanded = isWARExpanded;
    }

    void setIsWARValidated(String isWARValidated) {
        this.setIsWARValidated(Boolean.valueOf(isWARValidated));
    }

    void setIsWARValidated(boolean isWARValidated) {
        this.isWARValidated = isWARValidated;
    }

    void setIsWorkDirPersistent(String isWorkDirPersistent) {
        this.setIsWorkDirPersistent(Boolean.valueOf(isWorkDirPersistent));
    }

    void setIsWorkDirPersistent(boolean isWorkDirPersistent) {
        this.isWorkDirPersistent = isWorkDirPersistent;
    }

    void setPath(String path) {
        String p2 = path;
        if (p2.equals("") || p2.equals("/")) {
            p2 = "";
        }
        this.path = p2;
    }
}

