/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.png;

import java.awt.image.IndexColorModel;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataFormat;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

public class PNGMetadata
extends IIOMetadata
implements Cloneable {
    public static final String nativeMetadataFormatName = "com.sun.imageio.png_1.0";
    public static final String[] metadataFormatNames = new String[]{"com.sun.imageio.png_1.0"};
    public static final String[] IHDR_colorTypeNames = new String[]{"Grayscale", null, "RGB", "Palette", "GrayAlpha", null, "RGBAlpha"};
    public static final String[] IHDR_bitDepths = new String[]{"1", "2", "4", "8", "16"};
    public static final String[] IHDR_compressionMethodNames = new String[]{"deflate"};
    public static final String[] IHDR_filterMethodNames = new String[]{"adaptive"};
    public static final String[] IHDR_interlaceMethodNames = new String[]{"none", "adam7"};
    public static final String[] iCCP_compressionMethodNames = new String[]{"deflate"};
    public static final String[] zTXt_compressionMethodNames = new String[]{"deflate"};
    public static final String[] unitSpecifierNames = new String[]{"meter", "unknown"};
    public static final String[] renderingIntentNames = new String[]{"Perceptual", "Relative colorimetric", "Saturation", "Absolute colorimetric"};
    public boolean IHDR_present;
    public int IHDR_width;
    public int IHDR_height;
    public int IHDR_bitDepth;
    public int IHDR_colorType;
    public int IHDR_compressionMethod;
    public int IHDR_filterMethod;
    public int IHDR_interlaceMethod;
    public boolean PLTE_present;
    public byte[] PLTE_red;
    public byte[] PLTE_green;
    public byte[] PLTE_blue;
    public boolean bKGD_present;
    public int bKGD_colorType;
    public int bKGD_index;
    public int bKGD_gray;
    public int bKGD_red;
    public int bKGD_green;
    public int bKGD_blue;
    public boolean cHRM_present;
    public int cHRM_whitePointX;
    public int cHRM_whitePointY;
    public int cHRM_redX;
    public int cHRM_redY;
    public int cHRM_greenX;
    public int cHRM_greenY;
    public int cHRM_blueX;
    public int cHRM_blueY;
    public boolean gAMA_present;
    public int gAMA_gamma;
    public boolean hIST_present;
    public char[] hIST_histogram;
    public boolean iCCP_present;
    public String iCCP_profileName;
    public int iCCP_compressionMethod;
    public byte[] iCCP_compressedProfile;
    public ArrayList iTXt_keyword = new ArrayList();
    public ArrayList iTXt_compressionFlag = new ArrayList();
    public ArrayList iTXt_compressionMethod = new ArrayList();
    public ArrayList iTXt_languageTag = new ArrayList();
    public ArrayList iTXt_translatedKeyword = new ArrayList();
    public ArrayList iTXt_text = new ArrayList();
    public boolean pHYs_present;
    public int pHYs_pixelsPerUnitXAxis;
    public int pHYs_pixelsPerUnitYAxis;
    public int pHYs_unitSpecifier;
    public boolean sBIT_present;
    public int sBIT_colorType;
    public int sBIT_grayBits;
    public int sBIT_redBits;
    public int sBIT_greenBits;
    public int sBIT_blueBits;
    public int sBIT_alphaBits;
    public boolean sPLT_present;
    public String sPLT_paletteName;
    public int sPLT_sampleDepth;
    public int[] sPLT_red;
    public int[] sPLT_green;
    public int[] sPLT_blue;
    public int[] sPLT_alpha;
    public int[] sPLT_frequency;
    public boolean sRGB_present;
    public int sRGB_renderingIntent;
    public ArrayList tEXt_keyword = new ArrayList();
    public ArrayList tEXt_text = new ArrayList();
    public boolean tIME_present;
    public int tIME_year;
    public int tIME_month;
    public int tIME_day;
    public int tIME_hour;
    public int tIME_minute;
    public int tIME_second;
    public boolean tRNS_present;
    public int tRNS_colorType;
    public byte[] tRNS_alpha;
    public int tRNS_gray;
    public int tRNS_red;
    public int tRNS_green;
    public int tRNS_blue;
    public ArrayList zTXt_keyword = new ArrayList();
    public ArrayList zTXt_compressionMethod = new ArrayList();
    public ArrayList zTXt_compressedText = new ArrayList();
    public ArrayList unknownChunkType = new ArrayList();
    public ArrayList unknownChunkData = new ArrayList();

    public PNGMetadata() {
        super(nativeMetadataFormatName, metadataFormatNames);
    }

    public PNGMetadata(IIOMetadata iIOMetadata) {
    }

    /*
     * Unable to fully structure code
     */
    public void initialize(ImageTypeSpecifier var1_1) {
        block30: {
            block28: {
                block29: {
                    var2_2 = var1_1.getColorModel();
                    var3_3 = var1_1.getSampleModel();
                    var4_4 = var3_3.getSampleSize();
                    var5_5 = var4_4[0];
                    var6_6 = 1;
                    while (var6_6 < var4_4.length) {
                        if (var4_4[var6_6] != var5_5) {
                            throw new RuntimeException();
                        }
                        ++var6_6;
                    }
                    if (var5_5 > 2 && var5_5 < 4) {
                        var5_5 = 4;
                    } else if (var5_5 > 4 && var5_5 < 8) {
                        var5_5 = 8;
                    } else if (var5_5 > 8 && var5_5 < 16) {
                        var5_5 = 16;
                    } else if (var5_5 > 16) {
                        throw new RuntimeException();
                    }
                    this.IHDR_bitDepth = var5_5;
                    var7_7 = var3_3.getNumBands();
                    if (!(var2_2 instanceof IndexColorModel)) break block28;
                    var8_8 = (IndexColorModel)var2_2;
                    var9_9 = var8_8.getMapSize();
                    var10_10 = new byte[var9_9];
                    var8_8.getReds(var10_10);
                    var11_11 = new byte[var9_9];
                    var8_8.getGreens(var11_11);
                    var12_12 = new byte[var9_9];
                    var8_8.getBlues(var12_12);
                    var13_13 = false;
                    if (!this.IHDR_present || this.IHDR_colorType != 3) {
                        var13_13 = true;
                        var14_14 = 255 / ((1 << this.IHDR_bitDepth) - 1);
                        var15_15 = 0;
                        while (var15_15 < var9_9) {
                            var16_16 = var10_10[var15_15];
                            if (var16_16 != (int)(var15_15 * var14_14) || var16_16 != var11_11[var15_15] || var16_16 != var12_12[var15_15]) {
                                var13_13 = false;
                                break;
                            }
                            ++var15_15;
                        }
                    }
                    var14_14 = 0;
                    var15_15 = 0;
                    var16_16 = -1;
                    if (!var2_2.hasAlpha()) break block29;
                    var14_14 = 1;
                    var17_17 = new byte[var9_9];
                    var8_8.getAlphas(var17_17);
                    var15_15 = 1;
                    var18_18 = 0;
                    while (var18_18 < var9_9) {
                        var19_19 = var17_17[var18_18];
                        if (var19_19 != 0) ** GOTO lbl63
                        if (var16_16 == -1) {
                            var15_15 = 1;
                            var16_16 = var18_18;
                        } else {
                            var15_15 = 0;
                            break;
lbl63:
                            // 1 sources

                            if (var19_19 != -1) {
                                var15_15 = 0;
                                break;
                            }
                        }
                        ++var18_18;
                    }
                }
                if (var13_13 && var14_14 != 0 && var15_15 == 0) {
                    this.IHDR_colorType = 4;
                } else if (var13_13) {
                    this.IHDR_colorType = 0;
                } else {
                    this.IHDR_colorType = 3;
                    this.PLTE_present = true;
                    this.PLTE_red = (byte[])var10_10.clone();
                    this.PLTE_green = (byte[])var11_11.clone();
                    this.PLTE_blue = (byte[])var12_12.clone();
                }
                break block30;
            }
            if (var7_7 == 1) {
                this.IHDR_colorType = 0;
            } else if (var7_7 == 2) {
                this.IHDR_colorType = 4;
            } else if (var7_7 == 3) {
                this.IHDR_colorType = 2;
            } else if (var7_7 == 4) {
                this.IHDR_colorType = 6;
            } else {
                throw new RuntimeException("Number of bands not 1-4!");
            }
        }
        this.IHDR_present = true;
    }

    public boolean isReadOnly() {
        return false;
    }

    private ArrayList cloneBytesArrayList(ArrayList arrayList) {
        if (arrayList == null) {
            return null;
        }
        ArrayList<Object> arrayList2 = new ArrayList<Object>(arrayList.size());
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e == null) {
                arrayList2.add(null);
                continue;
            }
            arrayList2.add(((byte[])e).clone());
        }
        return arrayList2;
    }

    public Object clone() {
        PNGMetadata pNGMetadata;
        try {
            pNGMetadata = (PNGMetadata)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        pNGMetadata.zTXt_compressedText = this.cloneBytesArrayList(this.zTXt_compressedText);
        pNGMetadata.unknownChunkData = this.cloneBytesArrayList(this.unknownChunkData);
        return pNGMetadata;
    }

    public IIOMetadataFormat getMetadataFormat(String string) {
        if (string.equals(nativeMetadataFormatName)) {
            return null;
        }
        throw new IllegalArgumentException("Not a recognized format!");
    }

    public Node getAsTree(String string) {
        if (string.equals(nativeMetadataFormatName)) {
            return this.getNativeTree();
        }
        throw new IllegalArgumentException("Not a recognized format!");
    }

    private Node getNativeTree() {
        IIOMetadataNode iIOMetadataNode;
        int n;
        IIOMetadataNode iIOMetadataNode2;
        IIOMetadataNode iIOMetadataNode3 = null;
        IIOMetadataNode iIOMetadataNode4 = new IIOMetadataNode(nativeMetadataFormatName);
        if (this.IHDR_present) {
            iIOMetadataNode2 = new IIOMetadataNode("IHDR");
            iIOMetadataNode2.setAttribute("width", Integer.toString(this.IHDR_width));
            iIOMetadataNode2.setAttribute("height", Integer.toString(this.IHDR_height));
            iIOMetadataNode2.setAttribute("bitDepth", Integer.toString(this.IHDR_bitDepth));
            iIOMetadataNode2.setAttribute("colorType", IHDR_colorTypeNames[this.IHDR_colorType]);
            iIOMetadataNode2.setAttribute("compressionMethod", IHDR_compressionMethodNames[this.IHDR_compressionMethod]);
            iIOMetadataNode2.setAttribute("filterMethod", IHDR_filterMethodNames[this.IHDR_filterMethod]);
            iIOMetadataNode2.setAttribute("interlaceMethod", IHDR_interlaceMethodNames[this.IHDR_interlaceMethod]);
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        if (this.PLTE_present) {
            iIOMetadataNode2 = new IIOMetadataNode("PLTE");
            n = this.PLTE_red.length;
            int n2 = 0;
            while (n2 < n) {
                iIOMetadataNode = new IIOMetadataNode("PLTEEntry");
                iIOMetadataNode.setAttribute("index", Integer.toString(n2));
                iIOMetadataNode.setAttribute("red", Integer.toString(this.PLTE_red[n2] & 0xFF));
                iIOMetadataNode.setAttribute("green", Integer.toString(this.PLTE_green[n2] & 0xFF));
                iIOMetadataNode.setAttribute("blue", Integer.toString(this.PLTE_blue[n2] & 0xFF));
                iIOMetadataNode2.appendChild(iIOMetadataNode);
                ++n2;
            }
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        if (this.bKGD_present) {
            iIOMetadataNode2 = new IIOMetadataNode("bKGD");
            if (this.bKGD_colorType == 3) {
                iIOMetadataNode3 = new IIOMetadataNode("bKGD_Palette");
                iIOMetadataNode3.setAttribute("index", Integer.toString(this.bKGD_index));
            } else if (this.bKGD_colorType == 0) {
                iIOMetadataNode3 = new IIOMetadataNode("bKGD_Grayscale");
                iIOMetadataNode3.setAttribute("gray", Integer.toString(this.bKGD_gray));
            } else if (this.bKGD_colorType == 2) {
                iIOMetadataNode3 = new IIOMetadataNode("bKGD_RGB");
                iIOMetadataNode3.setAttribute("red", Integer.toString(this.bKGD_red));
                iIOMetadataNode3.setAttribute("green", Integer.toString(this.bKGD_green));
                iIOMetadataNode3.setAttribute("blue", Integer.toString(this.bKGD_blue));
            }
            iIOMetadataNode2.appendChild(iIOMetadataNode3);
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        if (this.cHRM_present) {
            iIOMetadataNode2 = new IIOMetadataNode("cHRM");
            iIOMetadataNode2.setAttribute("whitePointX", Integer.toString(this.cHRM_whitePointX));
            iIOMetadataNode2.setAttribute("whitePointY", Integer.toString(this.cHRM_whitePointY));
            iIOMetadataNode2.setAttribute("redX", Integer.toString(this.cHRM_redX));
            iIOMetadataNode2.setAttribute("redY", Integer.toString(this.cHRM_redY));
            iIOMetadataNode2.setAttribute("greenX", Integer.toString(this.cHRM_greenX));
            iIOMetadataNode2.setAttribute("greenY", Integer.toString(this.cHRM_greenY));
            iIOMetadataNode2.setAttribute("blueX", Integer.toString(this.cHRM_blueX));
            iIOMetadataNode2.setAttribute("blueY", Integer.toString(this.cHRM_blueY));
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        if (this.gAMA_present) {
            iIOMetadataNode2 = new IIOMetadataNode("gAMA");
            iIOMetadataNode2.setAttribute("value", Integer.toString(this.gAMA_gamma));
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        if (this.hIST_present) {
            iIOMetadataNode2 = new IIOMetadataNode("hIST");
            n = 0;
            while (n < this.hIST_histogram.length) {
                IIOMetadataNode iIOMetadataNode5 = new IIOMetadataNode("hISTEntry");
                iIOMetadataNode5.setAttribute("index", Integer.toString(n));
                iIOMetadataNode5.setAttribute("value", Integer.toString(this.hIST_histogram[n]));
                iIOMetadataNode2.appendChild(iIOMetadataNode5);
                ++n;
            }
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        if (this.iCCP_present) {
            iIOMetadataNode2 = new IIOMetadataNode("iCCP");
            iIOMetadataNode2.setAttribute("profileName", this.iCCP_profileName);
            iIOMetadataNode2.setAttribute("compressionMethod", iCCP_compressionMethodNames[this.iCCP_compressionMethod]);
            Object object = this.iCCP_compressedProfile;
            if (object != null) {
                object = object.clone();
            }
            iIOMetadataNode2.setUserObject(object);
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        if (this.iTXt_keyword.size() > 0) {
            iIOMetadataNode2 = new IIOMetadataNode("iTXt");
            int n3 = 0;
            while (n3 < this.iTXt_keyword.size()) {
                iIOMetadataNode = new IIOMetadataNode("iTXtEntry");
                iIOMetadataNode.setAttribute("keyword", (String)this.iTXt_keyword.get(n3));
                Integer n4 = (Integer)this.iTXt_compressionFlag.get(n3);
                iIOMetadataNode.setAttribute("compressionFlag", n4.toString());
                n4 = (Integer)this.iTXt_compressionMethod.get(n3);
                iIOMetadataNode.setAttribute("compressionMethod", n4.toString());
                iIOMetadataNode.setAttribute("languageTag", (String)this.iTXt_languageTag.get(n3));
                iIOMetadataNode.setAttribute("translatedKeyword", (String)this.iTXt_translatedKeyword.get(n3));
                iIOMetadataNode.setAttribute("text", (String)this.iTXt_text.get(n3));
                iIOMetadataNode2.appendChild(iIOMetadataNode);
                ++n3;
            }
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        if (this.pHYs_present) {
            iIOMetadataNode2 = new IIOMetadataNode("pHYs");
            iIOMetadataNode2.setAttribute("pixelsPerUnitXAxis", Integer.toString(this.pHYs_pixelsPerUnitXAxis));
            iIOMetadataNode2.setAttribute("pixelsPerUnitYAxis", Integer.toString(this.pHYs_pixelsPerUnitYAxis));
            iIOMetadataNode2.setAttribute("unitSpecifier", unitSpecifierNames[this.pHYs_unitSpecifier]);
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        if (this.sBIT_present) {
            iIOMetadataNode2 = new IIOMetadataNode("sBIT");
            if (this.sBIT_colorType == 0) {
                iIOMetadataNode3 = new IIOMetadataNode("sBIT_Grayscale");
                iIOMetadataNode3.setAttribute("gray", Integer.toString(this.sBIT_grayBits));
            } else if (this.sBIT_colorType == 4) {
                iIOMetadataNode3 = new IIOMetadataNode("sBIT_GrayAlpha");
                iIOMetadataNode3.setAttribute("gray", Integer.toString(this.sBIT_grayBits));
                iIOMetadataNode3.setAttribute("alpha", Integer.toString(this.sBIT_alphaBits));
            } else if (this.sBIT_colorType == 2) {
                iIOMetadataNode3 = new IIOMetadataNode("sBIT_RGB");
                iIOMetadataNode3.setAttribute("red", Integer.toString(this.sBIT_redBits));
                iIOMetadataNode3.setAttribute("green", Integer.toString(this.sBIT_greenBits));
                iIOMetadataNode3.setAttribute("blue", Integer.toString(this.sBIT_blueBits));
            } else if (this.sBIT_colorType == 6) {
                iIOMetadataNode3 = new IIOMetadataNode("sBIT_RGBAlpha");
                iIOMetadataNode3.setAttribute("red", Integer.toString(this.sBIT_redBits));
                iIOMetadataNode3.setAttribute("green", Integer.toString(this.sBIT_greenBits));
                iIOMetadataNode3.setAttribute("blue", Integer.toString(this.sBIT_blueBits));
                iIOMetadataNode3.setAttribute("alpha", Integer.toString(this.sBIT_alphaBits));
            } else if (this.sBIT_colorType == 3) {
                iIOMetadataNode3 = new IIOMetadataNode("sBIT_Palette");
                iIOMetadataNode3.setAttribute("red", Integer.toString(this.sBIT_redBits));
                iIOMetadataNode3.setAttribute("green", Integer.toString(this.sBIT_greenBits));
                iIOMetadataNode3.setAttribute("blue", Integer.toString(this.sBIT_blueBits));
            }
            iIOMetadataNode2.appendChild(iIOMetadataNode3);
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        if (this.sPLT_present) {
            iIOMetadataNode2 = new IIOMetadataNode("sPLT");
            iIOMetadataNode2.setAttribute("name", this.sPLT_paletteName);
            iIOMetadataNode2.setAttribute("sampleDepth", Integer.toString(this.sPLT_sampleDepth));
            int n5 = this.sPLT_red.length;
            int n6 = 0;
            while (n6 < n5) {
                iIOMetadataNode = new IIOMetadataNode("sPLTEntry");
                iIOMetadataNode.setAttribute("index", Integer.toString(n6));
                iIOMetadataNode.setAttribute("red", Integer.toString(this.sPLT_red[n6]));
                iIOMetadataNode.setAttribute("green", Integer.toString(this.sPLT_green[n6]));
                iIOMetadataNode.setAttribute("blue", Integer.toString(this.sPLT_blue[n6]));
                iIOMetadataNode.setAttribute("alpha", Integer.toString(this.sPLT_alpha[n6]));
                iIOMetadataNode.setAttribute("frequency", Integer.toString(this.sPLT_frequency[n6]));
                iIOMetadataNode2.appendChild(iIOMetadataNode);
                ++n6;
            }
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        if (this.sRGB_present) {
            iIOMetadataNode2 = new IIOMetadataNode("sRGB");
            iIOMetadataNode2.setAttribute("renderingIntent", renderingIntentNames[this.sRGB_renderingIntent]);
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        if (this.tEXt_keyword.size() > 0) {
            iIOMetadataNode2 = new IIOMetadataNode("tEXt");
            int n7 = 0;
            while (n7 < this.tEXt_keyword.size()) {
                IIOMetadataNode iIOMetadataNode6 = new IIOMetadataNode("tEXtEntry");
                iIOMetadataNode6.setAttribute("keyword", (String)this.tEXt_keyword.get(n7));
                iIOMetadataNode6.setAttribute("value", (String)this.tEXt_text.get(n7));
                iIOMetadataNode2.appendChild(iIOMetadataNode6);
                ++n7;
            }
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        if (this.tIME_present) {
            iIOMetadataNode2 = new IIOMetadataNode("tIME");
            iIOMetadataNode2.setAttribute("year", Integer.toString(this.tIME_year));
            iIOMetadataNode2.setAttribute("month", Integer.toString(this.tIME_month));
            iIOMetadataNode2.setAttribute("day", Integer.toString(this.tIME_day));
            iIOMetadataNode2.setAttribute("hour", Integer.toString(this.tIME_hour));
            iIOMetadataNode2.setAttribute("minute", Integer.toString(this.tIME_minute));
            iIOMetadataNode2.setAttribute("second", Integer.toString(this.tIME_second));
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        if (this.tRNS_present) {
            iIOMetadataNode2 = new IIOMetadataNode("tRNS");
            if (this.tRNS_colorType == 3) {
                iIOMetadataNode3 = new IIOMetadataNode("tRNS_Palette");
                int n8 = 0;
                while (n8 < this.tRNS_alpha.length) {
                    IIOMetadataNode iIOMetadataNode7 = new IIOMetadataNode("tRNS_PaletteEntry");
                    iIOMetadataNode7.setAttribute("index", Integer.toString(n8));
                    iIOMetadataNode7.setAttribute("alpha", Integer.toString(this.tRNS_alpha[n8]));
                    iIOMetadataNode3.appendChild(iIOMetadataNode7);
                    ++n8;
                }
            } else if (this.tRNS_colorType == 0) {
                iIOMetadataNode3 = new IIOMetadataNode("tRNS_Grayscale");
                iIOMetadataNode3.setAttribute("gray", Integer.toString(this.tRNS_gray));
            } else if (this.tRNS_colorType == 2) {
                iIOMetadataNode3 = new IIOMetadataNode("tRNS_RGB");
                iIOMetadataNode3.setAttribute("red", Integer.toString(this.tRNS_red));
                iIOMetadataNode3.setAttribute("green", Integer.toString(this.tRNS_green));
                iIOMetadataNode3.setAttribute("blue", Integer.toString(this.tRNS_blue));
            }
            iIOMetadataNode2.appendChild(iIOMetadataNode3);
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        if (this.zTXt_keyword.size() > 0) {
            iIOMetadataNode2 = new IIOMetadataNode("zTXt");
            int n9 = 0;
            while (n9 < this.zTXt_keyword.size()) {
                IIOMetadataNode iIOMetadataNode8 = new IIOMetadataNode("zTXtEntry");
                iIOMetadataNode8.setAttribute("keyword", (String)this.zTXt_keyword.get(n9));
                int n10 = (Integer)this.zTXt_compressionMethod.get(n9);
                iIOMetadataNode8.setAttribute("compressionMethod", zTXt_compressionMethodNames[n10]);
                Object object = this.zTXt_compressedText.get(n9);
                if (object != null) {
                    object = ((byte[])object).clone();
                }
                iIOMetadataNode8.setUserObject(object);
                iIOMetadataNode2.appendChild(iIOMetadataNode8);
                ++n9;
            }
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        if (this.unknownChunkType.size() > 0) {
            iIOMetadataNode2 = new IIOMetadataNode("UnknownChunks");
            int n11 = 0;
            while (n11 < this.unknownChunkType.size()) {
                IIOMetadataNode iIOMetadataNode9 = new IIOMetadataNode("UnknownChunk");
                iIOMetadataNode9.setAttribute("type", (String)this.unknownChunkType.get(n11));
                iIOMetadataNode9.setUserObject((byte[])this.unknownChunkData.get(n11));
                iIOMetadataNode2.appendChild(iIOMetadataNode9);
                ++n11;
            }
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode4;
    }

    private void fatal(Node node, String string) throws IIOInvalidTreeException {
        throw new IIOInvalidTreeException(string, node);
    }

    private int getIntAttribute(Node node, String string, int n, boolean bl) throws IIOInvalidTreeException {
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 == null) {
            if (!bl) {
                return n;
            }
            this.fatal(node, "Required attribute " + string + " not present!");
        }
        String string2 = node2.getNodeValue();
        return Integer.parseInt(string2);
    }

    private int getIntAttribute(Node node, String string) throws IIOInvalidTreeException {
        return this.getIntAttribute(node, string, -1, true);
    }

    private boolean getBooleanAttribute(Node node, String string, boolean bl, boolean bl2) throws IIOInvalidTreeException {
        String string2;
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 == null) {
            if (!bl2) {
                return bl;
            }
            this.fatal(node, "Required attribute " + string + " not present!");
        }
        if ((string2 = node2.getNodeValue()).equals("true")) {
            return true;
        }
        if (string2.equals("false")) {
            return false;
        }
        this.fatal(node, "Attribute " + string + " must be 'true' or 'false'!");
        return false;
    }

    private boolean getBooleanAttribute(Node node, String string) throws IIOInvalidTreeException {
        return this.getBooleanAttribute(node, string, false, true);
    }

    private int getEnumeratedAttribute(Node node, String string, String[] stringArray, int n, boolean bl) throws IIOInvalidTreeException {
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 == null) {
            if (!bl) {
                return n;
            }
            this.fatal(node, "Required attribute " + string + " not present!");
        }
        String string2 = node2.getNodeValue();
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (string2.equals(stringArray[n2])) {
                return n2;
            }
            ++n2;
        }
        this.fatal(node, "Illegal value for attribute " + string + "!");
        return -1;
    }

    private int getEnumeratedAttribute(Node node, String string, String[] stringArray) throws IIOInvalidTreeException {
        return this.getEnumeratedAttribute(node, string, stringArray, -1, true);
    }

    private String getAttribute(Node node, String string, String string2, boolean bl) throws IIOInvalidTreeException {
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 == null) {
            if (!bl) {
                return string2;
            }
            this.fatal(node, "Required attribute " + string + " not present!");
        }
        return node2.getNodeValue();
    }

    private String getAttribute(Node node, String string) throws IIOInvalidTreeException {
        return this.getAttribute(node, string, null, true);
    }

    public void mergeTree(String string, Node node) throws IIOInvalidTreeException {
        if (string.equals(nativeMetadataFormatName)) {
            if (node == null) {
                throw new IllegalArgumentException("root == null!");
            }
        } else {
            throw new IllegalArgumentException("Not a recognized format!");
        }
        this.mergeNativeTree(node);
    }

    private void mergeNativeTree(Node node) throws IIOInvalidTreeException {
        Node node2 = node;
        if (!node2.getNodeName().equals(nativeMetadataFormatName)) {
            this.fatal(node2, "Root must be com.sun.imageio.png_1.0");
        }
        node2 = node2.getFirstChild();
        while (node2 != null) {
            Object object;
            Object object2;
            Object object3;
            String string = node2.getNodeName();
            if (string.equals("IHDR")) {
                this.IHDR_width = this.getIntAttribute(node2, "width");
                this.IHDR_height = this.getIntAttribute(node2, "height");
                this.IHDR_bitDepth = this.getEnumeratedAttribute(node2, "bitDepth", IHDR_bitDepths);
                this.IHDR_colorType = this.getEnumeratedAttribute(node2, "colorType", IHDR_colorTypeNames);
                this.IHDR_compressionMethod = this.getEnumeratedAttribute(node2, "compressionMethod", IHDR_compressionMethodNames);
                this.IHDR_filterMethod = this.getEnumeratedAttribute(node2, "filterMethod", IHDR_filterMethodNames);
                this.IHDR_interlaceMethod = this.getEnumeratedAttribute(node2, "interlaceMethod", IHDR_interlaceMethodNames);
                this.IHDR_present = true;
            } else if (string.equals("PLTE")) {
                int n;
                object3 = new byte[256];
                byte[] byArray = new byte[256];
                byte[] byArray2 = new byte[256];
                int n2 = -1;
                object2 = node2.getFirstChild();
                if (object2 == null) {
                    this.fatal(node2, "Palette has no entries!");
                }
                while (object2 != null) {
                    if (!object2.getNodeName().equals("PLTEEntry")) {
                        this.fatal(node2, "Only a PLTEEntry may be a child of a PLTE!");
                    }
                    if ((n = this.getIntAttribute((Node)object2, "index")) < 0 || n > 255) {
                        this.fatal(node2, "Bad value for PLTEEntry attribute index!");
                    }
                    if (n > n2) {
                        n2 = n;
                    }
                    object3[n] = (byte)this.getIntAttribute((Node)object2, "red");
                    byArray[n] = (byte)this.getIntAttribute((Node)object2, "green");
                    byArray2[n] = (byte)this.getIntAttribute((Node)object2, "blue");
                    object2 = object2.getNextSibling();
                }
                n = n2 + 1;
                this.PLTE_red = new byte[n];
                this.PLTE_green = new byte[n];
                this.PLTE_blue = new byte[n];
                System.arraycopy(object3, 0, this.PLTE_red, 0, n);
                System.arraycopy(byArray, 0, this.PLTE_green, 0, n);
                System.arraycopy(byArray2, 0, this.PLTE_blue, 0, n);
                this.PLTE_present = true;
            } else if (string.equals("bKGD")) {
                String string2;
                this.bKGD_present = false;
                object3 = node2.getFirstChild();
                if (object3 == null) {
                    this.fatal(node2, "bKGD node has no children!");
                }
                if ((string2 = object3.getNodeName()).equals("bKGD_Palette")) {
                    this.bKGD_index = this.getIntAttribute((Node)object3, "index");
                    this.bKGD_colorType = 3;
                } else if (string2.equals("bKGD_Grayscale")) {
                    this.bKGD_gray = this.getIntAttribute((Node)object3, "gray");
                    this.bKGD_colorType = 0;
                } else if (string2.equals("bKGD_RGB")) {
                    this.bKGD_red = this.getIntAttribute((Node)object3, "red");
                    this.bKGD_green = this.getIntAttribute((Node)object3, "green");
                    this.bKGD_blue = this.getIntAttribute((Node)object3, "blue");
                    this.bKGD_colorType = 2;
                } else {
                    this.fatal(node2, "Bad child of a bKGD node!");
                }
                if (object3.getNextSibling() != null) {
                    this.fatal(node2, "bKGD node has more than one child!");
                }
                this.bKGD_present = true;
            } else if (string.equals("cHRM")) {
                this.cHRM_whitePointX = this.getIntAttribute(node2, "whitePointX");
                this.cHRM_whitePointY = this.getIntAttribute(node2, "whitePointY");
                this.cHRM_redX = this.getIntAttribute(node2, "redX");
                this.cHRM_redY = this.getIntAttribute(node2, "redY");
                this.cHRM_greenX = this.getIntAttribute(node2, "greenX");
                this.cHRM_greenY = this.getIntAttribute(node2, "greenY");
                this.cHRM_blueX = this.getIntAttribute(node2, "blueX");
                this.cHRM_blueY = this.getIntAttribute(node2, "blueY");
                this.cHRM_present = true;
            } else if (string.equals("gAMA")) {
                this.gAMA_gamma = this.getIntAttribute(node2, "value");
                this.gAMA_present = true;
            } else if (string.equals("hIST")) {
                object3 = new char[256];
                int n = -1;
                Node node3 = node2.getFirstChild();
                if (node3 == null) {
                    this.fatal(node2, "hIST node has no children!");
                }
                while (node3 != null) {
                    int n3;
                    if (!node3.getNodeName().equals("hISTEntry")) {
                        this.fatal(node2, "Only a hISTEntry may be a child of a hIST!");
                    }
                    if ((n3 = this.getIntAttribute(node3, "index")) < 0 || n3 > 255) {
                        this.fatal(node2, "Bad value for histEntry attribute index!");
                    }
                    if (n3 > n) {
                        n = n3;
                    }
                    object3[n3] = (char)this.getIntAttribute(node3, "value");
                    node3 = node3.getNextSibling();
                }
                int n4 = n + 1;
                this.hIST_histogram = new char[n4];
                System.arraycopy(object3, 0, this.hIST_histogram, 0, n4);
                this.hIST_present = true;
            } else if (string.equals("iCCP")) {
                this.iCCP_profileName = this.getAttribute(node2, "profileName");
                this.iCCP_compressionMethod = this.getEnumeratedAttribute(node2, "compressionMethod", iCCP_compressionMethodNames);
                object3 = ((IIOMetadataNode)node2).getUserObject();
                if (object3 == null) {
                    this.fatal(node2, "No ICCP profile present in user object!");
                }
                if (!(object3 instanceof byte[])) {
                    this.fatal(node2, "User object not a byte array!");
                }
                this.iCCP_compressedProfile = (byte[])((byte[])object3).clone();
                this.iCCP_present = true;
            } else if (string.equals("iTXt")) {
                object3 = node2.getFirstChild();
                while (object3 != null) {
                    if (!object3.getNodeName().equals("iTXtEntry")) {
                        this.fatal(node2, "Only an iTXtEntry may be a child of an iTXt!");
                    }
                    String string3 = this.getAttribute((Node)object3, "keyword");
                    this.iTXt_keyword.add(string3);
                    boolean bl = this.getBooleanAttribute((Node)object3, "compressionFlag");
                    this.iTXt_compressionFlag.add(new Boolean(bl));
                    String string4 = this.getAttribute((Node)object3, "compressionMethod");
                    this.iTXt_compressionMethod.add(string4);
                    object2 = this.getAttribute((Node)object3, "languageTag");
                    this.iTXt_languageTag.add(object2);
                    String string5 = this.getAttribute((Node)object3, "translatedKeyword");
                    this.iTXt_translatedKeyword.add(string5);
                    object = this.getAttribute((Node)object3, "text");
                    this.iTXt_text.add(object);
                    object3 = object3.getNextSibling();
                }
            } else if (string.equals("pHYs")) {
                this.pHYs_pixelsPerUnitXAxis = this.getIntAttribute(node2, "pixelsPerUnitXAxis");
                this.pHYs_pixelsPerUnitYAxis = this.getIntAttribute(node2, "pixelsPerUnitYAxis");
                this.pHYs_unitSpecifier = this.getEnumeratedAttribute(node2, "unitSpecifier", unitSpecifierNames);
                this.pHYs_present = true;
            } else if (string.equals("sBIT")) {
                String string6;
                this.sBIT_present = false;
                object3 = node2.getFirstChild();
                if (object3 == null) {
                    this.fatal(node2, "sBIT node has no children!");
                }
                if ((string6 = object3.getNodeName()).equals("sBIT_Grayscale")) {
                    this.sBIT_grayBits = this.getIntAttribute((Node)object3, "gray");
                    this.sBIT_colorType = 0;
                } else if (string6.equals("sBIT_GrayAlpha")) {
                    this.sBIT_grayBits = this.getIntAttribute((Node)object3, "gray");
                    this.sBIT_alphaBits = this.getIntAttribute((Node)object3, "alpha");
                    this.sBIT_colorType = 4;
                } else if (string6.equals("sBIT_RGB")) {
                    this.sBIT_redBits = this.getIntAttribute((Node)object3, "red");
                    this.sBIT_greenBits = this.getIntAttribute((Node)object3, "green");
                    this.sBIT_blueBits = this.getIntAttribute((Node)object3, "blue");
                    this.sBIT_colorType = 2;
                } else if (string6.equals("sBIT_RGBAlpha")) {
                    this.sBIT_redBits = this.getIntAttribute((Node)object3, "red");
                    this.sBIT_greenBits = this.getIntAttribute((Node)object3, "green");
                    this.sBIT_blueBits = this.getIntAttribute((Node)object3, "blue");
                    this.sBIT_alphaBits = this.getIntAttribute((Node)object3, "alpha");
                    this.sBIT_colorType = 6;
                } else if (string6.equals("sBIT_Palette")) {
                    this.sBIT_redBits = this.getIntAttribute((Node)object3, "red");
                    this.sBIT_greenBits = this.getIntAttribute((Node)object3, "green");
                    this.sBIT_blueBits = this.getIntAttribute((Node)object3, "blue");
                    this.sBIT_colorType = 3;
                } else {
                    this.fatal(node2, "Bad child of an sBIT node!");
                }
                if (object3.getNextSibling() != null) {
                    this.fatal(node2, "sBIT node has more than one child!");
                }
                this.sBIT_present = true;
            } else if (string.equals("sPLT")) {
                int n;
                this.sPLT_paletteName = this.getAttribute(node2, "name");
                this.sPLT_sampleDepth = this.getIntAttribute(node2, "sampleDepth");
                object3 = new int[256];
                int[] nArray = new int[256];
                int[] nArray2 = new int[256];
                int[] nArray3 = new int[256];
                object2 = new int[256];
                int n5 = -1;
                object = node2.getFirstChild();
                if (object == null) {
                    this.fatal(node2, "sPLT node has no children!");
                }
                while (object != null) {
                    if (!object.getNodeName().equals("sPLTEntry")) {
                        this.fatal(node2, "Only an sPLTEntry may be a child of an sPLT!");
                    }
                    if ((n = this.getIntAttribute((Node)object, "index")) < 0 || n > 255) {
                        this.fatal(node2, "Bad value for PLTEEntry attribute index!");
                    }
                    if (n > n5) {
                        n5 = n;
                    }
                    object3[n] = this.getIntAttribute((Node)object, "red");
                    nArray[n] = this.getIntAttribute((Node)object, "green");
                    nArray2[n] = this.getIntAttribute((Node)object, "blue");
                    nArray3[n] = this.getIntAttribute((Node)object, "alpha");
                    object2[n] = this.getIntAttribute((Node)object, "frequency");
                    object = object.getNextSibling();
                }
                n = n5 + 1;
                this.sPLT_red = new int[n];
                this.sPLT_green = new int[n];
                this.sPLT_blue = new int[n];
                this.sPLT_alpha = new int[n];
                this.sPLT_frequency = new int[n];
                System.arraycopy(object3, 0, this.sPLT_red, 0, n);
                System.arraycopy(nArray, 0, this.sPLT_green, 0, n);
                System.arraycopy(nArray2, 0, this.sPLT_blue, 0, n);
                System.arraycopy(nArray3, 0, this.sPLT_alpha, 0, n);
                System.arraycopy(object2, 0, this.sPLT_frequency, 0, n);
                this.sPLT_present = true;
            } else if (string.equals("sRGB")) {
                this.sRGB_renderingIntent = this.getEnumeratedAttribute(node2, "renderingIntent", renderingIntentNames);
                this.sRGB_present = true;
            } else if (string.equals("tEXt")) {
                object3 = node2.getFirstChild();
                while (object3 != null) {
                    if (!object3.getNodeName().equals("tEXtEntry")) {
                        this.fatal(node2, "Only an tEXtEntry may be a child of an tEXt!");
                    }
                    String string7 = this.getAttribute((Node)object3, "keyword");
                    this.tEXt_keyword.add(string7);
                    String string8 = this.getAttribute((Node)object3, "value");
                    this.tEXt_text.add(string8);
                    object3 = object3.getNextSibling();
                }
            } else if (string.equals("tIME")) {
                this.tIME_year = this.getIntAttribute(node2, "year");
                this.tIME_month = this.getIntAttribute(node2, "month");
                this.tIME_day = this.getIntAttribute(node2, "day");
                this.tIME_hour = this.getIntAttribute(node2, "hour");
                this.tIME_minute = this.getIntAttribute(node2, "minute");
                this.tIME_second = this.getIntAttribute(node2, "second");
                this.tIME_present = true;
            } else if (string.equals("tRNS")) {
                String string9;
                this.tRNS_present = false;
                object3 = node2.getFirstChild();
                if (object3 == null) {
                    this.fatal(node2, "tRNS node has no children!");
                }
                if ((string9 = object3.getNodeName()).equals("tRNS_Palette")) {
                    byte[] byArray = new byte[256];
                    int n = -1;
                    object2 = object3.getFirstChild();
                    if (object2 == null) {
                        this.fatal(node2, "tRNS_Palette node has no children!");
                    }
                    while (object2 != null) {
                        int n6;
                        if (!object2.getNodeName().equals("tRNS_PaletteEntry")) {
                            this.fatal(node2, "Only a tRNS_PaletteEntry may be a child of a tRNS_Palette!");
                        }
                        if ((n6 = this.getIntAttribute((Node)object2, "index")) < 0 || n6 > 255) {
                            this.fatal(node2, "Bad value for tRNS_PaletteEntry attribute index!");
                        }
                        if (n6 > n) {
                            n = n6;
                        }
                        byArray[n6] = (byte)this.getIntAttribute((Node)object2, "alpha");
                        object2 = object2.getNextSibling();
                    }
                    int n7 = n + 1;
                    this.tRNS_alpha = new byte[n7];
                    this.tRNS_colorType = 3;
                    System.arraycopy(byArray, 0, this.tRNS_alpha, 0, n7);
                } else if (string9.equals("tRNS_Grayscale")) {
                    this.tRNS_gray = this.getIntAttribute((Node)object3, "gray");
                    this.tRNS_colorType = 0;
                } else if (string9.equals("tRNS_RGB")) {
                    this.tRNS_red = this.getIntAttribute((Node)object3, "red");
                    this.tRNS_green = this.getIntAttribute((Node)object3, "green");
                    this.tRNS_blue = this.getIntAttribute((Node)object3, "blue");
                    this.tRNS_colorType = 2;
                } else {
                    this.fatal(node2, "Bad child of a tRNS node!");
                }
                if (object3.getNextSibling() != null) {
                    this.fatal(node2, "tRNS node has more than one child!");
                }
                this.tRNS_present = true;
            } else if (string.equals("zTXt")) {
                object3 = node2.getFirstChild();
                while (object3 != null) {
                    if (!object3.getNodeName().equals("zTXtEntry")) {
                        this.fatal(node2, "Only an zTXtEntry may be a child of an zTXt!");
                    }
                    String string10 = this.getAttribute((Node)object3, "keyword");
                    this.zTXt_keyword.add(string10);
                    int n = this.getEnumeratedAttribute((Node)object3, "compressionMethod", zTXt_compressionMethodNames);
                    this.zTXt_compressionMethod.add(new Integer(n));
                    Object object4 = ((IIOMetadataNode)object3).getUserObject();
                    if (object4 == null) {
                        this.fatal((Node)object3, "No compressed text present in user object!");
                    }
                    if (!(object4 instanceof byte[])) {
                        this.fatal((Node)object3, "User object not a byte array!");
                    }
                    this.zTXt_compressedText.add(((byte[])object4).clone());
                    object3 = object3.getNextSibling();
                }
            } else if (string.equals("UnknownChunks")) {
                object3 = node2.getFirstChild();
                while (object3 != null) {
                    if (!object3.getNodeName().equals("UnknownChunk")) {
                        this.fatal(node2, "Only an UnknownChunk may be a child of an UnknownChunks!");
                    }
                    String string11 = this.getAttribute((Node)object3, "type");
                    Object object5 = ((IIOMetadataNode)object3).getUserObject();
                    if (string11.length() != 4) {
                        this.fatal((Node)object3, "Chunk type must be 4 characters!");
                    }
                    if (object5 == null) {
                        this.fatal((Node)object3, "No chunk data present in user object!");
                    }
                    if (!(object5 instanceof byte[])) {
                        this.fatal((Node)object3, "User object not a byte array!");
                    }
                    this.unknownChunkType.add(string11);
                    this.unknownChunkData.add(((byte[])object5).clone());
                    object3 = object3.getNextSibling();
                }
            } else {
                this.fatal(node2, "Unknown child of root node!");
            }
            node2 = node2.getNextSibling();
        }
    }

    public void reset() {
        this.IHDR_present = false;
        this.PLTE_present = false;
        this.bKGD_present = false;
        this.cHRM_present = false;
        this.gAMA_present = false;
        this.hIST_present = false;
        this.iCCP_present = false;
        this.iTXt_keyword = new ArrayList();
        this.iTXt_compressionFlag = new ArrayList();
        this.iTXt_compressionMethod = new ArrayList();
        this.iTXt_languageTag = new ArrayList();
        this.iTXt_translatedKeyword = new ArrayList();
        this.iTXt_text = new ArrayList();
        this.pHYs_present = false;
        this.sBIT_present = false;
        this.sPLT_present = false;
        this.sRGB_present = false;
        this.tEXt_keyword = new ArrayList();
        this.tEXt_text = new ArrayList();
        this.tIME_present = false;
        this.tRNS_present = false;
        this.zTXt_keyword = new ArrayList();
        this.zTXt_compressionMethod = new ArrayList();
        this.zTXt_compressedText = new ArrayList();
        this.unknownChunkType = new ArrayList();
        this.unknownChunkData = new ArrayList();
    }
}

