/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.spi.ImageOutputStreamSpi;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageTranscoderSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

public final class ImageIO {
    private static final IIORegistry theRegistry = IIORegistry.getDefaultInstance();
    private static boolean _useCache = true;
    private static File _cacheDir = null;
    private static Method readerFormatNamesMethod;
    private static Method readerFileSuffixesMethod;
    private static Method readerMIMETypesMethod;
    private static Method writerFormatNamesMethod;
    private static Method writerFileSuffixesMethod;
    private static Method writerMIMETypesMethod;
    static /* synthetic */ Class class$javax$imageio$spi$ImageInputStreamSpi;
    static /* synthetic */ Class class$javax$imageio$spi$ImageOutputStreamSpi;
    static /* synthetic */ Class class$javax$imageio$spi$ImageReaderSpi;
    static /* synthetic */ Class class$javax$imageio$spi$ImageWriterSpi;
    static /* synthetic */ Class class$javax$imageio$spi$ImageTranscoderSpi;

    private ImageIO() {
    }

    public static void scanForPlugins() {
        theRegistry.registerApplicationClasspathSpis();
    }

    public static void setUseCache(boolean bl) {
        _useCache = bl;
    }

    public static boolean getUseCache() {
        return _useCache;
    }

    public static void setCacheDirectory(File file) {
        if (file != null && !file.isDirectory()) {
            throw new IllegalArgumentException("Not a directory!");
        }
        _cacheDir = file;
    }

    public static File getCacheDirectory() {
        return _cacheDir;
    }

    public static ImageInputStream createImageInputStream(Object object) throws IIOException {
        if (object == null) {
            throw new IllegalArgumentException("input == null!");
        }
        Iterator iterator = theRegistry.getServiceProviders(class$javax$imageio$spi$ImageInputStreamSpi == null ? (class$javax$imageio$spi$ImageInputStreamSpi = ImageIO.class$("javax.imageio.spi.ImageInputStreamSpi")) : class$javax$imageio$spi$ImageInputStreamSpi, true);
        while (iterator.hasNext()) {
            ImageInputStreamSpi imageInputStreamSpi = (ImageInputStreamSpi)iterator.next();
            if (!imageInputStreamSpi.getInputClass().isInstance(object)) continue;
            try {
                return imageInputStreamSpi.createInputStreamInstance(object, _useCache, _cacheDir);
            }
            catch (IOException iOException) {
                throw new IIOException("Can't create cache file!", iOException);
            }
        }
        return null;
    }

    public static ImageOutputStream createImageOutputStream(Object object) throws IIOException {
        if (object == null) {
            throw new IllegalArgumentException("output == null!");
        }
        Iterator iterator = theRegistry.getServiceProviders(class$javax$imageio$spi$ImageOutputStreamSpi == null ? (class$javax$imageio$spi$ImageOutputStreamSpi = ImageIO.class$("javax.imageio.spi.ImageOutputStreamSpi")) : class$javax$imageio$spi$ImageOutputStreamSpi, true);
        while (iterator.hasNext()) {
            ImageOutputStreamSpi imageOutputStreamSpi = (ImageOutputStreamSpi)iterator.next();
            if (!imageOutputStreamSpi.getOutputClass().isInstance(object)) continue;
            try {
                return imageOutputStreamSpi.createOutputStreamInstance(object, _useCache, _cacheDir);
            }
            catch (IOException iOException) {
                throw new IIOException("Can't create cache file!", iOException);
            }
        }
        return null;
    }

    private static String[] toStringArray(Set set) {
        String[] stringArray = new String[set.size()];
        Iterator iterator = set.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            stringArray[n++] = (String)iterator.next();
        }
        return stringArray;
    }

    public static String[] getReaderFormatNames() {
        Iterator iterator = theRegistry.getServiceProviders(class$javax$imageio$spi$ImageReaderSpi == null ? (class$javax$imageio$spi$ImageReaderSpi = ImageIO.class$("javax.imageio.spi.ImageReaderSpi")) : class$javax$imageio$spi$ImageReaderSpi, true);
        HashSet<String> hashSet = new HashSet<String>();
        while (iterator.hasNext()) {
            ImageReaderSpi imageReaderSpi = (ImageReaderSpi)iterator.next();
            String[] stringArray = imageReaderSpi.getFormatNames();
            int n = 0;
            while (n < stringArray.length) {
                hashSet.add(stringArray[n]);
                ++n;
            }
        }
        return ImageIO.toStringArray(hashSet);
    }

    public static String[] getReaderMIMETypes() {
        Iterator iterator = theRegistry.getServiceProviders(class$javax$imageio$spi$ImageReaderSpi == null ? (class$javax$imageio$spi$ImageReaderSpi = ImageIO.class$("javax.imageio.spi.ImageReaderSpi")) : class$javax$imageio$spi$ImageReaderSpi, true);
        HashSet<String> hashSet = new HashSet<String>();
        while (iterator.hasNext()) {
            ImageReaderSpi imageReaderSpi = (ImageReaderSpi)iterator.next();
            String[] stringArray = imageReaderSpi.getMIMETypes();
            int n = 0;
            while (n < stringArray.length) {
                hashSet.add(stringArray[n]);
                ++n;
            }
        }
        return ImageIO.toStringArray(hashSet);
    }

    public static Iterator getImageReaders(Object object) {
        Iterator iterator = theRegistry.getServiceProviders(class$javax$imageio$spi$ImageReaderSpi == null ? (class$javax$imageio$spi$ImageReaderSpi = ImageIO.class$("javax.imageio.spi.ImageReaderSpi")) : class$javax$imageio$spi$ImageReaderSpi, new CanDecodeInputFilter(object), true);
        return new ImageReaderIterator(iterator);
    }

    public static Iterator getImageReadersByFormatName(String string) {
        Iterator iterator = theRegistry.getServiceProviders(class$javax$imageio$spi$ImageReaderSpi == null ? (class$javax$imageio$spi$ImageReaderSpi = ImageIO.class$("javax.imageio.spi.ImageReaderSpi")) : class$javax$imageio$spi$ImageReaderSpi, new ContainsFilter(readerFormatNamesMethod, string), true);
        return new ImageReaderIterator(iterator);
    }

    public static Iterator getImageReadersBySuffix(String string) {
        Iterator iterator = theRegistry.getServiceProviders(class$javax$imageio$spi$ImageReaderSpi == null ? (class$javax$imageio$spi$ImageReaderSpi = ImageIO.class$("javax.imageio.spi.ImageReaderSpi")) : class$javax$imageio$spi$ImageReaderSpi, new ContainsFilter(readerFileSuffixesMethod, string), true);
        return new ImageReaderIterator(iterator);
    }

    public static Iterator getImageReadersByMIMEType(String string) {
        Iterator iterator = theRegistry.getServiceProviders(class$javax$imageio$spi$ImageReaderSpi == null ? (class$javax$imageio$spi$ImageReaderSpi = ImageIO.class$("javax.imageio.spi.ImageReaderSpi")) : class$javax$imageio$spi$ImageReaderSpi, new ContainsFilter(readerMIMETypesMethod, string), true);
        return new ImageReaderIterator(iterator);
    }

    public static String[] getWriterFormatNames() {
        Iterator iterator = theRegistry.getServiceProviders(class$javax$imageio$spi$ImageWriterSpi == null ? (class$javax$imageio$spi$ImageWriterSpi = ImageIO.class$("javax.imageio.spi.ImageWriterSpi")) : class$javax$imageio$spi$ImageWriterSpi, true);
        HashSet<String> hashSet = new HashSet<String>();
        while (iterator.hasNext()) {
            ImageWriterSpi imageWriterSpi = (ImageWriterSpi)iterator.next();
            String[] stringArray = imageWriterSpi.getFormatNames();
            int n = 0;
            while (n < stringArray.length) {
                hashSet.add(stringArray[n]);
                ++n;
            }
        }
        return ImageIO.toStringArray(hashSet);
    }

    public static String[] getWriterMIMETypes() {
        Iterator iterator = theRegistry.getServiceProviders(class$javax$imageio$spi$ImageWriterSpi == null ? (class$javax$imageio$spi$ImageWriterSpi = ImageIO.class$("javax.imageio.spi.ImageWriterSpi")) : class$javax$imageio$spi$ImageWriterSpi, true);
        HashSet<String> hashSet = new HashSet<String>();
        while (iterator.hasNext()) {
            ImageWriterSpi imageWriterSpi = (ImageWriterSpi)iterator.next();
            String[] stringArray = imageWriterSpi.getMIMETypes();
            int n = 0;
            while (n < stringArray.length) {
                hashSet.add(stringArray[n]);
                ++n;
            }
        }
        return ImageIO.toStringArray(hashSet);
    }

    private static boolean contains(String[] stringArray, String string) {
        int n = 0;
        while (n < stringArray.length) {
            if (string.equalsIgnoreCase(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static Iterator getImageWritersByFormatName(String string) {
        Iterator iterator = theRegistry.getServiceProviders(class$javax$imageio$spi$ImageWriterSpi == null ? (class$javax$imageio$spi$ImageWriterSpi = ImageIO.class$("javax.imageio.spi.ImageWriterSpi")) : class$javax$imageio$spi$ImageWriterSpi, new ContainsFilter(writerFormatNamesMethod, string), true);
        return new ImageWriterIterator(iterator);
    }

    public static Iterator getImageWritersBySuffix(String string) {
        Iterator iterator = theRegistry.getServiceProviders(class$javax$imageio$spi$ImageWriterSpi == null ? (class$javax$imageio$spi$ImageWriterSpi = ImageIO.class$("javax.imageio.spi.ImageWriterSpi")) : class$javax$imageio$spi$ImageWriterSpi, new ContainsFilter(writerFileSuffixesMethod, string), true);
        return new ImageWriterIterator(iterator);
    }

    public static Iterator getImageWritersByMIMEType(String string) {
        Iterator iterator = theRegistry.getServiceProviders(class$javax$imageio$spi$ImageWriterSpi == null ? (class$javax$imageio$spi$ImageWriterSpi = ImageIO.class$("javax.imageio.spi.ImageWriterSpi")) : class$javax$imageio$spi$ImageWriterSpi, new ContainsFilter(writerMIMETypesMethod, string), true);
        return new ImageWriterIterator(iterator);
    }

    public static ImageWriter getImageWriter(ImageReader imageReader) {
        Object object;
        Object object2;
        if (imageReader == null) {
            throw new IllegalArgumentException();
        }
        Object object3 = imageReader.getOriginatingProvider();
        if (object3 == null) {
            object2 = theRegistry.getServiceProviders(class$javax$imageio$spi$ImageReaderSpi == null ? (class$javax$imageio$spi$ImageReaderSpi = ImageIO.class$("javax.imageio.spi.ImageReaderSpi")) : class$javax$imageio$spi$ImageReaderSpi, false);
            while (object2.hasNext()) {
                object = (ImageReaderSpi)object2.next();
                if (!((ImageReaderSpi)object).isOwnReader(imageReader)) continue;
                object3 = object;
                break;
            }
            if (object3 == null) {
                return null;
            }
        }
        if ((object2 = ((ImageReaderSpi)object3).getImageWriterSpiNames()) == null) {
            return null;
        }
        object = null;
        try {
            object = Class.forName((String)object2[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        ImageWriterSpi imageWriterSpi = (ImageWriterSpi)theRegistry.getServiceProviderByClass((Class)object);
        if (imageWriterSpi == null) {
            return null;
        }
        try {
            return imageWriterSpi.createWriterInstance();
        }
        catch (IIOException iIOException) {
            theRegistry.deregisterServiceProvider(imageWriterSpi, class$javax$imageio$spi$ImageWriterSpi == null ? (class$javax$imageio$spi$ImageWriterSpi = ImageIO.class$("javax.imageio.spi.ImageWriterSpi")) : class$javax$imageio$spi$ImageWriterSpi);
            return null;
        }
    }

    public static ImageReader getImageReader(ImageWriter imageWriter) {
        Object object;
        Object object2;
        if (imageWriter == null) {
            throw new IllegalArgumentException();
        }
        Object object3 = imageWriter.getOriginatingProvider();
        if (object3 == null) {
            object2 = theRegistry.getServiceProviders(class$javax$imageio$spi$ImageWriterSpi == null ? (class$javax$imageio$spi$ImageWriterSpi = ImageIO.class$("javax.imageio.spi.ImageWriterSpi")) : class$javax$imageio$spi$ImageWriterSpi, false);
            while (object2.hasNext()) {
                object = (ImageWriterSpi)object2.next();
                if (!((ImageWriterSpi)object).isOwnWriter(imageWriter)) continue;
                object3 = object;
                break;
            }
            if (object3 == null) {
                return null;
            }
        }
        if ((object2 = ((ImageWriterSpi)object3).getImageReaderSpiNames()) == null) {
            return null;
        }
        object = null;
        try {
            object = Class.forName((String)object2[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        ImageReaderSpi imageReaderSpi = (ImageReaderSpi)theRegistry.getServiceProviderByClass((Class)object);
        if (imageReaderSpi == null) {
            return null;
        }
        try {
            return imageReaderSpi.createReaderInstance();
        }
        catch (IIOException iIOException) {
            theRegistry.deregisterServiceProvider(imageReaderSpi, class$javax$imageio$spi$ImageReaderSpi == null ? (class$javax$imageio$spi$ImageReaderSpi = ImageIO.class$("javax.imageio.spi.ImageReaderSpi")) : class$javax$imageio$spi$ImageReaderSpi);
            return null;
        }
    }

    public static Iterator getImageWriters(ImageTypeSpecifier imageTypeSpecifier, String string) {
        Iterator iterator = theRegistry.getServiceProviders(class$javax$imageio$spi$ImageWriterSpi == null ? (class$javax$imageio$spi$ImageWriterSpi = ImageIO.class$("javax.imageio.spi.ImageWriterSpi")) : class$javax$imageio$spi$ImageWriterSpi, new ContainsFilter(writerFormatNamesMethod, string), true);
        return new ImageWriterIterator(iterator);
    }

    public static Iterator getImageTranscoders(ImageReader imageReader, ImageWriter imageWriter) {
        if (imageReader == null) {
            throw new IllegalArgumentException("reader == null!");
        }
        if (imageWriter == null) {
            throw new IllegalArgumentException("reader == null!");
        }
        ImageReaderSpi imageReaderSpi = imageReader.getOriginatingProvider();
        ImageWriterSpi imageWriterSpi = imageWriter.getOriginatingProvider();
        TranscoderFilter transcoderFilter = new TranscoderFilter(imageReaderSpi, imageWriterSpi);
        Iterator iterator = theRegistry.getServiceProviders(class$javax$imageio$spi$ImageTranscoderSpi == null ? (class$javax$imageio$spi$ImageTranscoderSpi = ImageIO.class$("javax.imageio.spi.ImageTranscoderSpi")) : class$javax$imageio$spi$ImageTranscoderSpi, transcoderFilter, true);
        return new ImageTranscoderIterator(iterator);
    }

    public static BufferedImage read(File file) throws IIOException {
        if (file == null) {
            throw new IllegalArgumentException("input == null!");
        }
        if (!file.canRead()) {
            throw new IIOException("Can't read input file!");
        }
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(file);
        if (imageInputStream == null) {
            throw new IIOException("Can't create an ImageInputStream!");
        }
        return ImageIO.read(imageInputStream);
    }

    public static BufferedImage read(InputStream inputStream) throws IIOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("input == null!");
        }
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
        return ImageIO.read(imageInputStream);
    }

    public static BufferedImage read(URL uRL) throws IIOException {
        if (uRL == null) {
            throw new IllegalArgumentException("input == null!");
        }
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            throw new IIOException("Can't get input stream from URL!", iOException);
        }
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
        return ImageIO.read(imageInputStream);
    }

    public static BufferedImage read(ImageInputStream imageInputStream) throws IIOException {
        if (imageInputStream == null) {
            throw new IllegalArgumentException("stream == null!");
        }
        Iterator iterator = ImageIO.getImageReaders(imageInputStream);
        if (!iterator.hasNext()) {
            return null;
        }
        ImageReader imageReader = (ImageReader)iterator.next();
        ImageReadParam imageReadParam = imageReader.getDefaultReadParam();
        imageReadParam.setIgnoreMetadata(true);
        imageReader.setInput(imageInputStream, true);
        BufferedImage bufferedImage = imageReader.read(0, imageReadParam);
        return bufferedImage;
    }

    public static boolean write(RenderedImage renderedImage, String string, ImageOutputStream imageOutputStream) throws IIOException {
        if (renderedImage == null) {
            throw new IllegalArgumentException("im == null!");
        }
        if (string == null) {
            throw new IllegalArgumentException("formatName == null!");
        }
        if (imageOutputStream == null) {
            throw new IllegalArgumentException("output == null!");
        }
        ImageWriter imageWriter = null;
        ImageTypeSpecifier imageTypeSpecifier = ImageTypeSpecifier.createFromRenderedImage(renderedImage);
        Iterator iterator = ImageIO.getImageWriters(imageTypeSpecifier, string);
        if (iterator.hasNext()) {
            imageWriter = (ImageWriter)iterator.next();
        }
        if (imageWriter == null) {
            return false;
        }
        imageWriter.setOutput(imageOutputStream);
        imageWriter.write(renderedImage);
        return true;
    }

    public static boolean write(RenderedImage renderedImage, String string, File file) throws IIOException {
        ImageOutputStream imageOutputStream = null;
        try {
            imageOutputStream = ImageIO.createImageOutputStream(file);
        }
        catch (IOException iOException) {
            throw new IIOException("Can't create output stream!", iOException);
        }
        return ImageIO.write(renderedImage, string, imageOutputStream);
    }

    public static boolean write(RenderedImage renderedImage, String string, OutputStream outputStream) throws IIOException {
        ImageOutputStream imageOutputStream = null;
        try {
            imageOutputStream = ImageIO.createImageOutputStream(outputStream);
        }
        catch (IOException iOException) {
            throw new IIOException("Can't create output stream!", iOException);
        }
        return ImageIO.write(renderedImage, string, imageOutputStream);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            readerFormatNamesMethod = (class$javax$imageio$spi$ImageReaderSpi == null ? (class$javax$imageio$spi$ImageReaderSpi = ImageIO.class$("javax.imageio.spi.ImageReaderSpi")) : class$javax$imageio$spi$ImageReaderSpi).getMethod("getFormatNames", null);
            readerFileSuffixesMethod = (class$javax$imageio$spi$ImageReaderSpi == null ? (class$javax$imageio$spi$ImageReaderSpi = ImageIO.class$("javax.imageio.spi.ImageReaderSpi")) : class$javax$imageio$spi$ImageReaderSpi).getMethod("getFileSuffixes", null);
            readerMIMETypesMethod = (class$javax$imageio$spi$ImageReaderSpi == null ? (class$javax$imageio$spi$ImageReaderSpi = ImageIO.class$("javax.imageio.spi.ImageReaderSpi")) : class$javax$imageio$spi$ImageReaderSpi).getMethod("getMIMETypes", null);
            writerFormatNamesMethod = (class$javax$imageio$spi$ImageWriterSpi == null ? (class$javax$imageio$spi$ImageWriterSpi = ImageIO.class$("javax.imageio.spi.ImageWriterSpi")) : class$javax$imageio$spi$ImageWriterSpi).getMethod("getFormatNames", null);
            writerFileSuffixesMethod = (class$javax$imageio$spi$ImageWriterSpi == null ? (class$javax$imageio$spi$ImageWriterSpi = ImageIO.class$("javax.imageio.spi.ImageWriterSpi")) : class$javax$imageio$spi$ImageWriterSpi).getMethod("getFileSuffixes", null);
            writerMIMETypesMethod = (class$javax$imageio$spi$ImageWriterSpi == null ? (class$javax$imageio$spi$ImageWriterSpi = ImageIO.class$("javax.imageio.spi.ImageWriterSpi")) : class$javax$imageio$spi$ImageWriterSpi).getMethod("getMIMETypes", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
    }

    static class TranscoderFilter
    implements ServiceRegistry.Filter {
        String readerSpiName;
        String writerSpiName;

        public TranscoderFilter(ImageReaderSpi imageReaderSpi, ImageWriterSpi imageWriterSpi) {
            this.readerSpiName = imageReaderSpi.getClass().getName();
            this.writerSpiName = imageWriterSpi.getClass().getName();
        }

        public boolean filter(Object object) {
            ImageTranscoderSpi imageTranscoderSpi = (ImageTranscoderSpi)object;
            String string = imageTranscoderSpi.getReaderServiceProviderName();
            String string2 = imageTranscoderSpi.getWriterServiceProviderName();
            return string.equals(this.readerSpiName) && string2.equals(this.writerSpiName);
        }
    }

    static class ImageTranscoderIterator
    implements Iterator {
        public Iterator iter;

        public ImageTranscoderIterator(Iterator iterator) {
            this.iter = iterator;
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            ImageTranscoderSpi imageTranscoderSpi = null;
            imageTranscoderSpi = (ImageTranscoderSpi)this.iter.next();
            return imageTranscoderSpi.createTranscoderInstance();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class ImageWriterIterator
    implements Iterator {
        public Iterator iter;
        static /* synthetic */ Class class$javax$imageio$spi$ImageWriterSpi;

        public ImageWriterIterator(Iterator iterator) {
            this.iter = iterator;
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            ImageWriterSpi imageWriterSpi = null;
            try {
                imageWriterSpi = (ImageWriterSpi)this.iter.next();
                return imageWriterSpi.createWriterInstance();
            }
            catch (IIOException iIOException) {
                theRegistry.deregisterServiceProvider(imageWriterSpi, class$javax$imageio$spi$ImageWriterSpi == null ? (class$javax$imageio$spi$ImageWriterSpi = ImageWriterIterator.class$("javax.imageio.spi.ImageWriterSpi")) : class$javax$imageio$spi$ImageWriterSpi);
                return null;
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    static class ContainsFilter
    implements ServiceRegistry.Filter {
        Method method;
        String name;

        public ContainsFilter(Method method, String string) {
            this.method = method;
            this.name = string;
        }

        public boolean filter(Object object) {
            try {
                return ImageIO.contains((String[])this.method.invoke(object, null), this.name);
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    static class CanDecodeInputFilter
    implements ServiceRegistry.Filter {
        Object input;

        public CanDecodeInputFilter(Object object) {
            this.input = object;
        }

        public boolean filter(Object object) {
            try {
                ImageReaderSpi imageReaderSpi = (ImageReaderSpi)object;
                ImageInputStream imageInputStream = null;
                if (this.input instanceof ImageInputStream) {
                    imageInputStream = (ImageInputStream)this.input;
                }
                boolean bl = false;
                if (imageInputStream != null) {
                    imageInputStream.mark();
                }
                bl = imageReaderSpi.canDecodeInput(this.input);
                if (imageInputStream != null) {
                    imageInputStream.reset();
                }
                return bl;
            }
            catch (IOException iOException) {
                return false;
            }
        }
    }

    static class ImageReaderIterator
    implements Iterator {
        public Iterator iter;
        static /* synthetic */ Class class$javax$imageio$spi$ImageReaderSpi;

        public ImageReaderIterator(Iterator iterator) {
            this.iter = iterator;
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            ImageReaderSpi imageReaderSpi = null;
            try {
                imageReaderSpi = (ImageReaderSpi)this.iter.next();
                return imageReaderSpi.createReaderInstance();
            }
            catch (IIOException iIOException) {
                theRegistry.deregisterServiceProvider(imageReaderSpi, class$javax$imageio$spi$ImageReaderSpi == null ? (class$javax$imageio$spi$ImageReaderSpi = ImageReaderIterator.class$("javax.imageio.spi.ImageReaderSpi")) : class$javax$imageio$spi$ImageReaderSpi);
                return null;
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

