/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageReader;
import javax.imageio.ImageTranscoder;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.event.IIOWriteProgressListener;
import javax.imageio.event.IIOWriteWarningListener;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;

public abstract class ImageWriter
implements ImageTranscoder {
    protected ImageWriterSpi originatingProvider = null;
    protected Object output = null;
    protected boolean abortFlag = false;
    protected Locale[] availableLocales = null;
    protected Locale locale = null;
    protected List warningListeners = null;
    protected List warningLocales = null;
    protected List progressListeners = null;

    protected ImageWriter(ImageWriterSpi imageWriterSpi) {
        this.originatingProvider = imageWriterSpi;
    }

    public ImageWriterSpi getOriginatingProvider() {
        return this.originatingProvider;
    }

    public void setOutput(Object object) {
        if (object != null) {
            Class[] classArray = this.getOriginatingProvider().getOutputTypes();
            boolean bl = false;
            int n = 0;
            while (n < classArray.length) {
                if (classArray[n].isInstance(object)) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                throw new IllegalArgumentException("Illegal output type!");
            }
        }
        this.output = object;
    }

    public Object getOutput() {
        return this.output;
    }

    public Locale[] getAvailableLocales() {
        return this.availableLocales == null ? null : (Locale[])this.availableLocales.clone();
    }

    public void setLocale(Locale locale) {
        if (locale != null) {
            Locale[] localeArray = this.getAvailableLocales();
            boolean bl = false;
            if (localeArray != null) {
                int n = 0;
                while (n < localeArray.length) {
                    if (locale.equals(localeArray[n])) {
                        bl = true;
                        break;
                    }
                    ++n;
                }
            }
            if (!bl) {
                throw new IllegalArgumentException("Invalid locale!");
            }
        }
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public ImageWriteParam getDefaultWriteParam() {
        return new ImageWriteParam(false, false, false, false, null, null, this.getLocale());
    }

    public abstract IIOMetadata getDefaultStreamMetadata(ImageWriteParam var1);

    public abstract IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier var1, ImageWriteParam var2);

    public abstract IIOMetadata convertStreamMetadata(IIOMetadata var1, ImageWriteParam var2);

    public abstract IIOMetadata convertImageMetadata(IIOMetadata var1, ImageTypeSpecifier var2, ImageWriteParam var3);

    public int getNumThumbnailsSupported(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam, IIOMetadata iIOMetadata, IIOMetadata iIOMetadata2) {
        return 0;
    }

    public Dimension[] getPreferredThumbnailSizes(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam, IIOMetadata iIOMetadata, IIOMetadata iIOMetadata2) {
        return null;
    }

    public boolean canWriteRasters() {
        return false;
    }

    public abstract void write(IIOMetadata var1, IIOImage var2, ImageWriteParam var3) throws IIOException;

    public void write(IIOImage iIOImage) throws IIOException {
        this.write(null, iIOImage, null);
    }

    public void write(RenderedImage renderedImage) throws IIOException {
        this.write(null, new IIOImage(renderedImage, null, null), null);
    }

    private void unsupported() {
        if (this.getOutput() == null) {
            throw new IllegalStateException("getOutput() == null!");
        }
        throw new UnsupportedOperationException("Unsupported write variant!");
    }

    public boolean canWritePartial() {
        return false;
    }

    public void writePartial(IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IIOException {
        this.unsupported();
    }

    public boolean canReplaceStreamMetadata() throws IIOException {
        if (this.getOutput() == null) {
            throw new IllegalStateException("getOutput() == null!");
        }
        return false;
    }

    public void replaceStreamMetadata(IIOMetadata iIOMetadata) throws IIOException {
        this.unsupported();
    }

    public boolean canReplaceImageMetadata(int n) throws IIOException {
        if (this.getOutput() == null) {
            throw new IllegalStateException("getOutput() == null!");
        }
        return false;
    }

    public void replaceImageMetadata(int n, IIOMetadata iIOMetadata) throws IIOException {
        this.unsupported();
    }

    public boolean canInsertImage(int n) throws IIOException {
        if (this.getOutput() == null) {
            throw new IllegalStateException("getOutput() == null!");
        }
        return false;
    }

    public void writeInsert(int n, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IIOException {
        this.unsupported();
    }

    public boolean canRemoveImage(int n) throws IIOException {
        if (this.getOutput() == null) {
            throw new IllegalStateException("getOutput() == null!");
        }
        return false;
    }

    public void removeImage(int n) throws IIOException {
        this.unsupported();
    }

    public boolean canWriteEmpty() throws IIOException {
        if (this.getOutput() == null) {
            throw new IllegalStateException("getOutput() == null!");
        }
        return false;
    }

    public void prepareWriteEmpty(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, int n, int n2, IIOMetadata iIOMetadata2, List list, ImageWriteParam imageWriteParam) throws IIOException {
        this.unsupported();
    }

    public void endWriteEmpty() throws IIOException {
        if (this.getOutput() == null) {
            throw new IllegalStateException("getOutput() == null!");
        }
        throw new IllegalStateException("No call to prepareInsertEmpty!");
    }

    public boolean canInsertEmpty(int n) throws IIOException {
        if (this.getOutput() == null) {
            throw new IllegalStateException("getOutput() == null!");
        }
        return false;
    }

    public void prepareInsertEmpty(int n, ImageTypeSpecifier imageTypeSpecifier, int n2, int n3, IIOMetadata iIOMetadata, List list, ImageWriteParam imageWriteParam) throws IIOException {
        this.unsupported();
    }

    public void endInsertEmpty() throws IIOException {
        if (this.getOutput() == null) {
            throw new IllegalStateException("getOutput() == null!");
        }
        throw new IllegalStateException("No call to prepareInsertEmpty!");
    }

    public boolean canReplacePixels(int n) throws IIOException {
        if (this.getOutput() == null) {
            throw new IllegalStateException("getOutput() == null!");
        }
        return false;
    }

    public void prepareReplacePixels(int n, Rectangle rectangle) throws IIOException {
        this.unsupported();
    }

    public void replacePixels(RenderedImage renderedImage, ImageWriteParam imageWriteParam) throws IIOException {
        if (this.getOutput() == null) {
            throw new IllegalStateException("getOutput() == null!");
        }
        throw new IllegalStateException("No call to prepareReplacePixels!");
    }

    public void replacePixels(Raster raster, ImageWriteParam imageWriteParam) throws IIOException {
        if (this.getOutput() == null) {
            throw new IllegalStateException("getOutput() == null!");
        }
        throw new IllegalStateException("No call to prepareReplacePixels!");
    }

    public void endReplacePixels() throws IIOException {
        if (this.getOutput() == null) {
            throw new IllegalStateException("getOutput() == null!");
        }
        throw new IllegalStateException("No call to prepareReplacePixels!");
    }

    public synchronized void abort() {
        this.abortFlag = true;
    }

    public void addIIOWriteWarningListener(IIOWriteWarningListener iIOWriteWarningListener) {
        this.warningListeners = ImageReader.addToList(this.warningListeners, iIOWriteWarningListener);
        this.warningLocales = ImageReader.addToList(this.warningLocales, iIOWriteWarningListener);
    }

    public void removeIIOWriteWarningListener(IIOWriteWarningListener iIOWriteWarningListener) {
        if (iIOWriteWarningListener == null || this.warningListeners == null) {
            return;
        }
        int n = this.warningListeners.indexOf(iIOWriteWarningListener);
        if (n != -1) {
            this.warningListeners.remove(n);
            this.warningLocales.remove(n);
            if (this.warningListeners.size() == 0) {
                this.warningLocales = null;
                this.warningListeners = null;
            }
        }
    }

    public void removeAllIIOWriteWarningListeners() {
        this.warningListeners = null;
        this.warningLocales = null;
    }

    public void addIIOWriteProgressListener(IIOWriteProgressListener iIOWriteProgressListener) {
        this.progressListeners = ImageReader.addToList(this.progressListeners, iIOWriteProgressListener);
    }

    public void removeIIOWriteProgressListener(IIOWriteProgressListener iIOWriteProgressListener) {
        this.progressListeners = ImageReader.removeFromList(this.progressListeners, iIOWriteProgressListener);
    }

    public void removeAllIIOWriteProgressListeners() {
        this.progressListeners = null;
    }

    protected void processSequenceStarted() {
        if (this.progressListeners == null) {
            return;
        }
        int n = this.progressListeners.size();
        int n2 = 0;
        while (n2 < n) {
            IIOWriteProgressListener iIOWriteProgressListener = (IIOWriteProgressListener)this.progressListeners.get(n2);
            iIOWriteProgressListener.sequenceStarted(this);
            ++n2;
        }
    }

    protected void processSequenceComplete() {
        if (this.progressListeners == null) {
            return;
        }
        int n = this.progressListeners.size();
        int n2 = 0;
        while (n2 < n) {
            IIOWriteProgressListener iIOWriteProgressListener = (IIOWriteProgressListener)this.progressListeners.get(n2);
            iIOWriteProgressListener.sequenceComplete(this);
            ++n2;
        }
    }

    protected void processImageStarted(int n) {
        if (this.progressListeners == null) {
            return;
        }
        int n2 = this.progressListeners.size();
        int n3 = 0;
        while (n3 < n2) {
            IIOWriteProgressListener iIOWriteProgressListener = (IIOWriteProgressListener)this.progressListeners.get(n3);
            iIOWriteProgressListener.imageStarted(this, n);
            ++n3;
        }
    }

    protected void processImageProgress(float f) {
        if (this.progressListeners == null) {
            return;
        }
        int n = this.progressListeners.size();
        int n2 = 0;
        while (n2 < n) {
            IIOWriteProgressListener iIOWriteProgressListener = (IIOWriteProgressListener)this.progressListeners.get(n2);
            iIOWriteProgressListener.imageProgress(this, f);
            ++n2;
        }
    }

    protected void processImageComplete() {
        if (this.progressListeners == null) {
            return;
        }
        int n = this.progressListeners.size();
        int n2 = 0;
        while (n2 < n) {
            IIOWriteProgressListener iIOWriteProgressListener = (IIOWriteProgressListener)this.progressListeners.get(n2);
            iIOWriteProgressListener.imageComplete(this);
            ++n2;
        }
    }

    protected void processThumbnailStarted(int n, int n2) {
        if (this.progressListeners == null) {
            return;
        }
        int n3 = this.progressListeners.size();
        int n4 = 0;
        while (n4 < n3) {
            IIOWriteProgressListener iIOWriteProgressListener = (IIOWriteProgressListener)this.progressListeners.get(n4);
            iIOWriteProgressListener.thumbnailStarted(this, n, n2);
            ++n4;
        }
    }

    protected void processThumbnailProgress(float f) {
        if (this.progressListeners == null) {
            return;
        }
        int n = this.progressListeners.size();
        int n2 = 0;
        while (n2 < n) {
            IIOWriteProgressListener iIOWriteProgressListener = (IIOWriteProgressListener)this.progressListeners.get(n2);
            iIOWriteProgressListener.thumbnailProgress(this, f);
            ++n2;
        }
    }

    protected void processThumbnailComplete() {
        if (this.progressListeners == null) {
            return;
        }
        int n = this.progressListeners.size();
        int n2 = 0;
        while (n2 < n) {
            IIOWriteProgressListener iIOWriteProgressListener = (IIOWriteProgressListener)this.progressListeners.get(n2);
            iIOWriteProgressListener.thumbnailComplete(this);
            ++n2;
        }
    }

    protected void processWarningOccurred(int n, String string) {
        if (this.warningListeners == null) {
            return;
        }
        int n2 = this.warningListeners.size();
        int n3 = 0;
        while (n3 < n2) {
            IIOWriteWarningListener iIOWriteWarningListener = (IIOWriteWarningListener)this.warningListeners.get(n3);
            iIOWriteWarningListener.warningOccurred(this, n, string);
            ++n3;
        }
    }

    protected void processWarningOccurred(int n, String string, String string2) {
        if (this.warningListeners == null) {
            return;
        }
        int n2 = this.warningListeners.size();
        int n3 = 0;
        while (n3 < n2) {
            IIOWriteWarningListener iIOWriteWarningListener = (IIOWriteWarningListener)this.warningListeners.get(n3);
            Locale locale = (Locale)this.warningLocales.get(n3);
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string, locale);
            String string3 = resourceBundle.getString(string2);
            iIOWriteWarningListener.warningOccurred(this, n, string3);
            ++n3;
        }
    }

    public void reset() {
        this.setOutput(null);
        this.setLocale(null);
        this.removeAllIIOWriteWarningListeners();
        this.removeAllIIOWriteProgressListeners();
        this.abortFlag = false;
    }

    public void dispose() {
    }
}

