/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.imageio.stream.ImageInputStreamImpl;

public class FileImageInputStream
extends ImageInputStreamImpl {
    private RandomAccessFile raf;

    public FileImageInputStream(File file) throws FileNotFoundException, IOException {
        this(new RandomAccessFile(file, "r"));
    }

    public FileImageInputStream(RandomAccessFile randomAccessFile) {
        this.raf = randomAccessFile;
    }

    public int read() throws IOException {
        this.bitOffset = 0;
        int n = this.raf.read();
        if (n != -1) {
            ++this.streamPos;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.bitOffset = 0;
        int n3 = this.raf.read(byArray, n, n2);
        if (n3 != -1) {
            this.streamPos += (long)n3;
        }
        return n3;
    }

    public long length() {
        try {
            return this.raf.length();
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    public void seek(long l) throws IOException {
        this.bitOffset = 0;
        this.raf.seek(l);
        this.streamPos = this.raf.getFilePointer();
    }

    public void close() throws IOException {
        super.close();
        this.raf.close();
    }
}

