/*
 * @(#)GIFStreamMetadata.java	1.15 00/10/19
 *
 * Copyright 2000 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package com.sun.imageio.plugins.gif;

import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.metadata.IIOMetadataFormat;
import org.w3c.dom.Node;

/**
 * @version 0.5
 */
public class GIFStreamMetadata extends IIOMetadata {

    // package scope
    static final String
        nativeMetadataFormatName = "com.sun.imageio.gifstream_1.0";

    static final String[] metadataFormatNames = {
        nativeMetadataFormatName
    };
    
    public String version; // 87a or 89a

    public int logicalScreenWidth;
    public int logicalScreenHeight;
    public int backgroundColorIndex;
    public int pixelAspectRatio;
    
    public boolean globalColorTableFlag;
    public int colorResolution;
    public boolean sortFlag;
    public int sizeOfGlobalColorTable;

    public byte[] globalColorTable;

    public GIFStreamMetadata() {
        super(nativeMetadataFormatName, metadataFormatNames);
    }

    public IIOMetadataFormat getMetadataFormat(String formatName) {
        if (formatName.equals(nativeMetadataFormatName)) {
            return null;
        } else {
            throw new IllegalArgumentException("Not a recognized format!");
        }
    }

    public boolean isReadOnly() {
        return true;
    }
    
    public Node getAsTree(String formatName) {
        if (formatName.equals(nativeMetadataFormatName)) {
            return getNativeTree();
        } else {
            throw new IllegalArgumentException("Not a recognized format!");
        }
    }

    private Node getNativeTree() {
        IIOMetadataNode node; // scratch node
        IIOMetadataNode root =
            new IIOMetadataNode(nativeMetadataFormatName);
            
        node = new IIOMetadataNode("Version");
        node.setAttribute("value", version);
        root.appendChild(node);
        
        // Image descriptor
        node = new IIOMetadataNode("LogicalScreenDescriptor");
        node.setAttribute("logicalScreenWidth",
                          Integer.toString(logicalScreenWidth));
        node.setAttribute("logicalScreenHeight",
                          Integer.toString(logicalScreenHeight));
        node.setAttribute("backgroundColorIndex",
                          Integer.toString(backgroundColorIndex));
        node.setAttribute("pixelAspectRatio",
                          Integer.toString(pixelAspectRatio));
        node.setAttribute("globalColorTableFlag",
                          globalColorTableFlag ? "true" : "false");
        node.setAttribute("colorResolution",
                          Integer.toString(colorResolution));
        node.setAttribute("sortFlag",
                          sortFlag ? "true" : "false");
        node.setAttribute("sizeOfGlobalColorTable",
                          Integer.toString(sizeOfGlobalColorTable));
        root.appendChild(node);

        if (globalColorTable != null) {
            node = new IIOMetadataNode("GlobalColorTable");
            int numEntries = globalColorTable.length/3;
            for (int i = 0; i < numEntries; i++) {
                IIOMetadataNode entry =
                    new IIOMetadataNode("ColorTableEntry");
                entry.setAttribute("index", Integer.toString(i));
                int r = globalColorTable[3*i] & 0xff;
                int g = globalColorTable[3*i] & 0xff;
                int b = globalColorTable[3*i] & 0xff;
                entry.setAttribute("red", Integer.toString(r));
                entry.setAttribute("green", Integer.toString(r));
                entry.setAttribute("blue", Integer.toString(r));
                node.appendChild(entry);
            }
            
            root.appendChild(node);
        }

        return root;
    }

    public void setFromTree(String formatName, Node root) {
        throw new IllegalStateException("Metadata is read-only!");
    }

    public void mergeTree(String formatName, Node root) {
        throw new IllegalStateException("Metadata is read-only!");
    }

    public void reset() {
        throw new IllegalStateException("Metadata is read-only!");
    }
}
