/*
 * @(#)PNGImageWriterSpi.java	1.5 00/11/07
 *
 * Copyright 2000 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package com.sun.imageio.plugins.png;

import java.util.Locale;
import javax.imageio.ImageWriter;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.spi.ImageWriterSpi;

/**
 * @version 0.5
 */
public class PNGImageWriterSpi extends ImageWriterSpi {

    private static final String vendorName = "Sun Microsystems, Inc.";
    
    private static final String version = "0.1";
    
    private static final String[] names = { "png", "PNG" };
    
    private static final String[] suffixes = { ".png", ".PNG" };
    
    private static final String[] MIMETypes = { "image/png", "image/x-png" };
    
    private static final String writerClassName =
        "com.sun.imageio.plugins.png.PNGImageWriter";
    
    private static final String[] readerSpiNames = { };

    public PNGImageWriterSpi() {
          super(vendorName,
                version,
                names,
                suffixes,
                MIMETypes,
                writerClassName,
                STANDARD_OUTPUT_TYPE,
                readerSpiNames,
                PNGMetadata.metadataFormatNames,
                PNGMetadata.nativeMetadataFormatName,
                PNGMetadata.metadataFormatNames,
                PNGMetadata.nativeMetadataFormatName);
    }

    public boolean canEncodeImage(ImageTypeSpecifier type) {
        System.out.println("type = " + type);
        return true;
    }

    public String getDescription(Locale locale) {
        return null;
    }

    public ImageWriter createWriterInstance(Object extension) {
        return new PNGImageWriter(this);
    }
}
