/*
 * @(#)ImageReaderWriterSpi.java	1.10 00/11/03
 *
 * Copyright 2000 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package javax.imageio.spi;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import javax.imageio.ImageReader;
import javax.imageio.IIOException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;

/**
 * A superclass containing instance variables and methods common to
 * <code>ImageReaderSpi</code> and <code>ImageWriterSpi</code>.
 *
 * @see IIORegistry
 * @see ImageReaderSpi
 * @see ImageWriterSpi
 *
 * @version 0.5
 */
public abstract class ImageReaderWriterSpi extends IIOServiceProvider {

    /**
     * An array of strings to be returned from
     * <code>getFormatNames</code>.
     */
    protected String[] names;

    /**
     * An array of strings to be returned from
     * <code>getFileSuffixes</code>.
     */
    protected String[] suffixes;

    /**
     * An array of strings to be returned from
     * <code>getMIMETypes</code>.
     */
    protected String[] MIMETypes;

    /**
     * A <code>String</code> containing the name of the associated
     * plug-in class.
     */ 
    protected String pluginClassName;
   
    /**
     * An array of <code>String</code>s containing the names of the
     * stream metadata formats supported by this plug-in.
     */
    protected String[] streamMetadataFormatNames;

    /**
     * A <code>String</code> containing the name of the
     * native stream metadata format supported by this plug-in,
     * or <code>null</code>.
     */
    protected String nativeStreamMetadataFormatName;

    /**
     * An array of <code>String</code>s containing the names of the
     * image metadata formats supported by this plug-in.
     */
    protected String[] imageMetadataFormatNames;

    /**
     * A <code>String</code> containing the name of the
     * native stream metadata format supported by this plug-in,
     * or <code>null</code>.
     */
    protected String nativeImageMetadataFormatName;

    /**
     * Constructs an <code>ImageReaderWriterSpi</code> with a given
     * set of values.
     *
     * @param vendorName the vendor name.
     * @param version a version identifier.
     * @param names an array of <code>String</code>s indicating the
     * format names.
     * @param suffixes an array of <code>String</code>s indicating the
     * common file suffixes.
     * @param MIMETypes an array of <code>String</code>s indicating
     * the format's MIME types.
     * @param pluginClassName the fully-qualified name of the
     * associated <code>ImageReader</code> or <code>ImageWriter</code>
     * class.
     * @param streamMetadataFormatNames an array of
     * <code>String</code>s, or <code>null</code>, to be returned from
     * <code>getStreamMetadataFormatNames</code>.
     * @param nativeStreamMetadataFormatName a
     * <code>String</code>, or <code>null</code>, to be returned from
     * <code>getNativeStreamMetadataFormatName</code>.
     * @param imageMetadataFormatNames an array of
     * <code>String</code>s to be returned from
     * <code>getImageMetadataFormatNames</code>.
     * @param nativeImageMetadataFormatName a
     * <code>String</code>, or <code>null</code>, to be returned from
     * <code>getNativeImageMetadataFormatName</code>.
     */
    public ImageReaderWriterSpi(String vendorName,
                                String version,
                                String[] names,
                                String[] suffixes,
                                String[] MIMETypes,
                                String pluginClassName,
                                String[] streamMetadataFormatNames,
                                String nativeStreamMetadataFormatName,
                                String[] imageMetadataFormatNames,
                                String nativeImageMetadataFormatName) {
        super(vendorName, version);
        this.names = (String[])names.clone();
        this.suffixes = (String[])suffixes.clone();
        this.MIMETypes = (String[])MIMETypes.clone();
        this.pluginClassName = pluginClassName;
        if (streamMetadataFormatNames != null) {
            this.streamMetadataFormatNames =
                (String[])streamMetadataFormatNames.clone();
        }
        this.nativeStreamMetadataFormatName = nativeStreamMetadataFormatName;
        if (imageMetadataFormatNames != null) {
            this.imageMetadataFormatNames =
                (String[])imageMetadataFormatNames.clone();
        }
        this.nativeImageMetadataFormatName = nativeImageMetadataFormatName;
    }

    /**
     * Constructs a blank <code>ImageReaderWriterSpi</code>.  It is up
     * to the subclass to initialize instance variables and/or
     * override method implementations in order to provide working
     * versions of all methods.
     */
    public ImageReaderWriterSpi() {
    }

    /**
     * Returns an array of <code>String</code>s containing
     * human-readable names for the formats that are generally usable
     * by the <code>ImageReader</code> or <code>ImageWriter</code>
     * implementation associated with this service provider.  For
     * example, a single <code>ImageReader</code> might be able to
     * process both PBM and PNM files.
     *
     * @return an array of Strings containing informal format names 
     * associated with this reader or writer.
     */
    public String[] getFormatNames() {
        return (String[])names.clone();
    }

    /**
     * Returns an array of <code>String</code>s containing a list of
     * file suffixes associated with the formats that are generally
     * usable by the <code>ImageReader</code> or
     * <code>ImageWriter</code> implementation associated with this
     * service provider.  For example, a single
     * <code>ImageReader</code> might be able to process files with
     * '.pbm' and '.pnm' suffixes, or both '.jpg' and '.jpeg'
     * suffixes.
     *
     * <p> Returning a particular suffix does not guarantee that files
     * with that suffix can be processed; it merely indicates that it
     * may be worthwhile attempting to decode or encode such files
     * using this service provider.
     *
     * @return an array of Strings containing common file suffixes
     * associated with this reader or writer.
     */
    public String[] getFileSuffixes() {
        return (String[])suffixes.clone();
    }

    /**
     * Returns an array of <code>String</code>s containing a list of
     * MIME types associated with the formats that are generally
     * usable by the <code>ImageReader</code> or
     * <code>ImageWriter</code> implementation associated with this
     * service provider.
     *
     * <p> Ideally, only a single MIME type would be required in order
     * to describe a particular format.  However, for several reasons
     * it is necessary to associate a list of types with each service
     * provider.  First, many common image file formats do not have
     * standard MIME types, so a list of commonly used unofficial
     * names will be required, such as ' 'image/x-pbm' and
     * 'image/x-portable-bitmap'.  Some file formats have official
     * MIME types but may sometimes be referred to using their
     * previous unofficial designations, such as 'image/x-png' and
     * 'image/png'.  Finally, a single service provider may be capable
     * of parsing multiple distinct types from the MIME point of
     * view, for example 'image/x-xbitmap' and 'image/x-xpixmap'.
     *
     * <p> Returning a particular MIME type does not guarantee that
     * files claiming to be of that type can be processed; it merely
     * indicates that it may be worthwhile attempting to decode or
     * encode such files using this service provider.
     *
     * @return an array of Strings containing MIME types 
     * associated with this reader or writer.
     */
    public String[] getMIMETypes() {
        return (String[])MIMETypes.clone();
    }

    /**
     * Returns the fully-qualified class name of the
     * <code>ImageReader</code> or <code>ImageWriter</code> plug-in
     * associated with this service provider.
     *
     * @return the class name, as a <code>String</code>.
     */
    public String getPluginClassName() {
        return pluginClassName;
    }

    /**
     * Returns an array of <code>String</code>s containing the names
     * of the document formats recognized by the
     * <code>getAsTree</code> and <code>setFromTree</code> methods on
     * the stream metadata objects produced or consumed by this
     * plug-in.
     *
     * <p> If the plug-in does not handle metadata, null should be
     * returned.  Note that this is different from
     * <code>IIOMetadata.getDocumentFormats</code>, which always
     * returns an array of length at least 1.
     *
     * <p> The set of formats may differ according to the particular
     * images being read or written; this method should indicate all
     * the formats sopported by the plug-in under any circumstances.
     *
     * <p> The formats should be returned roughly in order of decreasing
     * fidelity, with any "native" formats providing lossless encoding
     * listed first.
     *
     * <p> The default implementation returns a clone of the
     * <code>streamMetadataFormatNames</code> instance variable,
     * which is typically set by the constructor.
     *
     * @return an array of <code>String</code>s, or null.
     *
     * @see IIOMetadata#getMetadataFormatNames
     * @see #getImageMetadataFormatNames
     * @see #getNativeStreamMetadataFormatName
     */
    public String[] getStreamMetadataFormatNames() {
        if (streamMetadataFormatNames != null) {
            return (String[])streamMetadataFormatNames.clone();
        }
        return null;
    }

    /**
     * Returns the name of the "native" stream metadata format for
     * this plug-in, which typically allows for lossless encoding and
     * transmission of the stream metadata stored in the format handled by
     * this plug-in.  If no such format is supported,
     * <code>null</code>will be returned.  If a
     * non-<code>null</code> value is returned, it will be one of the
     * names returned by <code>getStreamMetadataFormatNames</code>.
     *
     * <p> The default implementation returns the
     * <code>nativeStreamMetadataFormatName</code> instance variable,
     * which is typically set by the constructor.
     *
     * @return the name of the native stream metadata format, or
     * <code>null</code>.
     *
     * @see #getStreamMetadataFormatNames
     */
    public String getNativeStreamMetadataFormatName() {
        return nativeStreamMetadataFormatName;
    }

    /**
     * Returns an array of <code>String</code>s containing the names
     * of the document formats recognized by the
     * <code>getAsTree</code> and <code>setFromTree</code> methods on
     * the image metadata objects produced or consumed by this
     * plug-in.
     *
     * <p> If the plug-in does not handle image metadata, null should
     * be returned.  Note that this is different from
     * <code>IIOMetadata.getDocumentFormats</code>, which always
     * returns an array of length at least 1.
     *
     * <p> The set of formats may differ according to the particular
     * images being read or written; this method should indicate all
     * the formats sopported by the plug-in under any circumstances.
     *
     * <p> The formats should be returned roughly in order of decreasing
     * fidelity, with any "native" formats providing lossless encoding
     * listed first.
     *
     * <p> The default implementation returns a clone of the
     * <code>imageMetadataFormatNames</code> instance variable,
     * which is typically set by the constructor.
     *
     * @return an array of <code>String</code>s, or null.
     *
     * @see IIOMetadata#getMetadataFormatNames
     * @see #getStreamMetadataFormatNames
     * @see #getNativeImageMetadataFormatName
     */
    public String[] getImageMetadataFormatNames() {
        if (imageMetadataFormatNames != null) {
            return (String[])imageMetadataFormatNames.clone();
        }
        return null;
    }

    /**
     * Returns the name of the "native" image metadata format for
     * this plug-in, which typically allows for lossless encoding and
     * transmission of the image metadata stored in the format handled by
     * this plug-in.  If no such format is supported,
     * <code>null</code>will be returned.  If a
     * non-<code>null</code> value is returned, it will be one of the
     * names returned by <code>getImageMetadataFormatNames</code>.
     *
     * <p> The default implementation returns the
     * <code>nativeStreamMetadataFormatName</code> instance variable,
     * which is typically set by the constructor.
     *
     * @return the name of the native image metadata format, or
     * <code>null</code>.
     *
     * @see #getImageMetadataFormatNames
     */
    public String getNativeImageMetadataFormatName() {
        return nativeImageMetadataFormatName;
    }
}
