package iDSS.beans;

import java.io.*;
import java.beans.*;
import java.sql.Timestamp;
import java.util.*;
import java.util.Properties; 

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;



import java.rmi.RemoteException;


import iDSS.*;
import iDSS.utils.*;

//Serverside packages
//import helpers.*;
import ejb.slr.*;



public class SLRJBean implements Serializable {


    private PropertyChangeSupport pcs;
    private String ejbName;

    private SLRHome slrHome;
    private SLR slr;



    public SLRJBean() {

        pcs = new PropertyChangeSupport(this);

    } //public SLRJBean()



    public void addPropertyChangeListener(PropertyChangeListener l) {

        pcs.addPropertyChangeListener(l);

    } //public void addPropertyChangeListener(PropertyChangeListener l)




    public void removePropertyChangeListener(PropertyChangeListener l) {

        pcs.removePropertyChangeListener(l);

    } //public void removePropertyChangeListener(PropertyChangeListener l)






    public String getEjbName() {

        return ejbName;

    }//public String getEjbName()




    public void setEjbName(String s) {

        try {
            ejbName = s;

            if(IDSSAppConstants.debug) {
                System.out.println("SLRJBean.setEjbName(), ejbName = " + ejbName);
            }//if(IDSSAppConstants.debug)


            Properties props = new Properties(); 
            props.put(Context.DNS_URL, IDSSAppConstants.serverURL);
            Context initial = new InitialContext(props);


            Object objref = initial.lookup(ejbName);
            slrHome = (SLRHome)PortableRemoteObject.narrow(objref,SLRHome.class);
        } //try

        catch(Exception ex) {
            System.out.println("SLRJBean.setEjbName(), Caught an exception");
            ex.printStackTrace();
        } //catch();

    }//public void setEjbName()




    public Vector findAll() {

        Vector v = new Vector();

        try {

            Collection c = slrHome.findAll();
            Iterator i=c.iterator();

            while (i.hasNext()) {

                Vector oneRow = new Vector();

                SLR t = (SLR)i.next();
                oneRow.add(0,t.getName());
                oneRow.add(1,t.getStoryLine());
                oneRow.add(2,t.getScenarioTable());

                v.add(oneRow);

            } //while (i.hasNext())

        } //try

        catch (Exception ex) {

            System.err.println("SLRJBean.findAll(), Caught an exception." );
            ex.printStackTrace();

        } //catch (Exception ex)

        return v;

    } //public Vector findAll()





}//public class SLRJBean implements Serializable

